/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.pool;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.msg.result.DownloadResult;
import com.kingdee.eas.tm.im.common.comm.service.pool.PoolWebPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WebDownloadByCodeNoPwyService
extends PoolWebPwyService {
    private WebDownloadByCodeNoPwyService nextService = null;
    private int totalPage = 0;
    private int currentPage = 0;

    public WebDownloadByCodeNoPwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public WebDownloadByCodeNoPwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public Map getPwyData() {
        return (Map)this.getInvokeParam().getParams().get("pwyData");
    }

    @Override
    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = super.createPwyLog();
        Map pwyData = (Map)this.getInvokeParam().getParams().get("pwyData");
        if (pwyData != null) {
            pwyLog.setInvoiceCode((String)pwyData.get("invoiceCode"));
            pwyLog.setInvoiceNum((String)pwyData.get("invoiceNo"));
        }
        return pwyLog;
    }

    @Override
    public String getDefaultInterfacePath() {
        return "/m6/bill/invoice/serialnos/query";
    }

    @Override
    protected boolean isNeedReverse() {
        return true;
    }

    @Override
    protected void resolveSuccess() {
        JSONObject retJson = null;
        try {
            retJson = new JSONObject(this.getInvokeParam().getRevMsg());
            if ("0000".equals(retJson.get("errcode"))) {
                this.totalPage = retJson.getInt("totalPage");
                this.currentPage = retJson.getInt("currentPage");
            }
        }
        catch (JSONException e) {
            this.setReturn(this.getUnKownCode(), e.getMessage());
        }
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("retInfo", this.getInvokeParam().getRevMsg());
        params.put("orgid", this.getInvokeParam().getOrgId());
        params.put("parserClass", "com.kingdee.eas.tm.im.common.comm.msg.parser.WebDownloadParser");
        params.putAll(this.getInvokeParam().getParams());
        Map retValue = BizInterfaceFactory.getIncomeInvoiceReWriteFacade(this.getCtx()).billQueryDownload(params);
        this.getInvokeParam().setInvokeActionMap(retValue);
        ++this.currentPage;
        if (this.currentPage <= this.totalPage) {
            Map pwyData = this.getPwyData();
            pwyData.put("pageNo", this.currentPage);
            HashMap<String, Map> newParams = new HashMap<String, Map>();
            newParams.put("pwyData", pwyData);
            newParams.putAll(this.getInvokeParam().getParams());
            newParams.put("totalMap", retValue);
            PwyInvokeParam invokeParam = PwyInvokeParam.newPwyInvokeParam(this.getInvokeParam());
            invokeParam.setParams(params);
            invokeParam.setInit(true);
            this.nextService = (WebDownloadByCodeNoPwyService)PwyServiceHelper.getPwyService(this.getCtx(), invokeParam);
            this.nextService.invoke();
            this.getInvokeParam().setInvokeActionMap(this.nextService.getInvokeParam().getInvokeActionMap());
        }
    }

    public List getErrorList() {
        ArrayList<String> errorList = new ArrayList<String>();
        if (!this.isSuccess()) {
            errorList.add(this.getInvokeParam().getDescription());
        }
        for (WebDownloadByCodeNoPwyService nextService = this.getNextService(); nextService != null; nextService = nextService.getNextService()) {
            if (nextService.isSuccess()) continue;
            errorList.add(nextService.getInvokeParam().getDescription());
        }
        return errorList;
    }

    public Map getInvokeActionMap() {
        HashMap retValue = new HashMap();
        ArrayList<DownloadResult> resultList = new ArrayList<DownloadResult>();
        DownloadResult result = (DownloadResult)this.getInvokeParam().getInvokeActionMap().get(this.getInvokeParam().getOrgId());
        resultList.add(result);
        DownloadResult invokeResult = null;
        for (WebDownloadByCodeNoPwyService nextService = this.getNextService(); nextService != null; nextService = nextService.getNextService()) {
            Map invokeActionMap = nextService.getInvokeParam().getInvokeActionMap();
            if (invokeActionMap == null) continue;
            invokeResult = (DownloadResult)invokeActionMap.get(this.getInvokeParam().getOrgId());
            resultList.add(invokeResult);
        }
        retValue.put("result", resultList);
        return retValue;
    }

    public WebDownloadByCodeNoPwyService getNextService() {
        return this.nextService;
    }

    public void setNextService(WebDownloadByCodeNoPwyService nextService) {
        this.nextService = nextService;
    }

    @Override
    public String getPwyCzlx() {
        return "PS1910";
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        return null;
    }
}

