/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.httpClient.SSLClientConfig;
import com.kingdee.eas.tm.im.common.comm.LocalServiceInfo;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.service.util.CommUtil;
import com.kingdee.eas.tm.im.httpClient.HttpClientUtil;
import org.apache.log4j.Logger;

public class EASOpenApiUtil {
    private static Logger logger = Logger.getLogger(EASOpenApiUtil.class);

    public static String login(LocalServiceInfo service) throws BOSException, EASBizException {
        StringBuffer url = new StringBuffer();
        url.append(service.getServiceURL());
        url.append(service.getLoginUrl());
        url.append("?authPattern=BaseDB&isEncodePwd=0");
        url.append("&dcName=").append(service.getDcName());
        url.append("&user=").append(service.getUser());
        url.append("&password=").append(CommUtil.isNull(service.getPwd()));
        url.append("&language=").append(service.getLanguage().getValue());
        String token = null;
        try {
            String resultJSON = HttpClientUtil.doGet(url.toString(), SSLClientConfig.custom().build());
            JSONObject jsonObject = JSONObject.parseObject((String)resultJSON);
            int errCode = jsonObject.getInteger("errCode");
            if (errCode != 0) {
                logger.error((Object)resultJSON);
                throw new ServiceException(ServiceException.EPX_EAS_LOGIN_FAILURE, new Object[]{jsonObject.getString("errMsg")});
            }
            JSONObject dataObject = jsonObject.getJSONObject("data");
            token = dataObject.getString("token");
        }
        catch (Throwable e) {
            logger.error((Object)e.getMessage(), e);
            if (e.getCause() != null) {
                throw new ServiceException(ServiceException.EPX_EAS_LOGIN_FAILURE, new Object[]{e.getCause().getMessage()});
            }
            throw new ServiceException(ServiceException.EPX_EAS_LOGIN_FAILURE, new Object[]{e.getMessage()});
        }
        return token;
    }
}

