/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.comm.CommunicationSetInfo;
import com.kingdee.eas.tm.im.common.comm.LocalServiceInfo;
import com.kingdee.eas.tm.im.common.comm.RemoteServiceInfo;
import com.kingdee.eas.tm.im.common.comm.service.util.CommUtil;
import com.kingdee.eas.tm.im.common.comm.service.util.IERPServiceHelper;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FpyServiceHelper {
    public static Map getInitCloudData(RemoteServiceInfo remoteService) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msgId", CommUtil.nextId());
        map.put("identifytype", "imacImasmFromImc");
        map.put("msgType", "register");
        HashMap<String, String> reqData = new HashMap<String, String>();
        LocalServiceInfo localService = remoteService.getLocalService();
        reqData.put("tenantId", CommUtil.isNull(localService.getDcName()));
        reqData.put("accountId", CommUtil.isNull(localService.getAccountId()));
        reqData.put("url", CommUtil.isNull(localService.getServiceURL()));
        reqData.put("apiUrl", CommUtil.isNull(localService.getApiUrl()));
        reqData.put("tokenUrl", CommUtil.isNull(localService.getTokenUrl()));
        reqData.put("loginUrl", CommUtil.isNull(localService.getLoginUrl()));
        reqData.put("appId", CommUtil.isNull(localService.getAppId()));
        reqData.put("appSecuret", CommUtil.isNull(localService.getPwd()));
        reqData.put("publicKey", CommUtil.isNull(localService.getPublicKey()));
        reqData.put("user", CommUtil.isNull(localService.getUser()));
        reqData.put("userType", CommUtil.isNull(localService.getUserType().getValue()));
        reqData.put("tenantName", CommUtil.isNull(localService.getTenantName()));
        map.put("reqData", reqData);
        return map;
    }

    public static Map getSyncQrKeyData(RemoteServiceInfo remoteService, Set taxNos) {
        LocalServiceInfo localService = remoteService.getLocalService();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("msgId", CommUtil.nextId());
        map.put("identifytype", "imacImasmFromImc");
        map.put("msgType", "syncQrKey");
        map.put("tenantId", CommUtil.isNull(localService.getDcName()));
        map.put("accountId", CommUtil.isNull(localService.getAccountId()));
        ArrayList reqData = new ArrayList();
        HashMap<String, String> reqObj = null;
        String taxNo = null;
        Iterator it = taxNos.iterator();
        while (it.hasNext()) {
            reqObj = new HashMap<String, String>();
            taxNo = (String)it.next();
            reqObj.put("taxNo", taxNo);
            reqObj.put("scanType", "0");
            reqData.add(reqObj);
        }
        map.put("reqData", reqData);
        return map;
    }

    public static RemoteServiceInfo getRemoteService(Context ctx) throws BOSException, EASBizException {
        CommunicationSetInfo commSettingInfo = PwyServiceHelper.getCommSetting(ctx);
        return FpyServiceHelper.getRemoteService(ctx, commSettingInfo);
    }

    public static RemoteServiceInfo getRemoteService(Context ctx, CommunicationSetInfo commSettingInfo) throws BOSException, EASBizException {
        String remoteServiceNumber = "FPY";
        if (!commSettingInfo.isIsPwyDev()) {
            remoteServiceNumber = "FPY-DEMO";
        }
        RemoteServiceInfo remoteServiceInfo = IERPServiceHelper.getRemoteService(ctx, remoteServiceNumber);
        return remoteServiceInfo;
    }
}

