/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.tm.im.AbstractIncomeInvoiceInfo;
import com.kingdee.eas.tm.im.IncomeInvoiceCollection;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.param.TaxNoSumResult;
import com.kingdee.eas.tm.im.util.CheckAbsUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class IncomeInvoicePwyHelper {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper");

    public static Map getInvoiceCheckPwyData(List invoices, PwySettingInfo setting) {
        HashMap<String, CharSequence> body = new HashMap<String, CharSequence>();
        StringBuffer fpdm = new StringBuffer();
        StringBuffer fphm = new StringBuffer();
        StringBuffer kprq = new StringBuffer();
        StringBuffer zt = new StringBuffer();
        for (int i = 0; i < invoices.size(); ++i) {
            IncomeInvoiceInfo info = (IncomeInvoiceInfo)invoices.get(i);
            if (fpdm.length() == 0) {
                fpdm.append(info.getInvoiceCode());
                fphm.append(info.getInvoiceNumber());
                kprq.append(info.getBizDate());
                zt.append("1");
                continue;
            }
            fpdm.append("=").append(info.getInvoiceCode());
            fphm.append("=").append(info.getInvoiceNumber());
            kprq.append("=").append(info.getBizDate());
            zt.append("=").append("1");
        }
        body.put("fpdm", fpdm);
        body.put("fphm", fphm);
        body.put("kprq", kprq);
        body.put("zt", zt);
        body.put("caPass", setting.getCaPassword());
        return body;
    }

    public static Map getInvoiceCheckConfirmPwyData(PwySettingInfo setting) {
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("caPass", setting.getCaPassword());
        return body;
    }

    public static void handleCompany(Context ctx, IncomeInvoiceInfo invoiceInfo, Map<String, CompanyOrgUnitInfo> matchCompany) throws BOSException {
        if (invoiceInfo.isIsAccept()) {
            return;
        }
        if (invoiceInfo.getBizBillID() != null) {
            return;
        }
        if (invoiceInfo.getVoucher() != null) {
            return;
        }
        CompanyOrgUnitInfo curCompany = (CompanyOrgUnitInfo)ctx.get((Object)OrgType.Company);
        CompanyOrgUnitInfo companyInfo = null;
        if (matchCompany != null && (companyInfo = matchCompany.get(invoiceInfo.getBuyerAccount() == null ? "" : invoiceInfo.getBuyerAccount())) == null) {
            companyInfo = matchCompany.get("");
        }
        if (companyInfo == null) {
            companyInfo = IncomeInvoicePwyHelper.getCompanyOrgUnitByTaxNo(ctx, invoiceInfo.getBuyerTaxNo());
        }
        if (companyInfo == null) {
            companyInfo = curCompany;
        }
        invoiceInfo.setCompany(companyInfo);
        if (invoiceInfo.getCheckAbs() != null && invoiceInfo.getCheckAbs().get("taxPeriodStr") != null) {
            invoiceInfo.getCheckAbs().setTaxPeriod(CheckAbsUtil.getPeriodInfo(ctx, (String)invoiceInfo.getCheckAbs().get("taxPeriodStr"), invoiceInfo.getCompany()));
        }
    }

    private static CompanyOrgUnitInfo getCompanyOrgUnitByTaxNo(Context ctx, String taxNo) throws BOSException {
        EntityViewInfo cview = new EntityViewInfo();
        FilterInfo cfilter = new FilterInfo();
        cfilter.getFilterItems().add(new FilterItemInfo("taxNumber", (Object)taxNo));
        cview.setFilter(cfilter);
        CompanyOrgUnitInfo company = null;
        ICompanyOrgUnit iCompany = ctx == null ? CompanyOrgUnitFactory.getRemoteInstance() : CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
        CompanyOrgUnitCollection col = iCompany.getCompanyOrgUnitCollection(cview);
        CompanyOrgUnitInfo curCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        for (int i = 0; i < col.size(); ++i) {
            company = col.get(i);
            if (!company.getId().toString().equals(curCompany.getId().toString())) continue;
            return company;
        }
        if (col != null && col.size() > 0) {
            company = col.get(0);
        }
        if (company == null) {
            company = curCompany;
        }
        return company;
    }

    public static void handleSupplier(Context ctx, IncomeInvoiceInfo invoiceInfo) throws BOSException {
        String taxNumber = invoiceInfo.getTaxNumber();
        String companyId = invoiceInfo.getCompany().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT SUPPLIER.FID AS id FROM T_BD_Supplier AS SUPPLIER ");
        sql.append(" LEFT OUTER JOIN  T_BD_SupplierCompanyInfo AS SUPCOMPANY ON  SUPPLIER.FID = SUPCOMPANY.FSupplierID ");
        sql.append(" WHERE SUPCOMPANY.FComOrgID = '").append(companyId).append("' ");
        sql.append(" AND SUPPLIER.FTaxRegisterNo = '").append(taxNumber).append("'");
        sql.append(" AND SUPPLIER.FUsedStatus = '1'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                SupplierInfo supplierInfo = new SupplierInfo();
                supplierInfo.setId(BOSUuid.read((String)rs.getString("id")));
                invoiceInfo.setCurrAcctSupplier(supplierInfo);
            } else {
                invoiceInfo.setCurrAcctSupplier(null);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public static Map<String, CompanyOrgUnitInfo> matchPwySettingCompany(TaxNoSumResult sumRet) {
        HashMap<String, CompanyOrgUnitInfo> result = new HashMap<String, CompanyOrgUnitInfo>();
        ArrayList<PwySettingInfo> pwySettingList = sumRet.getPwySettingList();
        for (int i = 0; i < pwySettingList.size(); ++i) {
            PwySettingInfo setting = pwySettingList.get(i);
            if (setting.getBankAccount() == null || setting.getBankAccount().isEmpty()) continue;
            result.put(setting.getBankAccount(), sumRet.getCompanyMap().get(setting.getCompany().getId().toString()));
        }
        result.put("", sumRet.getDefaultCompany());
        return result;
    }

    public static synchronized IncomeInvoiceInfo getInfoWithNumber(Context ctx, String invoiceCode, String invoiceNo) {
        AbstractIncomeInvoiceInfo invoice = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("invoiceCode", (Object)invoiceCode, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("invoiceNumber", (Object)invoiceNo, CompareType.EQUALS));
            view.setFilter(filter);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("checkAbs.*"));
            sic.add(new SelectorItemInfo("nonCompliantInvoice.*"));
            sic.add(new SelectorItemInfo("nonCompliantInvoice.entry.*"));
            sic.add(new SelectorItemInfo("nonCompliantInvoice.entry.nonCompliantType.*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("entries.*"));
            view.setSelector(sic);
            IncomeInvoiceCollection coll = ctx == null ? IncomeInvoiceFactory.getRemoteInstance().getIncomeInvoiceCollection(view) : IncomeInvoiceFactory.getLocalInstance(ctx).getIncomeInvoiceCollection(view);
            if (coll.size() > 0) {
                invoice = coll.get(0);
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        if (invoice == null) {
            invoice = new IncomeInvoiceInfo();
            invoice.setId(BOSUuid.create((String)"1343913D"));
        }
        invoice.setInvoiceCode(invoiceCode);
        invoice.setInvoiceNumber(invoiceNo);
        invoice.setNumber(invoiceCode + "_" + invoiceNo);
        return invoice;
    }

    public static boolean isPoolDownload(Map params) {
        Object value = params.get("isPoolDownload");
        return value != null && Boolean.parseBoolean(value.toString());
    }

    public static boolean isPoolCheck(Map params) {
        Object value = params.get("isPoolCheck");
        return value != null && Boolean.parseBoolean(value.toString());
    }

    public static boolean isCQPurCloudReceive(Map params) {
        Object value = params.get("isCQPurCloudReceive");
        return value != null && Boolean.parseBoolean(value.toString());
    }
}

