/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.Kson;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.httpClient.HttpClientUtil;
import com.kingdee.eas.tm.common.httpClient.SSLClientConfig;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.PwyHelper;
import com.kingdee.eas.tm.im.common.comm.LogStatusEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.model.ResqMsg;
import com.kingdee.eas.tm.im.common.comm.msg.PwyDebugHelper;
import java.util.HashMap;
import java.util.Map;

public class PoolSyncLoginUtil {
    private static Map<String, String> tokenMap = new HashMap<String, String>();

    public static String getToken(Context ctx, PwyInvokeParam info) {
        return tokenMap.get(PoolSyncLoginUtil.getCacheTokenKey(ctx, info));
    }

    public static boolean isNotLogin(ResqMsg resqMsg) {
        return "1300".equals(resqMsg.getErrcode());
    }

    public static void login(Context ctx, PwyInvokeParam info) throws EASBizException, BOSException {
        String baseUrl = info.getCommSettingInfo().isIsPwyDev() ? info.getCommSettingInfo().getPwyURL() : info.getCommSettingInfo().getPwyDevURL();
        String url = baseUrl + "/base/oauth/token";
        Map map = PwyHelper.getSfrz(info.getClientId(), info.getClientSecret());
        String param = Kson.getGson().toJson((Object)map);
        String response = null;
        if (info.getMsgSettingInfo().isIsDebug()) {
            response = PwyDebugHelper.getPwyRespJson("9004");
        } else {
            SSLClientConfig config = SSLClientConfig.custom().setConfig(ctx).setConnectionRequestTimeout(6000).setConnectTimeout(6000).setSocketTimeout(6000).build();
            response = HttpClientUtil.doPost((String)url, (String)param, (SSLClientConfig)config);
        }
        Map result = (Map)JSONObject.parseObject((String)response, Map.class);
        String errorCode = (String)result.get("errcode");
        String errorDesc = (String)result.get("description");
        String accessToken = null;
        if (!"0000".equals(errorCode)) {
            info.getPwyLog().setLogStatus(LogStatusEnum.FAILURE);
            throw new IMException(IMException.ERRORMSG, new Object[]{errorDesc});
        }
        accessToken = (String)result.get("access_token");
        tokenMap.put(PoolSyncLoginUtil.getCacheTokenKey(ctx, info), accessToken);
    }

    private static String getCacheTokenKey(Context ctx, PwyInvokeParam info) {
        return info.getClientId() + "_" + info.getClientSecret();
    }
}

