/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.common.perf.CreateJobFacadeFactory;
import com.kingdee.eas.basedata.common.perf.JobConfig;
import com.kingdee.eas.basedata.common.perf.JobParam;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.gl.VoucherCollection;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.common.utils.TMSqlUtil;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.common.comm.ServiceException;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.PwyHelperUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class PoolSyncUtil {
    private static Logger logger = Logger.getLogger(PoolSyncUtil.class);

    public static void poolSyncCall(Context ctx, PwyActionParam actionParam) throws Exception {
        try {
            PwyInvokeParam invokeParam = new PwyInvokeParam(actionParam);
            IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                throw new IMException(IMException.ERRORMSG, new Object[]{pwyService.getInvokeParam().getDescription()});
            }
        }
        catch (Throwable e) {
            if (e.getCause() != null) {
                logger.error((Object)e.getCause().getMessage(), e.getCause());
                throw new ServiceException(ServiceException.EPX_INVOKESERVICE_ERROR, new Object[]{actionParam.getMsgType().getAlias(), e.getCause().getMessage()});
            }
            logger.error((Object)e.getMessage(), e);
            throw new ServiceException(ServiceException.EPX_INVOKESERVICE_ERROR, new Object[]{actionParam.getMsgType().getAlias(), e.getMessage()});
        }
    }

    public static void poolAsyncCall(Context ctx, PwyActionParam actionParam) throws BOSException, EASBizException {
        String billId = actionParam.getBillId();
        String bizBillNumber = actionParam.getBillNumber();
        String bizBillNumberAlias = IMUtils.getString("com.kingdee.eas.tm.im.IMCommonResource", "Msg_BillNumber", ctx.getLocale(), new Object[]{bizBillNumber});
        String title = actionParam.getMsgType().getAlias() + "\u3010" + bizBillNumberAlias + "\u3011";
        JobConfig jobCfg = new JobConfig();
        jobCfg.setNumber("TM_POOL_SYNC");
        jobCfg.setTitle(title);
        jobCfg.setDescription(title);
        jobCfg.setTaskType("TM_POOL_SYNC");
        jobCfg.setNeedCheckTaskType(false);
        jobCfg.setMutex(billId);
        CreateJobFacadeFactory.getLocalInstance((Context)ctx).executeJob(new JobParam((Object)actionParam), jobCfg);
    }

    public static IObjectCollection getBillCollection(Context ctx, Set<String> billIdSet, SelectorItemCollection sic) throws BOSException {
        BOSObjectType bosObjectType = BOSUuid.read((String)billIdSet.iterator().next()).getType();
        ICoreBase iBillBase = (ICoreBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)bosObjectType);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        return iBillBase.getCollection(view);
    }

    public static VoucherCollection getVoucherCollection(Context ctx, Set<String> voucherIdSet, SelectorItemCollection sic) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", voucherIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(sic);
        VoucherCollection voucherCollection = VoucherFactory.getLocalInstance((Context)ctx).getVoucherCollection(view);
        return voucherCollection;
    }

    public static VoucherCollection getVoucherCollection(Context ctx, Set<String> voucherIdSet) throws BOSException {
        return PoolSyncUtil.getVoucherCollection(ctx, voucherIdSet, PoolSyncUtil.getVoucherSelectors());
    }

    public static SelectorItemCollection getVoucherSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("period.number"));
        sic.add(new SelectorItemInfo("bookedDate"));
        sic.add(new SelectorItemInfo("bizDate"));
        return sic;
    }

    public static List getInvoiceList(Context ctx, Set<String> billIdList) throws BOSException {
        StringBuffer sql = new StringBuffer();
        List<String> invoiceTables = PwyHelperUtils.getBizAllowInvoiceTables();
        String tableName = null;
        int size = invoiceTables.size();
        for (int i = 0; i < size; ++i) {
            tableName = invoiceTables.get(i);
            if (i > 0) {
                sql.append("UNION ALL").append("\n");
            }
            if ("T_IM_INCOMEINVOICE".equalsIgnoreCase(tableName)) {
                sql.append(" SELECT FID,CONVERT(NVARCHAR(40),FSerialNo) as FSERIALNO,FBIZBILLID,");
                sql.append(" FBizVoucherID as FVOUCHERID,CONVERT(NVARCHAR(200),FBizVoucherNumber) as FVOUCHERNUMBER");
                sql.append(" FROM ").append(tableName).append(" WHERE FBIZBILLID  in ({" + i + "})");
                continue;
            }
            sql.append(" SELECT FID,CONVERT(NVARCHAR(40),FSerialNo) as FSERIALNO,FBIZBILLID,");
            sql.append(" FVoucherID as FVOUCHERID,CONVERT(NVARCHAR(200),FVoucherNumber) as FVOUCHERNUMBER");
            sql.append(" FROM ").append(tableName).append(" WHERE FBIZBILLID  in ({" + i + "})");
        }
        Object[] params = new Object[invoiceTables.size()];
        for (int i = 0; i < invoiceTables.size(); ++i) {
            params[i] = billIdList;
        }
        IRowSet rs = TMSqlUtil.executeQueryNotInject((Context)ctx, (String)sql.toString(), (Object[])params);
        ArrayList invoiceList = new ArrayList();
        try {
            ResultSetMetaData RSMD = rs.getMetaData();
            int colCount = RSMD.getColumnCount();
            HashMap<String, Object> invoiceObject = null;
            while (rs.next()) {
                invoiceObject = new HashMap<String, Object>();
                for (int k = 1; k <= colCount; ++k) {
                    invoiceObject.put(RSMD.getColumnName(k), rs.getObject(k));
                }
                invoiceList.add(invoiceObject);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return invoiceList;
    }
}

