/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.comm.service.vehicleMakeInvoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.OPTypeEnum;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.PwySettingInfo;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceCollection;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.comm.TaxTransLogInfo;
import com.kingdee.eas.tm.im.common.comm.TransOperTypeEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.AbstractPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.BizInterfaceFactory;
import com.kingdee.eas.tm.im.util.IMSelectorFactory;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class AbstractVehiclePwyService
extends AbstractPwyService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.comm.service.vehicleMakeInvoice.VehicleMakeInvoicePwyService");

    public AbstractVehiclePwyService(Context ctx, PwyInvokeParam invokeParam) {
        super(ctx, invokeParam);
    }

    public AbstractVehiclePwyService(Context ctx, TaxTransLogInfo pwyLog) {
        super(ctx, pwyLog);
    }

    @Override
    public List getValues() throws EASBizException, BOSException {
        String billId = this.getInvokeParam().getBillId();
        ArrayList<VehicleMakeInvoiceInfo> invoiceList = null;
        if (!StringUtils.isEmpty((String)billId)) {
            String[] invoiceArr = billId.split(",");
            HashSet<String> invoiceSet = new HashSet<String>(Arrays.asList(invoiceArr));
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", invoiceSet, CompareType.INCLUDE));
            view.setFilter(filter);
            view.setSelector(IMSelectorFactory.getVehicleMakeInvoiceSelectors());
            invoiceList = new ArrayList<VehicleMakeInvoiceInfo>();
            VehicleMakeInvoiceCollection invoiceColl = BizInterfaceFactory.getVehicleMakeInvoice(this.getCtx()).getVehicleMakeInvoiceCollection(view);
            VehicleMakeInvoiceInfo info = null;
            for (int i = 0; i < invoiceColl.size(); ++i) {
                info = invoiceColl.get(i);
                invoiceList.add(info);
            }
        }
        return invoiceList;
    }

    @Override
    protected PwySettingInfo getPwySetting() throws EASBizException, BOSException {
        FullOrgUnitInfo company;
        String orgid = this.getInvokeParam().getOrgId();
        VehicleMakeInvoiceInfo invoice = this.getInvoice();
        if (orgid == null) {
            orgid = invoice.getCompany().getId().toString();
        }
        if ((company = BizInterfaceFactory.getFullOrgUnit(this.getCtx()).getFullOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid))).isIsCompanyOrgUnit()) {
            CompanyOrgUnitInfo org = BizInterfaceFactory.getCompanyOrgUnit(this.getCtx()).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgid));
            this.getInvokeParam().setCompany(org);
        }
        logger.error((Object)("getPwySetting() : " + orgid + " - " + (invoice != null ? invoice.getId().toString() : null) + " - " + this.getPwyCzlx()));
        PwySettingInfo setting = BizInterfaceFactory.getPwySetting(this.getCtx()).getCollectionByCompany(orgid, OPTypeEnum.MakeInvoice, invoice != null ? invoice.getId().toString() : null, null);
        if (setting == null) {
            this.setReturn(this.getUnKownCode(), company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0]));
            throw new IMException(IMException.ERRORMSG, new Object[]{company.getName() + IMUtils.getIMResource(this.getCtx(), "NO_PWYSETTING", new String[0])});
        }
        return setting;
    }

    public VehicleMakeInvoiceInfo getInvoice() {
        Object value;
        VehicleMakeInvoiceInfo invoice = null;
        List invoices = null;
        try {
            invoices = this.getValues();
        }
        catch (Exception e) {
            return null;
        }
        if (invoices != null && invoices.size() == 1 && (value = invoices.get(0)) instanceof VehicleMakeInvoiceInfo) {
            invoice = (VehicleMakeInvoiceInfo)invoices.get(0);
        }
        return invoice;
    }

    @Override
    protected TaxTransLogInfo createPwyLog() throws EASBizException, BOSException {
        TaxTransLogInfo pwyLog = super.createPwyLog();
        pwyLog.setOperType(TransOperTypeEnum.makeinvoice);
        if (this.getInvoice() != null) {
            pwyLog.setInvoiceNumber(this.getInvoice().getNumber());
            pwyLog.setInvoiceNum(this.getInvoice().getInvoiceNo());
            pwyLog.setInvoiceCode(this.getInvoice().getInvoiceNumber());
        }
        return pwyLog;
    }

    @Override
    protected void handleSuccess() throws EASBizException, BOSException {
    }

    @Override
    public void invokeAction() throws EASBizException, BOSException {
        super.invokeAction();
        if ((this.isSuccess() || this.isPartSuccess()) && !StringUtils.isEmpty((String)this.getInvokeParam().getLogPK())) {
            LogUtils.afterLog(this.getCtx(), (IObjectPK)new ObjectUuidPK(this.getInvokeParam().getLogPK()));
        }
    }

    @Override
    protected PwyServiceType getTokenMsgType() {
        return PwyServiceType.OPR_WEB_GETTOKEN_MAKEINV;
    }

    @Override
    public String getSuccessCode() {
        return "0";
    }
}

