/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.formula.util;

import com.kingdee.bos.kscript.ParserException;
import com.kingdee.bos.kscript.parser.Token;
import com.kingdee.bos.kscript.parser.TokenList;
import com.kingdee.bos.service.formula.engine.IKScriptTransformer;
import com.kingdee.bos.service.formula.engine.KeyWordTransformer;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class EntityKeyWordTransformer
implements IKScriptTransformer {
    private static final Logger logger = Logger.getLogger(KeyWordTransformer.class);
    private static Map keywordMappingCache;
    private static Token[] keywords;

    public static String[] getKeyWords() {
        EntityKeyWordTransformer.setUpKeyWords();
        String[] ss1 = new String[keywordMappingCache.size()];
        ss1 = keywordMappingCache.keySet().toArray(ss1);
        String[] ss2 = new String[keywords.length + ss1.length];
        for (int i = 0; i < keywords.length; ++i) {
            ss2[i] = EntityKeyWordTransformer.keywords[i].value;
        }
        System.arraycopy(ss1, 0, ss2, keywords.length, ss1.length);
        return ss2;
    }

    private static void setUpKeyWords() {
        keywordMappingCache = new HashMap();
        keywords = EntityKeyWordTransformer.getAllPreDefinedTokens();
        ResourceBundle keywordBundle = ResourceBundle.getBundle("com.kingdee.eas.scm.framework.bizflow.formula.FormulaTokenMapping", EntityKeyWordTransformer.getLocale());
        Enumeration<String> names = keywordBundle.getKeys();
        while (names.hasMoreElements()) {
            String name = names.nextElement();
            boolean match = false;
            for (int i = 0; i < keywords.length; ++i) {
                Token keyword = keywords[i];
                if (!name.equalsIgnoreCase(keyword.value)) continue;
                match = true;
                String _sList = keywordBundle.getString(name);
                String[] ss = _sList.split("\\s+");
                for (int j = 0; j < ss.length; ++j) {
                    keywordMappingCache.put(ss[j], keyword);
                }
            }
            if (match) continue;
            String _sList = keywordBundle.getString(name);
            String[] ss = _sList.split("\\s+");
            for (int j = 0; j < ss.length; ++j) {
                keywordMappingCache.put(ss[j], new Token(3, name));
            }
        }
    }

    public TokenList transform(TokenList tokenList) throws ParserException {
        EntityKeyWordTransformer.setUpKeyWords();
        int index = 0;
        while (true) {
            Token k = null;
            try {
                k = tokenList.lookup(index);
            }
            catch (Exception e) {
                MsgBox.showWarning((String)e.getMessage());
                SysUtil.abort();
            }
            if (k == null || k.type == 12) break;
            if (keywordMappingCache.get(k.value) != null) {
                Token _k = (Token)keywordMappingCache.get(k.value);
                k.type = _k.type;
                k.value = _k.value;
            }
            ++index;
        }
        return tokenList;
    }

    static Token[] getAllPreDefinedTokens() {
        Field[] fields = Token.class.getFields();
        ArrayList<Token> keywords = new ArrayList<Token>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!Modifier.isStatic(field.getModifiers()) || !field.getDeclaringClass().equals(Token.class)) continue;
            try {
                Token keyword = (Token)field.get(null);
                keywords.add(keyword);
                continue;
            }
            catch (IllegalArgumentException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return keywords.toArray(new Token[keywords.size()]);
    }

    public TokenList reverseTransform(TokenList tokenList) throws ParserException {
        Token k;
        EntityKeyWordTransformer.setUpKeyWords();
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            Set entrySet = keywordMappingCache.entrySet();
            for (Map.Entry element : entrySet) {
                if (!(element.getValue() instanceof Token) || !k.equals((Token)element.getValue())) continue;
                k.type = 1;
                k.value = (String)element.getKey();
                break;
            }
            ++index;
        }
        return tokenList;
    }

    TokenList fixSpace(TokenList tokenList) throws ParserException {
        Token k;
        int index = 0;
        while ((k = tokenList.lookup(index)) != null && k.type != 12) {
            if (k.type == 4) {
                Token next = tokenList.lookup(index + 1);
                if (k.space.length() == 0) {
                    k.space = " ";
                }
                if (next != null && next.space.length() == 0) {
                    next.space = " ";
                }
            }
            ++index;
        }
        return tokenList;
    }

    public static Locale getLocale() {
        return SysContext.getSysContext().getLocale();
    }
}

