/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class IMWriteBackHandlerFactory {
    private static final Logger logger = Logger.getLogger(IMWriteBackHandlerFactory.class);

    public void handle(Context ctx, String bizAction, IObjectValue billInfo) throws EASBizException, BOSException {
        String destBillBosType = billInfo.getBOSType().toString();
        Object billID = null;
        if ("AC368D2D".equals(destBillBosType)) {
            MakeInvoiceReqInfo info = (MakeInvoiceReqInfo)billInfo;
            StringBuffer sql = new StringBuffer();
            sql.append(" select  entry.fsourcebillid,entry.fcorebillid from T_IM_MakeInvoiceReq bill");
            sql.append(" left join T_IM_MakeInvoiceReqEntry entry on bill.fid = entry.fparentid");
            sql.append(" where bill.fid = ?");
            sql.append(" group by bill.fsourcebillid");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billID});
            int rsSize = rs.size();
            String[] srcIdArr = new String[rsSize];
            String[][] idList = new String[rsSize][2];
            int i = 0;
            try {
                while (rs.next()) {
                    idList[i][0] = rs.getString(1);
                    idList[i][1] = rs.getString(2);
                    srcIdArr[i] = idList[i][0];
                    ++i;
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            String srcBillBosType = BOSUuid.read((String)info.getSourceBillId()).toString();
            String writeBackHandler = IMWriteBackHandlerFactory.getWriteBackHandler(destBillBosType, srcBillBosType);
            String[] billIds = new String[1];
            String[][] ids = new String[1][1];
            try {
                String methodName = "handle";
                Class<?> c = Class.forName(writeBackHandler);
                Object instance = c.newInstance();
                Method method = instance.getClass().getMethod("handle", Context.class, String.class, String[].class, String[][].class);
                method.invoke(instance, new Object[]{ctx, bizAction, billIds, ids});
            }
            catch (Exception e) {
                if (e.getCause() instanceof EASBizException) {
                    throw (EASBizException)e.getCause();
                }
                if (e.getCause() instanceof BOSException) {
                    throw (BOSException)e.getCause();
                }
                logger.error((Object)("writeBackHandler:" + writeBackHandler + "  invoke error"));
            }
        } else if ("412A6F98".equals(destBillBosType)) {
            // empty if block
        }
    }

    private static String getWriteBackHandler(String destBillBosType, String srcBillBosType) throws EASBizException, BOSException {
        String className = null;
        return className;
    }

    public Object invoke(String className, String methodName, Map params) throws BOSException, EASBizException {
        if (StringUtils.isEmpty((String)className) || StringUtils.isEmpty((String)methodName)) {
            logger.error((Object)("className:" + className + ",methodName:" + methodName + "  invoke param error"));
            throw new BOSException("className:" + className + ",methodName:" + methodName + "  invoke param error");
        }
        Map ret = new HashMap();
        try {
            Class<?> c = Class.forName(className);
            Object instance = c.newInstance();
            Method method = instance.getClass().getMethod(methodName, Map.class);
            ret = (Map)method.invoke(instance, params);
        }
        catch (Exception e) {
            if (e.getCause() instanceof EASBizException) {
                throw (EASBizException)e.getCause();
            }
            if (e.getCause() instanceof BOSException) {
                throw (BOSException)e.getCause();
            }
            logger.error((Object)("className:" + className + ",methodName:" + methodName + "  invoke error"));
        }
        return ret;
    }

    public static void main(String[] args) throws Exception {
    }
}

