/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.UsedCarInvoiceReqInfo;
import com.kingdee.eas.tm.im.UsedCarMakeInvoiceInfo;
import com.kingdee.eas.tm.im.VehicleInvoiceReqInfo;
import com.kingdee.eas.tm.im.VehicleMakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.writeback.WriteBackDefCollection;
import com.kingdee.eas.tm.im.common.writeback.WriteBackDefFactory;
import com.kingdee.eas.tm.im.common.writeback.WriteBackDefInfo;
import com.kingdee.eas.tm.im.common.writeback.app.AbstractWriteBackFacadeControllerBean;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2SaleOrderDisposerAdapter;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class WriteBackFacadeControllerBean
extends AbstractWriteBackFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.writeback.app.WriteBackFacadeControllerBean");

    @Override
    protected void _dispose(Context ctx, String action, IObjectValue value) throws BOSException, EASBizException {
        if (value == null) {
            return;
        }
        String destId = null;
        String destBosType = null;
        String srcBosType = null;
        String sourceBillId = null;
        int type = -1;
        if (value instanceof MakeInvoiceReqInfo || value instanceof VehicleInvoiceReqInfo || value instanceof UsedCarInvoiceReqInfo) {
            type = 0;
            if (value.get("sourceBillId") == null || value.get("id") == null) {
                return;
            }
            destId = value.get("id").toString();
            sourceBillId = value.get("sourceBillId").toString();
            destBosType = value.getBOSType().toString();
            srcBosType = BOSUuid.read((String)sourceBillId).getType().toString();
        } else if (value instanceof MakeInvoiceInfo || value instanceof VehicleMakeInvoiceInfo || value instanceof UsedCarMakeInvoiceInfo) {
            type = 1;
            if (value.get("id") == null) {
                return;
            }
            destId = value.get("id").toString();
            destBosType = BOSUuid.read((String)destId).getType().toString();
            srcBosType = this.getBizBosType(ctx, destId);
        }
        if (StringUtils.isEmpty(srcBosType)) {
            return;
        }
        WriteBackDefCollection defs = this.getWriteBackDefs(ctx, destBosType, srcBosType, type);
        if (defs == null || defs.size() == 0) {
            return;
        }
        WriteBackDefInfo writeBackDefInfo = null;
        String disposer = null;
        for (int i = 0; i < defs.size(); ++i) {
            writeBackDefInfo = defs.get(i);
            try {
                disposer = writeBackDefInfo.getHandlerClass();
                if (StringUtils.isEmpty((String)disposer)) {
                    return;
                }
                Object instance = Class.forName(disposer).newInstance();
                Method method = instance.getClass().getMethod("dispose", Context.class, String.class, String.class);
                ctx.put((Object)"CTX_WRITEBACKDEFINFO", (Object)writeBackDefInfo);
                method.invoke(instance, ctx, action, destId);
                continue;
            }
            catch (Throwable e) {
                logger.error((Object)(disposer + " invoke error:" + e.getMessage()));
                if (e.getCause() instanceof EASBizException) {
                    throw (EASBizException)e.getCause();
                }
                if (e.getCause() instanceof BOSException) {
                    throw (BOSException)e.getCause();
                }
                throw new BOSException(e);
            }
            finally {
                ctx.remove((Object)"CTX_WRITEBACKDEFINFO");
            }
        }
    }

    protected String getBizBosType(Context ctx, String destID) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FBizBillID FROM T_IM_MakeInvoiceRelation ");
        sql.append(" WHERE FInvoiceBillID = '" + destID + "'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashSet bizSet = new HashSet();
        String bizBillID = null;
        try {
            if (rs.next() && !StringUtils.isEmpty((String)(bizBillID = rs.getString("FBizBillID")))) {
                return BOSUuid.read((String)bizBillID).getType().toString();
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return null;
    }

    protected WriteBackDefCollection getWriteBackDefs(Context ctx, String destBosType, String srcBosType, int type) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("destBillBosType", (Object)destBosType));
        filter.getFilterItems().add(new FilterItemInfo("srcBillBosType", (Object)srcBosType));
        filter.getFilterItems().add(new FilterItemInfo("type", (Object)type));
        view.setFilter(filter);
        WriteBackDefCollection coll = WriteBackDefFactory.getLocalInstance(ctx).getWriteBackDefCollection(view);
        return coll;
    }

    @Override
    protected void _dispose2Order(Context ctx, String bizAction, Set invoiceIds) throws BOSException, EASBizException {
        InvoiceReq2SaleOrderDisposerAdapter disposerAdapter = new InvoiceReq2SaleOrderDisposerAdapter();
        disposerAdapter.dispose(ctx, bizAction, invoiceIds);
    }
}

