/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.writeback.InvoiceDisposerAssignInfo;
import com.kingdee.eas.tm.im.common.writeback.InvoiceDisposerConfigInfo;
import com.kingdee.eas.tm.im.common.writeback.InvoiceDisposerInfo;
import com.kingdee.eas.tm.im.common.writeback.app.handler.Invoice2SaleOrderUpgradeSQLHelper;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReserveUtils;
import com.kingdee.eas.tm.im.common.writeback.app.handler.TempTableDisposer;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class Invoice2SaleOrderUpgradeDisposer
extends TempTableDisposer {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceDisposer");
    private String filterSql = null;
    private Map<String, InvoiceDisposerInfo> destDisposerMap = new HashMap<String, InvoiceDisposerInfo>();
    private Map<String, InvoiceDisposerInfo> srcDisposerMap = new HashMap<String, InvoiceDisposerInfo>();
    private InvoiceDisposerConfigInfo srcConfig;
    private Map<String, InvoiceDisposerConfigInfo> configMap = new HashMap<String, InvoiceDisposerConfigInfo>();

    @Override
    public void doDispose(Context ctx, String action, String destId) throws BOSException, EASBizException, SQLException {
        LowTimer totalTimer = new LowTimer();
        LowTimer timer = new LowTimer();
        logger.debug((Object)("\u3010" + this.getClass().getName() + "\u3011\u5f00\u59cb\uff1a"));
        boolean initSuccess = this.init(ctx, action, destId);
        if (!initSuccess) {
            return;
        }
        String tablename = null;
        int bizDirection = this.getBizDirection(action);
        try {
            tablename = this.createTempTable(ctx, destId);
            logger.debug((Object)("\u3010\u521b\u5efa\u4e34\u65f6\u8868 \u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.insertInitData(tablename, destId);
            logger.debug((Object)("\u3010\u63d2\u5165\u521d\u59cb\u5316\u6570\u636e \u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            if (!this.verify(ctx, tablename)) {
                return;
            }
            this.lockBill(tablename, destId);
            logger.debug((Object)("\u3010\u9501\u5355\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.updateInitData(tablename, destId);
            logger.debug((Object)("\u3010\u66f4\u65b0\u53d1\u7968\u4fe1\u606f\u6570\u636e\u5230\u4e34\u65f6\u8868\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.assignSrcBill(ctx, tablename, destId, bizDirection);
            logger.debug((Object)("\u3010\u5206\u914d\u53d1\u7968\u6570\u636e\u5230\u6765\u6e90\u5355\u53cd\u5199\u5bf9\u8c61\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
            this.updateSrcBill(ctx, tablename, destId);
            logger.debug((Object)("\u3010\u53cd\u5199\u6e90\u5355\u3011\u82b1\u8d39:" + timer.msValue()));
            timer.reset();
        }
        catch (Throwable e) {
            throw new BOSException(e);
        }
        finally {
            if (tablename != null) {
                try {
                    this.releaseTable(ctx, tablename);
                }
                catch (Exception e) {
                    logger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
            logger.debug((Object)("\u3010" + this.getClass().getName() + "\u3011 \u7ed3\u675f\uff0c\u603b\u8017\u65f6:" + totalTimer.msValue()));
        }
    }

    protected boolean init(Context ctx, String action, String destId) throws BOSException {
        if (!InvoiceReserveUtils.isOrderSupport(ctx)) {
            return false;
        }
        this.configMap = InvoiceReserveUtils.buildInvoiceDisposerMap();
        this.srcConfig = this.configMap.get("C48A423A");
        return true;
    }

    protected boolean verify(Context ctx, String tablename) throws BOSException, SQLException {
        boolean success = false;
        StringBuffer selectSql = new StringBuffer();
        selectSql.append("select 1 from ").append(tablename);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql.toString());
        if (rs.next()) {
            success = true;
        }
        return success;
    }

    protected void updateInitData(String tablename, String destId) throws SQLException {
        InvoiceDisposerConfigInfo arConfig = this.configMap.get("FC910EF3");
        InvoiceDisposerConfigInfo reqConfig = this.configMap.get("AC368D2D");
        String sql = this.getUpdateInitData(tablename, destId, this.getSrcConfig(), arConfig);
        PreparedStatement ps = this.createPreparedStatement("updateInitData" + arConfig.getSrcBosType(), sql);
        this.executeUpdate(ps, null);
        sql = this.getUpdateInitData(tablename, destId, this.getSrcConfig(), reqConfig);
        ps = this.createPreparedStatement("updateInitData" + reqConfig.getSrcBosType(), sql);
        this.executeUpdate(ps, null);
    }

    protected String getUpdateInitData(String tablename, String destId, InvoiceDisposerConfigInfo srcConfig, InvoiceDisposerConfigInfo destConfig) {
        return Invoice2SaleOrderUpgradeSQLHelper.getUpdateInitDataSQL(tablename, srcConfig, destConfig);
    }

    protected int getBizDirection(String action) throws EASBizException, BOSException {
        int bizDirection = 0;
        Object[] forward = new String[]{"make"};
        Object[] reverse = new String[]{"cancel"};
        if (Arrays.asList((Object[])forward).indexOf(action) > -1) {
            bizDirection = 0;
        } else if (Arrays.asList((Object[])reverse).indexOf(action) > -1) {
            bizDirection = 1;
        } else {
            throw new BOSException("action is illegal");
        }
        return bizDirection;
    }

    protected String createTempTable(Context ctx, String destID) throws EASBizException, BOSException, SQLException {
        String tablename = this.getTableName(ctx, Invoice2SaleOrderUpgradeDisposer.class.getName());
        String createSQL = this.getCreateTempTableSQL(tablename);
        this.createTable(ctx, createSQL);
        return tablename;
    }

    protected String getCreateTempTableSQL(String tablename) {
        String createSQL = Invoice2SaleOrderUpgradeSQLHelper.getCreateTempTableSQL(tablename);
        return createSQL;
    }

    protected void insertInitData(String tablename, String destId) throws SQLException {
        String sql = this.getInitSelectSQL(tablename, destId);
        PreparedStatement ps = this.createPreparedStatement("insertInitData", sql);
        this.executeUpdate(ps, null);
    }

    protected String getInitSelectSQL(String tablename, String destId) {
        String sql = Invoice2SaleOrderUpgradeSQLHelper.getSaleOrderUpgradeInitSelectSQL(tablename, destId, this.getFilterSql());
        return sql;
    }

    protected void lockBill(String tablename, String destId) throws SQLException {
        String operName = "lockBill";
        StringBuffer sql = new StringBuffer();
        sql.append("UPDATE t_sd_saleorder set FID = FID where FID in (");
        sql.append("SELECT FSrcID FROM ").append(tablename).append(")");
        PreparedStatement ps = this.createPreparedStatement(operName, sql.toString());
        this.executeUpdate(ps, null);
    }

    protected void assignSrcBill(Context ctx, String tablename, String destId, int bizDirection) throws BOSException, SQLException {
        Map<String, List<InvoiceDisposerAssignInfo>> disposerAssignMap = this.buildDisposerAssignMap(ctx, tablename, this.destDisposerMap, this.srcDisposerMap);
        for (String destID : this.destDisposerMap.keySet()) {
            InvoiceDisposerInfo destInfo = this.destDisposerMap.get(destID);
            this.assignInvoiceFields(destInfo, disposerAssignMap.get(destID), bizDirection);
            this.assignInvoiceAmount(destInfo, disposerAssignMap.get(destID), bizDirection);
        }
    }

    protected void assignInvoiceFields(InvoiceDisposerInfo destInfo, List<InvoiceDisposerAssignInfo> disposerAssignList, int bizDirection) {
        int size = disposerAssignList.size();
        for (int i = 0; i < size; ++i) {
            InvoiceDisposerAssignInfo assignInfo = disposerAssignList.get(i);
            InvoiceDisposerInfo srcInfo = assignInfo.getSrcInfo();
            this.mergeInvoiceNumberAndCode(srcInfo, destInfo, bizDirection);
        }
    }

    protected void mergeInvoiceNumberAndCode(InvoiceDisposerInfo srcInfo, InvoiceDisposerInfo destInfo, int bizDirection) {
        ArrayList<String> numberList1 = new ArrayList<String>();
        ArrayList numberList2 = new ArrayList();
        if (srcInfo.getInvoiceNumber() != null) {
            Object[] numberArr1 = srcInfo.getInvoiceNumber().split(";");
            numberList1 = new ArrayList(Arrays.asList((Object[])numberArr1));
        }
        if (destInfo.getInvoiceNumber() != null) {
            Object[] numberArr2 = destInfo.getInvoiceNumber().split(";");
            numberList2 = new ArrayList(Arrays.asList((Object[])numberArr2));
        }
        if (numberList2.size() > 0) {
            String number = null;
            int size = numberList2.size();
            for (int i = 0; i < size; ++i) {
                number = (String)numberList2.get(i);
                if (numberList1.contains(number)) continue;
                numberList1.add(number);
            }
        }
        srcInfo.setInvoiceNumber(this.formatNumberAndCode(numberList1));
    }

    protected String formatNumberAndCode(List numberList) {
        if (numberList == null || numberList.size() == 0) {
            return null;
        }
        StringBuffer value = new StringBuffer();
        Iterator it = numberList.iterator();
        while (it.hasNext()) {
            value.append(it.next()).append(";");
        }
        if (value.length() > 0) {
            return value.substring(0, value.length() - 1);
        }
        return value.toString();
    }

    protected void assignInvoiceAmount(InvoiceDisposerInfo destInfo, List<InvoiceDisposerAssignInfo> disposerAssignList, int bizDirection) {
        int size = disposerAssignList.size();
        for (int i = 0; i < size; ++i) {
            InvoiceDisposerAssignInfo assignInfo = disposerAssignList.get(i);
            InvoiceDisposerInfo srcInfo = assignInfo.getSrcInfo();
            if (destInfo.getInvoiceAmount().compareTo(BigDecimal.ZERO) == 0) break;
            this.assignInvoiceAmount4Overwrite(destInfo, srcInfo, assignInfo);
        }
    }

    protected void assignInvoiceAmount4Overwrite(InvoiceDisposerInfo destInfo, InvoiceDisposerInfo srcInfo, InvoiceDisposerAssignInfo assignInfo) {
        BigDecimal unInvoiceAmount = assignInfo.getInvoiceReqAmount();
        if (unInvoiceAmount.compareTo(srcInfo.getBillAmount()) > 0) {
            unInvoiceAmount = srcInfo.getBillAmount();
        }
        if (destInfo.getInvoiceAmount().compareTo(unInvoiceAmount) > 0) {
            srcInfo.setInvoiceAmount(srcInfo.getInvoiceAmount().add(unInvoiceAmount));
            destInfo.setInvoiceAmount(destInfo.getInvoiceAmount().subtract(unInvoiceAmount));
        } else {
            srcInfo.setInvoiceAmount(srcInfo.getInvoiceAmount().add(destInfo.getInvoiceAmount()));
            destInfo.setInvoiceAmount(BigDecimal.ZERO);
        }
    }

    protected void assignInvoiceAmount4AddNew(InvoiceDisposerInfo destInfo, InvoiceDisposerInfo srcInfo, int bizDirection) {
        boolean isRedInvoice = false;
        if (destInfo.getInvoiceAmount().compareTo(BigDecimal.ZERO) < 0) {
            isRedInvoice = true;
        }
        if (isRedInvoice) {
            bizDirection = bizDirection == 0 ? 1 : 0;
            destInfo.setInvoiceAmount(destInfo.getInvoiceAmount().negate());
        }
        if (bizDirection == 0) {
            BigDecimal amount = srcInfo.getBillAmount();
            BigDecimal unInvoiceAmount = amount.subtract(srcInfo.getInvoiceAmount());
            if (destInfo.getInvoiceAmount().compareTo(unInvoiceAmount) > 0) {
                srcInfo.setInvoiceAmount(srcInfo.getInvoiceAmount().add(unInvoiceAmount));
                destInfo.setInvoiceAmount(destInfo.getInvoiceAmount().subtract(unInvoiceAmount));
            } else {
                srcInfo.setInvoiceAmount(srcInfo.getInvoiceAmount().add(destInfo.getInvoiceAmount()));
                destInfo.setInvoiceAmount(BigDecimal.ZERO);
            }
        } else {
            BigDecimal invoiceAmount = srcInfo.getInvoiceAmount();
            if (destInfo.getInvoiceAmount().compareTo(invoiceAmount) > 0) {
                srcInfo.setInvoiceAmount(BigDecimal.ZERO);
                destInfo.setInvoiceAmount(destInfo.getInvoiceAmount().subtract(invoiceAmount));
            } else {
                srcInfo.setInvoiceAmount(srcInfo.getInvoiceAmount().subtract(destInfo.getInvoiceAmount()));
                destInfo.setInvoiceAmount(BigDecimal.ZERO);
            }
        }
        if (isRedInvoice) {
            destInfo.setInvoiceAmount(destInfo.getInvoiceAmount().negate());
        }
    }

    protected Map<String, List<InvoiceDisposerAssignInfo>> buildDisposerAssignMap(Context ctx, String tablename, Map<String, InvoiceDisposerInfo> destDisposerMap, Map<String, InvoiceDisposerInfo> srcDisposerMap) throws BOSException, SQLException {
        String sql = Invoice2SaleOrderUpgradeSQLHelper.getSelectTempTableSQL(tablename, this.getSrcConfig());
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        HashMap<String, List<InvoiceDisposerAssignInfo>> disposerAssignMap = new HashMap<String, List<InvoiceDisposerAssignInfo>>();
        InvoiceDisposerInfo destInfo = null;
        InvoiceDisposerInfo srcInfo = null;
        String destID = null;
        String srcID = null;
        BigDecimal invoiceReqAmount = BigDecimal.ZERO;
        InvoiceDisposerAssignInfo disposerAssignInfo = null;
        while (rs.next()) {
            srcID = rs.getString("FSrcID");
            destID = rs.getString("FDestID");
            invoiceReqAmount = rs.getBigDecimal("FInvoiceReqAmount");
            srcInfo = srcDisposerMap.get(srcID);
            if (srcInfo == null) {
                srcInfo = this.createInvoiceDisposerInfo(rs, true);
                srcDisposerMap.put(srcInfo.getId(), srcInfo);
            }
            if ((destInfo = destDisposerMap.get(destID)) == null) {
                destInfo = this.createInvoiceDisposerInfo(rs, false);
                destDisposerMap.put(destInfo.getId(), destInfo);
            }
            if (!disposerAssignMap.containsKey(destID)) {
                disposerAssignMap.put(destID, new ArrayList());
            }
            disposerAssignInfo = new InvoiceDisposerAssignInfo();
            disposerAssignInfo.setDestInfo(destInfo);
            disposerAssignInfo.setSrcInfo(srcInfo);
            disposerAssignInfo.setInvoiceReqAmount(invoiceReqAmount);
            ((List)disposerAssignMap.get(destID)).add(disposerAssignInfo);
        }
        return disposerAssignMap;
    }

    protected InvoiceDisposerInfo createInvoiceDisposerInfo(IRowSet rs, boolean isSrc) throws SQLException {
        InvoiceDisposerInfo info = new InvoiceDisposerInfo();
        if (isSrc) {
            info.setId(rs.getString("FSrcID"));
            info.setBillAmount(rs.getBigDecimal("FAmount"));
        } else {
            info.setId(rs.getString("FDestID"));
            info.setInvoiceNumber(rs.getString("FInvoiceNumber"));
            info.setInvoiceCode(rs.getString("FInvoiceCode"));
            info.setInvoiceDate(rs.getDate("FInvoiceDate"));
            info.setInvoiceAmount(rs.getBigDecimal("FInvoiceAmount"));
        }
        return info;
    }

    protected String getSelectSrcBillSQL(String tablename, InvoiceDisposerConfigInfo config) {
        return Invoice2SaleOrderUpgradeSQLHelper.getSelectSrcBillSQL(tablename, config);
    }

    protected void updateSrcBill(Context ctx, String tablename, String destId) throws BOSException {
        InvoiceDisposerConfigInfo config = this.getSrcConfig();
        Map<String, InvoiceDisposerInfo> srcDisposerMap = this.getSrcDisposerMap();
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        ArrayList<Object> param = new ArrayList<Object>();
        String updateSrcBillSQL = this.getUpdateSrcBillSQL(config);
        for (String srcID : srcDisposerMap.keySet()) {
            InvoiceDisposerInfo srcInfo = srcDisposerMap.get(srcID);
            param = new ArrayList();
            if (config.isNeedReserveInvoiceNumber()) {
                param.add(srcInfo.getInvoiceNumber());
            }
            if (config.isNeedReserveInvoiceCode()) {
                param.add(srcInfo.getInvoiceCode());
            }
            if (config.isNeedReserveIsInvoiced()) {
                param.add(srcInfo.isInvoiced());
            }
            if (config.isNeedReserveInvoiceDate()) {
                param.add(srcInfo.getInvoiceDate());
            }
            if (config.isNeedReserveInvoiceAmount()) {
                param.add(srcInfo.getInvoiceAmount());
            }
            param.add(srcID);
            paramList.add(param.toArray());
        }
        if (paramList.size() > 0) {
            DbUtil.executeBatch((Context)ctx, (String)updateSrcBillSQL, paramList);
        }
    }

    protected String getUpdateSrcBillSQL(InvoiceDisposerConfigInfo config) {
        return Invoice2SaleOrderUpgradeSQLHelper.getUpdateSrcBillSQL(config);
    }

    public String getFilterSql() {
        return this.filterSql;
    }

    public void setFilterSql(String filterSql) {
        this.filterSql = filterSql;
    }

    public Map<String, InvoiceDisposerInfo> getSrcDisposerMap() {
        return this.srcDisposerMap;
    }

    public void setSrcDisposerMap(Map<String, InvoiceDisposerInfo> srcDisposerMap) {
        this.srcDisposerMap = srcDisposerMap;
    }

    public InvoiceDisposerConfigInfo getSrcConfig() {
        return this.srcConfig;
    }

    public void setSrcConfig(InvoiceDisposerConfigInfo srcConfig) {
        this.srcConfig = srcConfig;
    }
}

