/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceBaseDisposer;
import com.kingdee.eas.tm.im.util.CollectionUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Invoice2UsedCarInvoiceReqDisposer
extends InvoiceBaseDisposer {
    public void dispose(Context ctx, String action, String destID) throws EASBizException, BOSException {
        MakeInvoiceInfo invoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(destID));
        InvoiceBaseDisposer.InvoiceInfo invoiceInfo = new InvoiceBaseDisposer.InvoiceInfo(this);
        invoiceInfo.setInvoiceNumber(invoice.getInvoiceNumber());
        invoiceInfo.setInvoiceNo(invoice.getInvoiceNo());
        invoiceInfo.setInvoiceDate(invoice.getInvoiceDate());
        invoiceInfo.setInvoiceAmt(invoice.getPriceTaxTotal());
        if (!StringUtils.isEmpty((String)invoice.getRedBillId())) {
            MakeInvoiceInfo blueInvoice = MakeInvoiceFactory.getLocalInstance(ctx).getMakeInvoiceInfo((IObjectPK)new ObjectUuidPK(invoice.getRedBillId()));
            invoiceInfo.setBuleInvoiceDate(blueInvoice.getInvoiceDate());
        }
        int bizAction = this.getBizAction(action);
        int bizDirection = this.getBizDirection(invoiceInfo, bizAction);
        String invoiceId = invoice.getId().toString();
        String selectSql = this.getSelectReqSql(bizDirection);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new Object[]{invoiceId});
        try {
            HashMap<String, String> unique = new HashMap<String, String>();
            String updateSql = "update T_IM_UsedCarInvoiceReq set FInvoiceCode=?,FInvoiceNumber=? where fid=?";
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            HashSet<String> srcIdSet = new HashSet<String>();
            while (rs.next()) {
                String srcID = rs.getString("srcID");
                if (unique.containsKey(srcID)) continue;
                srcIdSet.add(srcID);
                String invoiceCode = rs.getString("invoiceCode");
                String invoiceNo = rs.getString("invoiceNo");
                if (bizAction == 0) {
                    invoiceCode = this.merge(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.merge(invoiceNo, invoice.getInvoiceNo());
                } else {
                    invoiceCode = this.reduce(invoiceCode, invoice.getInvoiceNumber());
                    invoiceNo = this.reduce(invoiceNo, invoice.getInvoiceNo());
                }
                Object[] param = new Object[]{invoiceCode, invoiceNo, srcID};
                paramList.add(param);
                unique.put(srcID, srcID);
            }
            if (paramList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateSql.toString(), paramList);
            }
            HashMap<String, BigDecimal> destAmtMap = new HashMap<String, BigDecimal>();
            destAmtMap.put(invoice.getId().toString(), invoice.getPriceTaxTotal());
            Map result = this.buildSrcAmtMap(ctx, rs, destAmtMap, bizAction, bizDirection);
            Map curAmtMap = (Map)result.get("curAmtMap");
            Map totalAmtMap = (Map)result.get("totalAmtMap");
            ArrayList<Object[]> paramAmtList = new ArrayList<Object[]>();
            String updateAmtSql = " update T_IM_UsedCarInvoiceReq set FInvoicedAmt=? where fid=?";
            ArrayList<Object[]> paramMarkList = new ArrayList<Object[]>();
            String updateMarkSql = " update T_IM_UsedCarInvoiceReq set FInvoiceDate=?,FIsInvoiced=? where fid=?";
            for (String billID : totalAmtMap.keySet()) {
                BigDecimal invoiceAmt = (BigDecimal)totalAmtMap.get(billID);
                if (invoiceAmt.compareTo(BigDecimal.ZERO) == 0) {
                    Object[] paramMark = new Object[]{null, 0, billID};
                    paramMarkList.add(paramMark);
                } else {
                    Date invoiceDate = invoiceInfo.getInvoiceDate(bizAction);
                    int isInvoiced = 1;
                    Object[] paramMark = new Object[]{invoiceDate, isInvoiced, billID};
                    paramMarkList.add(paramMark);
                }
                Object[] paramAmt = new Object[]{invoiceAmt, billID};
                paramAmtList.add(paramAmt);
            }
            if (paramAmtList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateAmtSql, paramAmtList);
            }
            if (paramMarkList.size() > 0) {
                DbUtil.executeBatch((Context)ctx, (String)updateMarkSql, paramMarkList);
            }
            if (srcIdSet.size() > 0) {
                this.dispose2Ar(ctx, invoiceInfo, srcIdSet, curAmtMap, bizAction, bizDirection);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    protected String getSelectReqSql(int bizDirection) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT src.FID as srcID,relation.FInvoiceBillID as destID,").append("\n");
        sql.append(" src.FInvoiceCode as invoiceCode,src.FInvoiceNumber as invoiceNo,").append("\n");
        sql.append(" src.FInvoicedAmt as invoiceAmt,src.FPriceIncludingTax as billAmount,src.FPriceIncludingTax as reqAmount,src.FAudittime as auditTime").append("\n");
        sql.append(" FROM T_IM_UsedCarInvoiceReq src").append("\n");
        sql.append(" INNER JOIN T_IM_MakeInvoiceRelation relation on src.fid = relation.FBizBillID").append("\n");
        sql.append(" WHERE relation.FInvoiceBillID = ?").append("\n");
        sql.append(" ORDER BY src.fauditTime ").append(bizDirection == 0 ? "asc" : "desc");
        return sql.toString();
    }

    @Override
    protected String getSelectArSql(Set destIdSet, int bizDirection) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select t.destID as destID,src.FID as srcID,").append("\n");
        sql.append(" src.FInvoiceCode as invoiceCode,src.FInvoiceNo as invoiceNo,").append("\n");
        sql.append(" src.FInvoicedAmt as invoiceAmt,src.FAmountLocal as billAmount,t.reqAmount as reqAmount,src.FAuditDate as auditTime").append("\n");
        sql.append(" FROM  t_ar_otherbill src INNER JOIN");
        sql.append(" (SELECT srcEntry.FParentID as srcID,destEntry.FParentID as destID,sum(destEntry.FPriceIncludingTax) as reqAmount");
        sql.append(" from T_IM_UsedCarInvoiceReqEntry destEntry").append("\n");
        sql.append(" inner join t_ar_otherbillentry srcEntry on srcEntry.fid = destEntry.FSourceBillEntryId").append("\n");
        sql.append(" where destEntry.fparentid in (").append(CollectionUtil.convertSet2String(destIdSet)).append(")").append("\n");
        sql.append(" group by srcEntry.FParentID,destEntry.FParentID");
        sql.append(" ) t on src.fid = t.srcID");
        sql.append(" order by src.FAuditDate ").append(bizDirection == 0 ? "asc" : "desc");
        return sql.toString();
    }
}

