/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2ArDisposer;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2SaleOrderSQLHelper;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReqDisposer;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReqSQLHelper;
import com.kingdee.eas.tm.im.util.IMParamUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LowTimer;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.util.StringUtils;

public class InvoiceReq2SaleOrderDisposer
extends InvoiceReqDisposer {
    private static Logger logger = Logger.getLogger(InvoiceReq2SaleOrderDisposer.class);
    private String filterSql = null;
    private Map paramMap = new HashMap();

    public InvoiceReq2SaleOrderDisposer() {
        super(1);
    }

    public InvoiceReq2SaleOrderDisposer(int disposeType) {
        super(disposeType);
        this.setSrcBosType("C48A423A");
    }

    public InvoiceReq2SaleOrderDisposer(int disposeType, String filterSql) {
        super(disposeType);
        this.setFilterSql(filterSql);
    }

    @Override
    protected void init(Context ctx, String action, String destId) throws BOSException, EASBizException {
        super.init(ctx, action, destId);
        this.initParam(ctx, action, destId);
    }

    protected void initParam(Context ctx, String action, String destId) throws BOSException, EASBizException {
        if (!StringUtils.isEmpty((Object)destId)) {
            String billId = destId.split(";")[0];
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo(this.getDestOrgField()));
            IObjectValue value = DynamicObjectFactory.getLocalInstance((Context)ctx).getValue(BOSUuid.read((String)billId).getType(), (IObjectPK)new ObjectUuidPK(billId), sic);
            CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)value.get(this.getDestOrgField());
            if (company != null) {
                Map map = IMUtils.getParam(ctx, company.getId().toString(), new String[]{"VATM019"});
                this.paramMap.put("VATM019", Boolean.valueOf(map.get("VATM019").toString()));
            } else {
                this.paramMap.put("VATM019", true);
            }
        }
        this.paramMap.put("isAllowPreInvoiceOverOrder", IMParamUtils.isAllowPreInvoiceOverOrder(ctx));
    }

    protected String getDestOrgField() {
        return "company";
    }

    @Override
    protected String getInitSelectSQL(String destId, String tableName) {
        String sql = null;
        if (this.getDisposeType() == 1) {
            sql = InvoiceReqSQLHelper.getInitSelectSQL(destId, tableName, this.getSrcTable(), this.getSrcEntryTable());
        } else if (this.getDisposeType() == 2) {
            sql = InvoiceReq2SaleOrderSQLHelper.getInvoiceReq2OtherBillInitSQL(destId, tableName);
        } else if (this.getDisposeType() == 3) {
            sql = InvoiceReq2SaleOrderSQLHelper.getInvoice2OtherBillInitSQL(destId, tableName);
        } else if (this.getDisposeType() == 5) {
            sql = InvoiceReq2SaleOrderSQLHelper.getVehicleInvoiceReq2OtherBillInitSQL(destId, tableName);
        } else if (this.getDisposeType() == 6) {
            sql = InvoiceReq2SaleOrderSQLHelper.getUsedCarInvoiceReq2OtherBillInitSQL(destId, tableName);
        } else if (this.getDisposeType() == 99) {
            sql = InvoiceReq2SaleOrderSQLHelper.getSaleOrderUpgradeInitSQL(destId, tableName, this.getFilterSql());
        }
        return sql;
    }

    @Override
    protected void updateInvoiceReq(Context ctx, String destId, String tablename, int bizDirection) throws SQLException, EASBizException, BOSException {
        LowTimer timer = new LowTimer();
        super.updateInvoiceReq(ctx, destId, tablename, bizDirection);
        logger.debug((Object)("\u3010updateInvoiceReq \u3011\u82b1\u8d39:" + timer.msValue()));
        timer.reset();
        this.updateInvoiceReq2Ar(destId, tablename, bizDirection);
        logger.debug((Object)("\u3010updateInvoiceReq2Ar\u3011\u82b1\u8d39:" + timer.msValue()));
        timer.reset();
        this.updateInvoive2OtherBill(destId, tablename, bizDirection);
        logger.debug((Object)("\u3010updateInvoive2OtherBill\u3011\u82b1\u8d39:" + timer.msValue()));
        timer.reset();
        this.updateVehicleInvoiceReq2Ar(destId, tablename, bizDirection);
        logger.debug((Object)("\u3010updateVehicleInvoiceReq2Ar\u3011\u82b1\u8d39:" + timer.msValue()));
        timer.reset();
        this.updateUsedCarInvoiceReq2Ar(destId, tablename, bizDirection);
        logger.debug((Object)("\u3010updateUsedCarInvoiceReq2Ar\u3011\u82b1\u8d39:" + timer.msValue()));
        timer.reset();
    }

    protected void updateVehicleInvoiceReq2Ar(String destId, String tablename, int bizDirection) throws SQLException {
        String qtySql = InvoiceReq2SaleOrderSQLHelper.getUpdateVehicleInvoiceReq2ArQtySQL(destId, tablename, bizDirection, this.getDisposeType());
        PreparedStatement qtyPs = this.createPreparedStatement("updateVehicleInvoiceReq2ArQty", qtySql);
        this.executeUpdate(qtyPs, null);
        String amtSql = InvoiceReq2SaleOrderSQLHelper.getUpdateVehicleInvoiceReq2ArAmtSQL(destId, tablename, bizDirection, this.getDisposeType());
        PreparedStatement amtPs = this.createPreparedStatement("updateVehicleInvoiceReq2ArAmt", amtSql);
        this.executeUpdate(amtPs, null);
    }

    protected void updateUsedCarInvoiceReq2Ar(String destId, String tablename, int bizDirection) throws SQLException {
        String qtySql = InvoiceReq2SaleOrderSQLHelper.getUpdateUsedCarInvoiceReq2ArQtySQL(destId, tablename, bizDirection, this.getDisposeType());
        PreparedStatement qtyPs = this.createPreparedStatement("updateUsedCarInvoiceReq2ArQty", qtySql);
        this.executeUpdate(qtyPs, null);
        String amtSql = InvoiceReq2SaleOrderSQLHelper.getUpdateUsedCarInvoiceReq2ArAmtSQL(destId, tablename, bizDirection, this.getDisposeType());
        PreparedStatement amtPs = this.createPreparedStatement("updateUsedCarInvoiceReq2ArAmt", amtSql);
        this.executeUpdate(amtPs, null);
    }

    @Override
    protected void cascadeDispose(Context ctx, String action, String destId) throws EASBizException, BOSException {
        if (this.getDisposeType() == 1) {
            InvoiceReq2ArDisposer arDisposer = new InvoiceReq2ArDisposer(2);
            arDisposer.dispose(ctx, action, destId);
        }
    }

    protected void updateInvoiceReq2Ar(String destId, String tablename, int bizDirection) throws SQLException {
        String sql = InvoiceReq2SaleOrderSQLHelper.getUpdateInvoiceReq2ArSQL(destId, tablename, bizDirection, this.getDisposeType());
        PreparedStatement ps = this.createPreparedStatement("UpdateInvoiceReq2Ar", sql);
        this.executeUpdate(ps, null);
    }

    private void updateInvoive2OtherBill(String destId, String tablename, int bizDirection) throws SQLException {
        String sql = InvoiceReq2SaleOrderSQLHelper.getUpdateInvoive2OtherBillSQL(destId, tablename, bizDirection, this.getDisposeType());
        PreparedStatement ps = this.createPreparedStatement("updateInvoive2OtherBill", sql);
        this.executeUpdate(ps, null);
    }

    @Override
    protected void verify(Context ctx, String destId, String tablename) throws EASBizException, SQLException {
        boolean notAllowInvoiceOverOrderAmt = (Boolean)this.paramMap.get("VATM019");
        boolean isAllowPreInvoiceOverOrderAmt = (Boolean)this.paramMap.get("isAllowPreInvoiceOverOrder");
        if (this.getDisposeType() == 1 && isAllowPreInvoiceOverOrderAmt || this.getDisposeType() != 1 && !notAllowInvoiceOverOrderAmt || this.getDisposeType() == 99) {
            return;
        }
        if (this.getDisposeType() == 1) {
            super.verify(ctx, destId, tablename);
        } else {
            String sql = InvoiceReq2SaleOrderSQLHelper.createWriteBackVerifySQL(destId, tablename, this.getSrcTable(), this.getSrcEntryTable());
            PreparedStatement ps = this.createPreparedStatement("verifyOrder", sql);
            IRowSet rs = this.executeQuery(ps, null);
            InvoiceReq2SaleOrderSQLHelper.verifyWriteBack(ctx, rs);
        }
    }

    @Override
    protected String getSrcTable() {
        return "T_SD_SaleOrder";
    }

    @Override
    protected String getSrcEntryTable() {
        return "T_SD_SaleOrderEntry";
    }

    @Override
    public String getSrcBosType() {
        return "C48A423A";
    }

    public String getFilterSql() {
        return this.filterSql;
    }

    public void setFilterSql(String filterSql) {
        this.filterSql = filterSql;
    }
}

