/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2SaleOrderDisposer;
import com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReserveUtils;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceReq2SaleOrderDisposerAdapter {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReq2SaleOrderDisposerAdapter");

    public void dispose(Context ctx, String action, String destId) throws EASBizException, BOSException {
        Set<String> invoiceIdSet = InvoiceReserveUtils.parseString2Set(destId);
        this.dispose(ctx, action, invoiceIdSet);
    }

    public void dispose(Context ctx, String action, Set<String> invoiceIdSet) throws EASBizException, BOSException {
        logger.error((Object)"\u6267\u884c\u5f00\u7968\u5355\u53cd\u5199\u8ba2\u5355\u9002\u914d\u5668");
        if (!InvoiceReserveUtils.isOrderSupport(ctx)) {
            return;
        }
        Set<String> bizIdSet = this.getBizBillIds(ctx, invoiceIdSet);
        if (bizIdSet.size() == 0) {
            return;
        }
        String srcBillBosType = BOSUuid.read((String)bizIdSet.iterator().next()).getType().toString();
        if (!"FC910EF3".equals(srcBillBosType)) {
            return;
        }
        int bizDirection = this.getBizDirection(action);
        if (!this.isDataChange(ctx, invoiceIdSet, action, bizDirection)) {
            return;
        }
        String bizAction = "save";
        if ("delete".equals(action)) {
            bizAction = "delete";
        }
        InvoiceReq2SaleOrderDisposer arDisposer = new InvoiceReq2SaleOrderDisposer(3);
        arDisposer.dispose(ctx, bizAction, InvoiceReserveUtils.concatSet2String(bizIdSet));
    }

    protected boolean isDataChange(Context ctx, Set<String> invoiceIdSet, String action, int bizDirection) throws BOSException {
        if ("addSrcBill".equals(action) || "cancelSrcBill".equals(action) || "cancel".equals(action)) {
            return true;
        }
        Boolean currentState = this.checkHasMakeInvoice(ctx, invoiceIdSet, bizDirection);
        Boolean preState = this.checkHasMakeInvoice(ctx, invoiceIdSet, bizDirection == 0 ? 1 : 0);
        return currentState == false || !currentState.equals(preState);
    }

    protected boolean isNeedReserve(Context ctx) throws BOSException {
        return InvoiceReserveUtils.isOrderSupport(ctx);
    }

    protected int getBizDirection(String action) throws EASBizException, BOSException {
        int bizDirection = 0;
        Object[] forward = new String[]{"save", "genInvoice", "make", "addSrcBill", "submit", "red", "cancel", "cancelSrcBill"};
        Object[] reverse = new String[]{"delete"};
        Object[] restore = new String[]{"restore"};
        if (Arrays.asList((Object[])forward).indexOf(action) > -1) {
            bizDirection = 0;
        } else if (Arrays.asList((Object[])reverse).indexOf(action) > -1) {
            bizDirection = 1;
        } else if (Arrays.asList((Object[])restore).indexOf(action) > -1) {
            bizDirection = -1;
        } else {
            throw new BOSException("action is illegal");
        }
        return bizDirection;
    }

    protected boolean checkHasMakeInvoice(Context ctx, Set<String> invoiceIdSet, int bizDirection) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1 FROM t_im_makeinvoicerelation t1");
        sql.append(" INNER JOIN t_im_makeinvoice t2 on t1.FINVOICEBILLID = t2.fid");
        sql.append(" inner join t_ar_otherbill src on t1.fbizbillid = src.fid");
        sql.append(" where (");
        sql.append(" src.FInvoicedAmt <> 0");
        sql.append(" or  ");
        sql.append(" t2.fid  in  ( SELECT fid FROM  t_im_makeinvoice  where FStatus in ('1','2','3') ) ");
        sql.append(")");
        sql.append(" and t1.fbizbillid  in (");
        sql.append("   SELECT fbizbillid from t_im_makeinvoicerelation where finvoicebillid in " + IMUtils.getInStringFromSet(invoiceIdSet));
        sql.append(" )");
        if (bizDirection == 1) {
            sql.append(" and t2.fid not in").append(IMUtils.getInStringFromSet(invoiceIdSet));
        }
        IRowSet selRs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        boolean hasMakeInvoice = false;
        try {
            if (selRs.next()) {
                hasMakeInvoice = true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return hasMakeInvoice;
    }

    protected Set<String> getBizBillIds(Context ctx, Set<String> invoiceIdSet) throws BOSException {
        String selectSQL = "select fbizbillid from t_im_makeinvoicerelation where finvoicebillid in " + IMUtils.getInStringFromSet(invoiceIdSet);
        HashSet<String> bizIdSet = new HashSet<String>();
        String bizbillid = null;
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            while (rs.next()) {
                bizbillid = rs.getString("fbizbillid");
                bizIdSet.add(bizbillid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select relation.fbizbillid from t_im_makeinvoicerelation relation ");
        sql.append(" inner join t_im_makeinvoice invoice on invoice.FRedBillId = relation.finvoicebillid");
        sql.append(" where invoice.fid in ").append(IMUtils.getInStringFromSet(invoiceIdSet));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                bizbillid = rs.getString("fbizbillid");
                bizIdSet.add(bizbillid);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return bizIdSet;
    }
}

