/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.common.writeback.app.handler;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.tm.im.common.writeback.InvoiceDisposerConfigInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceReserveUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.common.writeback.app.handler.InvoiceReserveUtils");
    public static final String TAXSEPARATION_BOSTYPE = "3D667D4A";
    public static final String MAKEINVOICEREQ_BOSTYPE = "AC368D2D";
    public static final String AROTHERBILL_BOSTYPE = "FC910EF3";
    public static final String APOTHERBILL_BOSTYPE = "48DA3A71";
    public static final String SALEORDER_BOSTYPE = "C48A423A";
    public static final String WBRESOURCE = "com.kingdee.eas.tm.im.common.writeback.InvoiceWBResource";

    public static String concatList2String(List list) {
        String returnStr = "";
        for (int i = 0; i < list.size(); ++i) {
            returnStr = i == 0 ? returnStr + list.get(i).toString() : returnStr + ";" + list.get(i).toString();
        }
        return returnStr;
    }

    public static String concatSet2String(Set idSet) {
        return InvoiceReserveUtils.concatList2String(new ArrayList(idSet));
    }

    public static Set<String> parseString2Set(String billID) {
        String[] billIDs = billID.split(";");
        HashSet<String> idSet = new HashSet<String>();
        int size = billIDs.length;
        for (int i = 0; i < size; ++i) {
            idSet.add(billIDs[i]);
        }
        return idSet;
    }

    public static boolean isOrderSupport(Context ctx) throws BOSException {
        try {
            if (InvoiceReserveUtils.isColumnExists(ctx, "T_SD_SaleOrderEntry", "FInvoiceReqQty")) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static boolean isUsedCar2ArSupport(Context ctx) throws BOSException {
        try {
            if (InvoiceReserveUtils.isColumnExists(ctx, "T_AR_OtherBill", "FIsUsedCarInvoiceReq")) {
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isColumnExists(Context ctx, String tblName, String columnName) throws SQLException {
        String sql = "SELECT 1 WHERE EXISTS(SELECT 1 FROM KSQL_USERCOLUMNS WHERE KSQL_COL_TABNAME = '" + tblName + "' AND KSQL_COL_NAME = '" + columnName + "'  )";
        IRowSet rs = null;
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            boolean bl = rs.next();
            return bl;
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            SQLUtils.cleanup((ResultSet)rs);
        }
        return false;
    }

    public static Map buildInvoiceDisposerMap() {
        HashMap<String, InvoiceDisposerConfigInfo> invoiceDisposerMap = new HashMap<String, InvoiceDisposerConfigInfo>();
        ArrayList<InvoiceDisposerConfigInfo> disposerList = new ArrayList<InvoiceDisposerConfigInfo>();
        InvoiceDisposerConfigInfo invoice = new InvoiceDisposerConfigInfo();
        invoice.setSrcBosType("412A6F98");
        invoice.setInvoiceNumber("FInvoiceNo");
        invoice.setInvoiceCode("FInvoiceNumber");
        invoice.setInvoiceDate("FInvoiceDate");
        invoice.setIsInvoiced(null);
        invoice.setInvoiceAmount("FPriceTaxTotal");
        invoice.setSrcTable("T_IM_MakeInvoice");
        invoice.setSrcEntryTable("T_IM_MakeInvoiceEntry");
        invoice.setBillAmount("FPriceTaxTotal");
        disposerList.add(invoice);
        InvoiceDisposerConfigInfo invoiceReq = new InvoiceDisposerConfigInfo();
        invoiceReq.setSrcBosType(MAKEINVOICEREQ_BOSTYPE);
        invoiceReq.setInvoiceNumber("FInvoiceNo");
        invoiceReq.setInvoiceCode("FInvoiceCode");
        invoiceReq.setInvoiceDate("FInvoiceDate");
        invoiceReq.setIsInvoiced("FIsInvoiced");
        invoiceReq.setInvoiceAmount("FInvoicedAmt");
        invoiceReq.setSrcTable("T_IM_MakeInvoiceReq");
        invoiceReq.setSrcEntryTable("T_IM_MakeInvoiceReqEntry");
        invoiceReq.setBillAmount("FPriceIncludingTaxLocal");
        invoiceReq.setAuditDate("FAuditTime");
        invoiceReq.setCurrencyID("FCurrencyID");
        invoiceReq.setExchangeRate("FExchangeRate");
        invoiceReq.setCompanyID("FCompanyID");
        invoiceReq.setInvoiceReqAmount("FPriceIncludingTax");
        invoiceReq.setInvoiceReqAmountLocal("FPriceIncludingTaxLocal");
        disposerList.add(invoiceReq);
        InvoiceDisposerConfigInfo arotherbill = new InvoiceDisposerConfigInfo();
        arotherbill.setSrcBosType(AROTHERBILL_BOSTYPE);
        arotherbill.setInvoiceNumber("FInvoiceNo");
        arotherbill.setInvoiceCode("FInvoiceCode");
        arotherbill.setInvoiceDate("FInvoiceDate");
        arotherbill.setIsInvoiced("FIsInvoiced");
        arotherbill.setInvoiceAmount("FInvoicedAmt");
        arotherbill.setSrcTable("T_AR_OtherBill");
        arotherbill.setSrcEntryTable("T_AR_OtherBillentry");
        arotherbill.setBillAmount("FAmountLocal");
        arotherbill.setAuditDate("FAuditDate");
        arotherbill.setCurrencyID("FCurrencyID");
        arotherbill.setExchangeRate("FExchangeRate");
        arotherbill.setCompanyID("FCompanyID");
        arotherbill.setInvoiceReqAmount("FInvoiceReqAmount");
        arotherbill.setInvoiceReqAmountLocal("FInvoiceReqAmountLocal");
        arotherbill.setEntryAmount("FRecievePayAmount");
        arotherbill.setEntryAmountLocal("FRecievePayAmountLocal");
        disposerList.add(arotherbill);
        InvoiceDisposerConfigInfo apotherbill = new InvoiceDisposerConfigInfo();
        apotherbill.setSrcBosType(APOTHERBILL_BOSTYPE);
        apotherbill.setInvoiceNumber("FInvoiceNumber");
        apotherbill.setInvoiceCode("FInvoiceCode");
        apotherbill.setSrcTable("T_AP_OtherBill");
        apotherbill.setSrcEntryTable("T_AP_OtherBillentry");
        apotherbill.setBillAmount("FAmountLocal");
        apotherbill.setCurrencyID("FCurrencyID");
        apotherbill.setExchangeRate("FExchangeRate");
        apotherbill.setCompanyID("FCompanyID");
        apotherbill.setInvoiceReqAmount("FInvoiceReqAmount");
        apotherbill.setInvoiceReqAmountLocal("FInvoiceReqAmountLocal");
        apotherbill.setAuditDate("FAuditDate");
        disposerList.add(apotherbill);
        InvoiceDisposerConfigInfo saleorder = new InvoiceDisposerConfigInfo();
        saleorder.setSrcBosType(SALEORDER_BOSTYPE);
        saleorder.setInvoiceNumber("FINVOICENUMBER");
        saleorder.setInvoiceAmount("FINVOICEAMT");
        saleorder.setSrcTable("T_SD_SaleOrder");
        saleorder.setSrcEntryTable("T_SD_SaleOrderEntry");
        saleorder.setBillAmount("FLocalTotalTaxAmount");
        saleorder.setCurrencyID("FCurrencyID");
        saleorder.setExchangeRate("FExchangeRate");
        saleorder.setCompanyID("FCompanyOrgUnitID");
        saleorder.setInvoiceReqAmount("FInvoiceReqAmount");
        saleorder.setInvoiceReqAmountLocal("FInvoiceReqAmountLocal");
        saleorder.setAuditDate("FAuditTime");
        disposerList.add(saleorder);
        InvoiceDisposerConfigInfo info2 = null;
        for (InvoiceDisposerConfigInfo info2 : disposerList) {
            invoiceDisposerMap.put(info2.getSrcBosType(), info2);
        }
        return invoiceDisposerMap;
    }
}

