/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.tm.im.basedata.TaxPlateCollection;
import com.kingdee.eas.tm.im.basedata.TaxPlateFactory;
import com.kingdee.eas.tm.im.basedata.TaxPlateStatus;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrFactory;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrInfo;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrStatus;
import com.kingdee.eas.tm.im.inv.app.AbstractInvMgrFacadeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.util.BaseException;
import com.kingdee.util.NumericExceptionSubItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvMgrFacadeControllerBean
extends AbstractInvMgrFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvMgrFacadeControllerBean");

    @Override
    protected Map _operationDispatch(Context ctx, Map params) throws BOSException, EASBizException {
        List idList = (List)params.get("idList");
        int idListSize = idList.size();
        IObjectValue model = (IObjectValue)params.get("model");
        String bosType = (String)params.get("bosType");
        String methodName = (String)params.get("methodName");
        Map paramMap = (Map)params.get("paramMap");
        Class[] paramsTypes = (Class[])params.get("paramsTypes");
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)BOSObjectType.create((String)bosType));
        BatchExecuteParamsEntry[] paramsEntry = null;
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        ArrayList<String> errMsgList = new ArrayList<String>();
        IMutexServiceControl mutexServiceControl = MutexServiceControlFactory.getLocalInstance((Context)ctx);
        try {
            int errCount = 0;
            Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
            Iterator lt = idList.iterator();
            while (lt.hasNext()) {
                String id = (String)lt.next();
                Object value = map.get(id);
                if (value == null || Boolean.valueOf(value.toString()).booleanValue()) continue;
                EASBizException mutexException = new EASBizException(new NumericExceptionSubItem("100", ResourceBase.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_ObjectUpdateLock_Request", (Locale)ctx.getLocale())));
                errMsgList.add(id);
                ++errCount;
                lt.remove();
            }
            paramsEntry = this.getParameters(idList, paramsTypes, paramMap, model);
            BatchExecuteResult exeResult = bizCtrl.batchExecute(methodName, paramsTypes, paramsEntry);
            if (exeResult.getBatchResult() == null) {
                Throwable[] exps = exeResult.getExceptions();
                for (int i = 0; i < exps.length; ++i) {
                    if (exps[i] == null) continue;
                    errMsgList.add(exps[i].getMessage());
                    ++errCount;
                }
            } else {
                BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
                for (int i = 0; i < paramsEntry.length; ++i) {
                    Object id = paramsEntry[i].get(0);
                    ActionResult actionResult = actionResults.getActionResult(id);
                    if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                    errMsgList.add(actionResult.getMessage());
                    ++errCount;
                }
            }
            result.put("sucCount", Integer.valueOf(idListSize - errCount));
            result.put("errCount", Integer.valueOf(errCount));
            result.put("errMsgList", errMsgList);
        }
        catch (BaseException e) {
            if (e instanceof EASBizException) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw (EASBizException)((Object)e);
            }
            throw new BOSException(e.getMessage());
        }
        finally {
            mutexServiceControl.batchReleaseObjIDForUpdate(idList);
        }
        return result;
    }

    public BatchExecuteParamsEntry[] getParameters(List<String> idList, Class[] paramTypes, Map paramMap, IObjectValue model) {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            for (int j = 0; j < paramTypes.length; ++j) {
                if (IObjectPK.class.equals((Object)paramTypes[j])) {
                    entry.add(j, (Object)new ObjectUuidPK(idList.get(i)));
                    continue;
                }
                if (Map.class.equals((Object)paramTypes[j])) {
                    entry.add(j, (Object)paramMap);
                    continue;
                }
                if (!IObjectValue.class.equals((Object)paramTypes[j])) continue;
                entry.add(j, (Object)model);
            }
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    @Override
    protected Map _checkUpdateInvMgr(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        InvoiceInvMgrCollection coll = InvoiceInvMgrFactory.getLocalInstance(ctx).getInvoiceInvMgrCollection(view);
        String errMsg = ":" + IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_UPDATAINVMGR", ctx);
        ArrayList<String> errMsgList = new ArrayList<String>();
        ArrayList<String> ids = new ArrayList<String>();
        for (int i = 0; i < coll.size(); ++i) {
            InvoiceInvMgrInfo info = coll.get(i);
            if (InvoiceInvMgrStatus.USING.equals((Object)info.getStatus())) {
                ids.add(info.getId().toString());
                continue;
            }
            errMsgList.add(info.getNumber() + errMsg);
        }
        HashMap<String, ArrayList<String>> ret = new HashMap<String, ArrayList<String>>();
        ret.put("errMsg", errMsgList);
        ret.put("ids", ids);
        return ret;
    }

    @Override
    protected IObjectCollection _getTaxPlateByTaxNumber(Context ctx, String taxNumber) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("pwyData.taxNumber", (Object)taxNumber));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)TaxPlateStatus.USING));
        TaxPlateCollection coll = TaxPlateFactory.getLocalInstance(ctx).getTaxPlateCollection(view);
        return coll;
    }
}

