/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.inv.InvoiceAlarmEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceAlarmEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceAlarmInfo;
import com.kingdee.eas.tm.im.inv.InvoiceAlarmStatus;
import com.kingdee.eas.tm.im.inv.OutputInvoiceType;
import com.kingdee.eas.tm.im.inv.app.AbstractInvoiceAlarmControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.enums.EnumUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class InvoiceAlarmControllerBean
extends AbstractInvoiceAlarmControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvoiceAlarmControllerBean");
    private final String SUFFIX = "_Alarm";

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceAlarmInfo info = (InvoiceAlarmInfo)model;
        if (info.getId() == null) {
            info.setId(BOSUuid.create((BOSObjectType)this.getBOSType()));
        }
        if (info.getCU() == null) {
            info.setCU(((FullOrgUnitInfo)ctx.get((Object)"CurOU")).getCU());
        }
        if (info.getNumber() == null) {
            info.setNumber(info.getInvoiceInvMgr().getNumber() + "_Alarm");
        }
        if (info.getStatus() == null) {
            info.setStatus(InvoiceAlarmStatus.USING);
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceAlarmInfo invoiceAlarmInfo = this.getInvoiceAlarmInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(invoiceAlarmInfo.getCU().getId().toString(), "im_invoiceAlarm_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{invoiceAlarmInfo.getNumber() + ":" + e.getMessage()});
        }
        if (InvoiceAlarmStatus.USING.equals((Object)invoiceAlarmInfo.getStatus())) {
            String deleteMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_DELETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{deleteMsg});
        }
        String invoiceInvMgr = invoiceAlarmInfo.getInvoiceInvMgr().getId().toString();
        super._delete(ctx, pk);
        StringBuffer sql = new StringBuffer();
        sql.append(" UPDATE T_IM_InvoiceInvMgr SET FIsAlarm = 0 WHERE FID = ");
        sql.append(" '").append(invoiceInvMgr).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" DELETE FROM T_BOT_Relation WHERE FDestObjectID = ");
        sql.append(" '").append(pk.toString()).append("' ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getInvoiceAlarmInfo(ctx, pk);
        }
        InvoiceAlarmInfo info = (InvoiceAlarmInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "im_invoiceAlarm_cancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() == InvoiceAlarmStatus.FORBIDDEN) {
            String cancel = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + cancel});
        }
        info.setStatus(InvoiceAlarmStatus.FORBIDDEN);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getInvoiceAlarmInfo(ctx, pk);
        }
        InvoiceAlarmInfo info = (InvoiceAlarmInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCU().getId().toString(), "im_invoiceAlarm_cancelcancel");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() == InvoiceAlarmStatus.USING) {
            String active = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CANCELCANCEL", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + active});
        }
        info.setStatus(InvoiceAlarmStatus.USING);
        super._update(ctx, pk, (IObjectValue)info);
    }

    @Override
    protected void _reCalculate(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            InvoiceAlarmInfo alarm = this.getInvoiceAlarmInfo(ctx, pk, this.getSelectors());
            try {
                IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(alarm.getCU().getId().toString(), "im_invoiceAlarm_reCalculate");
            }
            catch (Exception e) {
                throw new IMException(IMException.ERRORMSG, new Object[]{alarm.getNumber() + ":" + e.getMessage()});
            }
            if (InvoiceAlarmStatus.FORBIDDEN.equals((Object)alarm.getStatus())) {
                String reCalculate = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_RECALCULATE", ctx);
                logger.error((Object)(alarm.getNumber() + ":" + reCalculate));
                return;
            }
            StringBuffer sql = new StringBuffer();
            sql.append(" SELECT FINVOICETYPE invoiceType, SUM(FQUANTITY) quantity, SUM(FREMAINDERQTY) remainderQty, SUM(FUSEDQTY) usedQty ");
            sql.append(" FROM T_IM_InvoiceInvMgrEntry WHERE FPARENTID = ");
            sql.append(" \t(SELECT FInvoiceInvMgrID FROM T_IM_INVOICEALARM WHERE FID = ");
            sql.append(" \t'").append(pk.toString()).append("') ");
            sql.append(" GROUP BY FINVOICETYPE ");
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            HashMap<String, InvoiceAlarmEntryInfo> oldEntryMap = new HashMap<String, InvoiceAlarmEntryInfo>();
            HashMap<String, InvoiceAlarmEntryInfo> newEntryMap = new HashMap<String, InvoiceAlarmEntryInfo>();
            InvoiceAlarmEntryCollection entry = alarm.getEntry();
            for (int i = 0; i < entry.size(); ++i) {
                oldEntryMap.put(entry.get(i).getInvoiceType().getValue(), entry.get(i));
            }
            while (rs.next()) {
                InvoiceAlarmEntryInfo alarmEntryInfo;
                String invoiceType = rs.getString("invoiceType");
                int quantity = rs.getInt("quantity");
                int remainderQty = rs.getInt("remainderQty");
                int usedQty = rs.getInt("usedQty");
                if (oldEntryMap.containsKey(invoiceType)) {
                    alarmEntryInfo = (InvoiceAlarmEntryInfo)oldEntryMap.get(invoiceType);
                    oldEntryMap.remove(invoiceType);
                } else {
                    alarmEntryInfo = new InvoiceAlarmEntryInfo();
                    alarmEntryInfo.setInvoiceType((OutputInvoiceType)EnumUtils.getEnumByValue(OutputInvoiceType.class, (String)invoiceType));
                }
                alarmEntryInfo.setQuantity(quantity);
                alarmEntryInfo.setRemainderQty(remainderQty);
                alarmEntryInfo.setUsedQty(usedQty);
                newEntryMap.put(invoiceType, alarmEntryInfo);
            }
            for (String invoiceType : oldEntryMap.keySet()) {
                InvoiceAlarmEntryInfo alarmEntry = (InvoiceAlarmEntryInfo)oldEntryMap.get(invoiceType);
                alarmEntry.setQuantity(0);
                alarmEntry.setRemainderQty(0);
                alarmEntry.setUsedQty(0);
                alarmEntry.setTotalRemainderQty(0);
                newEntryMap.put(invoiceType, alarmEntry);
            }
            if (alarm.getTaxPlate().isIsMain()) {
                String taxNumber = alarm.getInvoiceInvMgr().getTaxNumber();
                sql.setLength(0);
                sql.append(" SELECT FINVOICETYPE invoiceType, SUM(FREMAINDERQTY) totalRemainderQty ");
                sql.append(" FROM T_IM_InvoiceInvMgrEntry WHERE FPARENTID in ");
                sql.append(" \t(SELECT FID FROM T_IM_InvoiceInvMgr WHERE FTaxNumber = ");
                sql.append(" \t'").append(taxNumber).append("' AND FStatus = '0' ) ");
                sql.append(" GROUP BY FINVOICETYPE ");
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                while (rs.next()) {
                    InvoiceAlarmEntryInfo alarmEntryInfo;
                    String invoiceType = rs.getString("invoiceType");
                    int totalRemainderQty = rs.getInt("totalRemainderQty");
                    if (newEntryMap.containsKey(invoiceType)) {
                        alarmEntryInfo = (InvoiceAlarmEntryInfo)newEntryMap.get(invoiceType);
                    } else {
                        alarmEntryInfo = new InvoiceAlarmEntryInfo();
                        alarmEntryInfo.setInvoiceType((OutputInvoiceType)EnumUtils.getEnumByValue(OutputInvoiceType.class, (String)invoiceType));
                        newEntryMap.put(invoiceType, alarmEntryInfo);
                    }
                    alarmEntryInfo.setTotalRemainderQty(totalRemainderQty);
                }
            }
            alarm.getEntry().clear();
            for (InvoiceAlarmEntryInfo alarmEntry : newEntryMap.values()) {
                alarm.getEntry().add(alarmEntry);
            }
            super._update(ctx, pk, (IObjectValue)alarm);
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException(e.getMessage());
        }
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxPlate.isMain"));
        sic.add(new SelectorItemInfo("invoiceInvMgr.taxNumber"));
        sic.add(new SelectorItemInfo("entry.*"));
        return sic;
    }

    @Override
    protected Map _setAlarmQty(Context ctx, IObjectPK pk, Map params) throws BOSException, EASBizException {
        InvoiceAlarmInfo alarm = this.getInvoiceAlarmInfo(ctx, pk, this.getSelectors());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(alarm.getCU().getId().toString(), "im_invoiceAlarm_setAlarmQty");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{alarm.getNumber() + ":" + e.getMessage()});
        }
        InvoiceAlarmEntryCollection entries = alarm.getEntry();
        boolean needUpdate = false;
        for (int i = 0; i < entries.size(); ++i) {
            InvoiceAlarmEntryInfo entry = entries.get(i);
            Object object = params.get(entry.getInvoiceType().getValue());
            if (object == null || object.toString().isEmpty()) continue;
            entry.setAlarmQty(Integer.valueOf(object.toString()));
            needUpdate = true;
        }
        if (needUpdate) {
            this._update(ctx, pk, (IObjectValue)alarm);
        }
        return null;
    }
}

