/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.inv.InvoiceCheckDiffInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormEntryFactory;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormInfo;
import com.kingdee.eas.tm.im.inv.app.AbstractInvoiceCheckDiffControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceCheckDiffControllerBean
extends AbstractInvoiceCheckDiffControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvoiceCheckDiffControllerBean");

    @Override
    protected void _updateDiff(Context ctx, Map params) throws BOSException, EASBizException {
        List updateList = (List)params.get("update");
        Set deleteSet = (Set)params.get("delete");
        for (int i = 0; i < updateList.size(); ++i) {
            InvoiceCheckDiffInfo diff = (InvoiceCheckDiffInfo)updateList.get(i);
            if ("check".equals(params.get("isDiffHandle"))) {
                this.checkIsEntryRange(diff, ctx);
                this.checkInvoiceNoIsExist(diff, ctx);
            } else {
                diff.setHandleUser(ContextUtil.getCurrentUserInfo((Context)ctx));
                diff.setHandleTime(new Timestamp(System.currentTimeMillis()));
            }
            this._save(ctx, (IObjectValue)diff);
        }
        if (deleteSet != null && deleteSet.size() > 0) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)deleteSet, CompareType.INCLUDE));
            this._delete(ctx, filter);
        }
    }

    private void checkInvoiceNoIsExist(InvoiceCheckDiffInfo diff, Context ctx) throws BOSException, IMException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT *");
        sql.append(" from T_IM_InvoiceCheckDiff ");
        sql.append(" where FTAXPLATEID=? and FINVOICETYPE=? and FINVOICECODE=? and FINVOICENO=? and FINVOICECHECKFORMID=? and FID !=?");
        IRowSet rs = DbUtil.executeQueryNoTx((Context)ctx, (String)sql.toString(), (Object[])new Object[]{diff.getTaxPlate().getId().toString(), diff.getInvoiceType().getValue(), diff.getInvoiceCode(), diff.getInvoiceNo(), diff.getInvoiceCheckForm().getId().toString(), diff.getId().toString()});
        try {
            if (rs.next()) {
                String errMsg = IMUtils.getString("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_DIFF_EXIST", ctx.getLocale(), new Object[]{diff.getInvoiceCode(), diff.getInvoiceNo()});
                throw new IMException(IMException.ERRORMSG, new Object[]{errMsg});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void checkIsEntryRange(InvoiceCheckDiffInfo diff, Context ctx) throws IMException, BOSException {
        InvoiceCheckFormInfo form = diff.getInvoiceCheckForm();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invoiceCheckForm", (Object)new ObjectUuidPK(form.getId())));
        view.setFilter(filter);
        InvoiceCheckFormEntryCollection entryColl = InvoiceCheckFormEntryFactory.getLocalInstance(ctx).getInvoiceCheckFormEntryCollection(view);
        boolean isRange = false;
        for (int i = 0; i < entryColl.size(); ++i) {
            InvoiceCheckFormEntryInfo entry = entryColl.get(i);
            boolean bl = isRange = diff.getTaxPlate().getId().equals((Object)entry.getTaxPlate().getId()) && diff.getInvoiceType() == entry.getInvoiceType() && new BigDecimal(diff.getInvoiceNo()).compareTo(new BigDecimal(entry.getLastNumber())) < 1 && new BigDecimal(diff.getInvoiceNo()).compareTo(new BigDecimal(entry.getFirstNumber())) > -1;
            if (isRange) break;
        }
        if (!isRange) {
            String errMsg = IMUtils.getString("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CHECK_DIFF", ctx.getLocale(), new Object[]{diff.getInvoiceCode(), diff.getInvoiceNo()});
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
    }
}

