/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.basedata.TaxPlateInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckDiffCollection;
import com.kingdee.eas.tm.im.inv.InvoiceCheckDiffFactory;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormInfo;
import com.kingdee.eas.tm.im.inv.InvoiceCheckFormStatus;
import com.kingdee.eas.tm.im.inv.InvoiceCheckTaskFactory;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrFactory;
import com.kingdee.eas.tm.im.inv.InvoiceInvMgrInfo;
import com.kingdee.eas.tm.im.inv.app.AbstractInvoiceCheckFormControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class InvoiceCheckFormControllerBean
extends AbstractInvoiceCheckFormControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvoiceCheckFormControllerBean");

    protected void _save(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model == null) {
            model = this.getInvoiceCheckFormInfo(ctx, pk);
        }
        this._save(ctx, (IObjectValue)model);
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = (InvoiceCheckFormInfo)model;
        if (form.getId() != null) {
            form.setStatus(InvoiceCheckFormStatus.CHECKING);
        } else {
            form.setStatus(InvoiceCheckFormStatus.UNDO);
        }
        return super._save(ctx, model);
    }

    @Override
    protected void _update(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = (InvoiceCheckFormInfo)model;
        super._update(ctx, pk, model);
        InvoiceCheckTaskFactory.getLocalInstance(ctx).updateStatus((IObjectPK)new ObjectUuidPK(form.getInvoiceCheckTask().getId()));
    }

    @Override
    protected void _cancelCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = this.getInvoiceCheckFormInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(form.getCU().getId().toString(), "im_invoiceCheckForm_cancelCheck");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckFormStatus.CHECKING.equals((Object)form.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_CANCELCHECK", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
        InvoiceCheckFormEntryCollection entryColl = form.getEntry();
        for (int i = 0; i < entryColl.size(); ++i) {
            InvoiceCheckFormEntryInfo entry = entryColl.get(i);
            entry.setActQty(0);
            entry.setDiffQty(0);
        }
        form.setStatus(InvoiceCheckFormStatus.UNDO);
        form.setCheckUser(null);
        form.setCheckTime(null);
        form.setHandleUser(null);
        form.setHandleTime(null);
        InvoiceCheckDiffFactory.getLocalInstance(ctx).delete(" where invoiceCheckForm = '" + form.getId().toString() + "' ");
        this._update(ctx, pk, (IObjectValue)form);
    }

    @Override
    protected void _passCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = this.getInvoiceCheckFormInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(form.getCU().getId().toString(), "im_invoiceCheckForm_passCheck");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckFormStatus.UNDO.equals((Object)form.getStatus()) && !InvoiceCheckFormStatus.CHECKING.equals((Object)form.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_PASSCHECK", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
        InvoiceCheckFormEntryCollection entryColl = form.getEntry();
        for (int i = 0; i < entryColl.size(); ++i) {
            InvoiceCheckFormEntryInfo entry = entryColl.get(i);
            entry.setActQty(entry.getRemainderQty());
            entry.setDiffQty(0);
        }
        form.setStatus(InvoiceCheckFormStatus.HANDLED);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        form.setCheckUser(userInfo);
        form.setCheckTime(timestamp);
        form.setHandleUser(userInfo);
        form.setHandleTime(timestamp);
        InvoiceCheckDiffFactory.getLocalInstance(ctx).delete(" where invoiceCheckForm = '" + form.getId().toString() + "' ");
        this._update(ctx, pk, (IObjectValue)form);
    }

    @Override
    protected void _checkComplete(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        if (model != null && model.getBoolean("needSave")) {
            this._save(ctx, model);
        }
        InvoiceCheckFormInfo form = this.getInvoiceCheckFormInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(form.getCU().getId().toString(), "im_invoiceCheckForm_checkComplete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckFormStatus.CHECKING.equals((Object)form.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_CHECKCOMPLETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
        InvoiceCheckFormEntryCollection entryColl = form.getEntry();
        HashMap<String, Integer> invoiceCodeAndDiffQtyMap = new HashMap<String, Integer>();
        for (int i = 0; i < entryColl.size(); ++i) {
            InvoiceCheckFormEntryInfo entry = entryColl.get(i);
            if (entry.getDiffQty() + entry.getActQty() != entry.getRemainderQty()) {
                String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_CALCULATENOTEUQAL", ctx);
                throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
            }
            if (null != invoiceCodeAndDiffQtyMap.get(entry.getInvoiceCode())) {
                invoiceCodeAndDiffQtyMap.put(entry.getInvoiceCode(), (Integer)invoiceCodeAndDiffQtyMap.get(entry.getInvoiceCode()) + entry.getDiffQty());
                continue;
            }
            invoiceCodeAndDiffQtyMap.put(entry.getInvoiceCode(), entry.getDiffQty());
        }
        InvoiceCheckDiffCollection diffCollection = InvoiceCheckDiffFactory.getLocalInstance(ctx).getInvoiceCheckDiffCollection(" where invoiceCheckForm = '" + form.getId().toString() + "' ");
        int totalDiffQty = 0;
        if (invoiceCodeAndDiffQtyMap.size() > 0) {
            for (Map.Entry entry : invoiceCodeAndDiffQtyMap.entrySet()) {
                totalDiffQty += ((Integer)entry.getValue()).intValue();
            }
        }
        if (totalDiffQty > 0 && (diffCollection == null || diffCollection.size() == 0)) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_DIFFISEMPTY", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{errMsg});
        }
        HashMap<String, Integer> diffMap = new HashMap<String, Integer>();
        if (diffCollection != null && diffCollection.size() > 0) {
            int j = diffCollection.size();
            for (int i = 0; i < j; ++i) {
                if (diffMap.containsKey(diffCollection.get(i).getInvoiceCode())) {
                    diffMap.put(diffCollection.get(i).getInvoiceCode(), (Integer)diffMap.get(diffCollection.get(i).getInvoiceCode()) + 1);
                    continue;
                }
                diffMap.put(diffCollection.get(i).getInvoiceCode(), 1);
            }
        }
        Set invoiceCodeAndDiffQtyKeySet = invoiceCodeAndDiffQtyMap.keySet();
        Iterator it = invoiceCodeAndDiffQtyKeySet.iterator();
        String str = "";
        while (it.hasNext()) {
            str = (String)it.next();
            if (diffMap.containsKey(str)) continue;
            diffMap.put(str, 0);
        }
        String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_DIFFQTYNOTEQUALS", ctx);
        ArrayList errorDiffList = new ArrayList();
        if (invoiceCodeAndDiffQtyMap.size() > 0) {
            for (Map.Entry entry : invoiceCodeAndDiffQtyMap.entrySet()) {
                if ((diffMap.get(entry.getKey()) == null || entry.getValue() != null) && ((Integer)diffMap.get(entry.getKey())).equals(entry.getValue())) continue;
                errorDiffList.add(entry.getKey());
            }
            if (errorDiffList.size() > 0) {
                StringBuffer lastErrMsg = new StringBuffer();
                int j = errorDiffList.size();
                for (int i = 0; i < j; ++i) {
                    lastErrMsg.append((String)errorDiffList.get(i) + ":" + errMsg).append("\r\n");
                }
                throw new IMException(IMException.ERRORMSG, new Object[]{lastErrMsg.toString()});
            }
        }
        form.setStatus(InvoiceCheckFormStatus.CHECKED);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        form.setCheckUser(userInfo);
        form.setCheckTime(timestamp);
        this._update(ctx, pk, (IObjectValue)form);
    }

    @Override
    protected void _undoCheck(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = this.getInvoiceCheckFormInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(form.getCU().getId().toString(), "im_invoiceCheckForm_undoCheck");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckFormStatus.CHECKED.equals((Object)form.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_UNDOCHECK", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
        form.setStatus(InvoiceCheckFormStatus.CHECKING);
        form.setCheckUser(null);
        form.setCheckTime(null);
        this._update(ctx, pk, (IObjectValue)form);
    }

    @Override
    protected void _handleComplete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = this.getInvoiceCheckFormInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(form.getCU().getId().toString(), "im_invoiceCheckForm_handleComplete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckFormStatus.CHECKED.equals((Object)form.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_HANDLECOMPLETE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
        form.setStatus(InvoiceCheckFormStatus.HANDLED);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        form.setHandleUser(userInfo);
        form.setHandleTime(timestamp);
        this._update(ctx, pk, (IObjectValue)form);
    }

    @Override
    protected void _undoHandle(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = this.getInvoiceCheckFormInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(form.getCU().getId().toString(), "im_invoiceCheckForm_undoHandle");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + e.getMessage()});
        }
        if (!InvoiceCheckFormStatus.HANDLED.equals((Object)form.getStatus())) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_FORM_UNDOHANDLE", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
        form.setStatus(InvoiceCheckFormStatus.CHECKED);
        form.setHandleUser(null);
        form.setHandleTime(null);
        this._update(ctx, pk, (IObjectValue)form);
    }

    @Override
    protected void _syncRemainder(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceCheckFormInfo form = this.getInvoiceCheckFormInfo(ctx, pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(form.getCU().getId().toString(), "im_invoiceCheckForm_syncBookData");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + e.getMessage()});
        }
        if (form.getStatus() != InvoiceCheckFormStatus.UNDO) {
            String errMsg = IMUtils.getResource("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_CHECK_FORM_SYNC", ctx);
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + errMsg});
        }
        InvoiceCheckFormEntryCollection entryColl = form.getEntry();
        HashMap<String, String> plateInfos = new HashMap<String, String>();
        for (int i = 0; i < entryColl.size(); ++i) {
            TaxPlateInfo taxPlate = entryColl.get(i).getTaxPlate();
            plateInfos.put(taxPlate.getId().toString(), taxPlate.getNumber());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("taxPlate", plateInfos.keySet(), CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0"));
        view.setFilter(filter);
        InvoiceInvMgrCollection invMgrColl = InvoiceInvMgrFactory.getLocalInstance(ctx).getInvoiceInvMgrCollection(view);
        if (invMgrColl.size() != plateInfos.size()) {
            StringBuffer plateNumber = new StringBuffer();
            for (int j = 0; j < invMgrColl.size(); ++j) {
                String plateID = invMgrColl.get(j).getTaxPlate().getId().toString();
                plateInfos.remove(plateID);
            }
            for (String number : plateInfos.values()) {
                if (plateNumber.length() > 0) {
                    plateNumber.append(", ");
                }
                plateNumber.append(number);
            }
            String genMsg = IMUtils.getString("com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource", "ERR_GENNOMGR", ctx.getLocale(), new Object[]{plateNumber.toString()});
            throw new IMException(IMException.ERRORMSG, new Object[]{form.getNumber() + ":" + genMsg});
        }
        form.getEntry().clear();
        for (int i = 0; i < invMgrColl.size(); ++i) {
            InvoiceInvMgrInfo invMgrInfo = invMgrColl.get(i);
            InvoiceInvMgrEntryCollection invMgrEnColl = invMgrInfo.getEntry();
            for (int j = 0; j < invMgrEnColl.size(); ++j) {
                InvoiceInvMgrEntryInfo invMgrEn = invMgrEnColl.get(j);
                InvoiceCheckFormEntryInfo formEn = new InvoiceCheckFormEntryInfo();
                formEn.setTaxPlate(invMgrInfo.getTaxPlate());
                formEn.setInvoiceType(invMgrEn.getInvoiceType());
                formEn.setInvoiceCode(invMgrEn.getInvoiceCode());
                String firstNumber = invMgrEn.getNextNumber();
                formEn.setFirstNumber(firstNumber);
                String lastNumber = invMgrEn.getLastNumber();
                formEn.setLastNumber(lastNumber);
                formEn.setRemainderQty(Integer.valueOf(lastNumber) - Integer.valueOf(firstNumber) + 1);
                form.getEntry().add(formEn);
            }
        }
        super._update(ctx, pk, (IObjectValue)form);
    }
}

