/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.inv.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.InvoiceReceiveException;
import com.kingdee.eas.tm.im.inv.InvoiceReceiveEntryCollection;
import com.kingdee.eas.tm.im.inv.InvoiceReceiveEntryInfo;
import com.kingdee.eas.tm.im.inv.InvoiceReceiveEunm;
import com.kingdee.eas.tm.im.inv.InvoiceReceiveFactory;
import com.kingdee.eas.tm.im.inv.InvoiceReceiveInfo;
import com.kingdee.eas.tm.im.inv.InvoiceReceiveStatusEnum;
import com.kingdee.eas.tm.im.inv.app.AbstractInvoiceReceiveControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class InvoiceReceiveControllerBean
extends AbstractInvoiceReceiveControllerBean {
    private static final long serialVersionUID = -7210609564440338760L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.inv.app.InvoiceReceiveControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        InvoiceReceiveInfo info = (InvoiceReceiveInfo)model;
        this.checkReturnQty(ctx, info);
        String srcBillID = info.getSourceBillId();
        this.checkNumberUnique(ctx, info);
        InvoiceReceiveEntryCollection entrys = info.getEntry();
        int num = 0;
        Iterator iter = entrys.iterator();
        while (iter.hasNext()) {
            InvoiceReceiveEntryInfo element = (InvoiceReceiveEntryInfo)iter.next();
            if (info.getServiceType() != InvoiceReceiveEunm.RETURN) continue;
            this.checkReturnNumberRepeat(ctx, element, ++num, srcBillID, info.getId().toString());
        }
        String bostype = info.getBOSType().toString();
        InvoiceReceiveInfo returnInfo = (InvoiceReceiveInfo)model;
        String destBillID = returnInfo.getId().toString();
        if (srcBillID != null && !IMUtils.hasBotpRelation(ctx, srcBillID, destBillID, bostype, bostype)) {
            IMUtils.traceUpAndDown(ctx, srcBillID, bostype, destBillID, bostype);
        }
        return super._save(ctx, model);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        logger.debug((Object)"enter method submit.");
        InvoiceReceiveInfo info = (InvoiceReceiveInfo)model;
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceReceive_submit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        this.isSameUser(ctx, info);
        this.checkReturnQty(ctx, info);
        this.checkNumberUnique(ctx, info);
        InvoiceReceiveEntryCollection entrys = info.getEntry();
        int num = 0;
        Iterator iter = entrys.iterator();
        while (iter.hasNext()) {
            InvoiceReceiveEntryInfo element = (InvoiceReceiveEntryInfo)iter.next();
            if (info.getServiceType() != InvoiceReceiveEunm.RETURN) continue;
            this.checkReturnNumberRepeat(ctx, element, ++num, info.getSourceBillId().toString(), info.getId().toString());
        }
        if (info.getStatus() != InvoiceReceiveStatusEnum.SUBMIT && info.getStatus() != InvoiceReceiveStatusEnum.SAVE) {
            throw new InvoiceReceiveException(InvoiceReceiveException.SUBMIT_STATUS_CHECK, new Object[]{info.getNumber()});
        }
        info.setStatus(InvoiceReceiveStatusEnum.SUBMIT);
        String srcBillID = info.getSourceBillId();
        String bostype = info.getBOSType().toString();
        InvoiceReceiveInfo returnInfo = (InvoiceReceiveInfo)model;
        String destBillID = returnInfo.getId().toString();
        if (srcBillID != null && !IMUtils.hasBotpRelation(ctx, srcBillID, destBillID, bostype, bostype)) {
            IMUtils.traceUpAndDown(ctx, srcBillID, bostype, destBillID, bostype);
        }
        return super._submit(ctx, model);
    }

    private void checkReturnQty(Context ctx, InvoiceReceiveInfo info) throws EASBizException, BOSException {
        if (info.getServiceType() == InvoiceReceiveEunm.RETURN) {
            info.setReceiveQty(0);
            int returnQty = 0;
            InvoiceReceiveEntryCollection entrys = info.getEntry();
            Iterator iter = entrys.iterator();
            while (iter.hasNext()) {
                InvoiceReceiveEntryInfo element = (InvoiceReceiveEntryInfo)iter.next();
                returnQty += element.getQty();
            }
            info.setReturnQty(returnQty);
            ObjectUuidPK receivePK = new ObjectUuidPK(info.getSourceBillId());
            InvoiceReceiveInfo receiveInfo = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo((IObjectPK)receivePK);
            if (returnQty > receiveInfo.getRealReceiveQty()) {
                throw new InvoiceReceiveException(InvoiceReceiveException.RETURN_CHECK, new Object[]{info.getNumber()});
            }
        }
    }

    private void isSameUser(Context ctx, InvoiceReceiveInfo info) throws EASBizException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserInfo creator = info.getCreator();
        if (userInfo != null && creator != null && !userInfo.getId().equals((Object)creator.getId())) {
            throw new InvoiceReceiveException(InvoiceReceiveException.SUBMIT_CHECK, new Object[]{info.getNumber()});
        }
    }

    @Override
    protected void _returnConfirm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceReceiveInfo returnInfo = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo(pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(returnInfo.getCompany().getId().toString(), "im_invoiceReceive_returnConfirm");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{returnInfo.getNumber() + ":" + e.getMessage()});
        }
        if (returnInfo.getServiceType() != InvoiceReceiveEunm.RETURN || returnInfo.getStatus() != InvoiceReceiveStatusEnum.AUDITED) {
            throw new InvoiceReceiveException(InvoiceReceiveException.RETURN_CONFIRM, new Object[]{returnInfo.getNumber()});
        }
        ObjectUuidPK receivePK = new ObjectUuidPK(returnInfo.getSourceBillId());
        InvoiceReceiveInfo receiveInfo = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo((IObjectPK)receivePK);
        if (returnInfo.getReturnQty() > receiveInfo.getRealReceiveQty()) {
            throw new InvoiceReceiveException(InvoiceReceiveException.RETURN_CHECK, new Object[]{returnInfo.getNumber()});
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserInfo allocator = receiveInfo.getAllocator();
        if (userInfo != null && allocator != null && !userInfo.getId().equals((Object)allocator.getId())) {
            throw new InvoiceReceiveException(InvoiceReceiveException.RETURN_CONFIRM_CHECK, new Object[]{returnInfo.getNumber()});
        }
        returnInfo.setStatus(InvoiceReceiveStatusEnum.CONFIRMED);
        returnInfo.setConfirmUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        returnInfo.setConfirmTime(new Timestamp(System.currentTimeMillis()));
        InvoiceReceiveFactory.getLocalInstance(ctx).update(pk, returnInfo);
        receiveInfo.setReturnQty(receiveInfo.getReturnQty() + returnInfo.getReturnQty());
        receiveInfo.setRealReceiveQty(receiveInfo.getRealReceiveQty() - returnInfo.getReturnQty());
        receiveInfo.setIsReturn(true);
        InvoiceReceiveFactory.getLocalInstance(ctx).update((IObjectPK)receivePK, receiveInfo);
    }

    @Override
    protected void _receiveConfirm(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceReceiveInfo info = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo(pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceReceive_receiveConfirm");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getServiceType() != InvoiceReceiveEunm.RECEIVE || info.getStatus() != InvoiceReceiveStatusEnum.ALLOCATED) {
            throw new InvoiceReceiveException(InvoiceReceiveException.RECEIVE_CONFIRM, new Object[]{info.getNumber()});
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        UserInfo creator = info.getCreator();
        if (userInfo != null && creator != null && !userInfo.getId().equals((Object)creator.getId())) {
            throw new InvoiceReceiveException(InvoiceReceiveException.RECEIVE_CONFIRM_CHECK, new Object[]{info.getNumber()});
        }
        info.setStatus(InvoiceReceiveStatusEnum.CONFIRMED);
        info.setConfirmUser(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setConfirmTime(new Timestamp(System.currentTimeMillis()));
        info.setRealReceiveQty(info.getReceiveQty());
        InvoiceReceiveFactory.getLocalInstance(ctx).update(pk, info);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceReceiveInfo info = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo(pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceReceive_audit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() != InvoiceReceiveStatusEnum.SUBMIT) {
            throw new InvoiceReceiveException(InvoiceReceiveException.AUDIT_CHECK, new Object[]{info.getNumber()});
        }
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(new Timestamp(System.currentTimeMillis()));
        info.setStatus(InvoiceReceiveStatusEnum.AUDITED);
        InvoiceReceiveFactory.getLocalInstance(ctx).update(pk, info);
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceReceiveInfo info = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo(pk);
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceReceive_unAudit");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() != InvoiceReceiveStatusEnum.AUDITED) {
            throw new InvoiceReceiveException(InvoiceReceiveException.UNAUDIT_CHECK, new Object[]{info.getNumber()});
        }
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setStatus(InvoiceReceiveStatusEnum.SAVE);
        InvoiceReceiveFactory.getLocalInstance(ctx).update(pk, info);
    }

    @Override
    protected String _getReturnTime(Context ctx, String id) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT count(FID) count");
        sql.append(" from T_IM_InvoiceReceive ");
        sql.append(" where FSOURCEBILLID='").append(id).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String returnTime = "001";
        try {
            while (rs.next()) {
                returnTime = rs.getInt("count") + 1 + "";
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        return returnTime;
    }

    @Override
    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceReceiveInfo info = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo(pk, this.getSelector());
        try {
            IMFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(info.getCompany().getId().toString(), "im_invoiceReceive_delete");
        }
        catch (Exception e) {
            throw new IMException(IMException.ERRORMSG, new Object[]{info.getNumber() + ":" + e.getMessage()});
        }
        if (info.getStatus() != InvoiceReceiveStatusEnum.SAVE && info.getStatus() != InvoiceReceiveStatusEnum.SUBMIT) {
            throw new InvoiceReceiveException(InvoiceReceiveException.DELETE_CHECK, new Object[]{info.getNumber()});
        }
        super._delete(ctx, pk);
    }

    private void checkNumberUnique(Context ctx, InvoiceReceiveInfo info) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT * ");
        sql.append(" from T_IM_InvoiceReceive ");
        sql.append(" where FNUMBER='").append(info.getNumber()).append("'");
        sql.append(" and FID!='").append(info.getId().toString()).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                throw new InvoiceReceiveException(InvoiceReceiveException.UNIQUE_NUMBER_CHECK, new Object[]{info.getNumber()});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private void checkReturnNumberRepeat(Context ctx, InvoiceReceiveEntryInfo element, int num, String receiveId, String id) throws BOSException, EASBizException {
        String invoiceCode = element.getInvoiceCode();
        String firstNumber = element.getFirstNumber();
        String lastNumber = element.getLastNumber();
        StringBuffer sql = this.getCheckAddReturnSql(invoiceCode, firstNumber, lastNumber, receiveId);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (!rs.next()) {
                throw new InvoiceReceiveException(InvoiceReceiveException.RETURN_INVOICE_CODE_CHECK, new Object[]{num, invoiceCode});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer receiveSql = this.getAcrossSql(InvoiceReceiveEunm.RETURN, invoiceCode, firstNumber, lastNumber, id);
        IRowSet rs1 = DbUtil.executeQuery((Context)ctx, (String)receiveSql.toString());
        try {
            if (rs1.next()) {
                throw new InvoiceReceiveException(InvoiceReceiveException.INVOICE_CODE_CHECK, new Object[]{num, invoiceCode});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    private StringBuffer getCheckAddReturnSql(String invoiceCode, String firstNumber, String lastNumber, String receiveId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1");
        sql.append(" from T_IM_InvoiceReceiveEntry ie left join T_IM_InvoiceReceive ir on ie.FParentID=ir.FID");
        sql.append(" where ir.FID='").append(receiveId).append("'");
        sql.append(" and ie.FInvoiceCode='").append(invoiceCode).append("'");
        sql.append(" and (ie.FirstNumber<=").append(firstNumber);
        sql.append(" and ie.FLastNumber>=").append(lastNumber).append(")");
        return sql;
    }

    private StringBuffer getAcrossSql(InvoiceReceiveEunm serviceType, String invoiceCode, String firstNumber, String lastNumber, String id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT 1");
        sql.append(" from T_IM_InvoiceReceiveEntry ie inner join T_IM_InvoiceReceive ir on ie.FParentID=ir.FID");
        if (serviceType == InvoiceReceiveEunm.RECEIVE) {
            sql.append(" where ir.FServiceType='0' and ir.FIsReturn=0");
        } else {
            sql.append(" where ir.FServiceType='1' ");
        }
        sql.append(" and ie.FInvoiceCode='").append(invoiceCode).append("'");
        sql.append(" and ir.FID!='").append(id).append("'");
        sql.append(" and ((ie.FirstNumber>=").append(firstNumber);
        sql.append(" and ie.FirstNumber<=").append(lastNumber).append(")");
        sql.append(" or (ie.FLastNumber>=").append(firstNumber);
        sql.append(" and ie.FLastNumber<=").append(lastNumber).append("))");
        return sql;
    }

    private StringBuffer getCheckAddReceiveByReturnSql(String invoiceCode, String firstNumber, String lastNumber, String id) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT *");
        sql.append(" from T_IM_InvoiceReceiveEntry ie inner join T_IM_InvoiceReceive ir on ie.FParentID=ir.FID");
        sql.append(" where ir.FServiceType='0' and ir.FStatus='4' and ir.FID!='").append(id).append("'");
        sql.append(" and ie.FInvoiceCode='").append(invoiceCode).append("'");
        sql.append(" and (ie.FirstNumber>=").append(firstNumber);
        sql.append(" and ie.FLastNumber<=").append(lastNumber).append(")");
        return sql;
    }

    private void checkReceiveNumberRepeat(Context ctx, InvoiceReceiveEntryInfo element, int entryRow, String id) throws BOSException, EASBizException {
        String invoiceCode = element.getInvoiceCode();
        String firstNumber = element.getFirstNumber();
        String lastNumber = element.getLastNumber();
        StringBuffer checkAddReceiveByReturnSql = this.getCheckAddReceiveByReturnSql(invoiceCode, firstNumber, lastNumber, id);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)checkAddReceiveByReturnSql.toString());
        try {
            if (rs.next()) {
                return;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        StringBuffer receiveSql = this.getAcrossSql(InvoiceReceiveEunm.RECEIVE, invoiceCode, firstNumber, lastNumber, id);
        rs = DbUtil.executeQuery((Context)ctx, (String)receiveSql.toString());
        try {
            if (rs.next()) {
                throw new InvoiceReceiveException(InvoiceReceiveException.INVOICE_CODE_CHECK, new Object[]{entryRow, invoiceCode});
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    @Override
    protected void _submitSave(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        InvoiceReceiveInfo info = InvoiceReceiveFactory.getLocalInstance(ctx).getInvoiceReceiveInfo(pk);
        this._submit(ctx, (IObjectValue)info);
    }

    @Override
    protected void _receiveAllocate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        InvoiceReceiveInfo info = (InvoiceReceiveInfo)model;
        info.setStatus(InvoiceReceiveStatusEnum.ALLOCATED);
        info.setAllocator(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAllocateTime(new Timestamp(System.currentTimeMillis()));
        InvoiceReceiveEntryCollection entrys = info.getEntry();
        int entryRow = 0;
        Iterator iter = entrys.iterator();
        while (iter.hasNext()) {
            InvoiceReceiveEntryInfo element = (InvoiceReceiveEntryInfo)iter.next();
            this.checkReceiveNumberRepeat(ctx, element, ++entryRow, info.getId().toString());
        }
        this._update(ctx, pk, (IObjectValue)info);
    }

    public SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("taxPlate.*"));
        sic.add(new SelectorItemInfo("allocator.*"));
        sic.add(new SelectorItemInfo("confirmUser.*"));
        sic.add(new SelectorItemInfo("company.*"));
        return sic;
    }
}

