/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.rpt.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.eas.basedata.common.olap.EASEjbFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.tm.common.invoicePool.TMInvoiceType;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.common.comm.PwyServiceFacadeFactory;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyActionParam;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.IPwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.rpt.AddSyncLogStatusEnum;
import com.kingdee.eas.tm.im.rpt.app.AbstractAddSyncLogRptFacadeControllerBean;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AddSyncLogRptFacadeControllerBean
extends AbstractAddSyncLogRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger(AddSyncLogRptFacadeControllerBean.class);

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        this.dropTempTable(params.getString("tempTable"), ctx);
        String tempTable = null;
        tempTable = this.createTempTable(ctx, this.getCreateTempTable(tempTable, params));
        params.setString("tempTable", tempTable);
        RptTableHeader header = this.createTableHeader(ctx, params);
        params.setObject("header", (Object)header);
        return params;
    }

    private RptTableHeader createTableHeader(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FID");
        col.setWidth(0);
        col.setHided(true);
        header.addColumn(col);
        col = new RptTableColumn("FTaxNo");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FBatchNo");
        col.setWidth(250);
        header.addColumn(col);
        col = new RptTableColumn("FSyncStatus");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FInvoiceType");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FStartDate");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FEndDate");
        col.setWidth(100);
        header.addColumn(col);
        col = new RptTableColumn("FTotalNum");
        col.setWidth(150);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FSuccessTotalNum");
        col.setWidth(150);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FSyncTotalNum");
        col.setWidth(150);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FDiffNum");
        col.setWidth(150);
        col.setAligment(2);
        header.addColumn(col);
        col = new RptTableColumn("FCreateTime");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FSyncTime");
        col.setWidth(150);
        header.addColumn(col);
        col = new RptTableColumn("FDescription");
        col.setWidth(200);
        header.addColumn(col);
        String taxNo_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FTaxNo", ctx.getLocale());
        String batchNo_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FBatchNo", ctx.getLocale());
        String syncStatus_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FSyncStatus", ctx.getLocale());
        String invoiceType_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FInvoiceType", ctx.getLocale());
        String startDate_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FStartDate", ctx.getLocale());
        String endDate_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FEndDate", ctx.getLocale());
        String totalNum_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FTotalNum", ctx.getLocale());
        String successTotalNum_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FSuccessTotalNum", ctx.getLocale());
        String syncTotalNum_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FSyncTotalNum", ctx.getLocale());
        String diffNum_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FDiffNum", ctx.getLocale());
        String createTime_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FCreateTime", ctx.getLocale());
        String syncTime_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FSyncTime", ctx.getLocale());
        String description_alias = IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "FDescription", ctx.getLocale());
        header.setLabels((Object[][])new Object[][]{{"FID", taxNo_alias, batchNo_alias, syncStatus_alias, invoiceType_alias, startDate_alias, endDate_alias, totalNum_alias, successTotalNum_alias, syncTotalNum_alias, diffNum_alias, createTime_alias, syncTime_alias, description_alias}, {"FID", taxNo_alias, batchNo_alias, syncStatus_alias, invoiceType_alias, startDate_alias, endDate_alias, totalNum_alias, successTotalNum_alias, syncTotalNum_alias, diffNum_alias, createTime_alias, syncTime_alias, description_alias}}, true);
        return header;
    }

    private void insertBillData(Context ctx, RptParams rptParams, int from) throws EASBizException, BOSException {
        HashMap tempParam = new HashMap();
        String companyId = rptParams.getString("companyId");
        if (StringUtils.isEmpty((String)companyId)) {
            throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "companyNotNull", ctx.getLocale())});
        }
        ArrayList<PwyActionParam> paramList = new ArrayList<PwyActionParam>();
        HashMap<String, Object> pwyData = new HashMap<String, Object>();
        pwyData.put("syncStatus", rptParams.getString("syncStatus"));
        pwyData.put("dataType", "1");
        pwyData.put("startDate", rptParams.getString("startDate"));
        pwyData.put("endDate", rptParams.getString("endDate"));
        pwyData.put("currentPage", rptParams.getInt("currentPage"));
        pwyData.put("pageSize", rptParams.getInt("pageSize"));
        pwyData.put("successTotalNum", 0);
        pwyData.put("consumerType", "EAS");
        tempParam.put("pwyData", pwyData);
        PwyActionParam actionParam = new PwyActionParam(PwyServiceType.OPR_INV_ADD_SYNC_LOG, TransSrcSystemEnum.easgui, companyId, tempParam);
        paramList.add(actionParam);
        List list = PwyServiceFacadeFactory.getLocalInstance(ctx).buildPwyParam(paramList);
        PwyInvokeParam invokeParam = (PwyInvokeParam)list.get(0);
        IPwyService pwyService = PwyServiceHelper.getPwyService(ctx, invokeParam);
        pwyService.invoke();
        PwyInvokeParam revInvokeParam = pwyService.getInvokeParam();
        if (pwyService.isSuccess()) {
            this.insertToData(ctx, revInvokeParam.getInvokeActionMap(), rptParams, from);
        } else {
            try {
                JSONObject dataJson = new JSONObject(revInvokeParam.getRevMsg());
                rptParams.setString("failMsg", dataJson.getString("description"));
            }
            catch (JSONException e) {
                rptParams.setString("failMsg", IMUtils.getString("com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource", "INVOKE_PWY_ERROR", ctx.getLocale()));
                logger.error((Object)("insertBillData parse failed.e=" + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void insertToData(Context ctx, Map params, RptParams rptParams, int from) throws BOSException {
        try {
            StringBuffer insertSQL = new StringBuffer();
            String retInfo = (String)params.get("retInfo");
            String taxNo = (String)params.get("taxNo");
            JSONObject dataJson = new JSONObject(retInfo);
            String errcode = dataJson.getString("errcode");
            String tempTable = rptParams.getString("tempTable");
            if ("0000".equals(errcode)) {
                JSONArray jsonArray = dataJson.getJSONArray("data");
                for (int j = 0; j < jsonArray.length(); ++j) {
                    JSONObject data = (JSONObject)jsonArray.get(j);
                    insertSQL.append("insert into ").append(tempTable).append(" ").append(" (FID, FTaxNo,FSeq, FBatchNo,FInvoiceType,FStartDate,FEndDate,FSyncStatus, FTotalNum, FSuccessTotalNum, FSyncTotalNum,FDiffNum,FDescription,FCreateTime,FSyncTime)");
                    insertSQL.append(" values (");
                    insertSQL.append("newbosid('66666666')").append(",");
                    insertSQL.append("'").append(taxNo).append("',");
                    insertSQL.append(from + j).append(",");
                    insertSQL.append("'").append(data.getString("batchNo")).append("',");
                    if (!IMUtils.isPwyEmpty(data.getString("jxxInvoiceType"))) {
                        insertSQL.append("'").append(TMInvoiceType.getEnum((String)data.getString("jxxInvoiceType"))).append("',");
                    } else {
                        insertSQL.append(data.getString("jxxInvoiceType")).append(",");
                    }
                    if (!IMUtils.isPwyEmpty(data.getString("jxxStartDate"))) {
                        insertSQL.append("{ts'").append(data.getString("jxxStartDate")).append("'},");
                    } else {
                        insertSQL.append(data.getString("jxxStartDate")).append(",");
                    }
                    if (!IMUtils.isPwyEmpty(data.getString("jxxEndDate"))) {
                        insertSQL.append("{ts'").append(data.getString("jxxEndDate")).append("'},");
                    } else {
                        insertSQL.append(data.getString("jxxEndDate")).append(",");
                    }
                    insertSQL.append("'").append((Object)AddSyncLogStatusEnum.getEnum(data.getString("syncStatus"))).append("',");
                    insertSQL.append(data.getString("totalNum")).append(",");
                    insertSQL.append(data.getString("successTotalNum")).append(",");
                    insertSQL.append(data.getString("syncTotalNum")).append(",");
                    if (!IMUtils.isPwyEmpty(data.getString("syncTotalNum"))) {
                        insertSQL.append(data.getInt("successTotalNum") - data.getInt("syncTotalNum")).append(",");
                    } else {
                        insertSQL.append(data.getString("successTotalNum")).append(",");
                    }
                    insertSQL.append("'").append(data.getString("description")).append("',");
                    if (!IMUtils.isPwyEmpty(data.getString("createTime"))) {
                        insertSQL.append("{ts'").append(data.getString("createTime")).append("'},");
                    } else {
                        insertSQL.append(data.getString("createTime")).append(",");
                    }
                    if (!IMUtils.isPwyEmpty(data.getString("syncTime"))) {
                        insertSQL.append("{ts'").append(data.getString("syncTime")).append("'});");
                    } else {
                        insertSQL.append(data.getString("syncTime")).append(");");
                    }
                    insertSQL.append("\r\n");
                }
            }
            rptParams.setInt("totalCount", dataJson.getInt("totalElement"));
            if (insertSQL.length() > 0) {
                this.executeUpdate(ctx, insertSQL.toString(), null);
            }
        }
        catch (Exception e) {
            rptParams.setInt("totalCount", 0);
            logger.error((Object)("AddSyncLogRptFacadeControllerBean insertToData fail,e=" + e.getMessage()), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this.insertBillData(ctx, params, from);
        ctx = EASEjbFactory.getCtx((String)this.getClass().getName(), (Context)ctx);
        RptRowSet rs = null;
        String tempTable = params.getString("tempTable");
        StringBuffer sql = new StringBuffer();
        sql.append(" select FID, FTaxNo,FBatchNo, FSyncStatus,FInvoiceType,to_char(FStartDate,'YYYY-MM-dd') as FStartDate,to_char(FEndDate,'YYYY-MM-dd') as FEndDate, FTotalNum,FSuccessTotalNum, FSyncTotalNum,FDiffNum,FCreateTime,FSyncTime,FDescription").append(" from ").append(tempTable).append(" order by FSeq asc");
        rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        params.setObject("rowset", (Object)rs);
        return params;
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table TempReportTable(");
        sql.append("FID varchar(44),");
        sql.append("FTaxNo varchar(80),");
        sql.append("FBatchNo varchar(50),");
        sql.append("FSyncStatus nvarchar(10),");
        sql.append("FInvoiceType nvarchar(20),");
        sql.append("FStartDate DateTime,");
        sql.append("FEndDate DateTime,");
        sql.append("FTotalNum int,");
        sql.append("FSuccessTotalNum int,");
        sql.append("FSyncTotalNum int,");
        sql.append("FDiffNum int,");
        sql.append("FCreateTime DateTime,");
        sql.append("FSyncTime DateTime,");
        sql.append("FDescription nvarchar(100),");
        sql.append("FSeq int");
        sql.append(");");
        logger.info((Object)("\u521b\u5efa\u4e34\u65f6\u8868SQL\uff1a" + sql.toString()));
        return sql.toString();
    }
}

