/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.common.invoicePool.utils.PoolConstant;
import com.kingdee.eas.tm.common.utils.TMConstant;
import com.kingdee.eas.tm.common.utils.TMPwyHelperUtils;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class AP2IIRelationUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger(AP2IIRelationUpgrade.class);

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)this.getUpdateRangeSql());
            HashMap<String, ArrayList<Object[]>> allUpdateParams = new HashMap<String, ArrayList<Object[]>>();
            List<Object> updateParams = null;
            ArrayList<Object[]> insertBOTParams = new ArrayList<Object[]>();
            Date date = new Date(System.currentTimeMillis());
            while (rs.next()) {
                String[] invoiceNumbers;
                String srcEntityID = "48DA3A71";
                String srcObjectID = rs.getString("srcObjectID");
                String bizBillTypeID = PoolConstant.TYPEID_APOTHERBILL;
                String bizBillNumber = rs.getString("bizBillNumber");
                String bizVoucherID = rs.getString("bizVoucherID");
                int reBusiness = bizVoucherID == null ? 0 : 1;
                String bizVoucherNumber = rs.getString("bizVoucherNumber");
                String bizVoucherPeriodID = rs.getString("bizVoucherPeriodID");
                String bizVoucherTypeID = rs.getString("bizVoucherTypeID");
                String[] invoiceCodes = rs.getString("invoiceCodes").split(";");
                if (invoiceCodes.length != (invoiceNumbers = rs.getString("invoiceNumbers").split(";")).length) {
                    logger.error((Object)("AP2IIRelationUpgrade invoiceCodes.length != invoiceNumbers.length,billID: " + srcObjectID));
                    continue;
                }
                int size = invoiceNumbers.length;
                for (int i = 0; i < size; ++i) {
                    String invoiceCode = invoiceCodes[i];
                    String invoiceNumber = invoiceNumbers[i];
                    IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)this.getInvoiceSql(invoiceCode, invoiceNumber));
                    if (!rowSet.next()) continue;
                    String destObjectID = rowSet.getString("FID");
                    String destEntityID = BOSUuid.read((String)destObjectID).getType().toString();
                    if (!TMPwyHelperUtils.getAPInvoiceBosTypeSet().contains(destEntityID)) {
                        logger.error((Object)("AP2IIRelationUpgrade not support this invoiceType,billID: " + destObjectID));
                        continue;
                    }
                    updateParams = (List)allUpdateParams.get(destEntityID);
                    if (updateParams == null) {
                        updateParams = new ArrayList<Object[]>();
                        allUpdateParams.put(destEntityID, (ArrayList<Object[]>)updateParams);
                    }
                    updateParams.add(new Object[]{bizBillTypeID, bizBillNumber, reBusiness, bizVoucherID, bizVoucherNumber, bizVoucherPeriodID, bizVoucherTypeID, destObjectID});
                    insertBOTParams.add(new Object[]{srcEntityID, destEntityID, srcObjectID, destObjectID, date});
                }
            }
            if (allUpdateParams.size() > 0) {
                for (Map.Entry entry : allUpdateParams.entrySet()) {
                    updateParams = (ArrayList<Object[]>)entry.getValue();
                    if (updateParams == null || updateParams.size() <= 0) continue;
                    DbUtil.executeBatch((Context)ctx, (String)this.getUpdateSql((String)entry.getKey()), (List)updateParams);
                }
                DbUtil.executeBatch((Context)ctx, (String)this.getInsertBOTSql(), insertBOTParams);
            }
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            info.setIsProcessed(false);
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
    }

    private String getInvoiceSql(String invoiceCode, String invoiceNumber) throws SQLException, BOSException {
        StringBuffer sql = new StringBuffer();
        String bosType = null;
        ArrayList destEntityIDs = new ArrayList(TMPwyHelperUtils.getAPInvoiceBosTypeSet());
        int size = destEntityIDs.size();
        for (int i = 0; i < size; ++i) {
            bosType = (String)destEntityIDs.get(i);
            if (i > 0) {
                sql.append(" UNION ALL ");
            }
            sql.append(this.getSelectInvoiceSql(bosType, invoiceCode, invoiceNumber));
        }
        return sql.toString();
    }

    private String getSelectInvoiceSql(String bosType, String invoiceCode, String invoiceNumber) {
        String selectSql = null;
        if ("1343913D".equals(bosType)) {
            selectSql = " SELECT FID FROM T_IM_IncomeInvoice WHERE FInvoiceNumber = '" + invoiceNumber + "' and FInvoiceCode = '" + invoiceCode + "'";
        } else {
            String tableName = (String)TMConstant.INVOICE_TABLE_MAP.get(bosType);
            selectSql = " SELECT FID FROM " + tableName + " WHERE FInvoiceNo = '" + invoiceNumber + "' and FInvoiceCode = '" + invoiceCode + "'";
        }
        return selectSql;
    }

    private String getUpdateSql(String bosType) {
        String updateSql = null;
        if ("1343913D".equals(bosType)) {
            updateSql = "UPDATE T_IM_INCOMEINVOICE SET FBIZBILLTYPEID=?,FBIZBILLNUMBER=?,FREBUSINESS=?,FBIZVOUCHERID=?,FBIZVOUCHERNUMBER=?,FBIZVOUCHERPERIODID=?,FBIZVOUCHERTYPEID=? WHERE fid =?";
        } else {
            String tableName = (String)TMConstant.INVOICE_TABLE_MAP.get(bosType);
            updateSql = "UPDATE " + tableName + " SET FBIZBILLTYPEID=?,FBIZBILLNUMBER=?,FISBUSINESS=?,FVOUCHERID=?,FVOUCHERNUMBER=?,FVOUCHERPERIODID=?,FVOUCHERTYPEID=? WHERE fid =?";
        }
        return updateSql;
    }

    private String getInsertBOTSql() {
        return "INSERT INTO T_BOT_RELATION (fid,FSRCENTITYID ,FDESTENTITYID ,FSRCOBJECTID ,FDESTOBJECTID ,FDATE ,FOPERATORID ,fiseffected, ftype) VALUES (newbosid('59302EC6'), ?, ?, ?, ?, ?,'DataUpgrade',1,0)";
    }

    private String getUpdateRangeSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT AP.FID as srcObjectID, ").append(" AP.FNUMBER as bizBillNumber, ").append(" AP.FINVOICECODE as invoiceCodes, ").append(" AP.FINVOICENUMBER as invoiceNumbers, ").append(" AP.FVOUCHERID as bizVoucherID, ").append(" Voucher.FNUMBER as bizVoucherNumber, ").append(" Voucher.FPERIODID as bizVoucherPeriodID, ").append(" Voucher.FVOUCHERTYPEID as bizVoucherTypeID ").append(" FROM T_AP_OtherBill AP ").append(" LEFT JOIN T_GL_Voucher Voucher ON AP.FVOUCHERID = Voucher.FID ").append(" WHERE AP.FINVOICENUMBER IS NOT NULL ").append(" AND AP.FINVOICECODE IS NOT NULL ").append(" AND AP.FID NOT IN (SELECT FSRCOBJECTID FROM T_BOT_RELATION WHERE FSRCENTITYID = '48DA3A71' and FDESTENTITYID  in " + IMUtils.getInStringFromSet(TMPwyHelperUtils.getAPInvoiceBosTypeSet()) + ") ");
        return sql.toString();
    }
}

