/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillCollection;
import com.kingdee.eas.fi.ar.OtherBillFactory;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.tm.im.MakeInvoiceReqCollection;
import com.kingdee.eas.tm.im.MakeInvoiceReqFactory;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.MakeInvoiceTypeEnum;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.impl.BizYearMonthDataUpgrade;
import com.kingdee.eas.tm.im.upgrade.impl.MakeInvoiceReqBizYearMonthDataUpgrade;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class MakeInvoiceBizYearMonthDataUpgrade
extends BizYearMonthDataUpgrade {
    private static Logger logger = Logger.getLogger(MakeInvoiceBizYearMonthDataUpgrade.class);

    @Override
    protected List generateInvoiceToUpdate(Context ctx, Map<String, Map<String, Set<String>>> idRelation) throws BOSException, EASBizException, SQLException {
        IRowSet rs = null;
        Set<String> billIdSet = idRelation.keySet();
        HashMap<String, Date> billBizDateMap = new HashMap<String, Date>();
        if (billIdSet != null && billIdSet.size() != 0) {
            String sql = "select FID as id,FInvoiceDate as invoiceDate from T_IM_MakeInvoice where Fid in " + IMUtils.getInStringFromSet(billIdSet);
            rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                billBizDateMap.put(rs.getString("id"), rs.getDate("invoiceDate"));
            }
        }
        ArrayList<Object[]> invoiceIDBizList = new ArrayList<Object[]>();
        String bosType2 = null;
        String invoiceBillID2 = null;
        for (String invoiceBillID2 : billIdSet) {
            Map<String, Set<String>> bosBillMap = idRelation.get(invoiceBillID2);
            for (String bosType2 : bosBillMap.keySet()) {
                Set<String> bizBillIDSet = bosBillMap.get(bosType2);
                HashSet<Integer> yearSet = new HashSet<Integer>();
                HashSet<Integer> monthSet = new HashSet<Integer>();
                if ("FC910EF3".equals(bosType2)) {
                    OtherBillCollection arColl = OtherBillFactory.getLocalInstance((Context)ctx).getOtherBillCollection("where id in " + IMUtils.getInStringFromSet(bizBillIDSet));
                    for (int j = 0; j < arColl.size(); ++j) {
                        OtherBillInfo arInfo = arColl.get(j);
                        yearSet.add(arInfo.getYear());
                        monthSet.add(arInfo.getPeriod());
                    }
                } else if ("AC368D2D".equals(bosType2)) {
                    MakeInvoiceReqCollection reqColl = MakeInvoiceReqFactory.getLocalInstance(ctx).getMakeInvoiceReqCollection("where id in " + IMUtils.getInStringFromSet(bizBillIDSet));
                    for (int j = 0; j < reqColl.size(); ++j) {
                        MakeInvoiceReqInfo reqInfo = reqColl.get(j);
                        yearSet.add(reqInfo.getBizYear());
                        monthSet.add(reqInfo.getBizMonth());
                    }
                }
                Object[] invoiceBiz = new Object[]{null, null, null, invoiceBillID2};
                if (yearSet.size() == 1 && monthSet.size() == 1) {
                    Integer year = this.dealZerotoNull((Integer)yearSet.toArray()[0]);
                    Integer month = this.dealZerotoNull((Integer)monthSet.toArray()[0]);
                    Integer makeType = null;
                    MakeInvoiceTypeEnum makeInvoiceType = this.getMakeInvoiceType((java.util.Date)billBizDateMap.get(invoiceBillID2), year, month);
                    if (makeInvoiceType != null) {
                        makeType = makeInvoiceType.getValue();
                    }
                    invoiceBiz[0] = year;
                    invoiceBiz[1] = month;
                    invoiceBiz[2] = makeType;
                    invoiceBiz[3] = invoiceBillID2;
                }
                invoiceIDBizList.add(invoiceBiz);
            }
        }
        return invoiceIDBizList;
    }

    @Override
    protected Map<String, Map<String, Set<String>>> combinInvoiceRelation(Context ctx, String billId) throws BOSException, EASBizException, SQLException {
        IRowSet rs = null;
        String srcBosType = null;
        String bizBillID = null;
        String invoiceBillID = null;
        StringBuffer sql = new StringBuffer();
        HashMap<String, Map<String, Set<String>>> idRelation = new HashMap<String, Map<String, Set<String>>>();
        sql.append("select FBizBillID as bizBillID,FSrcBosType as srcBosType,FInvoiceBillID as invoiceBillID ");
        sql.append(" from T_IM_MakeInvoiceRelation where FInvoiceBillID in ");
        sql.append(billId);
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            HashSet<String> billIDSet;
            srcBosType = rs.getString("srcBosType");
            bizBillID = rs.getString("bizBillID");
            invoiceBillID = rs.getString("invoiceBillID");
            if (idRelation.containsKey(invoiceBillID)) {
                if (((Map)idRelation.get(invoiceBillID)).containsKey(srcBosType)) {
                    ((Set)((Map)idRelation.get(invoiceBillID)).get(srcBosType)).add(bizBillID);
                    continue;
                }
                billIDSet = new HashSet();
                billIDSet.add(bizBillID);
                ((Map)idRelation.get(invoiceBillID)).put(srcBosType, billIDSet);
                continue;
            }
            billIDSet = new HashSet<String>();
            billIDSet.add(bizBillID);
            HashMap<String, HashSet<String>> srcBosBillIDMap = new HashMap<String, HashSet<String>>();
            srcBosBillIDMap.put(srcBosType, billIDSet);
            idRelation.put(invoiceBillID, srcBosBillIDMap);
        }
        return idRelation;
    }

    @Override
    protected String getUpdateSql() {
        String updateSQL = "update T_IM_MakeInvoice set FBizYear = ? , FBizMonth = ? , FMakeInvoiceType = ? where FID = ?";
        return updateSQL;
    }

    @Override
    protected void doOtherBeforeExecute(Context ctx, DataUpgradeTraceInfo info, Map<String, Map<String, Set<String>>> idRelation) throws Exception {
        if (idRelation == null || idRelation.size() == 0) {
            return;
        }
        HashSet reqIdSet = new HashSet();
        Iterator<String> srcBillSet = idRelation.keySet().iterator();
        while (srcBillSet.hasNext()) {
            Map<String, Set<String>> srcBillMap = idRelation.get(srcBillSet.next());
            for (String bosType : srcBillMap.keySet()) {
                if (!"AC368D2D".equals(bosType)) continue;
                reqIdSet.addAll(srcBillMap.get(bosType));
            }
        }
        if (reqIdSet.size() == 0) {
            return;
        }
        MakeInvoiceReqBizYearMonthDataUpgrade reqUpgrade = new MakeInvoiceReqBizYearMonthDataUpgrade();
        Map<String, Map<String, Set<String>>> reqIDRelation = reqUpgrade.combinInvoiceRelation(ctx, IMUtils.getInStringFromSet(reqIdSet));
        List reqIDBizList = reqUpgrade.generateInvoiceToUpdate(ctx, reqIDRelation);
        String reqUpdateSql = reqUpgrade.getUpdateSql();
        DbUtil.executeBatch((Context)ctx, (String)reqUpdateSql, (List)reqIDBizList);
    }
}

