/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMakeInvoice;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.RowType;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import org.apache.log4j.Logger;

public class MakeInvoicePartlyRedDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.upgrade.impl.MakeInvoicePartlyRedDataUpgrade");

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            EntityViewInfo defView = null;
            defView = StringUtils.isEmpty((String)info.getDefineConfig()) ? this.getDefaultFilter() : this.buildFilter(ctx, info);
            this.updateNoRedMkInvoice(ctx, defView);
            this.updateRedMkInvoice(ctx, defView);
            info.setIsProcessed(true);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    protected void updateNoRedMkInvoice(Context ctx, EntityViewInfo defView) throws BOSException, EASBizException {
        MakeInvoiceCollection mkInvoiceCol = new MakeInvoiceCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo defFilter = new FilterInfo();
        if (defView != null) {
            view = defView;
            defFilter = defView.getFilter();
        }
        HashSet<String> statusSet = new HashSet<String>();
        statusSet.add("2");
        statusSet.add("3");
        statusSet.add("4");
        statusSet.add("99");
        FilterInfo bizFilter = new FilterInfo();
        bizFilter.getFilterItems().add(new FilterItemInfo("isRedVoice", (Object)0, CompareType.EQUALS));
        bizFilter.getFilterItems().add(new FilterItemInfo("status", statusSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.priceTax"));
        sic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
        sic.add(new SelectorItemInfo("entries.billRowType"));
        defFilter.mergeFilter(bizFilter, "and");
        view.setFilter(defFilter);
        view.setSelector(sic);
        IMakeInvoice imakeInvoice = MakeInvoiceFactory.getLocalInstance(ctx);
        mkInvoiceCol = imakeInvoice.getMakeInvoiceCollection(view);
        int size = mkInvoiceCol.size();
        for (int k = 0; k < size; ++k) {
            MakeInvoiceEntryInfo entry;
            int i;
            MakeInvoiceInfo mkInfo = mkInvoiceCol.get(k);
            MakeInvoiceEntryCollection entries = mkInfo.getEntries();
            HashMap<String, BigDecimal> bluePriceTax = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> blueQty = new HashMap<String, BigDecimal>();
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                String key = null;
                key = entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW) ? entry.getSourceBillEntryId() : entry.getId().toString();
                if (bluePriceTax.containsKey(key)) {
                    bluePriceTax.put(key, ((BigDecimal)bluePriceTax.get(key)).add(entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax()));
                    blueQty.put(key, ((BigDecimal)blueQty.get(key)).add(entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity()));
                    continue;
                }
                bluePriceTax.put(key, entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax());
                blueQty.put(key, entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity());
            }
            for (i = 0; i < entries.size(); ++i) {
                entry = entries.get(i);
                if (entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) continue;
                entry.setUnRedQty((BigDecimal)blueQty.get(entry.getId().toString()));
                entry.setUnRedPriceTax((BigDecimal)bluePriceTax.get(entry.getId().toString()));
                entry.setRedPriceTax(BigDecimal.ZERO);
                entry.setRedQty(BigDecimal.ZERO);
            }
            imakeInvoice.updateWithoutCheck((IObjectPK)new ObjectUuidPK(mkInfo.getId()), (IObjectValue)mkInfo);
        }
    }

    protected void updateRedMkInvoice(Context ctx, EntityViewInfo defView) throws BOSException, EASBizException {
        MakeInvoiceCollection mkInvoiceCol = new MakeInvoiceCollection();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo defFilter = new FilterInfo();
        if (defView != null) {
            view = defView;
            defFilter = defView.getFilter();
        }
        FilterInfo bizFilter = new FilterInfo();
        bizFilter.getFilterItems().add(new FilterItemInfo("isRedVoice", (Object)0, CompareType.EQUALS));
        bizFilter.getFilterItems().add(new FilterItemInfo("isRedVoicedBill", (Object)1, CompareType.EQUALS));
        defFilter.mergeFilter(bizFilter, "and");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("entries.id"));
        sic.add(new SelectorItemInfo("entries.quantity"));
        sic.add(new SelectorItemInfo("entries.priceTax"));
        sic.add(new SelectorItemInfo("entries.billRowType"));
        sic.add(new SelectorItemInfo("entries.redPriceTax"));
        sic.add(new SelectorItemInfo("entries.redQty"));
        sic.add(new SelectorItemInfo("entries.unRedPriceTax"));
        sic.add(new SelectorItemInfo("entries.unRedQty"));
        view.setFilter(defFilter);
        view.setSelector(sic);
        IMakeInvoice imakeInvoice = MakeInvoiceFactory.getLocalInstance(ctx);
        mkInvoiceCol = imakeInvoice.getMakeInvoiceCollection(view);
        int mkColSize = mkInvoiceCol.size();
        for (int k = 0; k < mkColSize; ++k) {
            int i;
            MakeInvoiceInfo blue = mkInvoiceCol.get(k);
            HashMap<String, BigDecimal> priceTaxMap = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> qtyMap = new HashMap<String, BigDecimal>();
            EntityViewInfo redViewInfo = new EntityViewInfo();
            FilterInfo redFilter = new FilterInfo();
            redFilter.getFilterItems().add(new FilterItemInfo("isRedVoice", (Object)1, CompareType.EQUALS));
            redFilter.getFilterItems().add(new FilterItemInfo("redBillId", (Object)blue.getId().toString(), CompareType.EQUALS));
            redFilter.getFilterItems().add(new FilterItemInfo("status", (Object)"99", CompareType.NOTEQUALS));
            redViewInfo.setFilter(redFilter);
            SelectorItemCollection redSic = new SelectorItemCollection();
            redSic.add(new SelectorItemInfo("id"));
            redSic.add(new SelectorItemInfo("entries.billRowType"));
            redSic.add(new SelectorItemInfo("entries.sourceBillEntryId"));
            redSic.add(new SelectorItemInfo("entries.quantity"));
            redSic.add(new SelectorItemInfo("entries.priceTax"));
            redViewInfo.setSelector(redSic);
            MakeInvoiceCollection redInvoiceColl = imakeInvoice.getMakeInvoiceCollection(redViewInfo);
            int size = redInvoiceColl.size();
            for (int i2 = 0; i2 < size; ++i2) {
                MakeInvoiceEntryCollection redEntries = redInvoiceColl.get(i2).getEntries();
                int entrySize = redEntries.size();
                for (int j = 0; j < entrySize; ++j) {
                    MakeInvoiceEntryInfo redEntry = redEntries.get(j);
                    if (StringUtils.isEmpty((String)redEntry.getSourceBillEntryId())) continue;
                    if (!priceTaxMap.containsKey(redEntry.getSourceBillEntryId())) {
                        priceTaxMap.put(redEntry.getSourceBillEntryId(), redEntry.getPriceTax() == null ? BigDecimal.ZERO : redEntry.getPriceTax());
                        qtyMap.put(redEntry.getSourceBillEntryId(), redEntry.getQuantity() == null ? BigDecimal.ZERO : redEntry.getQuantity());
                        continue;
                    }
                    BigDecimal oldPriceTax = (BigDecimal)priceTaxMap.get(redEntry.getSourceBillEntryId());
                    BigDecimal oldQty = (BigDecimal)qtyMap.get(redEntry.getSourceBillEntryId());
                    priceTaxMap.put(redEntry.getSourceBillEntryId(), oldPriceTax.add(redEntry.getPriceTax() == null ? BigDecimal.ZERO : redEntry.getPriceTax()));
                    qtyMap.put(redEntry.getSourceBillEntryId(), oldQty.add(redEntry.getQuantity() == null ? BigDecimal.ZERO : redEntry.getQuantity()));
                }
            }
            HashMap<String, BigDecimal> bluePriceTax = new HashMap<String, BigDecimal>();
            HashMap<String, BigDecimal> blueQty = new HashMap<String, BigDecimal>();
            MakeInvoiceEntryCollection blueEntries = blue.getEntries();
            for (i = 0; i < blueEntries.size(); ++i) {
                MakeInvoiceEntryInfo entry = blueEntries.get(i);
                String key = null;
                key = entry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW) ? entry.getSourceBillEntryId() : entry.getId().toString();
                if (bluePriceTax.containsKey(key)) {
                    bluePriceTax.put(key, ((BigDecimal)bluePriceTax.get(key)).add(entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax()));
                    blueQty.put(key, ((BigDecimal)blueQty.get(key)).add(entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity()));
                    continue;
                }
                bluePriceTax.put(key, entry.getPriceTax() == null ? BigDecimal.ZERO : entry.getPriceTax());
                blueQty.put(key, entry.getQuantity() == null ? BigDecimal.ZERO : entry.getQuantity());
            }
            int size2 = blueEntries.size();
            for (i = 0; i < size2; ++i) {
                MakeInvoiceEntryInfo blueEntry = blueEntries.get(i);
                if (blueEntry.getBillRowType().equals((Object)RowType.DISCOUNT_ROW)) continue;
                BigDecimal unRedPriceTax = blueEntry.getUnRedPriceTax() == null ? BigDecimal.ZERO : blueEntry.getUnRedPriceTax();
                BigDecimal unRedQty = blueEntry.getUnRedQty() == null ? BigDecimal.ZERO : blueEntry.getUnRedQty();
                BigDecimal redPriceTax = blueEntry.getRedPriceTax() == null ? BigDecimal.ZERO : blueEntry.getRedPriceTax();
                BigDecimal redQty = blueEntry.getRedQty() == null ? BigDecimal.ZERO : blueEntry.getRedQty();
                BigDecimal totalPriceTax = unRedPriceTax.add(redPriceTax);
                BigDecimal totalQty = unRedQty.add(redQty);
                BigDecimal nowUnRedPriceTax = totalPriceTax;
                BigDecimal nowRedPriceTax = BigDecimal.ZERO;
                BigDecimal nowUnRedQty = totalQty;
                BigDecimal nowRedQty = BigDecimal.ZERO;
                BigDecimal NEG_ONE = new BigDecimal(-1);
                if (priceTaxMap.containsKey(blueEntry.getId().toString())) {
                    nowUnRedPriceTax = totalPriceTax.add((BigDecimal)priceTaxMap.get(blueEntry.getId().toString()));
                    nowRedPriceTax = NEG_ONE.multiply((BigDecimal)priceTaxMap.get(blueEntry.getId().toString()));
                    nowUnRedQty = totalQty.add((BigDecimal)qtyMap.get(blueEntry.getId().toString()));
                    nowRedQty = NEG_ONE.multiply((BigDecimal)qtyMap.get(blueEntry.getId().toString()));
                }
                blueEntry.setUnRedPriceTax(nowUnRedPriceTax);
                blueEntry.setRedPriceTax(nowRedPriceTax);
                blueEntry.setUnRedQty(nowUnRedQty);
                blueEntry.setRedQty(nowRedQty);
            }
            imakeInvoice.updateWithoutCheck((IObjectPK)new ObjectUuidPK(blue.getId()), (IObjectValue)blue);
        }
    }

    protected EntityViewInfo buildFilter(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        String filterItems = info.getDefineConfig();
        EntityViewInfo defView = new EntityViewInfo();
        defView.getSelector().add(new SelectorItemInfo("id"));
        if (filterItems != null && filterItems.length() > 0) {
            try {
                defView.setFilter(new FilterInfo(IMSQLUtil.getDataFilterInfo(filterItems)));
                return defView;
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    protected EntityViewInfo getDefaultFilter() {
        Date currentDate = new Date(System.currentTimeMillis());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.add(2, -1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date lastMonth = calendar.getTime();
        FilterInfo filter = new FilterInfo();
        Timestamp dateFrom = new Timestamp(lastMonth.getTime());
        filter.getFilterItems().add(new FilterItemInfo("createTime", (Object)dateFrom, CompareType.GREATER_EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        return viewInfo;
    }
}

