/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.upgrade.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.ProductCodeFactory;
import com.kingdee.eas.tm.im.upgrade.DataUpgradeTraceInfo;
import com.kingdee.eas.tm.im.upgrade.api.AbstractDataUpgrade;
import com.kingdee.eas.tm.im.upgrade.impl.SaleOrderDataUpgrade;
import com.kingdee.eas.tm.im.util.IMSQLUtil;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.log4j.Logger;

public class ProductCodeSyncDataUpgrade
extends AbstractDataUpgrade {
    private static Logger logger = Logger.getLogger(SaleOrderDataUpgrade.class);

    @Override
    protected void doUpgrade(Context ctx, DataUpgradeTraceInfo info) throws EASBizException, BOSException {
        try {
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            if (StringUtils.isEmpty((String)info.getDefineConfig())) {
                throw new IMException(IMException.ERRORMSG, new Object[]{IMUtils.getString("com.kingdee.eas.tm.im.upgrade.DataUpgradeResource", "DefineConfig_NOT_NULLl", IMUtils.getLocale())});
            }
            String filterSql = this.buildFilterSql(ctx, info);
            FilterInfo filter = new FilterInfo("id in (" + filterSql + ")");
            FilterInfo statusfilter = new FilterInfo();
            statusfilter.getFilterItems().add(new FilterItemInfo("status", (Object)1, CompareType.EQUALS));
            filter.mergeFilter(statusfilter, "AND");
            SorterItemCollection sorter = new SorterItemCollection();
            IObjectPK[] pks = MaterialFactory.getLocalInstance((Context)ctx).getPKList(filter, sorter);
            ArrayList<String> idList = new ArrayList<String>();
            int size = pks.length;
            for (int i = 0; i < size; ++i) {
                idList.add(pks[i].toString());
            }
            HashMap<String, ArrayList<String>> params = new HashMap<String, ArrayList<String>>();
            params.put("idList", idList);
            ProductCodeFactory.getLocalInstance(ctx).syncProductCode("4409E7F0", params);
            info.setIsProcessed(true);
            logger.debug((Object)"upgrade success");
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
    }

    protected String buildFilterSql(Context ctx, DataUpgradeTraceInfo info) throws BOSException {
        return IMSQLUtil.structureFilter(ctx, info.getDefineConfig(), info.getQuery());
    }
}

