/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import java.math.BigDecimal;

public class EntrySplitStrategy {
    private BigDecimal avgNoTaxAmt = BigDecimal.ZERO;
    private BigDecimal avgTaxAmt = BigDecimal.ZERO;
    private BigDecimal avgPriceTax = BigDecimal.ZERO;
    private BigDecimal avgDiscountAmt = BigDecimal.ZERO;
    private BigDecimal avgQty = null;
    private BigDecimal leftNoTaxAmt = BigDecimal.ZERO;
    private BigDecimal leftTaxAmt = BigDecimal.ZERO;
    private BigDecimal leftPriceTax = BigDecimal.ZERO;
    private BigDecimal leftDiscountAmt = BigDecimal.ZERO;
    private BigDecimal leftQty = null;
    private MakeInvoiceEntryInfo entry;
    private BigDecimal maxAmt;
    private int splitNum = 1;
    private BigDecimal bdSplitNum = BigDecimal.ZERO;

    public EntrySplitStrategy(MakeInvoiceEntryInfo entry, BigDecimal maxAmt) {
        this.entry = entry;
        this.maxAmt = maxAmt;
    }

    public MakeInvoiceEntryInfo average() {
        MakeInvoiceEntryInfo entryClone = (MakeInvoiceEntryInfo)this.entry.clone();
        entryClone.setMakeInvoice(null);
        entryClone.setBOSUuid("id", BOSUuid.create((BOSObjectType)this.entry.getBOSType()));
        entryClone.setNoTaxAmt(this.avgNoTaxAmt);
        entryClone.setTaxAmt(this.avgTaxAmt);
        entryClone.setPriceTax(this.avgPriceTax);
        entryClone.setDiscountAmt(this.avgDiscountAmt);
        entryClone.setQuantity(this.avgQty);
        return entryClone;
    }

    public MakeInvoiceEntryInfo left() {
        MakeInvoiceEntryInfo entryClone = (MakeInvoiceEntryInfo)this.entry.clone();
        entryClone.setMakeInvoice(null);
        entryClone.setBOSUuid("id", BOSUuid.create((BOSObjectType)this.entry.getBOSType()));
        entryClone.setNoTaxAmt(this.leftNoTaxAmt);
        entryClone.setTaxAmt(this.leftTaxAmt);
        entryClone.setPriceTax(this.leftPriceTax);
        entryClone.setDiscountAmt(this.leftDiscountAmt);
        entryClone.setQuantity(this.leftQty);
        return entryClone;
    }

    public int getSplitNum() {
        return this.splitNum;
    }

    public void calcQtyAndAmt() {
        BigDecimal quantity = this.entry.getQuantity();
        if (quantity == null || quantity.compareTo(new BigDecimal(0)) == 0) {
            this.calcNoQtyNum();
            this.calcAvgAmtByAmt();
        } else {
            this.calcQtyNum();
            this.calcAvgAmtByQty();
        }
        this.calcLeftAmt();
    }

    private void calcQtyNum() {
        BigDecimal quantity;
        BigDecimal noTaxPrice = this.entry.getNoTaxPrice();
        BigDecimal noTaxAmt = this.entry.getNoTaxAmt();
        BigDecimal bdSplitQty = quantity = this.entry.getQuantity();
        bdSplitQty = this.maxAmt.divide(noTaxPrice, 2, 1);
        BigDecimal bdNum = quantity.divide(bdSplitQty, 2, 6);
        int num = bdNum.intValue();
        if (bdSplitQty.multiply(noTaxPrice).compareTo(this.maxAmt) < 0) {
            ++num;
        }
        if (this.maxAmt.multiply(new BigDecimal(num)).compareTo(noTaxAmt) < 0) {
            ++num;
        }
        this.avgQty = bdSplitQty = quantity.divide(new BigDecimal(num), 2, 6);
        this.splitNum = num;
        this.bdSplitNum = new BigDecimal(num);
        this.leftQty = quantity.subtract(this.avgQty.multiply(this.bdSplitNum.subtract(new BigDecimal(1))));
    }

    private void calcNoQtyNum() {
        BigDecimal noTaxAmt = this.entry.getNoTaxAmt();
        BigDecimal bdNum = noTaxAmt.divide(this.maxAmt, 2, 6);
        int num = bdNum.intValue();
        if ((bdNum = new BigDecimal(num)).multiply(this.maxAmt).compareTo(noTaxAmt) < 0) {
            bdNum = new BigDecimal(++num);
        }
        this.splitNum = num;
        this.bdSplitNum = new BigDecimal(num);
    }

    private void calcAvgAmtByQty() {
        BigDecimal quantity = this.entry.getQuantity();
        this.avgNoTaxAmt = this.entry.getNoTaxAmt().multiply(this.avgQty).divide(quantity, 2, 6);
        this.avgTaxAmt = this.entry.getTaxAmt().multiply(this.avgQty).divide(quantity, 2, 6);
        this.avgPriceTax = this.entry.getPriceTax().multiply(this.avgQty).divide(quantity, 2, 6);
        if (this.entry.getDiscountAmt() != null) {
            this.avgDiscountAmt = this.entry.getDiscountAmt().multiply(this.avgQty).divide(quantity, 2, 6);
        }
    }

    private void calcAvgAmtByAmt() {
        this.avgNoTaxAmt = this.entry.getNoTaxAmt().divide(this.bdSplitNum, 2, 6);
        this.avgTaxAmt = this.entry.getTaxAmt().divide(this.bdSplitNum, 2, 6);
        this.avgPriceTax = this.entry.getPriceTax().divide(this.bdSplitNum, 2, 6);
        if (this.entry.getDiscountAmt() != null) {
            this.avgDiscountAmt = this.entry.getDiscountAmt().divide(this.bdSplitNum, 2, 6);
        }
    }

    private void calcLeftAmt() {
        this.leftNoTaxAmt = this.entry.getNoTaxAmt().subtract(this.avgNoTaxAmt.multiply(this.bdSplitNum.subtract(new BigDecimal(1))));
        this.leftTaxAmt = this.entry.getTaxAmt().subtract(this.avgTaxAmt.multiply(this.bdSplitNum.subtract(new BigDecimal(1))));
        this.leftPriceTax = this.entry.getPriceTax().subtract(this.avgPriceTax.multiply(this.bdSplitNum.subtract(new BigDecimal(1))));
        if (this.entry.getDiscountAmt() != null) {
            this.leftDiscountAmt = this.entry.getDiscountAmt().subtract(this.avgDiscountAmt.multiply(this.bdSplitNum.subtract(new BigDecimal(1))));
        }
    }
}

