/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.base.commonquery.RowObject;
import com.kingdee.eas.base.commonquery.app.CommonQueryUtil;
import com.kingdee.eas.tm.im.util.DateUtil;
import java.util.ArrayList;

public class IMSQLUtil {
    public static String structureFilter(Context ctx, String filterItems, String queryPK) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        if (filterItems != null && filterItems.length() > 0) {
            try {
                view.setFilter(new FilterInfo(IMSQLUtil.getDataFilterInfo(filterItems)));
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        exec.setObjectView(view);
        String sql = exec.getSQL();
        return sql;
    }

    public static String autoStructureFilter(Context ctx, String filterItems, String queryPK) throws BOSException {
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)new MetaDataPK(queryPK));
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("id"));
        view.getSelector().add(new SelectorItemInfo("number"));
        if (filterItems != null && filterItems.length() > 0) {
            try {
                view.setFilter(new FilterInfo(IMSQLUtil.getDataFilterInfo(filterItems)));
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        exec.setObjectView(view);
        String sql = exec.getSQL();
        return sql;
    }

    public static String getDataFilterInfo(String filterItems) throws ParserException {
        FilterInfo filterInfo = new FilterInfo(filterItems);
        int filterSize = filterInfo.getFilterItems().size();
        ArrayList rowInfos = CommonQueryUtil.getRowInfos((FilterInfo)filterInfo);
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < filterSize; ++i) {
            RowObject rowObject = (RowObject)rowInfos.get(i);
            FilterItemInfo filterItemInfo = filterInfo.getFilterItems().get(i);
            if (filterItemInfo.getCompareType() == CompareType.EMPTY || filterItemInfo.getCompareType() == CompareType.NOTEMPTY) {
                filterItemInfo.setCompareValue(null);
            }
            sb.append(rowObject.getLeftBracket().toString());
            if (filterItemInfo.getCompareValue() != null) {
                sb.append(DateUtil.getDataFilterInfo(filterItemInfo));
            } else {
                sb.append(filterItemInfo.toString());
            }
            sb.append(rowObject.getRightBracket().toString()).append(" ");
            sb.append(rowObject.getLogic().toString()).append(" ");
        }
        return sb.toString();
    }
}

