/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.extendcontrols.IParser;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.SelectorListener;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.bot.BOTRelationFactory;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.bot.IBOTRelation;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.message.BMCMessageFactory;
import com.kingdee.eas.base.message.BMCMessageInfo;
import com.kingdee.eas.base.message.MsgBizType;
import com.kingdee.eas.base.message.MsgPriority;
import com.kingdee.eas.base.message.MsgStatus;
import com.kingdee.eas.base.message.MsgType;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.netctrl.MutexServiceControlFactory;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.IParamItem;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.ParamItemCollection;
import com.kingdee.eas.base.param.ParamItemFactory;
import com.kingdee.eas.base.param.ParamItemInfo;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.client.F7MaterialTreeListUI;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.TableManagerFacadeFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.client.GeneralKDPromptSelectorAdaptor;
import com.kingdee.eas.tm.im.CombinRuleSettingFactory;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.ICombinRuleSetting;
import com.kingdee.eas.tm.im.IIMFacade;
import com.kingdee.eas.tm.im.IMException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.common.goldenTaxControl.GoldenTaxControlParamCollection;
import com.kingdee.eas.tm.im.common.goldenTaxControl.GoldenTaxControlParamFactory;
import com.kingdee.eas.tm.im.common.goldenTaxControl.GoldenTaxControlParamInfo;
import com.kingdee.eas.tm.im.common.goldenTaxControl.IGoldenTaxControlParam;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.PropertyContainer;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public class IMUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.util.IMUtils");
    public static final String MAKEINVOICE_RESOURCE = "com.kingdee.eas.tm.im.MakeInvoiceResource";
    public static final String CUSTOMERTAX_RESOURCE = "com.kingdee.eas.tm.im.basedata.CustomerTaxResource";
    public static final String PRODUCTCODE_RESOURCE = "com.kingdee.eas.tm.im.ProductCodeResource";
    public static final String PWYSETTING_RESOURCE = "com.kingdee.eas.tm.im.PwySettingResource";
    public static final String MAKEINVOICEANALYSISRPT_RESOURCE = "com.kingdee.eas.tm.rpt.MakeInvoiceAnalysisRptResource";
    public static final String IMCOMMON_RESOURCE = "com.kingdee.eas.tm.im.IMCommonResource";
    public static final String IMIMPORT_RESOURCE = "com.kingdee.eas.tm.im.app.IMImportResource";
    public static final String INCOMEINVOICE_RESOURCE = "com.kingdee.eas.tm.im.IncomeInvoiceResource";
    public static final String TAXPLATE_RESOURCE = "com.kingdee.eas.tm.im.basedata.TaxPlateResource";
    public static final String INVOICEINVMGR_RESOURCE = "com.kingdee.eas.tm.im.inv.InvoiceInvMgrResource";
    public static final String INCOMETYPE_RESOURCE = "com.kingdee.eas.tm.im.basedata.IncomeTypeResource";
    public static final String IMCOMM_RESOURCE = "com.kingdee.eas.tm.im.common.comm.IMCommResource";
    public static final String IM_RESOURCE = "com.kingdee.eas.tm.im.IMResource";
    public static final String AUTO_MAKEINVOICESCHEME_RSOURCE = "com.kingdee.eas.tm.im.basedata.AutoMakeInvoiceSchemeResource";
    public static final String AUTO_INCOMEINVOICESCHEME_RSOURCE = "com.kingdee.eas.tm.im.basedata.AutoIncomeInvoiceSchemeResource";
    public static final String MAKEINVOICEREQ_RESOURCE = "com.kingdee.eas.tm.im.MakeInvoiceReqResource";
    public static final String WRITEBACK_RESOURCE = "com.kingdee.eas.tm.im.common.writeback.WriteBackResource";
    public static final String POOLSERVICE_RESOURCE = "com.kingdee.eas.tm.im.ps.PoolServiceResource";
    public static final String INVSTATISTICCOM_RESOURCE = "com.kingdee.eas.tm.im.ps.InvStatisticCompareResource";
    public static final String DATAUPGRADE_RESOURCE = "com.kingdee.eas.tm.im.upgrade.DataUpgradeResource";
    public static final String LOG_RESOURCE = "com.kingdee.eas.tm.im.LogResource";
    public static final String VEHICELMANAGE_RESOURCE = "com.kingdee.eas.tm.im.basedata.VehicleManageResource";
    public static final String IMBIZ_RESOURCE = "com.kingdee.eas.tm.im.IMBizResource";
    public static final String VEHICLEMAKEINVOICE_RESOURCE = "com.kingdee.eas.tm.im.VehicleMakeInvoiceResource";
    public static final String RES_RESOURCE_NAME = "com.kingdee.eas.tm.im.MakeVolumnInvoiceResource";
    public static final String ADD_SYNC_RESOURCE = "com.kingdee.eas.tm.im.rpt.AddSyncInvoiceResource";
    public static final String MAKEINVOICEVIEW_RESOURCE_NAME = "com.kingdee.eas.tm.im.MakeInvoiceViewResource";
    public static final String BDSYNCRULE_RESOURCE_NAME = "com.kingdee.eas.tm.im.basedata.BDSyncRuleResource";
    public static final String FORMULARESOURCE_RESOURCE_NAME = "com.kingdee.eas.tm.im.common.formula.FormulaResource";
    public static final String VIEWINVOICE_RESOURCE_NAME = "com.kingdee.eas.tm.im.ViewInvoiceResource";
    public static final String INVOICESCAN_RESOURCE_NAME = "com.kingdee.eas.tm.im.basedata.InvoiceScanResource";
    public static final String SPECIFICINFORMATION_RESOURCE = "com.kingdee.eas.tm.im.SpecificInformationResource";

    public static CombinRuleSettingInfo getCombinRule(Context ctx, String ruleID) throws BOSException, EASBizException {
        if (ruleID == null || "".equals(ruleID)) {
            CombinRuleSettingInfo info = new CombinRuleSettingInfo();
            info.setIsInTax(true);
            info.setCombinFields("entries.id_id");
            return info;
        }
        ICombinRuleSetting facade = null;
        facade = ctx == null ? CombinRuleSettingFactory.getRemoteInstance() : CombinRuleSettingFactory.getLocalInstance(ctx);
        CombinRuleSettingInfo info = facade.getCombinRuleSettingInfo((IObjectPK)new ObjectUuidPK(ruleID));
        return info;
    }

    public static Map getInQuestionParams(String inStr, boolean hasQuestion) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String marks = "";
        Object[] objs = null;
        if (!StringUtils.isEmpty((String)inStr)) {
            String[] arr = inStr.split(",");
            StringBuffer sql = new StringBuffer();
            objs = new Object[arr.length];
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    sql.append(",");
                }
                sql.append("?");
                objs[i] = hasQuestion ? arr[i].substring(1, arr[i].length() - 1) : arr[i];
            }
            marks = sql.toString();
        }
        ret.put("marks", marks);
        ret.put("objs", objs);
        return ret;
    }

    public static String getIMResource(Context context, String name, String ... params) {
        if (params.length == 0) {
            return ResourceBase.getString((String)IM_RESOURCE, (String)name, (Locale)context.getOriginLocale());
        }
        return ResourceBase.getString((String)IM_RESOURCE, (String)name, (Locale)context.getOriginLocale(), (Object[])params);
    }

    public static String getResource(String resClassName, String key, Context ctx) {
        return IMUtils.getString(resClassName, key, ctx.getLocale());
    }

    public static String getAllResource(String resClassName, String key, Context ctx, Object[] params) {
        Locale locale = SysContext.getSysContext().getOriginLocale();
        if (ctx != null) {
            locale = SysContext.getSysContext().getOriginLocale();
        }
        return IMUtils.getString(resClassName, key, locale, params);
    }

    public static String getString(String resClassName, String resName) {
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)IMUtils.getLocale());
    }

    public static String getString(String resClassName, String resName, Locale locale) {
        if (locale != null) {
            return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale);
        }
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)IMUtils.getLocale());
    }

    public static String getString(String resClassName, String resName, Locale locale, Object[] params) {
        if (locale != null) {
            return ResourceBase.getString((String)resClassName, (String)resName, (Locale)locale, (Object[])params);
        }
        return ResourceBase.getString((String)resClassName, (String)resName, (Locale)IMUtils.getLocale(), (Object[])params);
    }

    public static Locale getLocale() {
        try {
            return SysContext.getSysContext().getOriginLocale();
        }
        catch (Throwable e) {
            return LocaleUtils.locale_zh_CN;
        }
    }

    public static StringEnum getEnumByValueOrAlias(List enumList, String value) {
        for (StringEnum _enum : enumList) {
            if (!_enum.getValue().equals(value) && !_enum.getAlias().equals(value)) continue;
            return _enum;
        }
        return null;
    }

    public static String getInStringFromArray(String[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        for (int i = 0; i < arr.length; ++i) {
            in.append("'").append(arr[i]).append("'");
            if (i == arr.length - 1) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getInStringFromSet(Set ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getInMarkStringFromSet(Set ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            iter.next();
            in.append("?");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getInStringFromList(List ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getStringFromList(List ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            in.append(iter.next().toString());
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        return in.toString();
    }

    public static String getInMarkStringFromList(List ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            iter.next();
            in.append("?");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getInString(String str) {
        return "('" + str + "')";
    }

    public static String buildKey(ArrayList<String> propList, IObjectValue info) {
        StringBuffer retValue = new StringBuffer();
        for (int i = 0; i < propList.size(); ++i) {
            String prop = propList.get(i);
            Object obj = info.get(prop);
            if (obj instanceof IObjectValue) {
                retValue.append(((IObjectValue)obj).get("id").toString());
            } else if (obj != null) {
                retValue.append(obj.toString());
            }
            retValue.append("_");
        }
        return retValue.toString();
    }

    public static void traceUpAndDown(Context ctx, String srcId, String srcBosType, String desId, String desBosType) throws BOSException {
        BOTRelationInfo info = new BOTRelationInfo();
        info.setSrcObjectID(srcId);
        info.setSrcEntityID(srcBosType);
        info.setDestEntityID(desBosType);
        info.setDestObjectID(desId);
        info.setOperatorID("unknown");
        info.setType(0);
        IBOTRelation factory = null;
        factory = ctx == null ? BOTRelationFactory.getRemoteInstance() : BOTRelationFactory.getLocalInstance((Context)ctx);
        factory.addnew(info);
    }

    public static boolean getBooleanParam(Context ctx, String companyId, String paramName) throws EASBizException, BOSException {
        boolean retValue = false;
        String param = IMUtils.getParamByNumber(ctx, companyId, new String[]{paramName});
        if (param != null) {
            retValue = Boolean.parseBoolean(param);
        }
        return retValue;
    }

    public static boolean getBooleanValue(String value) {
        boolean retValue = false;
        if (value != null) {
            retValue = Boolean.parseBoolean(value);
        }
        return retValue;
    }

    public static int getIntegerValue(String value) {
        int retValue = 0;
        if (value != null) {
            retValue = Integer.parseInt(value);
        }
        return retValue;
    }

    public static BigDecimal getDecimalValue(String value) {
        BigDecimal retValue = BigDecimal.ZERO;
        if (value != null) {
            retValue = new BigDecimal(value);
        }
        return retValue;
    }

    public static BigDecimal getDecimalValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public static BigDecimal getDecimalParam(Context ctx, String companyId, String[] paramName) throws BOSException, EASBizException {
        BigDecimal retValue = BigDecimal.ZERO;
        String param = IMUtils.getParamByNumber(ctx, companyId, paramName);
        if (param != null) {
            retValue = new BigDecimal(param);
        }
        return retValue;
    }

    public static int getIntegerParam(Context ctx, String companyId, String paramName) throws EASBizException, BOSException {
        int retValue = 0;
        String param = IMUtils.getParamByNumber(ctx, companyId, new String[]{paramName});
        if (param != null) {
            retValue = Integer.parseInt(param);
        }
        return retValue;
    }

    public static String concatList2String(List list) {
        String returnStr = "";
        for (int i = 0; i < list.size(); ++i) {
            returnStr = i == 0 ? returnStr + list.get(i).toString() : returnStr + ";" + list.get(i).toString();
        }
        return returnStr;
    }

    public static String getParamByNumber(Context ctx, String companyId, String[] paramName) throws BOSException, EASBizException {
        IIMFacade facade = null;
        facade = ctx == null ? IMFacadeFactory.getRemoteInstance() : IMFacadeFactory.getLocalInstance(ctx);
        Map paramMap = facade.getParam(companyId, paramName);
        String param = (String)paramMap.get(paramName[0]);
        return param;
    }

    public static Map getParam(Context ctx, String companyId, String[] paramName) throws BOSException, EASBizException {
        IIMFacade facade = null;
        facade = ctx == null ? IMFacadeFactory.getRemoteInstance() : IMFacadeFactory.getLocalInstance(ctx);
        Map paramMap = facade.getParam(companyId, paramName);
        return paramMap;
    }

    public static String getParamValue(Context ctx, String cuid, String paramNumber) throws BOSException, EASBizException {
        IParamControl ipc = ctx == null ? ParamControlFactory.getRemoteInstance() : ParamControlFactory.getLocalInstance((Context)ctx);
        return ipc.getParamValue((IObjectPK)new ObjectUuidPK(cuid), paramNumber);
    }

    public static IObjectValue billCopy(Context context, AbstractObjectValue dataObject) throws BOSException {
        BOSObjectType bosType = dataObject.getBOSType();
        EntitySelect select = new EntitySelect(bosType);
        select.selectPKFields();
        SimpleEntity entity = MetaDataAccessFactory.getLocalInstance((Context)context).select(select);
        String[] pks = entity.getPKFields();
        IMUtils.removePKField(dataObject, pks);
        dataObject.setBOSUuid("id", BOSUuid.create((BOSObjectType)dataObject.getBOSType()));
        return dataObject;
    }

    private static void removePKField(AbstractObjectValue dataObject, String[] pks) {
        if (dataObject == null) {
            return;
        }
        dataObject.remove(dataObject.getPKField());
        if (pks != null) {
            for (int i = 0; i < pks.length; ++i) {
                String[] path = StringUtils.split((String)pks[i], (String)".");
                List<AbstractObjectValue> ovs = new ArrayList<AbstractObjectValue>(1);
                ovs.add(dataObject);
                for (int j = 0; j < path.length && (ovs = IMUtils.findSubObject(ovs, path[j])) != null; ++j) {
                }
                if (ovs == null) continue;
                for (AbstractObjectValue ov : ovs) {
                    ov.remove(ov.getPKField());
                }
            }
        }
    }

    private static List<AbstractObjectValue> findSubObject(List<AbstractObjectValue> dataObjects, String prop) {
        if (dataObjects == null || dataObjects.size() <= 0 || prop == null) {
            return null;
        }
        ArrayList<AbstractObjectValue> subs = new ArrayList<AbstractObjectValue>();
        int size = dataObjects.size();
        for (int i = 0; i < size; ++i) {
            AbstractObjectValue ov;
            Object sub = dataObjects.get(i).get(prop);
            if (sub == null) continue;
            if (sub instanceof AbstractObjectValue) {
                ov = (AbstractObjectValue)sub;
                subs.add(ov);
                continue;
            }
            if (!(sub instanceof AbstractObjectCollection)) continue;
            AbstractObjectCollection oc = (AbstractObjectCollection)sub;
            int s = oc.size();
            for (int j = 0; j < s; ++j) {
                ov = (AbstractObjectValue)oc.getObject(j);
                subs.add(ov);
            }
        }
        return subs;
    }

    public static HashSet list2Set(ArrayList list) {
        HashSet retSet = new HashSet();
        for (int i = 0; i < list.size(); ++i) {
            retSet.add(list.get(i));
        }
        return retSet;
    }

    public static String getIds(ArrayList list) {
        String ids = "";
        for (int i = 0; i < list.size(); ++i) {
            ids = i < list.size() - 1 ? ids + list.get(i) + "," : ids + list.get(i);
        }
        return ids;
    }

    public static KDMenuItem cloneMenuItem(KDMenuItem menuItem) {
        KDMenuItem newMenuItem = new KDMenuItem();
        newMenuItem.setAction(menuItem.getAction());
        newMenuItem.setText(menuItem.getText());
        newMenuItem.setToolTipText(menuItem.getToolTipText());
        newMenuItem.setIcon(menuItem.getIcon());
        return newMenuItem;
    }

    public static String buildErrorMsg(List<String> msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i));
            if (StringUtils.isEmpty((String)msg.get(i)) || msg.get(i).endsWith("\n")) continue;
            retMsg.append("\r\n");
        }
        return retMsg.toString();
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean IsUrl(String str) {
        if (str == null) {
            return false;
        }
        Pattern pattern = Pattern.compile("(https?|ftp|file)://[-A-Za-z0-9+&@#/%?=~_|!:,.;]+[-A-Za-z0-9+&@#/%=~_|]");
        Matcher matcher = pattern.matcher(str);
        return matcher.matches();
    }

    public static String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(context.getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, SorterItemCollection sorter) throws BOSException {
        OrgUnitCollection results = new OrgUnitCollection();
        if (orgs == null || orgs.size() == 0) {
            return results;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(IMUtils.getOrgInfoSelector(orgType));
        switch (orgType.getValue()) {
            case 0: {
                AdminOrgUnitCollection collection;
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                if (sorter != null) {
                    view.setSorter(sorter);
                }
                if ((collection = iAdmin.getAdminOrgUnitCollection(view)) != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 1: {
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 2: {
                ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 3: {
                IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 4: {
                IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 24: {
                ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 10: {
                ICtrlUnit ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
                CtrlUnitCollection collection = ictrlUnit.getCtrlUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
        }
        return null;
    }

    public static SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    public static void removeNullRow(KDTable table, String[] colNames) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        if (colNames == null) {
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = true;
                IRow row = table.getRow(i);
                for (int colIndex = 0; isNullRow && colIndex < colCount; ++colIndex) {
                    isNullRow = row.getCell(colIndex).getValue() == null;
                }
                if (!isNullRow) continue;
                table.removeRow(i);
                --i;
                --rowCount;
            }
        } else {
            int colCounts = colNames.length;
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = false;
                IRow row = table.getRow(i);
                for (int colIndex = 0; !isNullRow && colIndex < colCounts; ++colIndex) {
                    isNullRow = row.getCell(colNames[colIndex]).getValue() == null;
                }
                if (!isNullRow) continue;
                if (rowCount == 1) {
                    return;
                }
                table.removeRow(i);
                --i;
                --rowCount;
            }
        }
    }

    public static Object getCompareValue(FilterItemCollection filters, String propName, CompareType compareType) {
        Object obj = null;
        compareType = compareType == null ? CompareType.EQUALS : compareType;
        for (FilterItemInfo filterInfo : filters) {
            if (filterInfo == null || !propName.equalsIgnoreCase(filterInfo.getPropertyName()) || !compareType.equals((Object)filterInfo.getCompareType())) continue;
            obj = filterInfo.getCompareValue();
            return obj;
        }
        return obj;
    }

    public static List getCompareValues(FilterItemCollection filters, String propName, CompareType compareType) {
        ArrayList<Object> objs = new ArrayList<Object>();
        Object obj = null;
        compareType = compareType == null ? CompareType.EQUALS : compareType;
        for (FilterItemInfo filterInfo : filters) {
            if (filterInfo == null || !propName.equalsIgnoreCase(filterInfo.getPropertyName()) || !compareType.equals((Object)filterInfo.getCompareType())) continue;
            obj = filterInfo.getCompareValue();
            objs.add(obj);
        }
        return objs;
    }

    public static Enum getEnumValue(String enumSource, String value) throws BOSException, EASBizException {
        if (value == null) {
            return null;
        }
        List list = EnumUtils.getEnumList((String)enumSource);
        if (list == null) {
            list = DynamicEnum.getEnumList((String)enumSource);
        }
        int size = list.size();
        Object enumValue = null;
        for (int j = 0; j < size; ++j) {
            if (!(list.get(j) instanceof Enum)) continue;
            Enum enumData = (Enum)list.get(j);
            if (enumData instanceof StringEnum) {
                enumValue = ((StringEnum)enumData).getValue();
            } else if (enumData instanceof IntEnum) {
                enumValue = ((IntEnum)enumData).getValue();
            } else if (enumData instanceof LongEnum) {
                enumValue = ((LongEnum)enumData).getValue();
            } else if (enumData instanceof FloatEnum) {
                enumValue = Float.valueOf(((FloatEnum)enumData).getValue());
            } else if (enumData instanceof DoubleEnum) {
                enumValue = ((DoubleEnum)enumData).getValue();
            } else if (enumData instanceof DynamicEnum) {
                enumValue = ((DynamicEnum)enumData).getValue();
            }
            if (enumValue != null && enumValue.toString().equals(value)) {
                return enumData;
            }
            if (!enumData.getAlias().equals(value)) continue;
            return enumData;
        }
        return null;
    }

    public static Object getEnumValue(Enum enumData) {
        Object enumValue = null;
        if (enumData instanceof StringEnum) {
            enumValue = ((StringEnum)enumData).getValue();
        } else if (enumData instanceof IntEnum) {
            enumValue = ((IntEnum)enumData).getValue();
        } else if (enumData instanceof LongEnum) {
            enumValue = ((LongEnum)enumData).getValue();
        } else if (enumData instanceof FloatEnum) {
            enumValue = Float.valueOf(((FloatEnum)enumData).getValue());
        } else if (enumData instanceof DoubleEnum) {
            enumValue = ((DoubleEnum)enumData).getValue();
        } else if (enumData instanceof DynamicEnum) {
            enumValue = ((DynamicEnum)enumData).getValue();
        }
        return enumValue;
    }

    public static boolean getImportParam(Context ctx) {
        boolean isByRule = false;
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.getSelector().add(new SelectorItemInfo("Value"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.subSysID", (Object)"0000", CompareType.EQUALS));
        filterInfo.getFilterItems().add(new FilterItemInfo("keyID.number", (Object)"importDataByRule", CompareType.EQUALS));
        entityViewInfo.setFilter(filterInfo);
        try {
            IParamItem iParamItem = ParamItemFactory.getLocalInstance((Context)ctx);
            ParamItemCollection collection = iParamItem.getParamItemCollection(entityViewInfo);
            if (collection == null || collection.size() == 0) {
                return isByRule;
            }
            ParamItemInfo info = collection.get(0);
            String value = info.getValue();
            if (value != null && value.equals("true")) {
                isByRule = true;
            }
        }
        catch (Exception e) {
            isByRule = false;
        }
        return isByRule;
    }

    public static CompanyOrgUnitInfo getPermissionCompany(String permissionItem) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, permissionItem);
        FilterInfo tmpFilter = iProducer.getFilterInfo();
        view.setFilter(tmpFilter);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        if (companyOrgUnitCollection.isEmpty()) {
            return null;
        }
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
            if (!companyOrgUnitInfo.getId().toString().equals(companyId)) continue;
            return companyOrgUnitInfo;
        }
        return companyOrgUnitCollection.get(0);
    }

    public static boolean isLocked(Map lockList) {
        Iterator iterator = lockList.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (Boolean.parseBoolean(lockList.get(key).toString())) continue;
            return true;
        }
        return false;
    }

    public static void tryLock(Context ctx, List idList) throws EASBizException, BOSException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMutexServiceControl mutexServiceControl = null;
        mutexServiceControl = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
        boolean isReqError = IMUtils.isLocked(map);
        if (isReqError) {
            throw new IMException(IMException.BILL_LOCKED);
        }
    }

    public static void releaseLock(Context ctx, List idList) throws BOSException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMutexServiceControl mutexServiceControl = null;
        mutexServiceControl = ctx == null ? MutexServiceControlFactory.getRemoteInstance() : MutexServiceControlFactory.getLocalInstance((Context)ctx);
        mutexServiceControl.batchReleaseObjIDForUpdate(idList);
    }

    public static void tryLock(List idList) throws EASBizException, BOSException {
        IMUtils.tryLock(null, idList);
    }

    public static void releaseLock(List idList) throws BOSException {
        IMUtils.releaseLock(null, idList);
    }

    public static boolean idEquals(CoreBaseInfo obj1, CoreBaseInfo obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.getId().equals((Object)obj2.getId());
    }

    public static boolean objectEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
        }
        if (obj1 instanceof CoreBaseInfo && obj2 instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj1).getId().toString().equals(((CoreBaseInfo)obj2).getId().toString());
        }
        return obj1.equals(obj2);
    }

    public static boolean isEqual(Object newValue, Object oldValue) {
        Object[] newValueArr = null;
        newValueArr = newValue instanceof Object[] ? (Object[])newValue : new Object[]{newValue};
        Object[] oldValueArr = null;
        oldValueArr = oldValue instanceof Object[] ? (Object[])oldValue : new Object[]{oldValue};
        if (newValueArr.length != oldValueArr.length) {
            return false;
        }
        HashMap<String, CoreBaseInfo> oldValueMap = new HashMap<String, CoreBaseInfo>();
        CoreBaseInfo oldValueInfo = null;
        for (int i = 0; i < oldValueArr.length; ++i) {
            oldValueInfo = (CoreBaseInfo)oldValueArr[i];
            if (oldValueInfo == null) continue;
            oldValueMap.put(oldValueInfo.getId().toString(), oldValueInfo);
        }
        HashMap<String, CoreBaseInfo> newValueMap = new HashMap<String, CoreBaseInfo>();
        CoreBaseInfo newValueInfo = null;
        for (int i = 0; i < newValueArr.length; ++i) {
            newValueInfo = (CoreBaseInfo)newValueArr[i];
            if (newValueInfo == null) continue;
            newValueMap.put(newValueInfo.getId().toString(), newValueInfo);
            if (oldValueMap.get(newValueInfo.getId().toString()) != null) continue;
            return false;
        }
        return oldValueMap.size() == newValueMap.size();
    }

    public static boolean hasBotpRelation(Context ctx, String srcID, String destID, String srcEntityID, String destEntityID) throws BOSException {
        boolean hasRelation = false;
        String operateID = "unknown";
        int type = 0;
        try {
            String selectSQL = " SELECT FID FROM T_BOT_Relation WHERE FSRCENTITYID = '" + srcEntityID + "' and FDESTENTITYID = '" + destEntityID + "' and FOPERATORID = '" + operateID + "' and FTYPE = " + type + " and FDESTOBJECTID ='" + destID + "' and FSRCOBJECTID = '" + srcID + "'";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)selectSQL);
            if (rs.next()) {
                hasRelation = true;
            }
        }
        catch (SQLException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
            throw new BOSException("excute sql error...");
        }
        return hasRelation;
    }

    public static String getStringFromSet(Set values) {
        StringBuffer sb = new StringBuffer();
        for (Object value : values) {
            if (sb.length() == 0) {
                sb.append(value.toString());
                continue;
            }
            sb.append("\u3001").append(value.toString());
        }
        return sb.toString();
    }

    public static String join(Object[] array, char separator) {
        if (array == null) {
            return null;
        }
        int arraySize = array.length;
        int bufSize = arraySize == 0 ? 0 : ((array[0] == null ? 16 : array[0].toString().length()) + 1) * arraySize;
        StringBuffer buf = new StringBuffer(bufSize);
        for (int i = 0; i < arraySize; ++i) {
            if (array[i] == null) continue;
            if (i > 0) {
                buf.append(separator);
            }
            buf.append(array[i]);
        }
        return buf.toString();
    }

    public static NumberFormat getInvoiceNumberFmt() {
        NumberFormat numberFormat = NumberFormat.getNumberInstance();
        numberFormat.setMinimumIntegerDigits(8);
        numberFormat.setGroupingUsed(false);
        return numberFormat;
    }

    public static void sendBMCMsg(Context ctx, String msg, String title, String receiver) throws EASBizException, BOSException {
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        msgInfo.setType(MsgType.NOTICE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        msgInfo.setBizType(MsgBizType.ONLINE);
        msgInfo.setPriority(MsgPriority.MIDDLE);
        msgInfo.setTitle(title);
        msgInfo.setBody(msg);
        msgInfo.setReceiver(receiver);
        msgInfo.setSender(ctx.getUserName());
        msgInfo.setSenderId(receiver);
        BMCMessageFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)msgInfo);
    }

    public static void sendBMCMsg(Context ctx, String msg, String title, MsgBizType msgBizType, String receiver) throws EASBizException, BOSException {
        BMCMessageInfo msgInfo = new BMCMessageInfo();
        msgInfo.setType(MsgType.NOTICE);
        msgInfo.setStatus(MsgStatus.UNREADED);
        msgInfo.setBizType(msgBizType);
        msgInfo.setPriority(MsgPriority.MIDDLE);
        msgInfo.setTitle(title);
        msgInfo.setBody(msg);
        msgInfo.setReceiver(receiver);
        msgInfo.setSender(ctx.getUserName());
        msgInfo.setSenderId(receiver);
        BMCMessageFactory.getLocalInstance((Context)ctx).addnew((CoreBaseInfo)msgInfo);
    }

    public static ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, CurrencyInfo sourceCur, Date date) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = null;
        ObjectUuidPK excTablepk = null;
        ObjectUuidPK destCurrpk = null;
        if (companyOrgUnitInfo.getBaseExchangeTable() == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(companyOrgUnitInfo.getBaseExchangeTable().getId());
        CurrencyInfo baseCur = companyOrgUnitInfo.getBaseCurrency();
        if (baseCur != null) {
            if (baseCur.getId().equals((Object)sourceCur.getId())) {
                return null;
            }
        } else {
            return null;
        }
        destCurrpk = new ObjectUuidPK(baseCur.getId());
        iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(sourceCur.getId());
        ExchangeRateInfo erInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, date);
        return erInfo;
    }

    public static String getChineseFormat(BigDecimal number, boolean hasFull, Locale locale) {
        boolean integerEmpty;
        if (number == null) {
            return "";
        }
        if (locale.equals(LocaleUtils.locale_l1) || locale.equals(LocaleUtils.locale_L1)) {
            return number == null ? "" : number.toString();
        }
        String nagative = "";
        String nagVirText = "";
        boolean isNagativeB = false;
        if (number.toString().indexOf("-") >= 0) {
            nagative = IMUtils.getChineseName("nagative", locale);
            isNagativeB = true;
        }
        Properties decimalPro = IMUtils.getDecimalUnitMapping(locale);
        Properties integerPro = IMUtils.getIntegerUnitMapping(true, locale);
        Properties numberPro = IMUtils.getNumberMapping(locale);
        String valTemp = number.toString();
        if (isNagativeB) {
            valTemp = valTemp.replace('-', ' ').trim();
        }
        int dotIndex = valTemp.indexOf(".");
        String integerStr = "";
        String integerTempStr = null;
        String decimalStr = "";
        String decimalTempStr = null;
        if (dotIndex == -1) {
            integerTempStr = valTemp;
        } else {
            integerTempStr = valTemp.substring(0, dotIndex);
            decimalTempStr = valTemp.substring(dotIndex + 1);
        }
        if (integerTempStr != null) {
            int integerLen = integerTempStr.length() - 1;
            boolean zeroAttached = false;
            boolean hasTem = true;
            for (int i = integerLen; i >= 0; --i) {
                String index = String.valueOf(i);
                String str = String.valueOf(integerTempStr.charAt(integerLen - i));
                String numStr = numberPro.getProperty(str);
                String uombStr = integerPro.getProperty(index);
                boolean needed = false;
                if (uombStr.startsWith("*")) {
                    needed = true;
                    uombStr = uombStr.substring(1);
                    if (hasTem && i == 4 && integerLen >= 8) {
                        if ('0' == integerTempStr.charAt(0) && '0' == integerTempStr.charAt(1) && '0' == integerTempStr.charAt(2) && '0' == integerTempStr.charAt(3) && '0' == integerTempStr.charAt(integerLen - 8) && '0' == integerTempStr.charAt(integerLen - 7) && '0' == integerTempStr.charAt(integerLen - 6) && '0' == integerTempStr.charAt(integerLen - 5) && ('0' != integerTempStr.charAt(integerLen - 4) || '0' != integerTempStr.charAt(integerLen - 3) || '0' != integerTempStr.charAt(integerLen - 2) || '0' != integerTempStr.charAt(integerLen - 1))) {
                            uombStr = IMUtils.getChineseName("zero", locale);
                        } else if ('0' == integerTempStr.charAt(integerLen - 4)) {
                            uombStr = "";
                        }
                        hasTem = false;
                    }
                }
                if ("0".equals(str)) {
                    if (zeroAttached) {
                        numStr = "";
                        if (needed) {
                            zeroAttached = false;
                            integerStr = integerStr.substring(0, integerStr.length() - 1);
                        } else {
                            uombStr = "";
                        }
                    } else if (!needed) {
                        zeroAttached = true;
                        uombStr = "";
                    } else {
                        zeroAttached = false;
                        numStr = "";
                    }
                } else {
                    if (i <= 7 && i >= 4) {
                        hasTem = false;
                    }
                    zeroAttached = false;
                }
                integerStr = integerStr + numStr + uombStr;
            }
        }
        boolean bl = integerEmpty = integerStr.length() < 2;
        if (integerEmpty) {
            integerStr = "";
        }
        boolean decimalEmpty = true;
        boolean hasJiao = false;
        if (decimalTempStr != null) {
            int n;
            int decimalLen = decimalTempStr.length();
            n = decimalLen > (n = decimalPro.size()) ? n : decimalLen;
            boolean zeroAttached = false;
            boolean ignoreLeadingZero = true;
            for (int j = 0; j < n; ++j) {
                String index = String.valueOf(j);
                String str = String.valueOf(decimalTempStr.charAt(j));
                String numStr = numberPro.getProperty(str);
                String uombStr = decimalPro.getProperty(index);
                if ("0".equals(str)) {
                    if (zeroAttached) {
                        numStr = "";
                        uombStr = "";
                        if (j == n - 1) {
                            decimalStr = decimalStr.substring(0, decimalStr.length() - 1);
                        }
                    } else {
                        if (j < n - 1 && !ignoreLeadingZero) {
                            zeroAttached = true;
                        } else {
                            numStr = "";
                        }
                        uombStr = "";
                    }
                } else {
                    hasJiao = j == 0;
                    zeroAttached = false;
                    ignoreLeadingZero = false;
                }
                decimalStr = decimalStr + numStr + uombStr;
            }
            boolean bl2 = decimalEmpty = decimalStr.length() < 2;
            if (decimalEmpty) {
                decimalStr = "";
            }
            String unDescriptable = "";
            int index = -1;
            for (int i = n; i < decimalLen; ++i) {
                char c = decimalTempStr.charAt(i);
                String numStr = numberPro.getProperty(String.valueOf(c));
                unDescriptable = unDescriptable + numStr;
                if ('0' == c) continue;
                index = i;
            }
            if (index >= 0) {
                decimalEmpty = false;
                if ('0' == decimalTempStr.charAt(n - 1)) {
                    decimalStr = decimalStr + IMUtils.getChineseName("zero", locale) + decimalPro.getProperty(String.valueOf(n - 1));
                }
                decimalStr = decimalStr + unDescriptable.substring(0, index - n + 1);
            } else if (decimalTempStr.length() > 1 && '0' == decimalTempStr.charAt(0) && '0' != decimalTempStr.charAt(1)) {
                decimalStr = IMUtils.getChineseName("zero", locale) + decimalStr;
            }
        }
        if (integerEmpty && decimalEmpty) {
            integerStr = IMUtils.getChineseName("zero", locale) + IMUtils.getChineseName("money", locale);
        }
        String value = nagative + nagVirText + integerStr + decimalStr;
        value = nagative + nagVirText + integerStr + decimalStr;
        if (decimalStr == null || decimalStr.length() == 0 || decimalStr.length() == 1 || hasJiao) {
            value = value + IMUtils.getChineseName("full", locale);
        }
        return value;
    }

    private static Properties getDecimalUnitMapping(Locale locale) {
        Properties decimalCurrencyUomb = new Properties();
        decimalCurrencyUomb.setProperty("0", IMUtils.getChineseName("jiao", locale));
        decimalCurrencyUomb.setProperty("1", IMUtils.getChineseName("fen", locale));
        decimalCurrencyUomb.setProperty("2", IMUtils.getChineseName("li", locale));
        decimalCurrencyUomb.setProperty("3", IMUtils.getChineseName("hao", locale));
        return decimalCurrencyUomb;
    }

    private static Properties getIntegerUnitMapping(boolean flag, Locale locale) {
        Properties integerCurrencyUomb = new Properties();
        if (flag) {
            integerCurrencyUomb.setProperty("0", "*" + IMUtils.getChineseName("money", locale));
        } else {
            integerCurrencyUomb.setProperty("0", "*");
        }
        integerCurrencyUomb.setProperty("1", IMUtils.getChineseName("ten", locale));
        integerCurrencyUomb.setProperty("2", IMUtils.getChineseName("handred", locale));
        integerCurrencyUomb.setProperty("3", IMUtils.getChineseName("thrasand", locale));
        integerCurrencyUomb.setProperty("4", "*" + IMUtils.getChineseName("tenshand", locale));
        integerCurrencyUomb.setProperty("5", IMUtils.getChineseName("ten", locale));
        integerCurrencyUomb.setProperty("6", IMUtils.getChineseName("handred", locale));
        integerCurrencyUomb.setProperty("7", IMUtils.getChineseName("thrasand", locale));
        integerCurrencyUomb.setProperty("8", "*" + IMUtils.getChineseName("handredmill", locale));
        integerCurrencyUomb.setProperty("9", IMUtils.getChineseName("ten", locale));
        integerCurrencyUomb.setProperty("10", IMUtils.getChineseName("handred", locale));
        integerCurrencyUomb.setProperty("11", IMUtils.getChineseName("thrasand", locale));
        integerCurrencyUomb.setProperty("12", IMUtils.getChineseName("tenshand", locale));
        integerCurrencyUomb.setProperty("13", IMUtils.getChineseName("handredmill", locale));
        integerCurrencyUomb.setProperty("14", IMUtils.getChineseName("ten", locale));
        return integerCurrencyUomb;
    }

    private static Properties getNumberMapping(Locale locale) {
        Properties numberMapping = new Properties();
        numberMapping.setProperty("0", IMUtils.getChineseName("zero", locale));
        numberMapping.setProperty("1", IMUtils.getChineseName("one", locale));
        numberMapping.setProperty("2", IMUtils.getChineseName("two", locale));
        numberMapping.setProperty("3", IMUtils.getChineseName("three", locale));
        numberMapping.setProperty("4", IMUtils.getChineseName("four", locale));
        numberMapping.setProperty("5", IMUtils.getChineseName("five", locale));
        numberMapping.setProperty("6", IMUtils.getChineseName("six", locale));
        numberMapping.setProperty("7", IMUtils.getChineseName("seven", locale));
        numberMapping.setProperty("8", IMUtils.getChineseName("eight", locale));
        numberMapping.setProperty("9", IMUtils.getChineseName("nine", locale));
        return numberMapping;
    }

    private static String getChineseName(String key, Locale locale) {
        return ResourceBase.getString((String)"com.kingdee.eas.fi.gl.GLResource", (String)key, (Locale)locale);
    }

    public static int getStringlength(String value) {
        int valueLength = 0;
        String chinese = "[\u4e00-\u9fa5]|\u3002|\uff1f|\uff01|\u3010|\u3011|\uff0c|\u3001|\uff1b|\uff1a|\u300c|\u300d|\u300e|\u300f|\u2019|\u201c|\u201d|\u2018|\uff08|\uff09|\u3014|\u3015|\u2026|\u2013|\uff0e|\u2014|\u300a|\u300b|\u3008|\u3009";
        if (value != null) {
            for (int i = 0; i < value.length(); ++i) {
                String temp = value.substring(i, i + 1);
                if (temp.matches(chinese)) {
                    valueLength += 2;
                    continue;
                }
                ++valueLength;
            }
        }
        return valueLength;
    }

    public static String getStringByLenth(String str, int len) {
        int strLen = 0;
        String chinese = "[\u4e00-\u9fa5]|\u3002|\uff1f|\uff01|\u3010|\u3011|\uff0c|\u3001|\uff1b|\uff1a|\u300c|\u300d|\u300e|\u300f|\u2019|\u201c|\u201d|\u2018|\uff08|\uff09|\u3014|\u3015|\u2026|\u2013|\uff0e|\u2014|\u300a|\u300b|\u3008|\u3009";
        if (str != null) {
            int subLen;
            for (subLen = 0; subLen < str.length(); ++subLen) {
                String temp = str.substring(subLen, subLen + 1);
                if (strLen >= len) break;
                if (temp.matches(chinese)) {
                    strLen += 2;
                    continue;
                }
                ++strLen;
            }
            return str.substring(0, subLen);
        }
        return null;
    }

    public static void setMaterialF7(CoreUIObject ui, KDBizPromptBox bizPromptBox, CompanyOrgUnitInfo companyInfo, boolean isMultiSelect, int f7DisplayMode, boolean includeFreezed, boolean onlySupportQueryViaMaterialNumber) {
        bizPromptBox.setDisplayFormat("$name$");
        bizPromptBox.setEditFormat("$number$");
        bizPromptBox.setCommitFormat("$number$");
        if (onlySupportQueryViaMaterialNumber) {
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$", bizPromptBox));
        } else {
            bizPromptBox.setCommitParser((IParser)new KDBizPromptBox.DefaultParser("$number$;$name$;$model$;$helpCode$", bizPromptBox));
        }
        FilterInfo filter = new FilterInfo();
        if (includeFreezed) {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(0), CompareType.GREATER));
            filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(0), CompareType.GREATER));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("FIInfo.status", (Object)new Integer(1)));
        }
        if (companyInfo != null) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)companyInfo.getId(), CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(filter);
        bizPromptBox.setEntityViewInfo(evi);
        bizPromptBox.setEnabledMultiSelection(isMultiSelect);
        String queryInfo = "com.kingdee.eas.basedata.master.material.app.F7MaterialFIQuery";
        if (f7DisplayMode == 0) {
            SelectorListener[] selectorListener1 = IMUtils.removePrmtAllSelListener(bizPromptBox);
            GeneralKDPromptSelectorAdaptor selector = new GeneralKDPromptSelectorAdaptor((KDPromptBox)bizPromptBox, F7MaterialTreeListUI.class.getName(), (Object)ui, MaterialGroupInfo.getBosType(), queryInfo, "materialGroup.id", "orgUnit.id", "com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
            IMUtils.assignSelector((KDPromptBox)bizPromptBox, (KDPromptSelector)selector);
            selector.setIsMultiSelect(isMultiSelect);
            IMUtils.addPrmtAllSelListener(bizPromptBox, selectorListener1);
            bizPromptBox.addSelectorListener((SelectorListener)selector);
        } else {
            bizPromptBox.setQueryInfo("com.kingdee.eas.basedata.master.material.app.F7MaterialFINoGroupQuery");
            if (companyInfo != null) {
                bizPromptBox.setCurrentMainBizOrgUnit((OrgUnitInfo)companyInfo, OrgType.Company);
            }
            bizPromptBox.setHasCUDefaultFilter(false);
        }
    }

    private static SelectorListener[] removePrmtAllSelListener(KDBizPromptBox prmtCtrl) {
        SelectorListener[] selListeners = prmtCtrl.getSelectorListeners();
        if (selListeners == null) {
            return selListeners;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.removeSelectorListener(selListeners[i]);
        }
        return selListeners;
    }

    public static void assignSelector(KDPromptBox promptBox, KDPromptSelector selector) {
        promptBox.setSelector(selector);
    }

    private static void addPrmtAllSelListener(KDBizPromptBox prmtCtrl, SelectorListener[] selListeners) {
        if (selListeners == null) {
            return;
        }
        for (int i = 0; i < selListeners.length; ++i) {
            prmtCtrl.addSelectorListener(selListeners[i]);
        }
    }

    public static Map<String, String> getTaxControlParam(Context ctx, int goldenTaxType, String[] paramName) throws BOSException {
        IGoldenTaxControlParam iGoldenTaxControlParam = null;
        iGoldenTaxControlParam = ctx == null ? GoldenTaxControlParamFactory.getRemoteInstance() : GoldenTaxControlParamFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("goldenTaxType", (Object)goldenTaxType, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("paramName", new HashSet(Arrays.asList((Object[])paramName)), CompareType.INCLUDE));
        view.setFilter(filter);
        GoldenTaxControlParamCollection coll = iGoldenTaxControlParam.getGoldenTaxControlParamCollection(view);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        GoldenTaxControlParamInfo paramInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            paramInfo = coll.get(i);
            paramMap.put(paramInfo.getParamName(), paramInfo.getParamValue());
        }
        return paramMap;
    }

    public static String getTaxControlParamBigValue(Context ctx, int goldenTaxType, String paramName) throws BOSException {
        Map<String, String> map = IMUtils.getTaxControlParam(ctx, goldenTaxType, new String[]{paramName});
        String value = map.get(paramName);
        return value;
    }

    public static BigDecimal getTaxControlParamBigDecimalValue(Context ctx, int goldenTaxType, String paramName) throws BOSException {
        Map<String, String> map = IMUtils.getTaxControlParam(ctx, goldenTaxType, new String[]{paramName});
        String value = map.get(paramName);
        BigDecimal bValue = null;
        if (!StringUtils.isEmpty((String)value)) {
            bValue = new BigDecimal(value);
        }
        return bValue;
    }

    public static Integer getTaxControlParamIntegerValue(Context ctx, int goldenTaxType, String paramName) throws BOSException {
        Map<String, String> map = IMUtils.getTaxControlParam(ctx, goldenTaxType, new String[]{paramName});
        String value = map.get(paramName);
        Integer bValue = null;
        if (!StringUtils.isEmpty((String)value)) {
            bValue = Integer.parseInt(value);
        }
        return bValue;
    }

    public static void textFieldTrim(Component[] comps) {
        for (int i = 0; i < comps.length; ++i) {
            KDTextField txt;
            JComponent boundEditor;
            if (!(comps[i] instanceof KDLabelContainer) || !((boundEditor = ((KDLabelContainer)comps[i]).getBoundEditor()) instanceof KDTextField) || (txt = (KDTextField)boundEditor).getText() == null) continue;
            txt.setText(txt.getText().trim());
        }
    }

    public static String cutStr(String strs, int length) throws BOSException {
        String finalStr;
        block4: {
            int sum = 0;
            finalStr = "";
            try {
                if (null == strs || strs.getBytes("GBK").length <= length) {
                    finalStr = strs == null ? "" : strs;
                    break block4;
                }
                for (int i = 0; i < strs.length(); ++i) {
                    String str = strs.substring(i, i + 1);
                    if ((sum += str.getBytes("GBK").length) <= length) continue;
                    finalStr = strs.substring(0, i);
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return finalStr;
    }

    public static Timestamp getCurrentTime() {
        Timestamp time = new Timestamp(new Date().getTime());
        return time;
    }

    public static Timestamp[] getDefaultDateRange(Date d) {
        Calendar calendar = Calendar.getInstance();
        if (d != null) {
            calendar.setTime(d);
        }
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 23, 59, 59);
        calendar.set(14, 999);
        Timestamp currDate = new Timestamp(calendar.getTimeInMillis());
        calendar.add(2, -1);
        calendar.set(calendar.get(1), calendar.get(2), calendar.get(5), 0, 0, 0);
        calendar.set(14, 0);
        return new Timestamp[]{new Timestamp(calendar.getTimeInMillis()), currDate};
    }

    public static String getSign(String clientID, String secret, long timestamp) {
        String str = clientID + secret + timestamp;
        return IMUtils.StringToMD5(str);
    }

    private static String StringToMD5(String input) {
        String md5str = null;
        if (input == null) {
            return "";
        }
        byte[] bytes = input.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buff = md.digest(bytes);
            md5str = IMUtils.bytesToHex(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5str;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        return md5str.toString();
    }

    public static FilterInfo getAddSrcBill2OtherBillFilterInfo(Context ctx, Map params) {
        boolean isBlueInvoice = (Boolean)params.get("isBlueInvoice");
        String companyID = (String)params.get("companyID");
        String customerID = (String)params.get("customerID");
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from t_ar_otherbill where fbillStatus = 3  and FisMakeInvoiceReq = 0 and FisVehicleInvoiceReq = 0");
        if (isBlueInvoice) {
            sql.append(" and ((FAmount - FInvoicedAmt) > 0 or (FAmount - FInvoicedAmt) < 0) ");
        }
        if (!StringUtils.isEmpty((String)customerID)) {
            sql.append(" and fasstActID = '" + customerID + "'");
        } else {
            sql.append(" and fasstActID = '111111111111111111111111111='");
        }
        if (!StringUtils.isEmpty((String)companyID)) {
            sql.append(" and FCompanyID = '" + companyID + "'");
        } else {
            sql.append(" and FCompanyID = '111111111111111111111111111='");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    public static FilterInfo getAddSrcBill2ReqBillFilterInfo(Map params) {
        boolean isBlueInvoice = (Boolean)params.get("isBlueInvoice");
        String companyID = (String)params.get("companyID");
        String customerID = (String)params.get("customerID");
        FilterInfo filter = new FilterInfo();
        StringBuffer sql = new StringBuffer();
        sql.append(" select fid from T_IM_MakeInvoiceReq where fstatus = 2");
        if (isBlueInvoice) {
            sql.append(" and ((FPriceExcludingTax - FInvoicedAmt) > 0 or (FPriceExcludingTax- FInvoicedAmt) < 0) ");
        }
        if (!StringUtils.isEmpty((String)customerID)) {
            sql.append(" and FAsstActID = '" + customerID + "'");
        } else {
            sql.append(" and FAsstActID = '111111111111111111111111111='");
        }
        if (!StringUtils.isEmpty((String)companyID)) {
            sql.append(" and FCompanyID = '" + companyID + "'");
        } else {
            sql.append(" and FCompanyID = '111111111111111111111111111='");
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.INNER));
        return filter;
    }

    public static boolean isPwyEmpty(String str) {
        return "null".equalsIgnoreCase(str) || StringUtils.isEmpty((String)str);
    }

    public static BigDecimal isNullToZero(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public static String getIdTempTable(Context ctx, String tableName, List idList) throws BOSException {
        Connection cn = null;
        PreparedStatement stmt = null;
        String tbl = null;
        try {
            tbl = TableManagerFacadeFactory.getLocalInstance((Context)ctx).getTableName(tableName);
            StringBuffer createSql = new StringBuffer();
            createSql.append(" create table ");
            createSql.append(tbl);
            createSql.append(" (fid varchar(44)");
            createSql.append(")");
            TableManagerFacadeFactory.getLocalInstance((Context)ctx).createTempTable(createSql.toString());
            cn = EJBFactory.getConnection((Context)ctx);
            stmt = cn.prepareStatement("insert into " + tbl + " values(?)");
            for (Object id : idList) {
                stmt.setString(1, id.toString());
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, cn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)cn);
        return tbl;
    }

    public static boolean isNotSatisfyRelations(MakeInvoiceInfo invoice, MakeInvoiceEntryInfo entry) {
        if (entry.getNoTaxAmt() == null || entry.getTaxRate() == null) {
            return false;
        }
        BigDecimal noTaxAmt = IMUtils.isNullToZero(entry.getNoTaxAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(entry.getTaxRate());
        BigDecimal taxAmt = IMUtils.isNullToZero(entry.getTaxAmt());
        BigDecimal priceTax = IMUtils.isNullToZero(entry.getPriceTax());
        if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        if (priceTax.compareTo(noTaxAmt.add(taxAmt)) != 0) {
            return true;
        }
        BigDecimal totalDiffAmount = invoice.getTotalDiffAmount(entry);
        logger.error((Object)("totalDiffAmount:" + totalDiffAmount));
        return totalDiffAmount.abs().compareTo(invoice.getAllowDiffMax()) > 0;
    }

    public static boolean isDiffNotSatisfyRelations(MakeInvoiceInfo invoice, MakeInvoiceEntryInfo entry) {
        if (entry.getNoTaxAmt() == null || entry.getTaxRate() == null) {
            return false;
        }
        BigDecimal noTaxAmt = IMUtils.isNullToZero(entry.getNoTaxAmt());
        BigDecimal taxRate = IMUtils.isNullToZero(entry.getTaxRate());
        BigDecimal taxAmt = IMUtils.isNullToZero(entry.getTaxAmt());
        BigDecimal priceTax = IMUtils.isNullToZero(entry.getPriceTax());
        if (taxRate.compareTo(BigDecimal.ZERO) == 0) {
            return false;
        }
        if (priceTax.compareTo(noTaxAmt.add(taxAmt)) != 0) {
            return true;
        }
        BigDecimal totalDiffAmount = invoice.getDiffTotalDiffAmount(entry);
        logger.error((Object)("totalDiffAmount:" + totalDiffAmount));
        return totalDiffAmount.abs().compareTo(invoice.getAllowDiffAmtMax()) > 0;
    }

    public static boolean isDiffNotSatisfyRelations(MakeInvoiceInfo invoice) {
        BigDecimal allowTotalDiffMax = IMUtils.isNullToZero(invoice.getAllowTotalDiffMax());
        BigDecimal allowDiffMaxAvg = IMUtils.isNullToZero(invoice.getAllowDiffMaxAvg());
        if (invoice.getTotalDiffer().abs().compareTo(allowTotalDiffMax) > 0) {
            return true;
        }
        return invoice.getGoldenTaxControl() == 1 && invoice.getDiffAvgAmount().abs().compareTo(allowDiffMaxAvg) > 0;
    }

    public static void mergeSelector(SelectorItemCollection sic, SelectorItemCollection selectors) {
        if (sic == null) {
            sic = new SelectorItemCollection();
        }
        if (selectors != null) {
            SelectorItemInfo selector = null;
            int size = selectors.size();
            for (int i = 0; i < size; ++i) {
                selector = selectors.get(i);
                if (sic.contains(selector)) continue;
                sic.add(selector);
            }
        }
    }

    public static Integer dealZerotoNull(Integer num) {
        if (num != null && num != 0) {
            return num;
        }
        return null;
    }

    public static List getF7Value(Object value) {
        ArrayList<String> ids;
        block6: {
            block5: {
                ids = new ArrayList<String>();
                if (!(value instanceof CoreBaseInfo)) break block5;
                CoreBaseInfo info = (CoreBaseInfo)value;
                if (info == null) break block6;
                ids.add(info.getId().toString());
                break block6;
            }
            if (value instanceof List) {
                List list = (List)value;
                CoreBaseInfo info2 = null;
                for (CoreBaseInfo info2 : list) {
                    if (info2 == null) continue;
                    ids.add(info2.getId().toString());
                }
            } else if (value instanceof Object[]) {
                Object[] objs = (Object[])value;
                CoreBaseInfo info = null;
                for (int i = 0; i < objs.length; ++i) {
                    info = (CoreBaseInfo)objs[i];
                    if (info == null) continue;
                    ids.add(info.getId().toString());
                }
            }
        }
        return ids;
    }

    public static void trimHeadTextFields(PropertyContainer info) {
        try {
            Class<PropertyContainer> pwySettingClass = PropertyContainer.class;
            Field valuesField = pwySettingClass.getDeclaredField("values");
            valuesField.setAccessible(true);
            Map valuesMap = (Map)valuesField.get(info);
            if (valuesMap != null && !valuesMap.isEmpty()) {
                Iterator iter = valuesMap.keySet().iterator();
                String mapKey = null;
                while (iter.hasNext()) {
                    mapKey = (String)iter.next();
                    if (valuesMap.get(mapKey) == null || !(valuesMap.get(mapKey) instanceof String)) continue;
                    info.put(mapKey, (Object)IMUtils.trimStr((String)valuesMap.get(mapKey)));
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public static String trimStr(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return str;
        }
        return str.trim();
    }
}

