/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.RelationshipInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import java.util.HashMap;
import java.util.Map;

public class MetaDataUtil {
    private static Map<String, EntityObjectInfo> entityMap = new HashMap<String, EntityObjectInfo>();

    public static EntityObjectInfo getEntity(Context ctx, String bosType) throws BOSException, EASBizException {
        IMetaDataLoader loader = null;
        EntityObjectInfo entity = entityMap.get(bosType);
        if (entity == null) {
            try {
                loader = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx);
                entity = loader.getEntity(BOSObjectType.create((String)bosType));
                entityMap.put(bosType, entity);
            }
            catch (Exception e) {
                throw new BOSException("bostype error");
            }
        }
        return entity;
    }

    public static PropertyInfo getEntityProperty(Context ctx, String bosType, String fieldName) throws BOSException, EASBizException {
        EntityObjectInfo entity = MetaDataUtil.getEntity(ctx, bosType);
        String name = fieldName;
        String[] fields = fieldName.split("\\.");
        if (fields.length > 1) {
            for (int i = 1; i < fields.length; ++i) {
                LinkPropertyInfo linkProperty = (LinkPropertyInfo)entity.getPropertyByName(fields[i - 1]);
                if (linkProperty == null) {
                    return null;
                }
                RelationshipInfo relation = linkProperty.getRelationship();
                entity = relation.getSupplierObject();
                name = fields[i];
            }
        }
        PropertyInfo property = entity.getPropertyByName(name);
        return property;
    }
}

