/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.util.HashSet;

public class UsedCarMakeInvoiceFilterFactory {
    private static UsedCarMakeInvoiceFilterFactory instance = new UsedCarMakeInvoiceFilterFactory();

    private UsedCarMakeInvoiceFilterFactory() {
    }

    public static UsedCarMakeInvoiceFilterFactory getInstance() {
        return instance;
    }

    public FilterInfo getCompanyFilter(String permItem) throws EASBizException, BOSException {
        OrgUnitCollection orgs = IMFacadeFactory.getRemoteInstance().getAuthOrgsByType(OrgType.Company, permItem);
        HashSet<String> companyIds = new HashSet<String>();
        companyIds.add("111111111111111111111111111=");
        OrgUnitInfo org = null;
        int size = orgs.size();
        for (int i = 0; i < size; ++i) {
            org = orgs.get(i);
            companyIds.add(org.getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", companyIds, CompareType.INCLUDE));
        return filter;
    }

    public FilterInfo getCustomerFilter(String companyId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("CustomerCompanyInfo.usingStatus", (Object)0, CompareType.EQUALS));
        return filter;
    }

    public FilterInfo getSupplierFilter(String companyId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)1, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("supplierCompany.usingStatus", (Object)0, CompareType.EQUALS));
        return filter;
    }

    public FilterInfo getBuyerNameFilter(String companyId, String customerId) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isVehicle", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)"0", CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)customerId)) {
            filter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerId, CompareType.EQUALS));
        }
        if (!StringUtils.isEmpty((String)companyId)) {
            FilterInfo innerFilter = new FilterInfo();
            innerFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            innerFilter.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.IS));
            innerFilter.setMaskString("#0 or #1");
            filter.mergeFilter(innerFilter, "and");
        }
        return filter;
    }

    public FilterInfo getProductCodeFilter(String companyId, String customerId) throws EASBizException, BOSException {
        FilterInfo innerFilter;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("isVehicle", (Object)true, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        if (!StringUtils.isEmpty((String)companyId)) {
            innerFilter = new FilterInfo();
            innerFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)companyId, CompareType.EQUALS));
            innerFilter.getFilterItems().add(new FilterItemInfo("company.id", null, CompareType.IS));
            innerFilter.setMaskString("#0 or #1");
            filter.mergeFilter(innerFilter, "and");
        }
        if (!StringUtils.isEmpty((String)customerId)) {
            innerFilter = new FilterInfo();
            innerFilter.getFilterItems().add(new FilterItemInfo("customer.id", (Object)customerId, CompareType.EQUALS));
            innerFilter.getFilterItems().add(new FilterItemInfo("customer.id", null, CompareType.IS));
            innerFilter.setMaskString("#0 or #1");
            filter.mergeFilter(innerFilter, "and");
        }
        return filter;
    }

    public FilterInfo getTaxClassificationCodeFilter() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        String vehicleName = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"Vehicle");
        filter.getFilterItems().add(new FilterItemInfo("simpleName", (Object)vehicleName, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("isLeaf", (Object)true, CompareType.EQUALS));
        return filter;
    }
}

