/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.syncUI.MonitorInfo;
import com.kingdee.bos.appframework.syncUI.SwingWorker;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONArray;
import com.kingdee.bos.json.JSONException;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.permission.client.util.PermissionHelper;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ar.OtherBillInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreBillEditUI;
import com.kingdee.eas.framework.client.CoreBillListUI;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.tm.common.TMException;
import com.kingdee.eas.tm.im.CombinRuleSettingFactory;
import com.kingdee.eas.tm.im.CombinRuleSettingInfo;
import com.kingdee.eas.tm.im.IMInvoiceFacadeFactory;
import com.kingdee.eas.tm.im.IMakeInvoice;
import com.kingdee.eas.tm.im.InvoiceRespInfo;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.MakeInvoiceParam;
import com.kingdee.eas.tm.im.MakeInvoiceReqInfo;
import com.kingdee.eas.tm.im.PwyServiceType;
import com.kingdee.eas.tm.im.client.MySwingWork;
import com.kingdee.eas.tm.im.client.MyThreadPool;
import com.kingdee.eas.tm.im.client.RuleItem;
import com.kingdee.eas.tm.im.client.SelectCombinRuleSchemeUI;
import com.kingdee.eas.tm.im.client.comp.MakeVolumnInvoiceClientService;
import com.kingdee.eas.tm.im.client.util.IMClientUtils;
import com.kingdee.eas.tm.im.common.comm.TransSrcSystemEnum;
import com.kingdee.eas.tm.im.common.comm.model.PwyInvokeParam;
import com.kingdee.eas.tm.im.common.comm.service.makeinvoice.MakeInvoicePwyService;
import com.kingdee.eas.tm.im.common.comm.service.util.PwyServiceHelper;
import com.kingdee.eas.tm.im.common.constant.IMConstant;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.util.LogUtils;
import com.kingdee.eas.tm.im.util.invoice.interfaces.IMakeInvoiceClientService;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class MakeInvoiceClientService
implements IMakeInvoiceClientService {
    private int invoicePercent = 0;

    @Override
    public Map doMakeInvoice(Map params) throws EASBizException, BOSException {
        int retValue;
        this.invoicePercent = 10;
        CoreBillListUI listUI = (CoreBillListUI)params.get("listUI");
        String[] ids = (String[])params.get("ids");
        ActionEvent e = (ActionEvent)params.get("e");
        boolean isReq = (Boolean)params.get("isReq");
        int invoiceType = (Integer)params.get("invoiceType");
        boolean isVolMake = false;
        if (params.get("isVolMake") != null) {
            isVolMake = (Boolean)params.get("isVolMake");
        }
        HashMap ret = new HashMap();
        if (ids == null || ids.length == 0 || listUI == null) {
            return ret;
        }
        try {
            IMInvoiceFacadeFactory.getRemoteInstance().checkIMKLicense();
        }
        catch (TMException e1) {
            String errorMsg = e1.getMessage();
            if (StringUtils.isEmpty((String)errorMsg)) {
                throw e1;
            }
            String[] errorArr = errorMsg.split("\r\n");
            if (errorArr.length <= 1) {
                throw e1;
            }
            StringBuffer sb = new StringBuffer();
            int length = errorArr.length;
            for (int i = 1; i < length; ++i) {
                sb.append(errorArr[i]).append("\r\n");
            }
            MsgBox.showDetailAndOK((Component)listUI, (String)errorArr[0], (String)sb.toString(), (int)0);
            return ret;
        }
        List<String> idList = Arrays.asList(ids);
        Set orgPKSet = new HashSet();
        orgPKSet = this.getOrgPKSet((CoreUI)listUI, idList);
        if (isReq) {
            this.checkFunctionPermission((CoreUI)listUI, orgPKSet, "fi_ar_ArOtherBill_Invoiced");
        } else {
            this.checkFunctionPermission((CoreUI)listUI, orgPKSet, "fi_ar_ArOtherBill_oneKeyInvoice");
        }
        if (params.get("companyIds") != null) {
            HashSet companyIds = (HashSet)params.get("companyIds");
            for (String companyId : companyIds) {
                Map paramMap = IMUtils.getParam(null, companyId, new String[]{"VATM015"});
                int goldenTaxControl = IMUtils.getIntegerValue((String)paramMap.get("VATM015"));
                if (goldenTaxControl == 0) continue;
                String msg = IMUtils.getString("com.kingdee.eas.tm.im.MakeVolumnInvoiceResource", "MSG_PARAMBEHANGXIN", IMUtils.getLocale());
                MsgBox.showWarning((Component)listUI, (String)msg);
                return ret;
            }
        }
        if ((retValue = MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"TO_MAKEINVOICE"))) == 2) {
            return ret;
        }
        HashMap<String, String> ruleIDs = new HashMap<String, String>();
        Map<String, Boolean> otherParams = new HashMap<String, Boolean>();
        EntityViewInfo srcview = new EntityViewInfo();
        FilterInfo srcfilter = new FilterInfo();
        srcview.setFilter(srcfilter);
        srcfilter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)"FC910EF3", CompareType.EQUALS));
        srcfilter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        CoreBaseCollection srcCombinRuleColl = CombinRuleSettingFactory.getRemoteInstance().getCollection(srcview);
        EntityViewInfo destview = new EntityViewInfo();
        FilterInfo destfilter = new FilterInfo();
        destview.setFilter(destfilter);
        destfilter.getFilterItems().add(new FilterItemInfo("billBosType", (Object)"412A6F98", CompareType.EQUALS));
        destfilter.getFilterItems().add(new FilterItemInfo("status", (Object)0, CompareType.EQUALS));
        CoreBaseCollection destCombinRuleColl = CombinRuleSettingFactory.getRemoteInstance().getCollection(destview);
        if (srcCombinRuleColl.size() <= 1 && destCombinRuleColl.size() <= 1) {
            CombinRuleSettingInfo destCombinRule;
            CombinRuleSettingInfo srcCombinRule;
            if (srcCombinRuleColl.size() > 0 && (srcCombinRule = (CombinRuleSettingInfo)srcCombinRuleColl.get(0)) != null) {
                ruleIDs.put("srcRuleID", srcCombinRule.getId().toString());
            }
            if (destCombinRuleColl.size() > 0 && (destCombinRule = (CombinRuleSettingInfo)destCombinRuleColl.get(0)) != null) {
                ruleIDs.put("destRuleID", destCombinRule.getId().toString());
            }
            otherParams.put("isConstantQty", false);
        } else {
            CommonQueryDialog downloadQueryDialog = IMClientUtils.showCombinRuleSchemeDialog((CoreUI)listUI, (String)"com.kingdee.eas.fi.ar.client.OtherBillListUI", (String)"FC910EF3", (String)"412A6F98", (boolean)true);
            SelectCombinRuleSchemeUI ruleSchemeUI = (SelectCombinRuleSchemeUI)downloadQueryDialog.getUserPanel(0);
            if (!ruleSchemeUI.getIsComfirm()) {
                return ret;
            }
            RuleItem srcItem = ruleSchemeUI.getSrcRule();
            RuleItem destItem = ruleSchemeUI.getDestRule();
            if (srcItem != null) {
                ruleIDs.put("srcRuleID", ruleSchemeUI.getSrcRule().getId());
            }
            if (destItem != null) {
                ruleIDs.put("destRuleID", ruleSchemeUI.getDestRule().getId());
            }
            otherParams = ruleSchemeUI.getOtherParams();
        }
        StringBuffer paramID = new StringBuffer();
        for (int i = 0; i < ids.length; ++i) {
            paramID.append(ids[i]).append(",");
        }
        MakeInvoiceParam param = new MakeInvoiceParam();
        param.setBilBillIds(paramID.toString());
        param.setInvoiceType(invoiceType + "");
        param.setPrint(false);
        param.setReq(isReq);
        param.setRuleIDs(ruleIDs);
        param.setSrcBosType("FC910EF3");
        param.setSrcSystem(IMConstant.SRCTYPE_FI_AR);
        param.setVolMake(isVolMake);
        param.setActionSystem("GUI");
        param.setOtherParams(otherParams);
        this.doInDeamon((CoreUI)listUI, e, isReq, invoiceType, ids.length, param);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map doInvoicePrint(Map params) throws EASBizException, BOSException, JSONException {
        HashMap ret = new HashMap();
        CoreUI comp = (CoreUI)params.get("coreUI");
        ArrayList ids = (ArrayList)params.get("ids");
        boolean isPrintList = (Boolean)params.get("isPrintList");
        boolean isRePrint = (Boolean)params.get("isRePrint");
        String sourceType = (String)params.get("sourceType");
        if (ids == null || ids.isEmpty() || comp == null) {
            return ret;
        }
        try {
            IMUtils.tryLock(ids);
            this.printInvoice(comp, ids, isPrintList, sourceType, isRePrint);
        }
        catch (EASBizException e) {
            MsgBox.showInfo((String)e.getMessage());
        }
        finally {
            IMUtils.releaseLock(ids);
        }
        return ret;
    }

    private void doInDeamon(final CoreUI coreUI, final ActionEvent e, final boolean isReq, final int invoiceType, final int billSize, final MakeInvoiceParam param) throws BOSException {
        KDMenuItem source;
        String parentTxt = "";
        this.invoicePercent = 10;
        MonitorInfo temp = null;
        if (e.getSource() instanceof KDMenuItem) {
            source = (KDMenuItem)e.getSource();
            if (source.getParent() instanceof KDPopupMenu) {
                KDPopupMenu parent = (KDPopupMenu)source.getParent();
                KDWorkButton button = (KDWorkButton)parent.getInvoker();
                parentTxt = button.getText();
            }
            temp = new MonitorInfo(parentTxt + "-->" + source.getText(), null, (Object)this, true);
        } else if (e.getSource() instanceof KDWorkButton) {
            source = (KDWorkButton)e.getSource();
            String invoiceName = null;
            if (invoiceType == 1) {
                invoiceName = PayInvoiceTypeEnum.VALUEADDEDTAXINV.getAlias();
            } else if (invoiceType == 2) {
                invoiceName = PayInvoiceTypeEnum.COMMONINVOICE.getAlias();
            } else if (invoiceType == 3) {
                invoiceName = PayInvoiceTypeEnum.ELECTRONICINVOICE.getAlias();
            } else if (invoiceType == 4) {
                invoiceName = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.getAlias();
            } else if (invoiceType == 5) {
                invoiceName = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE.getAlias();
            } else if (invoiceType == 6) {
                invoiceName = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE.getAlias();
            }
            temp = new MonitorInfo(source.getText() + "-->" + invoiceName, null, (Object)this, true);
        } else {
            throw new BOSException("com.kingdee.eas.tm.im.util.invoice.MakeInvoiceClientService.doInDeamon\uff1ae.getSource() involid!");
        }
        final MonitorInfo info = temp;
        MySwingWork worker = new MySwingWork(){

            public Object construct() {
                try {
                    MakeInvoiceClientService.this.innerMakeInvoiceWithLock(coreUI, isReq, invoiceType, billSize, param);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (coreUI instanceof CoreBillListUI) {
                                    ((CoreBillListUI)coreUI).actionRefresh_actionPerformed(e);
                                }
                            }
                            catch (Exception e1) {
                                coreUI.handUIException((Throwable)e1);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    coreUI.handUIException((Throwable)ex);
                }
                catch (Throwable ex) {
                    coreUI.handUIException(ex);
                }
                return null;
            }

            public void finished() {
                this.timerStop();
                MyThreadPool.destroyMonitor((MonitorInfo)info);
                MyThreadPool.destroyPorgressDialog();
            }

            public void refreshProgress() {
                MyThreadPool.refreshProgress((int)MakeInvoiceClientService.this.invoicePercent);
            }
        };
        info.setWorker((SwingWorker)worker);
        MyThreadPool.getInstance();
        MyThreadPool.addActionThread((MonitorInfo)info);
        MyThreadPool.setBackgroundRunButtonEnabled((boolean)false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerMakeInvoiceWithLock(CoreUI coreUI, boolean isReq, int invoiceType, int billSize, MakeInvoiceParam param) throws BOSException, EASBizException, JSONException {
        String[] ids = param.getBilBillIds().split(",");
        List<String> idList = Arrays.asList(ids);
        try {
            IMUtils.tryLock(idList);
            this.innerMakeInvoice(coreUI, isReq, invoiceType, billSize, param);
        }
        catch (EASBizException e) {
            MsgBox.showInfo((String)e.getMessage());
        }
        finally {
            IMUtils.releaseLock(idList);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerMakeInvoice(CoreUI coreUI, boolean isReq, int invoiceType, int billSize, MakeInvoiceParam param) throws BOSException, EASBizException, JSONException {
        InvoiceRespInfo resp = IMInvoiceFacadeFactory.getRemoteInstance().makeInvoice(param);
        String errorMsg = resp.getErrorMsg();
        ArrayList mkBillIds = resp.getMkSucessBillIds();
        ArrayList mkfailBills = resp.getMkFailBills();
        ArrayList arFailBills = resp.getBizFailBills();
        if (mkBillIds.isEmpty() && errorMsg.length() > 0 && !errorMsg.equals("null\r\n")) {
            if (isReq) {
                String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MKINVOICE_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size()});
                this.handShowDetailAndOK(coreUI, resp, errorMsg, msg);
            } else {
                String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MKINVOICE_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size(), mkBillIds.size(), mkfailBills.size()});
                this.handShowDetailAndOK(coreUI, resp, errorMsg, msg);
            }
            return;
        }
        StringBuffer mkmsg = new StringBuffer();
        PwyServiceType serviceType = PwyServiceType.OPR_INV_PAPER_MAKE;
        if (invoiceType == 3 || invoiceType == 5 || invoiceType == 6) {
            serviceType = PwyServiceType.OPR_INV_DISKELECT_MAKE;
        }
        if (isReq) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"MKINVOICE_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size()});
            this.handShowDetailAndOK(coreUI, resp, errorMsg, msg);
        } else if (mkBillIds.size() == 0) {
            String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MKINVOICE_MSG", (Object[])new Object[]{0, billSize, mkBillIds.size(), mkfailBills.size()});
            this.handShowDetailAndOK(coreUI, resp, mkmsg.toString(), msg);
        } else {
            try {
                IMUtils.tryLock(mkBillIds);
                if (param.isVolMake()) {
                    HashMap<String, Object> msgParam = new HashMap<String, Object>();
                    msgParam.put("billSize", billSize);
                    msgParam.put("fromSrc", IMConstant.SRCTYPE_FI_AR);
                    msgParam.put("mkBillIds", mkBillIds);
                    msgParam.put("mkfailBills", mkfailBills);
                    msgParam.put("srcFailBills", arFailBills);
                    msgParam.put("respErrorMsg", resp.getErrorMsg());
                    MakeVolumnInvoiceClientService service = new MakeVolumnInvoiceClientService(coreUI, msgParam);
                    service.invoice(mkBillIds);
                } else {
                    this.doMakeInvoiceRequest(coreUI, billSize, resp, mkBillIds, mkfailBills, arFailBills, mkmsg, serviceType);
                }
            }
            finally {
                IMUtils.releaseLock(mkBillIds);
            }
        }
    }

    protected void doMakeInvoiceRequest(CoreUI coreUI, int billSize, InvoiceRespInfo resp, ArrayList mkBillIds, ArrayList mkfailBills, ArrayList arFailBills, StringBuffer mkmsg, PwyServiceType serviceType) throws BOSException, EASBizException {
        ArrayList list = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyParam(mkBillIds, serviceType, TransSrcSystemEnum.easgui);
        int total = mkBillIds.size() + mkfailBills.size();
        int sucess = 0;
        BigDecimal a = new BigDecimal(90);
        BigDecimal b = new BigDecimal(list.size());
        BigDecimal c = BigDecimal.ZERO;
        if (list.size() > 0) {
            c = a.divide(b, 2, RoundingMode.HALF_UP);
        }
        for (int i = 0; i < list.size(); ++i) {
            this.invoicePercent = 10 + c.multiply(new BigDecimal(i)).intValue();
            Map resultMap = (Map)list.get(i);
            if (resultMap.get("error") != null) {
                String id = resultMap.get("error").toString();
                if (id.equals("exception")) {
                    mkmsg.append(resultMap.get("exception") + "\r\n");
                    continue;
                }
                mkmsg.append(resultMap.get("number") + ":" + resultMap.get(id) + "\r\n");
                continue;
            }
            String invoiceNum = (String)resultMap.get("number");
            PwyInvokeParam invokeParam = (PwyInvokeParam)resultMap.get("invokeParam");
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (pwyService.isSuccess()) {
                ++sucess;
                continue;
            }
            mkmsg.append(invoiceNum + ":" + pwyService.getInvokeParam().getDescription() + "\r\n");
        }
        String msg = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"ALL_MKINVOICE_MSG", (Object[])new Object[]{billSize - arFailBills.size(), arFailBills.size(), sucess, total - sucess});
        this.handShowDetailAndOK(coreUI, resp, mkmsg.toString(), msg);
    }

    private void handShowDetailAndOK(CoreUI coreUI, InvoiceRespInfo resp, String errorMsg, String msg) {
        final CoreUI ownerUI = coreUI;
        final String showMsg = msg;
        final String detailMsg = resp.getErrorMsg() != null && !resp.getErrorMsg().isEmpty() && !errorMsg.equals("null\r\n") ? resp.getErrorMsg() : errorMsg;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MsgBox.showDetailAndOK((Component)ownerUI, (String)showMsg, (String)detailMsg, (int)1);
            }
        });
    }

    public void afterMakeInvoice(String invoiceID, String pwyRetvalue, int invoiceType) throws JSONException, EASBizException, BOSException {
        JSONObject value = new JSONObject(pwyRetvalue);
        JSONArray list = value.getJSONArray("lists");
        JSONObject invoiceJson = list.getJSONObject(0);
        String invoiceNo = invoiceJson.getString("fphm");
        String invoiceNum = invoiceJson.getString("fpdm");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("invoiceNo", invoiceNo);
        param.put("invoiceNum", invoiceNum);
        param.put("invoiceType", (String)this.getInvoiceType(invoiceType));
        MakeInvoiceFactory.getRemoteInstance().make((IObjectPK)new ObjectUuidPK(invoiceID), param);
    }

    private PayInvoiceTypeEnum getInvoiceType(int invoiceType) {
        PayInvoiceTypeEnum actionInvoiceType = PayInvoiceTypeEnum.DEFAULTTYPE;
        if (invoiceType == 1) {
            actionInvoiceType = PayInvoiceTypeEnum.VALUEADDEDTAXINV;
        } else if (invoiceType == 2) {
            actionInvoiceType = PayInvoiceTypeEnum.COMMONINVOICE;
        } else if (invoiceType == 3) {
            actionInvoiceType = PayInvoiceTypeEnum.ELECTRONICINVOICE;
        } else if (invoiceType == 4) {
            actionInvoiceType = PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE;
        } else if (invoiceType == 5) {
            actionInvoiceType = PayInvoiceTypeEnum.DIGITALELECTRICITYINVOICE;
        } else if (invoiceType == 6) {
            actionInvoiceType = PayInvoiceTypeEnum.DIGITALELECTRICITYSPECIALINVOICE;
        }
        return actionInvoiceType;
    }

    public void afterMakeInvoice4Elec(String invoiceID, String pwyRetvalue, int invoiceType) throws JSONException, EASBizException, BOSException {
        JSONObject value = new JSONObject(pwyRetvalue);
        JSONObject invoiceJson = value.getJSONObject("data");
        String invoiceNo = invoiceJson.getString("invoicenum");
        String invoiceNum = invoiceJson.getString("invoicecode");
        String pdfurl = invoiceJson.getString("pdfurl");
        String sn = invoiceJson.getString("serialnum");
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("invoiceNo", invoiceNo);
        param.put("invoiceNum", invoiceNum);
        param.put("pdfurl", pdfurl);
        param.put("sn", sn);
        MakeInvoiceFactory.getRemoteInstance().make((IObjectPK)new ObjectUuidPK(invoiceID), param);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printInvoice(CoreUI comp, ArrayList ids, boolean isPrintList, String sourceType, boolean isRePrint) throws EASBizException, BOSException, JSONException {
        String msg;
        if (ids == null || ids.isEmpty()) {
            return;
        }
        ArrayList invocieIds = IMInvoiceFacadeFactory.getRemoteInstance().getInvoiceID(ids);
        HashSet invoiceId = new HashSet();
        for (int i = 0; i < invocieIds.size(); ++i) {
            invoiceId.add(invocieIds.get(i));
        }
        Map retValue = new HashMap();
        String operName = "";
        String printList_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintList", IMUtils.getLocale());
        String printInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintInvoice", IMUtils.getLocale());
        String rePrintInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "RePrintInvoice", IMUtils.getLocale());
        if (isPrintList) {
            retValue = IMInvoiceFacadeFactory.getRemoteInstance().checkBeforePrintList(invoiceId);
            operName = printList_alias;
        } else if (isRePrint) {
            retValue = IMInvoiceFacadeFactory.getRemoteInstance().checkBeforeRePrint(invoiceId);
            operName = rePrintInvoice_alias;
        } else {
            retValue = IMInvoiceFacadeFactory.getRemoteInstance().checkBeforePrint(invoiceId);
            operName = printInvoice_alias;
        }
        if (retValue.get("errorMsg") != null) {
            String msg2 = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"PRINT_ERROR");
            MsgBox.showDetailAndOK((Component)comp, (String)msg2, (String)retValue.get("errorMsg").toString(), (int)1);
            return;
        }
        if (retValue.get("successMsg") != null && !this.confirmDialog(comp, msg = retValue.get("successMsg") + "\n" + IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "ConfirmContinue", IMUtils.getLocale()) + operName + "\uff1f")) {
            return;
        }
        ArrayList orderIds = null;
        orderIds = isPrintList ? this.getMKBillOrderIds(invoiceId) : (ArrayList)retValue.get("orderIds");
        try {
            IMUtils.tryLock(ids);
            this.doPrintRequest(comp, isPrintList, isRePrint, printList_alias, printInvoice_alias, rePrintInvoice_alias, orderIds);
        }
        finally {
            IMUtils.releaseLock(ids);
        }
    }

    protected void doPrintRequest(CoreUI comp, boolean isPrintList, boolean isRePrint, String printList_alias, String printInvoice_alias, String rePrintInvoice_alias, ArrayList orderIds) throws BOSException, EASBizException {
        ArrayList retArray;
        String operName;
        if (isPrintList) {
            operName = printList_alias;
            retArray = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyPrintListParam(orderIds, TransSrcSystemEnum.easgui);
        } else {
            operName = isRePrint ? rePrintInvoice_alias : printInvoice_alias;
            retArray = IMInvoiceFacadeFactory.getRemoteInstance().buildPwyPrintParam(orderIds, TransSrcSystemEnum.easgui);
        }
        StringBuffer msg = new StringBuffer();
        int sucessCount = 0;
        for (int i = 0; i < retArray.size(); ++i) {
            HashMap map = (HashMap)retArray.get(i);
            MakeInvoiceInfo info = (MakeInvoiceInfo)map.get("info");
            IObjectPK logPk = this.beginLog(info, operName);
            String invoiceNum = (String)map.get("number");
            PwyInvokeParam invokeParam = (PwyInvokeParam)map.get("invokeParam");
            MakeInvoicePwyService pwyService = (MakeInvoicePwyService)PwyServiceHelper.getPwyService(null, invokeParam);
            pwyService.invoke();
            if (!pwyService.isSuccess()) {
                msg.append(invoiceNum).append(" : ").append(pwyService.getInvokeParam().getDescription()).append("\r\n");
                continue;
            }
            ++sucessCount;
            LogUtils.afterLog(null, logPk);
        }
        if (msg.length() > 0) {
            String printError = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"PRINTINVOICE_MSG", (Object[])new Object[]{sucessCount, retArray.size() - sucessCount});
            if (isPrintList) {
                printError = EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"PRINTINVOICELIST_MSG", (Object[])new Object[]{sucessCount, retArray.size() - sucessCount});
            }
            MsgBox.showDetailAndOK((Component)comp, (String)printError, (String)msg.toString(), (int)1);
        } else {
            String printSucess = EASResource.getString((String)"com.kingdee.eas.tm.im.IMResource", (String)"PRINT_SUCESS");
            MsgBox.showInfo((String)printSucess);
        }
    }

    protected final boolean confirmDialog(CoreUI comp, String msg) {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)comp, (String)msg));
    }

    private void checkFunctionPermission(CoreUI comp, Set orgPKSet, String permItemName) throws BOSException, EASBizException {
        String bizOrgId = null;
        Iterator iter = orgPKSet.iterator();
        ObjectUuidPK orgPK = null;
        IObjectPK userPK = (IObjectPK)comp.getServiceContext4Dyn().get("USER.PK");
        while (iter.hasNext()) {
            bizOrgId = (String)iter.next();
            orgPK = new ObjectUuidPK(bizOrgId);
            PermissionHelper.checkFunctionPermission((IObjectPK)userPK, (IObjectPK)orgPK, (String)permItemName);
        }
    }

    private Set getOrgPKSet(CoreUI comp, List idList) {
        HashSet ids = new HashSet(idList);
        if (ids.size() == 0) {
            return new HashSet();
        }
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
        ev.setFilter(filter);
        ICoreBase iCoreBase = null;
        CoreBaseCollection coll = null;
        try {
            if (comp instanceof CoreBillListUI) {
                iCoreBase = ((CoreBillListUI)comp).getBillInterface();
            } else if (comp instanceof CoreBillEditUI) {
                iCoreBase = ((CoreBillEditUI)comp).getBillInterface();
            }
            if (iCoreBase != null) {
                coll = iCoreBase.getCollection(ev);
            }
        }
        catch (Exception e) {
            comp.handUIException((Throwable)e);
        }
        HashSet<String> orgPKSet = new HashSet<String>();
        String bizOrgId = null;
        if (coll != null) {
            for (int i = 0; i < coll.size(); ++i) {
                Object coreInfo;
                CompanyOrgUnitInfo value = null;
                if (coll.get(i) instanceof OtherBillInfo) {
                    coreInfo = (OtherBillInfo)coll.get(i);
                    value = coreInfo.getCompany();
                    bizOrgId = value.get("id").toString();
                } else if (coll.get(i) instanceof MakeInvoiceReqInfo) {
                    coreInfo = (MakeInvoiceReqInfo)coll.get(i);
                    value = coreInfo.getCompany();
                    bizOrgId = value.get("id").toString();
                }
                orgPKSet.add(bizOrgId);
            }
        }
        return orgPKSet;
    }

    public void afterPrintInvoice(ArrayList ids) throws EASBizException, BOSException {
        for (int i = 0; i < ids.size(); ++i) {
            String billID = (String)ids.get(i);
            MakeInvoiceFactory.getRemoteInstance().updateIsPrint(billID, null);
        }
    }

    private IObjectPK beginLog(MakeInvoiceInfo info, String opType) {
        String methodName = "";
        String logItemName = "";
        String logDetail = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "LogDetail", IMUtils.getLocale(), new Object[]{info.getInvoiceNo(), info.getInvoiceNumber()});
        String printList_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintList", IMUtils.getLocale());
        String printInvoice_alias = IMUtils.getString("com.kingdee.eas.tm.im.MakeInvoiceResource", "PrintInvoice", IMUtils.getLocale());
        if (opType.equals(printList_alias)) {
            methodName = "printList";
            logItemName = "im_mkInvoice_printInvoiceList";
        } else if (opType.equals(printInvoice_alias)) {
            methodName = "printInvoice";
            logItemName = "im_mkInvoice_printInvoice";
        }
        IObjectPK logPk = LogUtils.beginLog(null, methodName, BOSObjectType.create((String)"412A6F98"), (IObjectPK)new ObjectUuidPK(info.getId().toString()), logDetail, logItemName, "");
        return logPk;
    }

    private ArrayList getMKBillOrderIds(Set invoiceId) throws BOSException {
        ArrayList<String> orderIds = new ArrayList<String>();
        IMakeInvoice iMkInvoice = MakeInvoiceFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)invoiceId, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("invoiceNumber"));
        sic.add(new SelectorItemInfo("invoiceNo"));
        view.setSelector(sic);
        SorterItemCollection sorterColl = new SorterItemCollection();
        sorterColl.add(new SorterItemInfo("invoiceNo"));
        view.setSorter(sorterColl);
        MakeInvoiceCollection mkInvoiceCol = iMkInvoice.getMakeInvoiceCollection(view);
        for (int i = 0; i < mkInvoiceCol.size(); ++i) {
            orderIds.add(mkInvoiceCol.get(i).getId().toString());
        }
        return orderIds;
    }
}

