/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.invoice;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.json.JSONObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.tm.common.invoicePool.BizBillTypeInfo;
import com.kingdee.eas.tm.common.invoicePool.TMSourceType;
import com.kingdee.eas.tm.common.invoicePool.utils.CreateInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceParams;
import com.kingdee.eas.tm.common.invoicePool.utils.DownloadInvoiceType;
import com.kingdee.eas.tm.common.logger.TMLoggerFactory;
import com.kingdee.eas.tm.common.logger.TMTraceLogger;
import com.kingdee.eas.tm.common.utils.TMDBMutexHelper;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceFactory;
import com.kingdee.eas.tm.im.IncomeInvoiceInfo;
import com.kingdee.eas.tm.im.InvResourceType;
import com.kingdee.eas.tm.im.app.service.PoolSync4ExpenseService;
import com.kingdee.eas.tm.im.common.comm.msg.parser.IncomeInvoiceDiskParser;
import com.kingdee.eas.tm.im.common.comm.msg.parser.IncomeInvoiceParser;
import com.kingdee.eas.tm.im.common.comm.service.util.IncomeInvoicePwyHelper;
import com.kingdee.eas.tm.im.param.InvoiceHelperParam;
import com.kingdee.util.StringUtils;
import java.util.Map;

public class PoolServerService {
    private static TMTraceLogger logger = TMLoggerFactory.getTraceLogger((String)"PoolServerService");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String saveIncomeInvoice(Context ctx, CreateInvoiceParams params, JSONObject jsonObject) throws BOSException {
        boolean lock;
        String mutex;
        String id;
        block20: {
            block21: {
                String string;
                block18: {
                    block19: {
                        String string2;
                        block16: {
                            block17: {
                                id = null;
                                mutex = null;
                                lock = false;
                                try {
                                    logger.debug((Object)("saveIncomeInvoice params : " + params.toString()));
                                    IncomeInvoiceParser parser = new IncomeInvoiceParser(ctx, jsonObject);
                                    mutex = parser.getMutex();
                                    lock = TMDBMutexHelper.requestDBMutex((Context)ctx, (String)mutex);
                                    if (!lock) {
                                        string2 = null;
                                        if (!lock) break block16;
                                        break block17;
                                    }
                                    IncomeInvoiceInfo invoice = parser.getIncomeInvoiceInfo();
                                    if (invoice == null) {
                                        logger.error((Object)"saveIncomeInvoice invoice is null.");
                                        string = null;
                                        if (!lock) break block18;
                                        break block19;
                                    }
                                    String serialNo = invoice.getSerialNo();
                                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                                    if (params.containsKey((Object)"entryIDs")) {
                                        String entryID = (String)((Map)params.get((Object)"entryIDs")).get(serialNo);
                                        String companyID = (String)((Map)params.get((Object)"companyIDs")).get(serialNo);
                                        invoice.setBizBillEntryID(entryID);
                                        company.setId(BOSUuid.read((String)companyID));
                                    } else {
                                        company.setId(BOSUuid.read((String)params.getCompanyID()));
                                    }
                                    parser.handleCompany(invoice, company);
                                    invoice.setBizBillID(params.getBizBillID());
                                    invoice.setBizBillNumber(params.getBillNumber());
                                    if (params.getBizBillTypeID() != null && !params.getBizBillTypeID().isEmpty()) {
                                        BizBillTypeInfo bizBill = new BizBillTypeInfo();
                                        bizBill.setId(BOSUuid.read((String)params.getBizBillTypeID()));
                                        invoice.setBizBillType(bizBill);
                                    }
                                    if (TMSourceType.PWYDOWNLOAD.equals((Object)params.getSourceType())) {
                                        invoice.setResourceType(InvResourceType.INV_DOWNLOAD);
                                    } else {
                                        invoice.setResourceType(InvResourceType.INV_OCR);
                                    }
                                    ctx.put((Object)"disablePermissionForKScript", (Object)true);
                                    ctx.put((Object)"isFromCPBC", (Object)true);
                                    IObjectPK pk = IncomeInvoiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)invoice);
                                    if (pk != null) {
                                        id = pk.toString();
                                    }
                                    params.put((Object)"model", (Object)invoice);
                                    if (!lock) break block20;
                                    break block21;
                                }
                                catch (Exception e) {
                                    logger.error(e.getMessage(), (Throwable)e);
                                    return id;
                                }
                            }
                            TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                            lock = false;
                        }
                        ctx.remove((Object)"disablePermissionForKScript");
                        ctx.remove((Object)"isFromCPBC");
                        return string2;
                    }
                    TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
                    lock = false;
                }
                ctx.remove((Object)"disablePermissionForKScript");
                ctx.remove((Object)"isFromCPBC");
                return string;
            }
            TMDBMutexHelper.releaseDBMutex((Context)ctx, (String)mutex);
            lock = false;
        }
        ctx.remove((Object)"disablePermissionForKScript");
        ctx.remove((Object)"isFromCPBC");
        return id;
        finally {
            if (lock) {
                TMDBMutexHelper.releaseDBMutex((Context)ctx, mutex);
                lock = false;
            }
            ctx.remove((Object)"disablePermissionForKScript");
            ctx.remove((Object)"isFromCPBC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectValue saveWebDownloadInvoice(Context ctx, DownloadInvoiceParams params, JSONObject jsonObject) {
        IncomeInvoiceInfo invoiceInfo = null;
        try {
            String operation;
            IncomeInvoiceParser parser = new IncomeInvoiceParser(ctx, jsonObject);
            invoiceInfo = parser.getIncomeInvoiceInfo();
            if (invoiceInfo == null) {
                logger.error((Object)"saveIncomeInvoice invoice is null.");
                IObjectValue iObjectValue = null;
                return iObjectValue;
            }
            if (params.getSrcType() == DownloadInvoiceType.ADD) {
                invoiceInfo.setBatchNo((String)params.get((Object)"batchNo"));
            }
            if (InvoiceHelperParam.OPR_DOWNLOAD.equals(operation = (String)params.get((Object)"operation")) || "apDownload".equals(operation)) {
                if (!StringUtils.isEmpty((String)params.getCompanyId())) {
                    CompanyOrgUnitInfo company = new CompanyOrgUnitInfo();
                    company.setId(BOSUuid.read((String)params.getCompanyId()));
                    parser.handleCompany(invoiceInfo, company);
                }
            } else {
                IncomeInvoicePwyHelper.handleCompany(ctx, invoiceInfo, params.getCompanyMap());
            }
            IncomeInvoicePwyHelper.handleSupplier(ctx, invoiceInfo);
            invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
            invoiceInfo.setCurrentAccountType(CurrentAccountType.SUPPLIER);
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            IncomeInvoiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)invoiceInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
        return invoiceInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IObjectValue saveDiskDownloadInvoice(Context ctx, DownloadInvoiceParams params, JSONObject jsonObject) {
        IncomeInvoiceInfo invoiceInfo = null;
        try {
            IncomeInvoiceDiskParser parser = new IncomeInvoiceDiskParser(ctx, jsonObject);
            invoiceInfo = parser.getIncomeInvoiceInfo();
            if (invoiceInfo == null) {
                logger.error((Object)"saveIncomeInvoice invoice is null.");
                IObjectValue iObjectValue = null;
                return iObjectValue;
            }
            IncomeInvoicePwyHelper.handleCompany(ctx, invoiceInfo, params.getCompanyMap());
            IncomeInvoicePwyHelper.handleSupplier(ctx, invoiceInfo);
            invoiceInfo.setResourceType(InvResourceType.INV_DOWNLOAD);
            invoiceInfo.setCurrentAccountType(CurrentAccountType.SUPPLIER);
            ctx.put((Object)"disablePermissionForKScript", (Object)true);
            IncomeInvoiceFactory.getLocalInstance(ctx).save((CoreBaseInfo)invoiceInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            ctx.remove((Object)"disablePermissionForKScript");
        }
        return invoiceInfo;
    }

    public static void updateVoucherInfo(Map params) throws Exception {
        boolean isUpdateBizVoucher2AWSFPY = false;
        try {
            Context ctx = (Context)params.get("ctx");
            Map imTempParams = IMFacadeFactory.getLocalInstance(ctx).getIMTempParamByKey(new String[]{"isUpdateBizVoucher2AWSFPY"});
            if (imTempParams != null && imTempParams.get("isUpdateBizVoucher2AWSFPY") != null && "1".equals((String)imTempParams.get("isUpdateBizVoucher2AWSFPY"))) {
                isUpdateBizVoucher2AWSFPY = true;
            }
        }
        catch (Throwable e) {
            logger.error(e.getMessage(), e);
        }
        if (isUpdateBizVoucher2AWSFPY) {
            new PoolSync4ExpenseService().updateVoucherInfo(params);
        }
    }
}

