/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.ofd.util;

import com.kingdee.eas.tm.im.util.ofd.CompressHelper;
import com.kingdee.eas.tm.im.util.ofd.OfdErrorType;
import com.kingdee.eas.tm.im.util.ofd.StrUtil;
import com.kingdee.eas.tm.im.util.ofd.XmlUtil;
import com.kingdee.eas.tm.im.util.ofd.config.exception.ReadException;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OfdReadUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfdReadUtil.class);

    public static Map<String, Object> extractData(byte[] fileBytes) {
        Map<String, byte[]> decompressFileMap = CompressHelper.decompress(fileBytes);
        byte[] ofdMainByte = decompressFileMap.get("OFD.xml");
        String docRootPath = OfdReadUtil.getTextByPath(ofdMainByte, "DocBody/DocRoot");
        StringBuffer dirPath = OfdReadUtil.getLastDirPath(docRootPath);
        byte[] documentByte = decompressFileMap.get(docRootPath);
        String attachmentsPath = OfdReadUtil.getTextByPath(documentByte, "Attachments");
        String path = dirPath.append(attachmentsPath).toString();
        byte[] attachmentsByte = decompressFileMap.get(path);
        String attachmentPath = OfdReadUtil.getTextByPath(attachmentsByte, "Attachment|||original_invoice/FileLoc");
        dirPath = OfdReadUtil.getLastDirPath(path).append(attachmentPath);
        byte[] invoiceByte = decompressFileMap.get(dirPath.toString());
        return OfdReadUtil.getInvoiceMap(invoiceByte);
    }

    private static Map<String, Object> getInvoiceMap(byte[] invoiceByte) {
        try {
            Document document = XmlUtil.loadXML(invoiceByte);
            String xml = document.asXML();
            return XmlUtil.Dom2Map(xml);
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, Element element, String dirPath) {
        String pagePath = dirPath + element.attributeValue("BaseLoc");
        return OfdReadUtil.getElementByByte(ofdFileMap.get(pagePath));
    }

    public static Element getElementByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        return OfdReadUtil.getElementByByte(OfdReadUtil.getByteByPath(ofdFileMap, filePath));
    }

    public static byte[] getByteByPath(Map<String, byte[]> ofdFileMap, String filePath) {
        if (filePath != null && filePath.startsWith("/")) {
            filePath = filePath.substring(1);
        }
        return ofdFileMap.get(filePath);
    }

    public static Element getElementByByte(byte[] fileByte) {
        try {
            Document document = XmlUtil.loadXML(fileByte);
            return document.getRootElement();
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.LOAD_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
            throw new ReadException(OfdErrorType.LOAD_ERROR);
        }
    }

    public static StringBuffer getLastDirPath(String path) {
        String[] pathArr;
        StringBuffer buffer = new StringBuffer();
        for (String pathStr : pathArr = path.split("/")) {
            if (pathStr == null || pathStr.trim().equals("") || pathStr.contains(".")) continue;
            buffer.append(pathStr).append("/");
        }
        return buffer;
    }

    public static String getDirPath(String path, String lastPath) {
        if (!StrUtil.isEmpty(path)) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (!StrUtil.isEmpty(lastPath) && !path.startsWith(lastPath = OfdReadUtil.getLastDirPath(lastPath).toString())) {
                path = lastPath + path;
            }
        }
        return path;
    }

    public static String getTextByPath(byte[] fileByte, String path) {
        String text;
        try {
            String[] dirArr;
            Element elementNow = OfdReadUtil.getElementByByte(fileByte);
            for (String dir : dirArr = path.split("/")) {
                String[] arr;
                boolean moreFlag = false;
                if (dir.contains("|||") && (arr = dir.split("\\|\\|\\|")) != null && arr.length == 2) {
                    List elementList = elementNow.elements(arr[0]);
                    for (Element e : elementList) {
                        if (!arr[1].equals(e.attributeValue("Name"))) continue;
                        elementNow = e;
                        moreFlag = true;
                        break;
                    }
                }
                if (moreFlag) continue;
                elementNow = elementNow.element(dir);
            }
            text = elementNow.getText();
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.EXTRACT_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
            throw new ReadException(OfdErrorType.EXTRACT_ERROR);
        }
        return text;
    }
}

