/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.ofd.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.kingdee.eas.tm.im.util.ofd.util.OfdConvertUtil;
import com.kingdee.eas.tm.im.util.ofd.util.OfdReadUtil;
import java.util.List;
import java.util.Map;

public class OfdUtil {
    public static Map<String, Object> getInvoiceMap(byte[] fileBytes) {
        return OfdReadUtil.extractData(fileBytes);
    }

    public static JSONObject getInvoiceJSON(byte[] fileBytes) {
        return JSONObject.parseObject((String)JSON.toJSONString(OfdUtil.getInvoiceMap(fileBytes)));
    }

    public static byte[] convertToSvg(byte[] fileBytes) {
        return OfdConvertUtil.convertToSvg(fileBytes);
    }

    public static byte[] convertToPng(byte[] fileBytes) throws Exception {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, 1);
    }

    public static byte[] convertToImage(byte[] fileBytes, int imageType) throws Exception {
        return OfdConvertUtil.convertToImage(fileBytes, 1.0f, imageType);
    }

    public static List<Object> convertToMulPngStr(byte[] fileBytes) throws Exception {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, 1, -1);
    }

    public static List<Object> convertToHDMulImageStr(byte[] fileBytes, float zoomScale, int imageType) throws Exception {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, -1);
    }

    public static List<Object> convertToMulImageStr(byte[] fileBytes, int imageType) throws Exception {
        return OfdConvertUtil.convertToMultImage(fileBytes, 1.0f, true, imageType, -1);
    }

    public static String convertToImageByPageNo(byte[] fileBytes, float zoomScale, int imageType, int pageNo) throws Exception {
        List<Object> list = OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, imageType, pageNo);
        String rsStr = null;
        if (list != null && !list.isEmpty()) {
            rsStr = (String)list.get(0);
        }
        return rsStr;
    }

    public static List<Object> convertToHDMulPngStr(byte[] fileBytes, float zoomScale) throws Exception {
        return OfdConvertUtil.convertToMultImage(fileBytes, zoomScale, true, 1, -1);
    }

    public static byte[] convertToPdf(byte[] fileBytes) {
        return OfdConvertUtil.convertToPdf(fileBytes);
    }

    public static byte[] convertToHDPng(byte[] fileBytes, float multipleNum) throws Exception {
        return OfdConvertUtil.convertToImage(fileBytes, multipleNum, 1);
    }

    public static byte[] convertToHDImage(byte[] fileBytes, float zoomScale, int imageType) throws Exception {
        return OfdConvertUtil.convertToImage(fileBytes, zoomScale, imageType);
    }
}

