/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.util.ofd.util;

import com.kingdee.eas.tm.im.util.ofd.Base64Util;
import com.kingdee.eas.tm.im.util.ofd.OfdErrorType;
import com.kingdee.eas.tm.im.util.ofd.XmlUtil;
import com.kingdee.eas.tm.im.util.ofd.config.exception.ConvertException;
import com.kingdee.eas.tm.im.util.ofd.util.SvgUtil;
import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.JPEGTranscoder;
import org.apache.batik.transcoder.image.PNGTranscoder;
import org.apache.batik.transcoder.image.TIFFTranscoder;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.svg.PDFTranscoder;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SVGConversionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SVGConversionUtil.class);

    public static List<String> svgSplit(String svgStr) throws Exception {
        ArrayList<String> strList = new ArrayList<String>();
        org.dom4j.Document svgDocument = XmlUtil.loadXML(svgStr);
        Element rootElement = svgDocument.getRootElement();
        List elementList = rootElement.elements("svg");
        for (int i = 0; i < elementList.size(); ++i) {
            Element elementI = (Element)elementList.get(i);
            elementI.addAttribute("version", "1.1");
            strList.add(elementI.asXML());
        }
        return strList;
    }

    public static List<Object> convertSvgBytes2MulImage(String svgStr, float zoomScale, boolean strFlag, int imageType) throws Exception {
        try {
            ArrayList<Object> imageList = new ArrayList<Object>();
            List<String> svgList = SVGConversionUtil.svgSplit(svgStr);
            for (int i = 0; i < svgList.size(); ++i) {
                String svgElementStr = svgList.get(i);
                org.dom4j.Document document = DocumentHelper.parseText((String)svgElementStr);
                String widthStr = document.getRootElement().attributeValue("width").replace("mm", "");
                String heightStr = document.getRootElement().attributeValue("height").replace("mm", "");
                float width = SvgUtil.getPxByMM(Float.parseFloat(widthStr) * zoomScale);
                float height = SvgUtil.getPxByMM(Float.parseFloat(heightStr) * zoomScale);
                byte[] svgIBytes = XmlUtil.toByteArray(document);
                try {
                    ByteArrayInputStream in = new ByteArrayInputStream(svgIBytes);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    byte[] imageBytes = SVGConversionUtil.convert2Image(in, byteArrayOutputStream, width, height, imageType);
                    if (strFlag) {
                        imageList.add(Base64Util.base64encoder(imageBytes));
                        continue;
                    }
                    imageList.add(imageBytes);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
                    throw new ConvertException(OfdErrorType.CONVERT_PNG_ERROR);
                }
            }
            return imageList;
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private static Transcoder getTranscoderByType(int imageType) {
        JPEGTranscoder transcoder;
        switch (imageType) {
            case 2: {
                transcoder = new JPEGTranscoder();
                break;
            }
            case 3: {
                transcoder = new TIFFTranscoder();
                break;
            }
            default: {
                transcoder = new PNGTranscoder();
            }
        }
        return transcoder;
    }

    public static byte[] convertSvgBytes2Image(byte[] svgBytes, float width, float height, int imageType) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(svgBytes);
        Object localThrowable6 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = SVGConversionUtil.convert2Image(in, byteArrayOutputStream, width, height, imageType);
            return byArray;
        }
        catch (ConvertException e) {
            LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
            throw new ConvertException(e.getErrorType());
        }
        catch (Exception e) {
            LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
            throw e;
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static byte[] convert2Image(InputStream in, ByteArrayOutputStream out, float width, float height, int imageType) throws TranscoderException {
        Transcoder transcoder = SVGConversionUtil.getTranscoderByType(imageType);
        TranscoderInput input = new TranscoderInput(in);
        TranscoderOutput output = new TranscoderOutput((OutputStream)out);
        float size = width * height;
        if (size > 2.147484E9f) {
            throw new ConvertException(OfdErrorType.CONVERT_PNG_TOO_LARGE);
        }
        transcoder.addTranscodingHint(PNGTranscoder.KEY_WIDTH, (Object)Float.valueOf(width * 2.0f));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_HEIGHT, (Object)Float.valueOf(height * 2.0f));
        transcoder.addTranscodingHint(PNGTranscoder.KEY_BACKGROUND_COLOR, (Object)Color.WHITE);
        try {
            transcoder.transcode(input, output);
        }
        catch (OutOfMemoryError e) {
            LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
            throw new ConvertException(OfdErrorType.CONVERT_PNG_TOO_LARGE);
        }
        return out.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertSvgStr2Pdf(String svgStr) throws Exception {
        byte[] byArray;
        block7: {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                List<String> svgList = SVGConversionUtil.svgSplit(svgStr);
                Document doc = new Document();
                PdfCopy pdfCopy = new PdfCopy(doc, (OutputStream)bos);
                pdfCopy.setFullCompression();
                doc.open();
                for (int i = 0; i < svgList.size(); ++i) {
                    String svgElementStr = svgList.get(i);
                    org.dom4j.Document document = DocumentHelper.parseText((String)svgElementStr);
                    byte[] svgIBytes = XmlUtil.toByteArray(document);
                    byte[] pdfIBytes = SVGConversionUtil.convertSvgBytes2Pdf(svgIBytes);
                    PdfImportedPage impPage = pdfCopy.getImportedPage(new PdfReader(pdfIBytes), 1);
                    pdfCopy.addPage(impPage);
                }
                doc.close();
                byArray = bos.toByteArray();
                if (bos == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (bos != null) {
                        bos.close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
                    throw e;
                }
            }
            bos.close();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] convertSvgBytes2Pdf(byte[] svgBytes) {
        byte[] byArray;
        block6: {
            ByteArrayInputStream in = new ByteArrayInputStream(svgBytes);
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byArray = SVGConversionUtil.convert2Pdf(in, byteArrayOutputStream);
                if (in == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error(OfdErrorType.CONVERT_PNG_ERROR.toString() + "  e:" + e.getMessage(), (Throwable)e);
                    throw new ConvertException(OfdErrorType.CONVERT_PNG_ERROR);
                }
            }
            ((InputStream)in).close();
        }
        return byArray;
    }

    public static byte[] convert2Pdf(InputStream in, ByteArrayOutputStream out) throws Exception {
        PDFTranscoder transcoder = new PDFTranscoder();
        transcoder.configure(SVGConversionUtil.getDefaultConfiguration());
        TranscoderInput input = new TranscoderInput(in);
        TranscoderOutput output = new TranscoderOutput((OutputStream)out);
        transcoder.transcode(input, output);
        return out.toByteArray();
    }

    private static Configuration getDefaultConfiguration() {
        DefaultConfiguration effCfg = new DefaultConfiguration("cfg");
        DefaultConfiguration fonts = new DefaultConfiguration("fonts");
        DefaultConfiguration autodetect = new DefaultConfiguration("auto-detect");
        fonts.addChild(autodetect);
        effCfg.addChild(fonts);
        return effCfg;
    }
}

