/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.master.cssp.PayInvoiceTypeEnum;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.CoreBillEntryBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.im.CurrentAccountType;
import com.kingdee.eas.tm.im.IMFacadeFactory;
import com.kingdee.eas.tm.im.IMKBizTypeEnum;
import com.kingdee.eas.tm.im.InvoiceSrcSystem;
import com.kingdee.eas.tm.im.MakeInvoiceCollection;
import com.kingdee.eas.tm.im.MakeInvoiceEntryInfo;
import com.kingdee.eas.tm.im.MakeInvoiceFactory;
import com.kingdee.eas.tm.im.MakeInvoiceInfo;
import com.kingdee.eas.tm.im.TaxClassificationCodeFactory;
import com.kingdee.eas.tm.im.TaxClassificationCodeInfo;
import com.kingdee.eas.tm.im.util.IMUtils;
import com.kingdee.eas.tm.im.ws.app.importbill.TMBillSupport;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;

public class MakeInvoiceSupport
extends TMBillSupport {
    @Override
    public ICoreBase getInterface() throws BOSException {
        return MakeInvoiceFactory.getLocalInstance(this.getContext());
    }

    @Override
    public Class<MakeInvoiceCollection> getInfoClass() {
        return MakeInvoiceCollection.class;
    }

    @Override
    public String getEntryName() {
        return "entries";
    }

    @Override
    protected void setDefaultHeadData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MakeInvoiceInfo info = (MakeInvoiceInfo)model;
        if (info.getCurrentAccountType() == null) {
            info.setCurrentAccountType(CurrentAccountType.CUSTOMER);
        }
        if (info.getInvoiceType() != null) {
            PayInvoiceTypeEnum invoiceType = PayInvoiceTypeEnum.getEnum((String)info.getInvoiceType().getValue());
            info.setInvoiceType(invoiceType);
        }
        info.setSrcSystem(InvoiceSrcSystem.WEBSERVICE);
        info.setBizType(IMKBizTypeEnum.EAS);
    }

    @Override
    protected void verifyHeadData(CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MakeInvoiceInfo info = (MakeInvoiceInfo)model;
        StringBuffer sb = new StringBuffer();
        if (info.getCompany() != null) {
            try {
                IMFacadeFactory.getLocalInstance(this.getContext()).checkFunctionPermission(info.getCompany().getId().toString(), "im_makeInvoice_new");
            }
            catch (Exception e) {
                sb.append(e.getMessage());
                errorMsg.add(sb.toString());
                return;
            }
        } else {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"COMPANY", (Locale)this.getContext().getLocale()));
        }
        if (info.getApplicateDate() == null) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"APPLICATEDATE", (Locale)this.getContext().getLocale()));
        }
        if (info.getInvoiceType() == null) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"INVOICETYPE", (Locale)this.getContext().getLocale()));
        }
        if (StringUtils.isEmpty((String)info.getReceiveCompany())) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"RECEIVECOMPANY", (Locale)this.getContext().getLocale()));
        }
        if (PayInvoiceTypeEnum.VALUEADDEDTAXINV.equals((Object)info.getInvoiceType()) || PayInvoiceTypeEnum.ELECTRONICSPECIALINVOICE.equals((Object)info.getInvoiceType())) {
            if (StringUtils.isEmpty((String)info.getTaxNumber())) {
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"TAXNUMBER", (Locale)this.getContext().getLocale()));
            } else if (StringUtils.isEmpty((String)info.getAddress())) {
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"ADDRESSTEL", (Locale)this.getContext().getLocale()));
            } else if (StringUtils.isEmpty((String)info.getBankAccount())) {
                sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"BANKACCOUNT", (Locale)this.getContext().getLocale()));
            }
        }
        if (sb.length() > 0) {
            sb.append(ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"NOTNULL", (Locale)this.getContext().getLocale()));
            errorMsg.add(sb.substring(1));
        }
        if (info.isIsPurchaseInvoice() && info.isIsVehicle()) {
            errorMsg.add(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "SGFP_REPEAT", this.getContext().getLocale()));
        }
    }

    @Override
    protected void verifyEntryData(int rownum, CoreBillEntryBaseInfo entryModel, CoreBillBaseInfo model, List<String> errorMsg) throws BOSException, EASBizException {
        MakeInvoiceInfo info = (MakeInvoiceInfo)model;
        MakeInvoiceEntryInfo entry = (MakeInvoiceEntryInfo)entryModel;
        StringBuffer sb = new StringBuffer();
        if (entry.getProduceName() == null) {
            sb.append(this.getEntryMsg(rownum, "TB_PRODUCTNAME"));
        }
        if (entry.getNoTaxAmt() == null) {
            sb.append(this.getEntryMsg(rownum, "TB_NOTAXAMT"));
        }
        if (entry.getTaxAmt() == null) {
            sb.append(this.getEntryMsg(rownum, "TB_TAXAMT"));
        }
        if (entry.getPriceTax() == null) {
            sb.append(this.getEntryMsg(rownum, "TB_PRICETAX"));
        }
        if (StringUtils.isEmpty((String)entry.getTaxClassificationCode())) {
            sb.append(this.getEntryMsg(rownum, "TB_TAXCLASSIFICATIONCODE"));
        }
        if (sb.length() > 0) {
            errorMsg.add(sb.substring(1));
        }
        if (info.isIsVehicle()) {
            TaxClassificationCodeInfo tccInfo;
            StringBuffer lineMsg = new StringBuffer();
            String billMsg = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "VEHICLE_BILL", this.getContext().getLocale());
            if (entry.getPrice() == null || entry.getNoTaxPrice() == null || entry.getQuantity() == null || BigDecimal.ZERO.compareTo(entry.getPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getNoTaxPrice()) == 0 || BigDecimal.ZERO.compareTo(entry.getQuantity()) == 0) {
                lineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_PRICEANDQTY_NOTNULL", this.getContext().getLocale())).append("\u3001");
            }
            if (!StringUtils.isEmpty((String)entry.getTaxClassificationCode()) && (tccInfo = TaxClassificationCodeFactory.getLocalInstance(this.getContext()).getTaxClassificationCodeInfo("where mergeCode = '" + entry.getTaxClassificationCode() + "'")) != null && !"\u673a\u52a8\u8f66".equals(tccInfo.getSimpleName())) {
                lineMsg.append(IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_TAXCLASSIFICATIONCODE_NOTVOLID", this.getContext().getLocale())).append("\u3001");
            }
            if (lineMsg.length() > 0) {
                String line = IMUtils.getString("com.kingdee.eas.tm.im.IMBizResource", "ENTRY_LINE_MSG", this.getContext().getLocale(), new Object[]{rownum});
                String msg = line + "\uff0c" + billMsg + lineMsg.substring(0, lineMsg.length() - 1);
                errorMsg.add(msg);
            }
        }
    }

    private String getEntryMsg(int i, String field) {
        return ResourceBase.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)"ENTRYNULL_MSG", (Locale)this.getContext().getLocale(), (Object[])new Object[]{i, EASResource.getString((String)"com.kingdee.eas.tm.im.MakeInvoiceResource", (String)field)});
    }
}

