/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.importbill;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.access.entity.SimpleProperty;
import com.kingdee.bos.metadata.access.entity.SimplePropertyCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoCollection;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoFactory;
import com.kingdee.eas.basedata.master.material.MaterialCompanyInfoInfo;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.DataBaseCollection;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.framework.ICoreBillBase;
import com.kingdee.eas.framework.IDataBase;
import com.kingdee.eas.tm.im.ws.app.importbill.DataInfoCache;
import com.kingdee.eas.tm.im.ws.app.json.MultiLangUtils;
import java.util.Enumeration;
import java.util.List;

public class TMBillImportUtils {
    public static List<String> setInfoByNumber(Context ctx, CoreBaseInfo info, List<String> errorMsg) throws BOSException {
        return TMBillImportUtils.setDataInfoByNumber(ctx, info, errorMsg);
    }

    public static List<String> setDataInfoByNumber(Context ctx, CoreBaseInfo info, List<String> errorMsg) throws BOSException {
        Enumeration keys = info.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object obj = info.get(key);
            if (obj != null && obj instanceof MaterialInfo) {
                TMBillImportUtils.setMaterial(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj != null && obj instanceof DataBaseInfo) {
                TMBillImportUtils.setDataBaseInfo(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj != null && obj instanceof CoreBillBaseInfo) {
                TMBillImportUtils.setCoreBillInfo(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj != null && obj instanceof UserInfo) {
                TMBillImportUtils.setUserInfo(ctx, info, errorMsg, key, obj);
                continue;
            }
            if (obj == null || !(obj instanceof IObjectCollection)) continue;
            TMBillImportUtils.setCollection(ctx, errorMsg, obj);
        }
        return errorMsg;
    }

    private static String getOql(DataBaseInfo lInfo, String number) {
        StringBuffer sb = new StringBuffer();
        if (lInfo instanceof CurrencyInfo) {
            sb.append("select id,number,name,precision where number='").append(number).append("'");
        } else if (lInfo instanceof RowTypeInfo) {
            sb.append("select id,number,name,isHasMaterialNumber,precision,destinationtype where number='").append(number).append("'");
        } else {
            sb.append("select id,number,name where number='").append(number).append("'");
        }
        return sb.toString();
    }

    public static void setDataBaseInfo(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        String oql;
        DataBaseInfo lInfo = (DataBaseInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        IDataBase iDataBase = (IDataBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)lInfo.getBOSType());
        DataBaseCollection databaseCol = iDataBase.getDataBaseCollection(oql = TMBillImportUtils.getOql(lInfo, number));
        if (databaseCol != null && databaseCol.size() > 0) {
            lInfo = databaseCol.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            errorMsg.add("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + TMBillImportUtils.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    public static void setCollection(Context ctx, List<String> errorMsg, Object obj) throws BOSException {
        IObjectCollection collection = (IObjectCollection)obj;
        for (int i = 0; i < collection.size(); ++i) {
            CoreBaseInfo entryInfo = (CoreBaseInfo)collection.getObject(i);
            TMBillImportUtils.setDataInfoByNumber(ctx, entryInfo, errorMsg);
        }
    }

    public static void setCoreBillInfo(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        CoreBillBaseInfo lInfo = (CoreBillBaseInfo)obj;
        if (lInfo.getId() != null) {
            return;
        }
        ICoreBillBase iCoreBillBase = (ICoreBillBase)BOSObjectFactory.createBOSObject((Context)ctx, (BOSObjectType)lInfo.getBOSType());
        String number = lInfo.getNumber();
        CoreBillBaseCollection databaseCol = iCoreBillBase.getCoreBillBaseCollection("select id,number where number='" + number + "'");
        if (databaseCol != null && databaseCol.size() > 0) {
            lInfo = databaseCol.get(0);
        } else {
            lInfo = null;
            errorMsg.add("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + TMBillImportUtils.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    public static void setUserInfo(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        UserInfo lInfo = (UserInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        IUser iuser = UserFactory.getLocalInstance((Context)ctx);
        UserCollection userCol = iuser.getUserCollection("select id,number ,name where number='" + number + "'");
        if (userCol != null && userCol.size() > 0) {
            lInfo = userCol.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            errorMsg.add("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + TMBillImportUtils.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    public static void setMaterial(Context ctx, CoreBaseInfo info, List<String> errorMsg, String key, Object obj) throws BOSException {
        MaterialInfo lInfo = (MaterialInfo)obj;
        String number = lInfo.getNumber();
        if (lInfo.getId() != null || number == null || number.trim().length() <= 0) {
            return;
        }
        String mapKey = number + lInfo.getClass().toString();
        if (DataInfoCache.getInstance().containsKey(mapKey)) {
            info.put(key, DataInfoCache.getInstance().get(mapKey));
            return;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo(" id"));
        sic.add(new SelectorItemInfo(" name"));
        sic.add(new SelectorItemInfo(" number"));
        sic.add(new SelectorItemInfo(" model"));
        sic.add(new SelectorItemInfo(" pricePrecision"));
        sic.add(new SelectorItemInfo(" baseunit.id"));
        sic.add(new SelectorItemInfo(" assistUnit.id"));
        sic.add(new SelectorItemInfo(" materialGroup.name"));
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        viewInfo.setSelector(sic);
        MaterialCollection collection = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(viewInfo);
        if (collection != null && collection.size() > 0) {
            lInfo = collection.get(0);
            DataInfoCache.getInstance().put(mapKey, lInfo);
        } else {
            lInfo = null;
            errorMsg.add("\u7f16\u7801" + number + " \u4e0d\u662f\u4e00\u4e2a\u6b63\u786e\u7684 " + TMBillImportUtils.getAliasName(ctx, info, key) + " .");
        }
        info.put(key, (Object)lInfo);
    }

    public static String getAliasName(Context ctx, CoreBaseInfo info, String key) throws BOSException {
        String aliasName = "";
        EntitySelect select = new EntitySelect(info.getBOSType());
        select.propertySelect().select(key, "alias");
        SimpleEntity entity = MetaDataAccessFactory.getLocalInstance((Context)ctx).select(select);
        SimpleProperty propertyObject = entity.property(key);
        aliasName = propertyObject.getString("alias_l2");
        return aliasName;
    }

    public static String getResource(String key, Object[] params) {
        String resource = "";
        return resource;
    }

    public static MultiMeasureUnitInfo getMultiMeasureUnit(Context ctx, MaterialInfo material, MeasureUnitInfo unit, List<String> errorMsg) throws BOSException {
        MultiMeasureUnitInfo mmu = null;
        if (material != null && unit != null) {
            String key = material.getId().toString() + unit.getId().toString();
            if (DataInfoCache.getInstance().containsKey(key)) {
                mmu = (MultiMeasureUnitInfo)DataInfoCache.getInstance().get(key);
            } else {
                mmu = TMBillImportUtils.getMultiMeasureUnitInfo(ctx, material.getId().toString(), unit.getId().toString());
                if (mmu != null) {
                    DataInfoCache.getInstance().put(key, mmu);
                } else {
                    errorMsg.add("\u8ba1\u91cf\u5355\u4f4d" + unit.getNumber() + "\u4e0d\u5b58\u5728\u4e8e\u7269\u6599\u7684" + material.getNumber() + "\u591a\u8ba1\u91cf\u5355\u4f4d\u7ec4\u91cc\u9762");
                }
            }
        }
        return mmu;
    }

    private static MultiMeasureUnitInfo getMultiMeasureUnitInfo(Context ctx, String materialId, String unitId) throws BOSException {
        String oql;
        MultiMeasureUnitInfo mmu = null;
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oql = " select material.id, measureUnit.id, qtyPrecision,baseConvsRate where measureUnit.id ='" + unitId + "' and material.id ='" + materialId + "'");
        if (mulUnits != null && mulUnits.size() > 0) {
            mmu = mulUnits.get(0);
        }
        return mmu;
    }

    public static MaterialCompanyInfoInfo getMaterialCompanyInfo(Context ctx, MaterialInfo material, CompanyOrgUnitInfo cou, List<String> errorMsg) throws BOSException {
        MaterialCompanyInfoInfo materialcompanyInfo = null;
        if (material != null && cou != null) {
            String key = material.getId().toString() + cou.getId().toString();
            if (DataInfoCache.getInstance().containsKey(key)) {
                materialcompanyInfo = (MaterialCompanyInfoInfo)DataInfoCache.getInstance().get(key);
            } else {
                materialcompanyInfo = TMBillImportUtils.getMaterialCompanyInfo(ctx, material.getId().toString(), cou.getId().toString());
                if (materialcompanyInfo != null) {
                    DataInfoCache.getInstance().put(key, materialcompanyInfo);
                }
            }
        }
        return materialcompanyInfo;
    }

    private static MaterialCompanyInfoInfo getMaterialCompanyInfo(Context ctx, String materialid, String couID) throws BOSException {
        MaterialCompanyInfoInfo materialcompanyInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mateial", (Object)materialid, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)couID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("standardCost"));
        MaterialCompanyInfoCollection con = MaterialCompanyInfoFactory.getLocalInstance((Context)ctx).getMaterialCompanyInfoCollection(viewInfo);
        if (con != null && con.size() >= 1) {
            materialcompanyInfo = con.get(0);
        }
        return materialcompanyInfo;
    }

    public static CompanyOrgUnitInfo getCompanyInfo(Context ctx, OrgUnitInfo orgInfo, int orgType) throws BOSException, EASBizException {
        CompanyOrgUnitInfo couInfo = null;
        if (orgInfo == null) {
            return null;
        }
        IOrgUnitRelation iOrgRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgCollection = iOrgRelation.getToUnit(orgInfo.getId().toString(), orgType, 1);
        if (orgCollection != null && orgCollection.size() > 0) {
            couInfo = (CompanyOrgUnitInfo)orgCollection.get(0);
        }
        return couInfo;
    }

    public static void getbillMetas(Context ctx, String bosType) {
        SimplePropertyCollection properties = MultiLangUtils.getAllProperties(ctx, BOSObjectType.create((String)bosType));
        for (int i = 0; i < properties.size(); ++i) {
            SimpleProperty sp = properties.get(i);
            String sline = sp.getName() + "; " + sp.getAlias() + "; " + sp.getString("description");
            sline = sp.isOwnProperty() ? sline + "; " + sp.getDataType().getJavaTypeName() : sline + "; " + sp.getRefTypeInfo();
            System.out.println(sline);
        }
    }
}

