/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.im.ws.app.message;

import com.kingdee.eas.tm.im.ws.MessageTypeEnum;
import com.kingdee.eas.tm.im.ws.app.handler.InvoiceMailOrderMessageHandler;
import com.kingdee.eas.tm.im.ws.app.handler.PurchaseTitleMessageHandler;
import com.kingdee.eas.tm.im.ws.app.handler.SIMCallBackMessageHandler;
import com.kingdee.eas.tm.im.ws.app.message.IMessageHandler;
import com.kingdee.util.BOSResourceBundle;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public class MessageConfiguration {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.im.ws.app.message.MessageConfiguration");
    private static MessageConfiguration instance = null;
    private static Map<String, Class<IMessageHandler>> handlerClassMap = null;

    public static synchronized MessageConfiguration getInstance() {
        if (instance == null) {
            instance = new MessageConfiguration();
        }
        return instance;
    }

    private MessageConfiguration() {
        this.registerBills();
    }

    public IMessageHandler getHandler(String type) {
        IMessageHandler handler = null;
        Class<IMessageHandler> handlerClass = handlerClassMap.get(type);
        if (handlerClass != null) {
            try {
                handler = handlerClass.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return handler;
    }

    protected synchronized void registerBills() {
        if (handlerClassMap != null) {
            return;
        }
        handlerClassMap = new HashMap<String, Class<IMessageHandler>>();
        this.registHandler(MessageTypeEnum.INVOICE_MAILORDER_MESSAGEHANDLER.getNumber(), InvoiceMailOrderMessageHandler.class);
        this.registHandler(MessageTypeEnum.PURCHASE_TITLE_MESSAGEHANDLER.getNumber(), PurchaseTitleMessageHandler.class);
        this.registHandler(MessageTypeEnum.SIM_CALLBACK_MESSAGEHANDLER.getNumber(), SIMCallBackMessageHandler.class);
        this.registeExt();
    }

    protected void registeExt() {
        String resClassName = "com.kingdee.eas.tm.im.ws.WShandlerclasses";
        try {
            ResourceBundle resBundle = BOSResourceBundle.getBundle((String)resClassName, (Locale)new Locale("l1"));
            Enumeration<String> keyIter = resBundle.getKeys();
            while (keyIter.hasMoreElements()) {
                String type = keyIter.nextElement();
                String className = resBundle.getString(type);
                if (className == null) continue;
                this.registHandler(type, className);
            }
        }
        catch (Exception e) {
            logger.info((Object)e);
        }
    }

    private void registHandler(String type, Class handlerClass) {
        if (handlerClassMap.containsKey(type)) {
            logger.error((Object)("message type " + type + " existed."));
            return;
        }
        handlerClassMap.put(type, handlerClass);
    }

    private void registHandler(String type, String typeClassName) {
        if (handlerClassMap.containsKey(type)) {
            logger.error((Object)("message type " + type + " existed."));
            return;
        }
        Class<IMessageHandler> handlerClass = this.getClass(typeClassName);
        if (handlerClass != null) {
            handlerClassMap.put(type, handlerClass);
        }
    }

    private Class<IMessageHandler> getClass(String className) {
        Class<IMessageHandler> handlerClass = null;
        try {
            handlerClass = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return handlerClass;
    }
}

