/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxBaseBillInfo;
import com.kingdee.eas.tm.td.basedata.RptBillRangeEntryCollection;
import com.kingdee.eas.tm.td.basedata.RptBillRangeInfo;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DraftBillBuildCenter {
    private static final String rsClass = "com.kingdee.eas.tm.td.TDResource";
    private String fieldName;
    private String fieldDisplayName;
    private PropertyInfo property;
    private static Map<String, List<DraftBillBuildCenter>> billFieldMap = new HashMap<String, List<DraftBillBuildCenter>>();
    private static Map<String, Map> fieldsMap = new HashMap<String, Map>();
    private static Map<String, EntityObjectInfo> entityInfoMap = new HashMap<String, EntityObjectInfo>();
    private static final String[] standardFields = new String[]{"companyOrgUnit", "rptId", "taxItemType"};

    public static EntityObjectInfo getDrafteBillEntity(Context ctx, String billBosType) {
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityInfo = null;
        if (entityInfoMap.get(billBosType) == null) {
            entityInfo = loader.getEntity(BOSObjectType.create((String)billBosType));
            entityInfoMap.put(billBosType, entityInfo);
        } else {
            entityInfo = entityInfoMap.get(billBosType);
        }
        return entityInfo;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public void setFieldDisplayName(String fieldDisplayName) {
        this.fieldDisplayName = fieldDisplayName;
    }

    public PropertyInfo getProperty() {
        return this.property;
    }

    public void setProperty(PropertyInfo property) {
        this.property = property;
    }

    public static Map getFieldsMap(String bosType) {
        return fieldsMap.get(bosType);
    }

    public static List<DraftBillBuildCenter> getFieldsList(String bosType) {
        return billFieldMap.get(bosType);
    }

    public static void init(ReportBaseInfo reportInfo) {
        RptBillRangeEntryCollection entrys = DraftBillBuildCenter.getBillRangeEntry(reportInfo);
        if (entrys == null) {
            return;
        }
        for (int i = 0; i < entrys.size(); ++i) {
            String bosType = entrys.get(i).getBillBosType();
            DraftBillBuildCenter.initDraftBillInfos(null, bosType);
        }
    }

    public static void initDraftBillInfos(Context ctx, String bosType) {
        if (billFieldMap.containsKey(bosType)) {
            return;
        }
        ArrayList<DraftBillBuildCenter> fieldList = new ArrayList<DraftBillBuildCenter>();
        DraftBillBuildCenter info = null;
        info = new DraftBillBuildCenter();
        info.setFieldName("companyOrgUnit");
        info.setFieldDisplayName(TDUtils.getString(rsClass, "COMPANY_NUMBER", null));
        fieldList.add(info);
        IMetaDataLoader loader = null;
        loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
        EntityObjectInfo entityInfo = loader.getEntity(BOSObjectType.create((String)bosType));
        PropertyCollection properties = entityInfo.getProperties();
        List standardFieldsList = Arrays.asList((Object[])standardFields);
        PropertyInfo property = null;
        for (int i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            if (standardFieldsList.contains(property.getName())) continue;
            info = new DraftBillBuildCenter();
            info.setFieldName(property.getName());
            info.setFieldDisplayName(property.getAlias());
            info.setProperty(property);
            fieldList.add(info);
        }
        billFieldMap.put(bosType, fieldList);
        HashMap<String, DraftBillBuildCenter> fieldMap = new HashMap<String, DraftBillBuildCenter>();
        for (int i = 0; i < fieldList.size(); ++i) {
            info = (DraftBillBuildCenter)fieldList.get(i);
            fieldMap.put(info.getFieldName(), info);
        }
        fieldsMap.put(bosType, fieldMap);
    }

    public static void buildDraftBillInfo(String fieldKey, Object fieldValue, IObjectValue info, DraftBillBuildCenter fieldsInfo) throws ParseException {
        if (fieldValue == null) {
            return;
        }
        if ("companyOrgUnit".equals(fieldKey)) {
            info.put("description", (Object)fieldValue.toString());
        } else if ("startDate".equals(fieldKey) && fieldValue != null && !"".equals(fieldValue)) {
            if (fieldValue instanceof String) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date startDate = sdf.parse(fieldValue.toString());
                info.put("startDate", (Object)startDate);
            } else {
                info.put("startDate", (Object)((Date)fieldValue));
            }
        } else if ("endDate".equals(fieldKey) && fieldValue != null && !"".equals(fieldValue)) {
            if (fieldValue instanceof String) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date endDate = sdf.parse(fieldValue.toString());
                info.put("endDate", (Object)endDate);
            } else {
                info.put("endDate", (Object)((Date)fieldValue));
            }
        } else if ("amount".equals(fieldKey)) {
            info.put("amount", (Object)new BigDecimal(fieldValue.toString()));
        } else {
            PropertyInfo property = fieldsInfo.getProperty();
            if (property instanceof LinkPropertyInfo) {
                info.put("f7$$" + property.getName(), fieldValue);
            } else {
                String dataType = (String)property.get("dataType");
                if ("Enum".equals(dataType)) {
                    info.put("Enum$$" + property.getName(), fieldValue);
                } else {
                    info.put(property.getName(), fieldValue);
                }
            }
        }
    }

    public static String buildErrorResult(int index, String fieldKey, Object fieldValue, DraftBillBuildCenter fieldsInfo) {
        StringBuffer errorDetail = new StringBuffer();
        if ("companyOrgUnit".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "COMPANY_NUMBER", TDUtils.getLocale())})).append("\n");
        } else if ("itemNumber".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "ITEM_NUMBER", TDUtils.getLocale())})).append("\n");
        } else if ("itemName".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "ITEM_NAME", TDUtils.getLocale())})).append("\n");
        } else if ("startDate".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "START_DATE", TDUtils.getLocale())})).append("\n");
        } else if ("endDate".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "END_DATE", TDUtils.getLocale())})).append("\n");
        } else if ("amount".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "AMOUNT", TDUtils.getLocale())})).append("\n");
        } else {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, fieldsInfo.getFieldDisplayName()})).append("\n");
        }
        return errorDetail.toString();
    }

    public static TaxBaseBillInfo getTaxBillInfo(EntityObjectInfo entityInfo) throws BOSException {
        String infoClass = entityInfo.getObjectValueClass();
        TaxBaseBillInfo retInfo = null;
        try {
            retInfo = (TaxBaseBillInfo)Class.forName(infoClass).newInstance();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return retInfo;
    }

    public static RptBillRangeEntryCollection getBillRangeEntry(ReportBaseInfo info) {
        RptBillRangeInfo billRangeInfo = (RptBillRangeInfo)info.get("billRange");
        if (billRangeInfo == null) {
            return null;
        }
        return billRangeInfo.getEntrys();
    }
}

