/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td;

import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftConfirmBillInfo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DraftBillFieldsInfo {
    private static final String rsClass = "com.kingdee.eas.tm.td.TDResource";
    private String fieldName;
    private String fieldDisplayName;
    private PropertyInfo property;
    private static Map fieldsMap = null;
    private static List<DraftBillFieldsInfo> fieldList = null;
    private static final String[] standardFields = new String[]{"companyOrgUnit", "ItemNumber", "ItemName", "startDate", "endDate", "amount", "rptId", "taxItemType"};

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldDisplayName() {
        return this.fieldDisplayName;
    }

    public void setFieldDisplayName(String fieldDisplayName) {
        this.fieldDisplayName = fieldDisplayName;
    }

    public PropertyInfo getProperty() {
        return this.property;
    }

    public void setProperty(PropertyInfo property) {
        this.property = property;
    }

    public static Map getFieldsMap() {
        return fieldsMap;
    }

    public static List<DraftBillFieldsInfo> getFieldsList() {
        return fieldList;
    }

    public static void initDraftBillInfos() {
        int i;
        fieldList = new ArrayList<DraftBillFieldsInfo>();
        DraftBillFieldsInfo info = null;
        info = new DraftBillFieldsInfo();
        info.setFieldName("companyOrgUnit");
        info.setFieldDisplayName(TDUtils.getString(rsClass, "COMPANY_NUMBER", TDUtils.getLocale()));
        fieldList.add(info);
        info = new DraftBillFieldsInfo();
        info.setFieldName("itemNumber");
        info.setFieldDisplayName(TDUtils.getString(rsClass, "ITEM_NUMBER", TDUtils.getLocale()));
        fieldList.add(info);
        info = new DraftBillFieldsInfo();
        info.setFieldName("itemName");
        info.setFieldDisplayName(TDUtils.getString(rsClass, "ITEM_NAME", TDUtils.getLocale()));
        fieldList.add(info);
        info = new DraftBillFieldsInfo();
        info.setFieldName("startDate");
        info.setFieldDisplayName(TDUtils.getString(rsClass, "START_DATE", TDUtils.getLocale()));
        fieldList.add(info);
        info = new DraftBillFieldsInfo();
        info.setFieldName("endDate");
        info.setFieldDisplayName(TDUtils.getString(rsClass, "END_DATE", TDUtils.getLocale()));
        fieldList.add(info);
        info = new DraftBillFieldsInfo();
        info.setFieldName("amount");
        info.setFieldDisplayName(TDUtils.getString(rsClass, "AMOUNT", TDUtils.getLocale()));
        fieldList.add(info);
        String billBosType = "D7EA12D6";
        IMetaDataLoader loader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
        EntityObjectInfo entityInfo = loader.getEntity(BOSObjectType.create((String)billBosType));
        PropertyCollection properties = entityInfo.getProperties();
        List standardFieldsList = Arrays.asList((Object[])standardFields);
        PropertyInfo property = null;
        for (i = 0; i < properties.size(); ++i) {
            property = properties.get(i);
            if (standardFieldsList.contains(property.getName())) continue;
            info = new DraftBillFieldsInfo();
            info.setFieldName(property.getName());
            info.setFieldDisplayName(property.getAlias());
            info.setProperty(property);
            fieldList.add(info);
        }
        fieldsMap = new HashMap();
        for (i = 0; i < fieldList.size(); ++i) {
            info = fieldList.get(i);
            fieldsMap.put(info.getFieldName(), info);
        }
    }

    public static void buildDraftBillInfo(String fieldKey, Object fieldValue, TaxDraftConfirmBillInfo info, DraftBillFieldsInfo fieldsInfo) {
        if (fieldValue == null) {
            return;
        }
        if ("companyOrgUnit".equals(fieldKey)) {
            info.setDescription(fieldValue.toString());
        } else if ("itemNumber".equals(fieldKey)) {
            info.setItemNumber(fieldValue.toString());
        } else if ("itemName".equals(fieldKey)) {
            info.setItemName(fieldValue.toString());
        } else if ("startDate".equals(fieldKey) && fieldValue != null && !"".equals(fieldValue)) {
            info.setStartDate((Date)fieldValue);
        } else if ("endDate".equals(fieldKey) && fieldValue != null && !"".equals(fieldValue)) {
            info.setEndDate((Date)fieldValue);
        } else if ("amount".equals(fieldKey)) {
            info.setAmount(new BigDecimal(fieldValue.toString()));
        } else {
            PropertyInfo property = fieldsInfo.getProperty();
            if (property instanceof LinkPropertyInfo) {
                info.put("f7$$" + property.getName(), fieldValue);
            } else {
                String dataType = (String)property.get("dataType");
                if ("Enum".equals(dataType)) {
                    info.put("Enum$$" + property.getName(), fieldValue);
                } else {
                    info.put(property.getName(), fieldValue);
                }
            }
        }
    }

    public static String buildErrorResult(int index, String fieldKey, Object fieldValue, DraftBillFieldsInfo fieldsInfo) {
        StringBuffer errorDetail = new StringBuffer();
        if ("companyOrgUnit".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "COMPANY_NUMBER", TDUtils.getLocale())})).append("\n");
        } else if ("itemNumber".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "ITEM_NUMBER", TDUtils.getLocale())})).append("\n");
        } else if ("itemName".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "ITEM_NAME", TDUtils.getLocale())})).append("\n");
        } else if ("startDate".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "START_DATE", TDUtils.getLocale())})).append("\n");
        } else if ("endDate".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "END_DATE", TDUtils.getLocale())})).append("\n");
        } else if ("amount".equals(fieldKey)) {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, TDUtils.getString(rsClass, "AMOUNT", TDUtils.getLocale())})).append("\n");
        } else {
            errorDetail.append(TDUtils.getString(rsClass, "draftSaveErrorDetail", TDUtils.getLocale(), new Object[]{index, fieldsInfo.getFieldDisplayName()})).append("\n");
        }
        return errorDetail.toString();
    }
}

