/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.excel.model.expr.IErrorProvider;
import com.kingdee.bos.ctrl.excel.model.struct.Book;
import com.kingdee.bos.ctrl.excel.model.struct.Cell;
import com.kingdee.bos.ctrl.excel.model.struct.Sheet;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDMenuItem;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.access.MetaDataAccessFactory;
import com.kingdee.bos.metadata.access.entity.EntitySelect;
import com.kingdee.bos.metadata.access.entity.SimpleEntity;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceManager;
import com.kingdee.bos.service.ServiceManagerFactory;
import com.kingdee.bos.service.binding.IServiceBinder;
import com.kingdee.bos.service.binding.ServiceBindItem;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleInfo;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.netctrl.IMutexServiceControl;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.basedata.org.client.f7.NewOrgUnitFilterInfoProducer;
import com.kingdee.eas.basedata.person.client.PersonPromptBox;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.fi.newrpt.formula.ICalculateContextProvider;
import com.kingdee.eas.fi.newrpt.formula.IReportPropertyAdapter;
import com.kingdee.eas.fi.newrpt.formula.ReportCalculateContext;
import com.kingdee.eas.fi.newrpt.formula.define.FormulaDefinition;
import com.kingdee.eas.fi.rpt.ReportBaseInfo;
import com.kingdee.eas.fi.rpt.excelformula.ExcelFormulaPaserHelper;
import com.kingdee.eas.fi.rpt.excelformula.expr.BinaryOperationExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.Expression;
import com.kingdee.eas.fi.rpt.excelformula.expr.FunctionExpr;
import com.kingdee.eas.fi.rpt.excelformula.expr.UnaryOperationExpr;
import com.kingdee.eas.fi.rpt.util.BookProperties;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.FrameWorkClientUtils;
import com.kingdee.eas.tm.td.ITDFacade;
import com.kingdee.eas.tm.td.ITaxDraftRecord;
import com.kingdee.eas.tm.td.OwnerMenuEnum;
import com.kingdee.eas.tm.td.RecordTypeEnum;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordCollection;
import com.kingdee.eas.tm.td.TaxDraftRecordFactory;
import com.kingdee.eas.tm.td.TaxDraftRecordInfo;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.account.formula.AccountFormulaCalculateService;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tm.td.cloud.ITDParam;
import com.kingdee.eas.tm.td.cloud.TDParamCollection;
import com.kingdee.eas.tm.td.cloud.TDParamFactory;
import com.kingdee.eas.tm.td.cloud.TDParamInfo;
import com.kingdee.eas.tm.td.formula.fillFormula.FillFormulaFactory;
import com.kingdee.eas.tm.td.formula.fillFormula.IFillFormula;
import com.kingdee.eas.tm.td.structure.TaxReportTemplateInfo;
import com.kingdee.eas.tm.td.structure.utils.TaxReportTemplatePropertyAdapter;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.eas.tm.td.utils.TDSelectorFactory;
import com.kingdee.eas.tm.td.utils.TaxDraftRptPropertyAdapter;
import com.kingdee.eas.tm.td.utils.TaxOtherReportPropertyAdapter;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.DoubleEnum;
import com.kingdee.util.enums.DynamicEnum;
import com.kingdee.util.enums.Enum;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.FloatEnum;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.LongEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Component;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.MessageDigest;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TDUtils {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.TDUtils");
    public static final String DraftItemImportResource = "com.kingdee.eas.tm.td.basedata.DraftItemImportResource";
    public static final String TDLogResource = "com.kingdee.eas.tm.td.TDLogResource";
    public static final String TaxBaseResource = "com.kingdee.eas.tm.td.basedata.TaxBaseResource";
    public static final String TDCommonResource = "com.kingdee.eas.tm.td.TDCommonResource";
    public static final String TaxDraftExportResource = "com.kingdee.eas.tm.td.TaxDraftExportResource";
    public static final String TDResource = "com.kingdee.eas.tm.td.TDResource";
    public static final String TaxStructureResource = "com.kingdee.eas.tm.td.structure.TaxStructureResource";
    public static final String TeResourceResource = "com.kingdee.eas.tm.td.directdeclare.TeResource";
    public static final String TdCloudResource = "com.kingdee.eas.tm.td.cloud.TDCloudResource";
    public static final String TaxDraftResource = "com.kingdee.eas.tm.td.TaxDraftResource";
    public static final String TDBaseDataResource = "com.kingdee.eas.tm.td.basedata.TDBaseDataResource";
    public static final String RptBillRangeResource = "com.kingdee.eas.tm.td.basedata.RptBillRangeResource";
    public static final String TaxOtherReportResource = "com.kingdee.eas.tm.td.TaxOtherReportResource";
    public static final String ESTResource = "com.kingdee.eas.tm.td.est.ESTResource";
    public static final String TaxFormulaResource = "com.kingdee.eas.tm.td.formula.TaxFormulaResource";
    public static final String RealEstateResource = "com.kingdee.eas.tm.td.est.RealEstateResource";
    public static final String RealEstateGroupResource = "com.kingdee.eas.tm.td.est.RealEstateGroupResource";
    public static final String LandDataResource = "com.kingdee.eas.tm.td.est.landDataResource";
    public static final String TDImportResource = "com.kingdee.eas.tm.td.TDImportResource";
    public static final String TDBizResource = "com.kingdee.eas.tm.td.TDBizResource";
    public static final String TaxReliefRulesResource = "com.kingdee.eas.tm.td.basedata.TaxReliefRulesResource";
    public static final String TaxItemTypeResource = "com.kingdee.eas.tm.td.basedata.TaxItemTypeResource";
    private static final String[] taxes = new String[]{"Xip0em3cA6rgU0ETqMAGKduK96Y=", "Xip0em3dA6rgU0ETqMAGKduK96Y=", "Xip1b7mfPS7gU0ETqMBAL9uK96Y=", "ZCyrvv6mAnPgU0ETqMCc49uK96Y=", "ZCyrvv6nAnPgU0ETqMCc49uK96Y=", "ZCyrvv6oAnPgU0ETqMCc49uK96Y=", "ZCyrvv6pAnPgU0ETqMCc49uK96Y=", "d8umkg7qNn3gU0ETqMCsX9uK96Y="};
    private static final List<RecordTypeEnum> types = RecordTypeEnum.getEnumList();
    private static final Map<String, OwnerMenuEnum> map = new HashMap<String, OwnerMenuEnum>();

    public static final String getString(String rsCalss, String key) {
        return TDUtils.getString(rsCalss, key, TDUtils.getLocale());
    }

    public static final String getString(String rsCalss, String key, Object[] params, Locale locale) {
        return TDUtils.getString(rsCalss, key, locale, params);
    }

    public static final String getString(String rsCalss, String key, Locale locale) {
        if (locale == null) {
            locale = TDUtils.getLocale();
        }
        return ResourceBase.getString((String)rsCalss, (String)key, (Locale)locale);
    }

    public static final String getString(String rsCalss, String key, Locale locale, Object[] params) {
        if (locale == null) {
            locale = TDUtils.getLocale();
        }
        return ResourceBase.getString((String)rsCalss, (String)key, (Locale)locale, (Object[])params);
    }

    public static Locale getLocale() {
        try {
            return SysContext.getSysContext().getOriginLocale();
        }
        catch (Throwable e) {
            return LocaleUtils.locale_zh_CN;
        }
    }

    public static final String getNumberString() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        String newsNo = "NUM" + df.format(new Date());
        return newsNo;
    }

    public static TaxItemTypeInfo getUIParams(Map uiContext) {
        TaxItemTypeInfo taxTypeInfo = new TaxItemTypeInfo();
        if ("Xip0em3cA6rgU0ETqMAGKduK96Y=".equals(uiContext.get("UIClassParam"))) {
            taxTypeInfo.setId(BOSUuid.read((String)"Xip0em3cA6rgU0ETqMAGKduK96Y="));
            taxTypeInfo.setNumber("001");
        } else if ("Xip0em3dA6rgU0ETqMAGKduK96Y=".equals(uiContext.get("UIClassParam"))) {
            taxTypeInfo.setId(BOSUuid.read((String)"Xip0em3dA6rgU0ETqMAGKduK96Y="));
            taxTypeInfo.setNumber("002");
        } else if ("Xip1b7mfPS7gU0ETqMBAL9uK96Y=".equals(uiContext.get("UIClassParam"))) {
            taxTypeInfo.setId(BOSUuid.read((String)"Xip1b7mfPS7gU0ETqMBAL9uK96Y="));
            taxTypeInfo.setNumber("003");
        }
        return taxTypeInfo;
    }

    public static Enum getEnumValue(String enumSource, Object value) throws BOSException, EASBizException {
        if (value == null) {
            return null;
        }
        List list = EnumUtils.getEnumList((String)enumSource);
        if (list == null) {
            list = DynamicEnum.getEnumList((String)enumSource);
        }
        int size = list.size();
        Object enumValue = null;
        for (int j = 0; j < size; ++j) {
            if (!(list.get(j) instanceof Enum)) continue;
            Enum enumData = (Enum)list.get(j);
            if (enumData instanceof StringEnum) {
                enumValue = ((StringEnum)enumData).getValue();
            } else if (enumData instanceof IntEnum) {
                enumValue = ((IntEnum)enumData).getValue();
            } else if (enumData instanceof LongEnum) {
                enumValue = ((LongEnum)enumData).getValue();
            } else if (enumData instanceof FloatEnum) {
                enumValue = Float.valueOf(((FloatEnum)enumData).getValue());
            } else if (enumData instanceof DoubleEnum) {
                enumValue = ((DoubleEnum)enumData).getValue();
            } else if (enumData instanceof DynamicEnum) {
                enumValue = ((DynamicEnum)enumData).getValue();
            }
            if (enumValue != null && enumValue.toString().equals(value.toString())) {
                return enumData;
            }
            if (!enumData.getAlias().equals(value)) continue;
            return enumData;
        }
        return null;
    }

    public static Object getEnumValue(Enum enumData) {
        Object enumValue = null;
        if (enumData instanceof StringEnum) {
            enumValue = ((StringEnum)enumData).getValue();
        } else if (enumData instanceof IntEnum) {
            enumValue = ((IntEnum)enumData).getValue();
        } else if (enumData instanceof LongEnum) {
            enumValue = ((LongEnum)enumData).getValue();
        } else if (enumData instanceof FloatEnum) {
            enumValue = Float.valueOf(((FloatEnum)enumData).getValue());
        } else if (enumData instanceof DoubleEnum) {
            enumValue = ((DoubleEnum)enumData).getValue();
        } else if (enumData instanceof DynamicEnum) {
            enumValue = ((DynamicEnum)enumData).getValue();
        }
        return enumValue;
    }

    public static boolean isLocked(Map lockList) {
        Iterator iterator = lockList.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next().toString();
            if (Boolean.parseBoolean(lockList.get(key).toString())) continue;
            return true;
        }
        return false;
    }

    public static final void setRptIDLableVsb(KDTextField txtRrpID, KDTextField txtBaseRrpID) {
        Component[] components = txtRrpID.getParent().getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof KDLabel)) continue;
            KDLabel lab = (KDLabel)components[i];
            if (!TDUtils.getString(TDCommonResource, "RecordCode", TDUtils.getLocale()).equals(lab.getText())) continue;
            lab.setVisible(false);
            break;
        }
        txtBaseRrpID.setVisible(false);
        txtRrpID.setVisible(false);
    }

    public static String getTaxDraftRptUI(String taxFlag, String recordType) {
        String ret = null;
        if (taxFlag.equalsIgnoreCase("vat")) {
            if ("account".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.vat.client.AccountVatTaxDraftRptUI";
            } else if ("draftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.vat.client.DraftItemVatTaxDraftRptUI";
            } else if ("taxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.vat.client.TaxDeclareVatTaxDraftRptUI";
            }
        } else if (taxFlag.equalsIgnoreCase("ct")) {
            if ("account".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ct.client.CtAccountTaxDraftRptUI";
            } else if ("draftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ct.client.CtDraftItemTaxDraftRptUI";
            } else if ("taxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ct.client.CtTaxDeclareTaxDraftRptUI";
            }
        } else if (taxFlag.equalsIgnoreCase("eit")) {
            if ("account".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.eit.client.EitAccountTaxDraftRptUI";
            } else if ("quarterlydraftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.eit.client.QuarterlyEitDraftItemTaxDraftRptUI";
            } else if ("quarterlytaxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.eit.client.QuarterlyEitTaxDeclareTaxDraftRptUI";
            } else if ("annualdraftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.eit.client.AnnualEitDraftItemTaxDraftRptUI";
            } else if ("annualtaxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.eit.client.AnnualEitTaxDeclareTaxDraftRptUI";
            }
        } else if (taxFlag.equalsIgnoreCase("st")) {
            if ("account".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.st.client.StAccountTaxDraftRptUI";
            } else if ("draftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.st.client.StDraftItemTaxDraftRptUI";
            } else if ("taxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.st.client.StTaxDeclareTaxDraftRptUI";
            }
        } else if (taxFlag.equalsIgnoreCase("at")) {
            if ("draftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.at.client.AtDraftItemTaxDraftRptUI";
            } else if ("taxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.at.client.AtTaxDeclareTaxDraftRptUI";
            }
        } else if (taxFlag.equalsIgnoreCase("ert")) {
            if ("account".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ert.client.ErtAccountTaxDraftRptUI";
            } else if ("draftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ert.client.ErtDraftItemTaxDraftRptUI";
            } else if ("taxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ert.client.ErtTaxDeclareTaxDraftRptUI";
            }
        } else if (taxFlag.equalsIgnoreCase("ot")) {
            if ("draftitem".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ot.client.OtDraftItemTaxDraftRptUI";
            } else if ("taxdeclare".equalsIgnoreCase(recordType)) {
                ret = "com.kingdee.eas.tm.td.taxes.ot.client.OtTaxDeclareTaxDraftRptUI";
            }
        }
        return ret;
    }

    public static String getInStringFromList(List ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getInStringFromSet(Set ids) {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        Iterator iter = ids.iterator();
        while (iter.hasNext()) {
            in.append("'").append(iter.next().toString()).append("'");
            if (!iter.hasNext()) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static String getInStringFromArray(String[] arr) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        StringBuffer in = new StringBuffer();
        in.append(" (");
        for (int i = 0; i < arr.length; ++i) {
            in.append("'").append(arr[i]).append("'");
            if (i == arr.length - 1) continue;
            in.append(",");
        }
        in.append(") ");
        return in.toString();
    }

    public static boolean getBooleanParam(Context ctx, String companyId, String paramName) throws EASBizException, BOSException {
        boolean retValue = false;
        String param = TDUtils.getParamByNunber(ctx, companyId, new String[]{paramName});
        if (param != null) {
            retValue = Boolean.parseBoolean(param);
        }
        return retValue;
    }

    public static String getParamByNunber(Context ctx, String companyId, String[] paramName) throws BOSException, EASBizException {
        ITDFacade facade = null;
        facade = ctx == null ? TDFacadeFactory.getRemoteInstance() : TDFacadeFactory.getLocalInstance(ctx);
        Map paramMap = facade.getParam(companyId, paramName);
        String param = (String)paramMap.get(paramName[0]);
        return param;
    }

    public static KDMenuItem cloneMenuItem(KDMenuItem menuItem) {
        KDMenuItem newMenuItem = new KDMenuItem();
        newMenuItem.setAction(menuItem.getAction());
        newMenuItem.setText(menuItem.getText());
        newMenuItem.setToolTipText(menuItem.getToolTipText());
        newMenuItem.setIcon(menuItem.getIcon());
        return newMenuItem;
    }

    public static void removeNullRow(KDTable table, String[] colNames, Boolean flag) {
        int rowCount = table.getRowCount();
        int colCount = table.getColumnCount();
        if (colNames == null) {
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = true;
                IRow row = table.getRow(i);
                for (int colIndex = 0; isNullRow && colIndex < colCount; ++colIndex) {
                    isNullRow = row.getCell(colIndex).getValue() == null;
                }
                if (!isNullRow) continue;
                table.removeRow(i);
                --i;
                --rowCount;
            }
        } else {
            int colCounts = colNames.length;
            for (int i = 0; i < rowCount; ++i) {
                boolean isNullRow = false;
                IRow row = table.getRow(i);
                for (int colIndex = 0; !isNullRow && colIndex < colCounts; ++colIndex) {
                    isNullRow = row.getCell(colNames[colIndex]).getValue() == null;
                }
                if (!isNullRow) continue;
                if (flag.booleanValue() && rowCount == 1) {
                    return;
                }
                table.removeRow(i);
                --i;
                --rowCount;
            }
        }
    }

    public static OrgUnitCollection getOrgUnitInfosByType(Context ctx, OrgUnitCollection orgs, OrgType orgType, SorterItemCollection sorter) throws BOSException {
        OrgUnitCollection results = new OrgUnitCollection();
        int type = -1;
        if (orgs == null || orgs.size() == 0) {
            return results;
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < orgs.size(); ++i) {
            keys.add(orgs.get(i).getId().toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(TDUtils.getOrgInfoSelector(orgType));
        switch (orgType.getValue()) {
            case 0: {
                AdminOrgUnitCollection collection;
                type = 0;
                IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                if (sorter != null) {
                    view.setSorter(sorter);
                }
                if ((collection = iAdmin.getAdminOrgUnitCollection(view)) != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 1: {
                type = 1;
                ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 2: {
                type = 2;
                ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 3: {
                type = 3;
                IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 4: {
                type = 4;
                IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 24: {
                type = 24;
                ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
            case 10: {
                ICtrlUnit ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx);
                CtrlUnitCollection collection = ictrlUnit.getCtrlUnitCollection(view);
                if (collection != null && collection.size() > 0) {
                    for (int i = 0; i < collection.size(); ++i) {
                        results.add((OrgUnitInfo)collection.get(i));
                    }
                }
                return results;
            }
        }
        return null;
    }

    public static void getCompanyOrgUnitIds(Context ctx, Set curCompanyIds, Set companyIDs) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        companyIDs.addAll(curCompanyIds);
        HashSet<String> temp = new HashSet<String>();
        sql.append(" select fid from T_ORG_BaseUnit where FIsCompanyOrgUnit = 1  and FIsStart = 0 and FIsLeaf = 1 ");
        sql.append(" and fparentid in (").append(CollectionUtil.convertSet2String(curCompanyIds, ",", true)).append(")");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("fid") == null) continue;
                companyIDs.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" select fid from T_ORG_BaseUnit where FIsCompanyOrgUnit = 1  and FIsStart = 0 and FIsLeaf = 0 ");
        sql.append(" and fparentid in (").append(CollectionUtil.convertSet2String(curCompanyIds, ",", true)).append(")");
        rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                if (rs.getString("fid") == null) continue;
                temp.add(rs.getString("fid"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (temp.size() > 0) {
            TDUtils.getCompanyOrgUnitIds(ctx, temp, companyIDs);
        }
    }

    public static OrgUnitCollection getAuthOrgByPermItem(Context context, OrgType orgType, String permItem) throws BOSException, EASBizException {
        IPermission permission;
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission iPermission = permission = context == null ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)context);
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        ObjectUuidPK userPK = null == context || null == context.getCaller() ? new ObjectUuidPK(userInfo.getId()) : context.getCaller();
        FullOrgUnitCollection result = permission.getAuthorizedOrg((IObjectPK)userPK, orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    public static SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    public static String getPermissionItem(Context context, IMetaDataPK pk) throws BOSException, EASBizException {
        IServiceManager manager = ServiceManagerFactory.getServiceManager();
        IServiceBinder binder = manager.getServiceBinder(context);
        ServiceBindItem[] bind = binder.getServiceBindings(MetaDataTypeList.BASEQUERY, pk);
        if (bind != null) {
            int len = bind.length;
            for (int i = 0; i < len; ++i) {
                String permItemName;
                if (bind[i].getType() != 0 || StringUtils.isEmpty((String)(permItemName = bind[i].getName()))) continue;
                return permItemName;
            }
        }
        return null;
    }

    public static CompanyOrgUnitInfo getPermissionCompany(String permissionItem) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        NewOrgUnitFilterInfoProducer iProducer = new NewOrgUnitFilterInfoProducer(OrgType.Company, permissionItem);
        FilterInfo tmpFilter = iProducer.getFilterInfo();
        view.setFilter(tmpFilter);
        CompanyOrgUnitCollection companyOrgUnitCollection = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        if (companyOrgUnitCollection.isEmpty()) {
            return null;
        }
        String companyId = SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        for (int i = 0; i < companyOrgUnitCollection.size(); ++i) {
            CompanyOrgUnitInfo companyOrgUnitInfo = companyOrgUnitCollection.get(i);
            if (!companyOrgUnitInfo.getId().toString().equals(companyId)) continue;
            return companyOrgUnitInfo;
        }
        return companyOrgUnitCollection.get(0);
    }

    public static void sort(IObjectCollection coll, final String propertyName, boolean isASC) {
        int i;
        if (StringUtils.isEmpty((String)propertyName)) {
            return;
        }
        int size = coll.size();
        if (coll == null || size <= 1) {
            return;
        }
        ArrayList<IObjectValue> list = new ArrayList<IObjectValue>(size);
        for (i = 0; i < size; ++i) {
            list.add(coll.getObject(i));
        }
        Collections.sort(list, new Comparator<IObjectValue>(){

            @Override
            public int compare(IObjectValue o1, IObjectValue o2) {
                Object k1 = o1.get(propertyName);
                Object k2 = o2.get(propertyName);
                if (k1 != null && k2 != null) {
                    if (k1 instanceof Comparable) {
                        return ((Comparable)k1).compareTo(k2);
                    }
                } else {
                    if (k1 == null && k2 == null) {
                        return 0;
                    }
                    if (k1 == null) {
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        });
        coll.clear();
        if (isASC) {
            for (i = 0; i < list.size(); ++i) {
                coll.addObject((IObjectValue)list.get(i));
            }
        } else {
            for (i = list.size() - 1; i >= 0; --i) {
                coll.addObject((IObjectValue)list.get(i));
            }
        }
    }

    public static String StringToMD5(String input) {
        String md5str = null;
        if (input == null) {
            return "";
        }
        byte[] bytes = input.getBytes();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buff = md.digest(bytes);
            md5str = TDUtils.bytesToHex(buff);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return md5str;
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuffer md5str = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            int digital = bytes[i];
            if (digital < 0) {
                digital += 256;
            }
            if (digital < 16) {
                md5str.append("0");
            }
            md5str.append(Integer.toHexString(digital));
        }
        return md5str.toString();
    }

    public static String buildErrorMsg(List msg) {
        StringBuffer retMsg = new StringBuffer();
        for (int i = 0; i < msg.size(); ++i) {
            retMsg.append(msg.get(i)).append("\r\n");
        }
        return retMsg.toString();
    }

    public static IObjectValue billCopy(Context context, AbstractObjectValue dataObject) throws BOSException {
        BOSObjectType bosType = dataObject.getBOSType();
        EntitySelect select = new EntitySelect(bosType);
        select.selectPKFields();
        SimpleEntity entity = MetaDataAccessFactory.getLocalInstance((Context)context).select(select);
        String[] pks = entity.getPKFields();
        TDUtils.removePKField(dataObject, pks);
        dataObject.setBOSUuid("id", BOSUuid.create((BOSObjectType)dataObject.getBOSType()));
        return dataObject;
    }

    private static void removePKField(AbstractObjectValue dataObject, String[] pks) {
        if (dataObject == null) {
            return;
        }
        dataObject.remove(dataObject.getPKField());
        if (pks != null) {
            for (int i = 0; i < pks.length; ++i) {
                String[] path = StringUtils.split((String)pks[i], (String)".");
                List<AbstractObjectValue> ovs = new ArrayList<AbstractObjectValue>(1);
                ovs.add(dataObject);
                for (int j = 0; j < path.length && (ovs = TDUtils.findSubObject(ovs, path[j])) != null; ++j) {
                }
                if (ovs == null) continue;
                for (AbstractObjectValue ov : ovs) {
                    ov.remove(ov.getPKField());
                }
            }
        }
    }

    private static List<AbstractObjectValue> findSubObject(List<AbstractObjectValue> dataObjects, String prop) {
        if (dataObjects == null || dataObjects.size() <= 0 || prop == null) {
            return null;
        }
        ArrayList<AbstractObjectValue> subs = new ArrayList<AbstractObjectValue>();
        int size = dataObjects.size();
        for (int i = 0; i < size; ++i) {
            AbstractObjectValue ov;
            Object sub = dataObjects.get(i).get(prop);
            if (sub == null) continue;
            if (sub instanceof AbstractObjectValue) {
                ov = (AbstractObjectValue)sub;
                subs.add(ov);
                continue;
            }
            if (!(sub instanceof AbstractObjectCollection)) continue;
            AbstractObjectCollection oc = (AbstractObjectCollection)sub;
            int s = oc.size();
            for (int j = 0; j < s; ++j) {
                ov = (AbstractObjectValue)oc.getObject(j);
                subs.add(ov);
            }
        }
        return subs;
    }

    public static Book getReportBook(Context ctx, IObjectValue reportInfo) throws Exception {
        Book book = Book.Manager.getNewBook((String)"Sheet1", (int)1);
        if (reportInfo.get("data") != null) {
            if (reportInfo instanceof ReportBaseInfo) {
                book = ((ReportBaseInfo)reportInfo).getBook();
            } else if (reportInfo instanceof TaxReportTemplateInfo) {
                book = ((TaxReportTemplateInfo)reportInfo).getBook();
            }
        }
        book.setCalculate(false);
        BookProperties p = BookProperties.loadFromBook((Book)book);
        Object adapter = new TaxDraftRptPropertyAdapter();
        if (reportInfo instanceof TaxOtherReportInfo) {
            adapter = new TaxOtherReportPropertyAdapter();
        } else if (reportInfo instanceof TaxReportTemplateInfo) {
            adapter = new TaxReportTemplatePropertyAdapter();
        }
        adapter.initReportProperties(reportInfo, ctx);
        FormulaDefinition.registerFormulaToBook((Book)book, (ICalculateContextProvider)new ReportCalculateContext(ctx, (IReportPropertyAdapter)adapter, p.getVariables(), (IErrorProvider)p.getErrorProvider(), null));
        return book;
    }

    public static void calculateReport(Context ctx, ReportBaseInfo reportInfo) throws Exception {
        Book book = TDUtils.getReportBook(ctx, (IObjectValue)reportInfo);
        boolean oldstate = book.isAutoCalculate();
        book.setCalculate(false);
        AccountFormulaCalculateService calculateService = new AccountFormulaCalculateService(ctx);
        calculateService.calculateReport(reportInfo, book);
        book.calc();
        book.setCalculate(oldstate);
        reportInfo.setBook(book);
    }

    public static void calculateBook(Context ctx, TaxDraftRecordInfo reportInfo, Book book) throws Exception {
        boolean oldstate = book.isAutoCalculate();
        book.setCalculate(false);
        AccountFormulaCalculateService calculateService = new AccountFormulaCalculateService(ctx);
        calculateService.calculateReport(reportInfo, book);
        book.calc();
        book.setCalculate(oldstate);
    }

    public static void tryLock(List idList) throws EASBizException {
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        Map map = mutexServiceControl.batchRequestObjIDForUpdate(idList);
        boolean isReqError = TDUtils.isLocked(map);
        if (isReqError) {
            throw new TDException(TDException.BILL_LOCKED);
        }
    }

    public static void releaseLock(List idList) {
        if (idList == null || idList.size() == 0) {
            return;
        }
        IMutexServiceControl mutexServiceControl = FrameWorkClientUtils.createMutexServiceControl();
        mutexServiceControl.batchReleaseObjIDForUpdate(idList);
    }

    public static String getTDParamsValue(Context ctx, String key) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("key", (Object)key, CompareType.EQUALS));
        view.setFilter(filter);
        ITDParam itdParam = ctx == null ? TDParamFactory.getRemoteInstance() : TDParamFactory.getLocalInstance(ctx);
        TDParamCollection coll = itdParam.getTDParamCollection(view);
        TDParamInfo paramInfo = null;
        if (coll.size() > 0) {
            paramInfo = coll.get(0);
            return paramInfo.getValue();
        }
        return null;
    }

    public static boolean isEqual(Object newValue, Object oldValue) {
        Object[] newValueArr = null;
        newValueArr = newValue instanceof Object[] ? (Object[])newValue : new Object[]{newValue};
        Object[] oldValueArr = null;
        oldValueArr = oldValue instanceof Object[] ? (Object[])oldValue : new Object[]{oldValue};
        if (newValueArr.length != oldValueArr.length) {
            return false;
        }
        if (newValue instanceof String && oldValue instanceof String) {
            return newValue.toString().equals(oldValue.toString());
        }
        if (newValue instanceof CoreBaseInfo && oldValue instanceof CoreBaseInfo) {
            HashMap<String, CoreBaseInfo> oldValueMap = new HashMap<String, CoreBaseInfo>();
            CoreBaseInfo oldValueInfo = null;
            for (int i = 0; i < oldValueArr.length; ++i) {
                oldValueInfo = (CoreBaseInfo)oldValueArr[i];
                if (oldValueInfo == null) continue;
                oldValueMap.put(oldValueInfo.getId().toString(), oldValueInfo);
            }
            HashMap<String, CoreBaseInfo> newValueMap = new HashMap<String, CoreBaseInfo>();
            CoreBaseInfo newValueInfo = null;
            for (int i = 0; i < newValueArr.length; ++i) {
                newValueInfo = (CoreBaseInfo)newValueArr[i];
                if (newValueInfo == null) continue;
                newValueMap.put(newValueInfo.getId().toString(), newValueInfo);
                if (oldValueMap.get(newValueInfo.getId().toString()) != null) continue;
                return false;
            }
            if (oldValueMap.size() != newValueMap.size()) {
                return false;
            }
        } else if (!(newValue instanceof CoreBaseInfo) || !(oldValue instanceof CoreBaseInfo)) {
            return false;
        }
        return true;
    }

    public static boolean objectEquals(Object obj1, Object obj2) {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        if (obj1 instanceof BigDecimal && obj2 instanceof BigDecimal) {
            return ((BigDecimal)obj1).compareTo((BigDecimal)obj2) == 0;
        }
        if (obj1 instanceof CoreBaseInfo && obj2 instanceof CoreBaseInfo) {
            return ((CoreBaseInfo)obj1).getId().toString().equals(((CoreBaseInfo)obj2).getId().toString());
        }
        return obj1.equals(obj2);
    }

    public static List getF7Value(Object value) {
        ArrayList<String> ids;
        block6: {
            block5: {
                ids = new ArrayList<String>();
                if (!(value instanceof CoreBaseInfo)) break block5;
                CoreBaseInfo info = (CoreBaseInfo)value;
                if (info == null) break block6;
                ids.add(info.getId().toString());
                break block6;
            }
            if (value instanceof List) {
                List list = (List)value;
                CoreBaseInfo info2 = null;
                for (CoreBaseInfo info2 : list) {
                    if (info2 == null) continue;
                    ids.add(info2.getId().toString());
                }
            } else if (value instanceof Object[]) {
                Object[] objs = (Object[])value;
                CoreBaseInfo info = null;
                for (int i = 0; i < objs.length; ++i) {
                    info = (CoreBaseInfo)objs[i];
                    if (info == null) continue;
                    ids.add(info.getId().toString());
                }
            }
        }
        return ids;
    }

    public static List getF7ValueObject(Object value) {
        ArrayList<CoreBaseInfo> values;
        block6: {
            block5: {
                values = new ArrayList<CoreBaseInfo>();
                if (!(value instanceof CoreBaseInfo)) break block5;
                CoreBaseInfo info = (CoreBaseInfo)value;
                if (info == null) break block6;
                values.add(info);
                break block6;
            }
            if (value instanceof List) {
                List list = (List)value;
                CoreBaseInfo info2 = null;
                for (CoreBaseInfo info2 : list) {
                    if (info2 == null) continue;
                    values.add(info2);
                }
            } else if (value instanceof Object[]) {
                Object[] objs = (Object[])value;
                CoreBaseInfo info = null;
                for (int i = 0; i < objs.length; ++i) {
                    info = (CoreBaseInfo)objs[i];
                    if (info == null) continue;
                    values.add(info);
                }
            }
        }
        return values;
    }

    public static void checkPermission(Context ctx, String userID, String orgID, String permItemName) throws BOSException, EASBizException {
        IPermission permission = null == ctx ? PermissionFactory.getRemoteInstance() : PermissionFactory.getLocalInstance((Context)ctx);
        String currentUserID = StringUtils.isEmpty((String)userID) ? SysContext.getSysContext().getCurrentUserInfo().getId().toString() : userID;
        String currentCUID = StringUtils.isEmpty((String)orgID) ? SysContext.getSysContext().getCurrentCtrlUnit().getId().toString() : orgID;
        permission.checkFunctionPermission((IObjectPK)new ObjectUuidPK(currentUserID), (IObjectPK)new ObjectUuidPK(currentCUID), permItemName);
    }

    public static boolean hasSameAccountPeriodType(Set ids) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)ids, CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("accountPeriodType.*"));
        view.setSelector(sic);
        CompanyOrgUnitCollection coll = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection(view);
        HashSet<String> accountPeriodTypeIds = new HashSet<String>();
        CompanyOrgUnitInfo company = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            company = coll.get(i);
            accountPeriodTypeIds.add(company.getAccountPeriodType().getId().toString());
        }
        return accountPeriodTypeIds.size() <= 1;
    }

    public static boolean isAuditBill(ReportBaseInfo reportInfo) {
        if (reportInfo instanceof TaxDraftRecordInfo) {
            return String.valueOf(3).equals(reportInfo.get("draftStatus").toString());
        }
        if (reportInfo instanceof TaxOtherReportInfo) {
            return String.valueOf(3).equals(reportInfo.get("state").toString());
        }
        return false;
    }

    public static boolean isDeclaredBill(ReportBaseInfo reportInfo) {
        if (reportInfo instanceof TaxDraftRecordInfo) {
            return String.valueOf(4).equals(reportInfo.get("draftStatus").toString());
        }
        return false;
    }

    public static ReportBaseInfo getReportValue(Context ctx, String reportID, SelectorItemCollection sic) throws BOSException {
        ReportBaseInfo reportInfo = null;
        String bosType = BOSUuid.read((String)reportID).getType().toString();
        boolean reportType = false;
        if ("2A607F02".equals(bosType)) {
            reportType = false;
        } else if ("B4FE5E14".equals(bosType)) {
            reportType = true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)reportID));
        view.setFilter(filter);
        if (!reportType) {
            view.setSelector(sic == null ? TDSelectorFactory.getAllReportSelectors() : sic);
            TaxDraftRecordCollection coll = TaxDraftRecordFactory.getLocalInstance(ctx).getTaxDraftRecordCollection(view);
            if (coll.size() > 0) {
                reportInfo = coll.get(0);
            }
        } else if (reportType) {
            view.setSelector(sic == null ? TaxOtherReportInfo.getSelectors() : sic);
            TaxOtherReportCollection coll = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportCollection(view);
            if (coll.size() > 0) {
                reportInfo = coll.get(0);
            }
        }
        return reportInfo;
    }

    public static OwnerMenuEnum getOwnMenu(TaxItemTypeInfo taxType, RecordTypeEnum recordType) {
        String[] taxes = new String[]{"Xip0em3cA6rgU0ETqMAGKduK96Y=", "Xip0em3dA6rgU0ETqMAGKduK96Y=", "Xip1b7mfPS7gU0ETqMBAL9uK96Y=", "ZCyrvv6mAnPgU0ETqMCc49uK96Y=", "ZCyrvv6nAnPgU0ETqMCc49uK96Y=", "ZCyrvv6oAnPgU0ETqMCc49uK96Y=", "ZCyrvv6pAnPgU0ETqMCc49uK96Y=", "d8umkg7qNn3gU0ETqMCsX9uK96Y="};
        List types = RecordTypeEnum.getEnumList();
        if (map.containsKey(taxType.getId().toString() + recordType.getValue())) {
            return map.get(taxType.getId().toString() + recordType.getValue());
        }
        map.put(taxes[0] + ((RecordTypeEnum)((Object)types.get(0))).getValue(), OwnerMenuEnum.AccountVatTaxDraft);
        map.put(taxes[0] + ((RecordTypeEnum)((Object)types.get(1))).getValue(), OwnerMenuEnum.DraftItemVatTaxDraft);
        map.put(taxes[0] + ((RecordTypeEnum)((Object)types.get(2))).getValue(), OwnerMenuEnum.TaxDeclareVatTaxDraft);
        map.put(taxes[1] + ((RecordTypeEnum)((Object)types.get(0))).getValue(), OwnerMenuEnum.CtAccountTaxDraft);
        map.put(taxes[1] + ((RecordTypeEnum)((Object)types.get(1))).getValue(), OwnerMenuEnum.CtDraftItemTaxDraft);
        map.put(taxes[1] + ((RecordTypeEnum)((Object)types.get(2))).getValue(), OwnerMenuEnum.CtTaxDeclareTaxDraft);
        map.put(taxes[2] + ((RecordTypeEnum)((Object)types.get(0))).getValue(), OwnerMenuEnum.EitAccountTaxDraft);
        map.put(taxes[2] + ((RecordTypeEnum)((Object)types.get(3))).getValue(), OwnerMenuEnum.QuarterlyEitDraftItemTaxDraft);
        map.put(taxes[2] + ((RecordTypeEnum)((Object)types.get(4))).getValue(), OwnerMenuEnum.QuarterlyEitTaxDeclareTaxDraft);
        map.put(taxes[2] + ((RecordTypeEnum)((Object)types.get(5))).getValue(), OwnerMenuEnum.AnnualEitDraftItemTaxDraft);
        map.put(taxes[2] + ((RecordTypeEnum)((Object)types.get(6))).getValue(), OwnerMenuEnum.AnnualEitTaxDeclareTaxFDraft);
        map.put(taxes[3] + ((RecordTypeEnum)((Object)types.get(0))).getValue(), OwnerMenuEnum.StAccountTaxDraft);
        map.put(taxes[3] + ((RecordTypeEnum)((Object)types.get(1))).getValue(), OwnerMenuEnum.StDraftItemTaxDraft);
        map.put(taxes[3] + ((RecordTypeEnum)((Object)types.get(2))).getValue(), OwnerMenuEnum.StTaxDeclareTaxDraft);
        map.put(taxes[4] + ((RecordTypeEnum)((Object)types.get(1))).getValue(), OwnerMenuEnum.AtDraftItemTaxDraft);
        map.put(taxes[4] + ((RecordTypeEnum)((Object)types.get(2))).getValue(), OwnerMenuEnum.AtTaxDeclareTaxDraft);
        map.put(taxes[5] + ((RecordTypeEnum)((Object)types.get(0))).getValue(), OwnerMenuEnum.ErtAccountTaxDraft);
        map.put(taxes[5] + ((RecordTypeEnum)((Object)types.get(1))).getValue(), OwnerMenuEnum.ErtDraftItemTaxDraft);
        map.put(taxes[5] + ((RecordTypeEnum)((Object)types.get(2))).getValue(), OwnerMenuEnum.ErtTaxDeclareTaxDraft);
        map.put(taxes[6] + ((RecordTypeEnum)((Object)types.get(1))).getValue(), OwnerMenuEnum.OtDraftItemTaxDraft);
        map.put(taxes[6] + ((RecordTypeEnum)((Object)types.get(2))).getValue(), OwnerMenuEnum.OtTaxDeclareTaxDraft);
        map.put(taxes[7] + ((RecordTypeEnum)((Object)types.get(0))).getValue(), OwnerMenuEnum.LandAccountTaxDraft);
        map.put(taxes[7] + ((RecordTypeEnum)((Object)types.get(1))).getValue(), OwnerMenuEnum.LandDraftItemTaxDraft);
        map.put(taxes[7] + ((RecordTypeEnum)((Object)types.get(2))).getValue(), OwnerMenuEnum.ErtTaxDeclareTaxDraft);
        return map.get(taxType.getId().toString() + recordType.getValue());
    }

    public static void fillFormula(Context ctx, Sheet sheet, Object value) {
        int row = sheet.getRows().getMaxIntMark() + 1;
        int col = sheet.getCols().getMaxIntMark() + 1;
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, row, col, true, true);
        while (iter.hasNext()) {
            Cell cell = iter.next();
            String formula = cell.getFormula();
            if (StringUtils.isEmpty((String)formula) || formula.length() > 0 && formula.charAt(0) != '=') continue;
            try {
                Expression expr = TDUtils.paserFormula(formula);
                Expression expression = TDUtils.fillFormulaExpression(ctx, expr, value);
                sheet.getRange(cell).setFormula("=" + expression.toString());
            }
            catch (Throwable e) {
                logger.error((Object)("fillFormula error:\n" + e));
            }
        }
    }

    public static Expression paserFormula(String formula) throws BOSException {
        Expression expression = null;
        try {
            expression = ExcelFormulaPaserHelper.parse((String)formula);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
            throw new BOSException((Throwable)e);
        }
        return expression;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Expression fillFormulaExpression(Context ctx, Expression expression, Object value) {
        if (expression instanceof FunctionExpr) {
            FunctionExpr functionExpr = (FunctionExpr)expression;
            IFillFormula fillFormula = FillFormulaFactory.getFillFormula(functionExpr.funcionName);
            if (fillFormula == null) return expression;
            return fillFormula.fillFormulaParameter(ctx, (FunctionExpr)expression, value);
        }
        if (expression instanceof BinaryOperationExpr) {
            Expression expr;
            ((BinaryOperationExpr)expression).left = expr = TDUtils.fillFormulaExpression(ctx, ((BinaryOperationExpr)expression).left, value);
            ((BinaryOperationExpr)expression).right = expr = TDUtils.fillFormulaExpression(ctx, ((BinaryOperationExpr)expression).right, value);
            return expression;
        } else {
            Expression expr;
            if (!(expression instanceof UnaryOperationExpr)) return expression;
            ((UnaryOperationExpr)expression).operand = expr = TDUtils.fillFormulaExpression(ctx, ((UnaryOperationExpr)expression).operand, value);
        }
        return expression;
    }

    public static String toLowerCaseFirstOne(String str) {
        char first = str.charAt(0);
        if (!Character.isLowerCase(first)) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(Character.toLowerCase(first)).append(str.substring(1));
            str = buffer.toString();
        }
        return str;
    }

    public static ICoreBase getReportInterface(Context ctx, String reportID) throws BOSException {
        ITaxDraftRecord corebase = null;
        String bosType = BOSUuid.read((String)reportID).getType().toString();
        if ("2A607F02".equals(bosType)) {
            corebase = ctx != null ? TaxDraftRecordFactory.getLocalInstance(ctx) : TaxDraftRecordFactory.getRemoteInstance();
        } else if ("B4FE5E14".equals(bosType)) {
            corebase = ctx != null ? TaxOtherReportFactory.getLocalInstance(ctx) : TaxDraftRecordFactory.getRemoteInstance();
        }
        return corebase;
    }

    public static SelectorItemCollection getReportFilter(Context ctx, String reportID) throws BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        String bosType = BOSUuid.read((String)reportID).getType().toString();
        if ("2A607F02".equals(bosType)) {
            sic = TDSelectorFactory.getAllReportSelectors();
        } else if ("B4FE5E14".equals(bosType)) {
            sic = TDSelectorFactory.getTaxOtherReportSelectors();
        }
        return sic;
    }

    public static void setMainBizOrgFilter(KDBizPromptBox permMainBizOrg, OrgType mainBizOrgType, String permItem) throws EASBizException, BOSException {
        if (permMainBizOrg != null) {
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            HashSet<String> idset = new HashSet<String>();
            idset.add("111111111111111111111111111=");
            OrgUnitCollection authorizedMainOrgs = TDUtils.getAuthOrgsByType(mainBizOrgType, permItem);
            if (authorizedMainOrgs != null && authorizedMainOrgs.size() > 0) {
                for (int i = 0; i < authorizedMainOrgs.size(); ++i) {
                    OrgUnitInfo orgInfo = authorizedMainOrgs.get(i);
                    if (orgInfo == null || !orgInfo.isIsCompanyOrgUnit() || !orgInfo.getBoolean("isBizUnit")) continue;
                    idset.add(orgInfo.getId().toString());
                }
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("id", idset, CompareType.INCLUDE));
            ev.setFilter(filterInfo);
            permMainBizOrg.setEntityViewInfo(ev);
        }
    }

    protected static OrgUnitCollection getAuthOrgsByType(OrgType orgType, String permitem) throws EASBizException, BOSException {
        return TDFacadeFactory.getRemoteInstance().getAuthOrgsByType(orgType, permitem);
    }

    public static void setPersonAllCU(IUIObject ui, KDBizPromptBox prmtPerson, boolean fMultiSelection, boolean isDisplayName) {
        prmtPerson.setEditable(true);
        prmtPerson.setEditFormat("$number$");
        prmtPerson.setDisplayFormat("$name$");
        if (isDisplayName) {
            prmtPerson.setCommitFormat("$number$;$idNum$;$name$");
        } else {
            prmtPerson.setCommitFormat("$number$;$name$");
        }
        PersonPromptBox selector = new PersonPromptBox(ui);
        selector.setIsSingleSelect(!fMultiSelection);
        prmtPerson.setSelector((KDPromptSelector)selector);
        prmtPerson.setHasCUDefaultFilter(false);
        prmtPerson.setQueryInfo("com.kingdee.eas.basedata.person.app.PersonQuery");
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static String getNewNumber(IObjectValue editData, String companyID) throws BOSException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
        CodingRuleInfo codingRule = iCodingRuleManager.getCodingRule(editData, companyID);
        String number = null;
        if (codingRule != null && codingRule.isIsAddView()) {
            number = iCodingRuleManager.getNumber(editData, companyID);
        }
        return number;
    }

    public static Date parseDate(Object date, int hourOfDay, int minute, int second, int millisecond) throws BOSException {
        Date parseDate = null;
        Calendar calendar = Calendar.getInstance();
        try {
            if (date != null) {
                parseDate = date instanceof Date ? (Date)date : DateTimeUtils.parseDate((String)date.toString());
                calendar.setTime(parseDate);
                calendar.set(11, hourOfDay);
                calendar.set(12, minute);
                calendar.set(13, second);
                calendar.set(14, millisecond);
                parseDate = calendar.getTime();
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return parseDate;
    }

    public static String cutStr(String strs, int length) throws BOSException {
        String finalStr;
        block4: {
            int sum = 0;
            finalStr = "";
            try {
                if (null == strs || strs.getBytes("GBK").length <= length) {
                    finalStr = strs == null ? "" : strs;
                    break block4;
                }
                for (int i = 0; i < strs.length(); ++i) {
                    String str = strs.substring(i, i + 1);
                    if ((sum += str.getBytes("GBK").length) <= length) continue;
                    finalStr = strs.substring(0, i);
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException((Throwable)e);
            }
        }
        return finalStr;
    }
}

