/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.engine.interfaces.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.tm.td.account.engine.interfaces.impl.AbstractAccountSQLBuilder;
import com.kingdee.eas.tm.td.account.engine.model.AccountCalculatorParams;
import com.kingdee.eas.tm.td.basedata.AccountConfigInfo;
import com.kingdee.eas.tm.td.basedata.DataFilterTypeEnum;
import com.kingdee.eas.tm.td.basedata.TakeDataContditionInfo;
import com.kingdee.eas.tm.td.utils.CollectionUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.Set;

public class DefaultAccountSQLBuilder
extends AbstractAccountSQLBuilder {
    public DefaultAccountSQLBuilder(Context ctx, AccountConfigInfo accountConfigInfo, TakeDataContditionInfo conditionInfo, AccountCalculatorParams params) {
        super(ctx, accountConfigInfo, conditionInfo, params);
    }

    @Override
    protected FilterInfo getExtendFilter() throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.mergeFilter(this.getOrgFilter(), "AND");
        filter.mergeFilter(this.getGroupOrgFilter(), "AND");
        filter.mergeFilter(this.getDateFilter(), "AND");
        return filter;
    }

    protected FilterInfo getOrgFilter() throws EASBizException, BOSException {
        FilterInfo filter = null;
        StringBuffer orgFilter = new StringBuffer();
        Set numberSet = this.getOrgNumberSet();
        if (this.conditionInfo.getOrgField() != null) {
            if (numberSet.size() > 0) {
                orgFilter.append(this.conditionInfo.getOrgField()).append(" IN ");
                orgFilter.append("(").append(CollectionUtil.convertSet2String(numberSet, ",", true)).append(")");
            } else {
                orgFilter.append(this.conditionInfo.getOrgField()).append(" IN ");
                orgFilter.append("('").append(this.params.getCompanyID()).append("')");
            }
            try {
                filter = new FilterInfo(orgFilter.toString());
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return filter;
    }

    protected FilterInfo getGroupOrgFilter() throws EASBizException, BOSException {
        FilterInfo filter = null;
        StringBuffer orgFilter = new StringBuffer();
        if (this.conditionInfo.getGroupOrgField() != null) {
            orgFilter.append(this.conditionInfo.getGroupOrgField()).append(" IN ");
            orgFilter.append("('").append(this.params.getGroupID()).append("')");
            try {
                filter = new FilterInfo(orgFilter.toString());
            }
            catch (ParserException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return filter;
    }

    protected FilterInfo getDateFilter() throws EASBizException, BOSException {
        FilterInfo filter = null;
        StringBuffer dateFilter = new StringBuffer();
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.BizDate)) {
            dateFilter.append(" (").append(this.conditionInfo.getBizDateField()).append(" >= {ts'").append(sf.format(this.params.getStartDate())).append(" 00:00:00'}");
            dateFilter.append(" and ").append(this.conditionInfo.getBizDateField()).append(" <= {ts'").append(sf.format(this.params.getEndDate())).append(" 23:59:59'})");
        } else if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.PeriodID) && this.params.getPeriodID() != null) {
            String periodFromID = (String)this.params.get("periodFromID");
            String periodToID = (String)this.params.get("periodToID");
            String periodIdstr = null;
            if (periodFromID != null && periodFromID != null) {
                PeriodInfo periodFrom = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodFromID));
                PeriodInfo periodTo = PeriodFactory.getLocalInstance((Context)this.ctx).getPeriodInfo((IObjectPK)new ObjectUuidPK(periodToID));
                StringBuffer periodSql = new StringBuffer();
                periodSql.append(" select fid  FROM T_BD_Period WHERE fnumber>=").append(periodFrom.getNumber()).append(" and fnumber<=").append(periodTo.getNumber());
                IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)periodSql.toString(), null);
                HashSet<String> periodIds = new HashSet<String>();
                try {
                    while (rs.next()) {
                        periodIds.add(rs.getString("fid"));
                    }
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
                periodIdstr = CollectionUtil.convertSet2String(periodIds, ",", true);
                dateFilter.append(" ").append(this.conditionInfo.getPeriodIdField()).append(" in (").append(periodIdstr).append(")");
            } else if (this.params.getPeriodID() != null) {
                dateFilter.append(" ").append(this.conditionInfo.getPeriodIdField()).append(" = '").append(this.params.getPeriodID()).append("'");
            }
        } else if (this.conditionInfo.getDateFilterType().equals((Object)DataFilterTypeEnum.YearAndMonth)) {
            dateFilter.append(" (").append(this.conditionInfo.getPeriodYear()).append(" = ").append(this.params.getYear());
            dateFilter.append(" and ").append(this.conditionInfo.getPeriodMonth()).append(" = ").append(this.params.getPeriod()).append(")");
        }
        try {
            filter = new FilterInfo(dateFilter.toString());
        }
        catch (ParserException e) {
            throw new BOSException((Throwable)e);
        }
        return filter;
    }

    private Set getOrgNumberSet() throws BOSException {
        HashSet numberSet = new HashSet();
        String orgTreeID = (String)this.params.get("orgTreeID");
        if (!StringUtils.isEmpty((String)orgTreeID)) {
            return this.getCompanyOrgIDByParam(this.ctx, orgTreeID);
        }
        return numberSet;
    }

    private Set getCompanyOrgIDByParam(Context ctx, String orgTreeID) throws BOSException {
        HashSet<String> ids = new HashSet<String>();
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT t2.FUNITID orgUnitID FROM T_ORG_Tree t1  ");
        sb.append(" inner join T_ORG_Structure   t2 on t1.FID  = t2.FTREEID  ");
        sb.append(" inner join T_ORG_COMPANY t3 on t2.FUNITID  = t3.FID ");
        sb.append(" where t1.fid = '").append(orgTreeID).append("'");
        IRowSet rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        try {
            while (rs.next()) {
                ids.add(rs.getString("orgUnitID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return ids;
    }

    public SelectorItemCollection getOrgSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("condition.*"));
        sic.add(new SelectorItemInfo("orgUnit.*"));
        return sic;
    }
}

