/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.engine.util;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.MetaDataTypeList;
import com.kingdee.bos.metadata.resource.BizEnumInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueType;
import com.kingdee.eas.scm.framework.balance.BalanceModelException;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.tm.td.basedata.AccountConfigEntryInfo;
import com.kingdee.eas.tm.td.basedata.DataTypeEnum;

public class AccountUtil {
    public static String getDataTypeStr(Context ctx, AccountConfigEntryInfo fieldInfo) throws BalanceModelException {
        String dataType = "";
        int length = fieldInfo.getLength();
        if (fieldInfo.getDataType().equals((Object)DataTypeEnum.String)) {
            dataType = "Varchar(" + (fieldInfo.getLength() == 0 ? 255 : fieldInfo.getLength()) + ")";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Integer)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Date) || fieldInfo.getDataType().equals((Object)DataTypeEnum.Timestamp)) {
            dataType = "DateTime";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Boolean)) {
            dataType = "Int";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Qty)) {
            dataType = "Numeric(21, 8)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Amount)) {
            dataType = "Numeric(17, 4)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Price)) {
            dataType = "Numeric(21, 8)";
        } else if (fieldInfo.getDataType().equals((Object)DataTypeEnum.Enum)) {
            String eClassName = fieldInfo.getBaseDataBOSType();
            IMetaDataLoader loader = null;
            loader = ctx == null ? MetaDataLoaderFactory.getRemoteMetaDataLoader() : MetaDataLoaderFactory.getLocalMetaDataLoader((Context)ctx);
            BizEnumInfo bizEnum = (BizEnumInfo)loader.get(MetaDataTypeList.BIZENUM, (IMetaDataPK)MetaDataPK.create((String)eClassName));
            if (bizEnum == null) {
                throw new BalanceModelException(BalanceModelException.DATATYPEISINVALID);
            }
            if (BizEnumValueType.INTEGER.equals((Object)bizEnum.getDataType())) {
                dataType = "Int";
            } else if (BizEnumValueType.STRING.equals((Object)bizEnum.getDataType())) {
                dataType = "Varchar(100)";
            }
        } else {
            throw new BalanceModelException(BalanceModelException.DATATYPEISINVALID);
        }
        return dataType;
    }

    public static String getDefaultValueSQL(AccountConfigEntryInfo entryInfo, boolean isCreateSQL) {
        String defaultValue = "";
        if (StringUtil.isEmpty((String)entryInfo.getDefaultValue())) {
            return defaultValue;
        }
        if (entryInfo.getDataType().equals((Object)DataTypeEnum.String)) {
            defaultValue = "'" + entryInfo.getDefaultValue() + "'";
        } else if (entryInfo.getDataType().equals((Object)DataTypeEnum.Date)) {
            defaultValue = "{ts'" + entryInfo.getDefaultValue() + "'}";
        } else if (entryInfo.getDataType().equals((Object)DataTypeEnum.Integer) || entryInfo.getDataType().equals((Object)DataTypeEnum.Boolean) || entryInfo.getDataType().equals((Object)DataTypeEnum.Qty) || entryInfo.getDataType().equals((Object)DataTypeEnum.Price) || entryInfo.getDataType().equals((Object)DataTypeEnum.Amount)) {
            defaultValue = entryInfo.getDefaultValue();
        } else if (entryInfo.getDataType().equals((Object)DataTypeEnum.Enum)) {
            defaultValue = entryInfo.getDefaultValue();
        }
        if (isCreateSQL) {
            return "default " + defaultValue;
        }
        return defaultValue;
    }

    public static boolean isEmpty(String str) {
        return null == str || str.trim().length() == 0;
    }

    public static boolean isEmpty(Object[] arr) {
        return null == arr || arr.length == 0;
    }
}

