/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.account.formula;

import com.kingdee.eas.tm.td.account.formula.AccountFormulaColumnParams;
import com.kingdee.eas.tm.td.account.formula.FormulaHelper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AccountFormulaComparable
implements Comparator<Object[]> {
    private List<AccountFormulaColumnParams> sortColumns = null;
    private List<AccountFormulaColumnParams> dataColumns = null;
    private Map<String, Integer> columnIndex = new HashMap<String, Integer>();

    public AccountFormulaComparable(List<AccountFormulaColumnParams> sortColumns, List<AccountFormulaColumnParams> dataColumns) {
        this.sortColumns = sortColumns;
        this.dataColumns = dataColumns;
        this.initColumnIndex();
    }

    private void initColumnIndex() {
        AccountFormulaColumnParams column = null;
        int size = this.sortColumns.size();
        for (int i = 0; i < size; ++i) {
            column = this.sortColumns.get(i);
            this.columnIndex.put(column.getName(), FormulaHelper.getColumnIndex(this.dataColumns, column));
        }
    }

    @Override
    public int compare(Object[] o1, Object[] o2) {
        return this.recursion(o1, o2, 0);
    }

    private int recursion(Object[] o1, Object[] o2, int i) {
        AccountFormulaColumnParams column = this.sortColumns.get(i);
        int index = this.columnIndex.get(column.getName());
        Object value1 = o1[index];
        Object value2 = o2[index];
        if (value1 == null && value2 == null) {
            if (i + 1 < this.sortColumns.size()) {
                int recursion = this.recursion(o1, o2, i + 1);
                return recursion;
            }
            return 0;
        }
        if (value1 == null && value2 != null) {
            return column.getSortType() == 1 ? 1 : -1;
        }
        if (value1 != null && value2 == null) {
            return column.getSortType() == 1 ? -1 : 1;
        }
        if (value1.equals(value2)) {
            if (i + 1 < this.sortColumns.size()) {
                return this.recursion(o1, o2, i + 1);
            }
            return 0;
        }
        if (column.getSortType() == 1) {
            return value1.toString().compareTo(value2.toString());
        }
        return value2.toString().compareTo(value1.toString());
    }
}

