/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.basedata.DraftItemCollection;
import com.kingdee.eas.tm.td.basedata.DraftItemFactory;
import com.kingdee.eas.tm.td.basedata.DraftItemInfo;
import com.kingdee.eas.tm.td.basedata.DraftItemStatus;
import com.kingdee.eas.tm.td.basedata.IDraftItem;
import com.kingdee.eas.tm.td.basedata.IOrgToDraftItem;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemFactory;
import com.kingdee.eas.tm.td.basedata.OrgToDraftItemInfo;
import com.kingdee.eas.tm.td.basedata.TaxItemTypeInfo;
import com.kingdee.eas.tools.datatask.AbstractDataTransmission;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Map;

public class DraftItemDatasImport
extends AbstractDataTransmission {
    String relationFid = null;

    public void submit(CoreBaseInfo coreBaseInfo, Context ctx) throws TaskExternalException {
        if (coreBaseInfo == null || !(coreBaseInfo instanceof DraftItemInfo)) {
            return;
        }
        try {
            DraftItemInfo bill = (DraftItemInfo)coreBaseInfo;
            bill.setTaxItemType((TaxItemTypeInfo)this.getContextParameter().get("taxItemTypeInfo"));
            String id = this.getIdFromNumber(ctx, bill.getNumber());
            IDraftItem iDraftItem = (IDraftItem)this.getController(ctx);
            IOrgToDraftItem iOrgToDraftItem = OrgToDraftItemFactory.getLocalInstance(ctx);
            if (StringUtil.isEmptyString((String)id)) {
                OrgToDraftItemInfo orgToDraftItemInfo = new OrgToDraftItemInfo();
                orgToDraftItemInfo.setOrgUnit(bill.getCU());
                orgToDraftItemInfo.setTaxTypeItem(bill.getTaxItemType());
                orgToDraftItemInfo.setState(bill.getIsAwaken());
                iDraftItem.addnew(coreBaseInfo);
                DraftItemCollection col = this.getDraftItemCollection(ctx, bill.getNumber());
                if (col != null && col.size() > 0) {
                    orgToDraftItemInfo.setDraftItem(col.get(0));
                    iOrgToDraftItem.addnew(orgToDraftItemInfo);
                }
            } else {
                ObjectUuidPK pk = new ObjectUuidPK(this.relationFid);
                OrgToDraftItemInfo orgToDraftItemInfo = (OrgToDraftItemInfo)iOrgToDraftItem.getValue((IObjectPK)pk);
                orgToDraftItemInfo.setOrgUnit(bill.getCU());
                orgToDraftItemInfo.setTaxTypeItem(bill.getTaxItemType());
                orgToDraftItemInfo.setState(bill.getIsAwaken());
                iOrgToDraftItem.update((IObjectPK)pk, orgToDraftItemInfo);
                iDraftItem.delete((IObjectPK)new ObjectUuidPK(id));
                iDraftItem.addnew(coreBaseInfo);
            }
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), ex.getCause());
        }
    }

    private String getIdFromNumber(Context ctx, String number) throws TaskExternalException {
        DraftItemCollection collection;
        try {
            collection = DraftItemFactory.getLocalInstance(ctx).getDraftItemCollection("where number='" + number + "'");
        }
        catch (BOSException e) {
            return null;
        }
        if (collection != null && collection.size() > 0) {
            return collection.get(0).getId().toString();
        }
        return null;
    }

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return DraftItemFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException(bex.getMessage(), (Throwable)bex);
        }
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        DraftItemInfo draftItemInfo = new DraftItemInfo();
        try {
            draftItemInfo = this.doNumber(hsData, ctx, draftItemInfo);
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        this.doDraftItemName(hsData, ctx, draftItemInfo);
        this.doDraftItemIsAwaken(hsData, ctx, draftItemInfo);
        this.doDraftItemDesc(hsData, ctx, draftItemInfo);
        try {
            this.doDraftItemCU(hsData, ctx, draftItemInfo);
        }
        catch (BOSException e) {
            throw new TaskExternalException(e.getMessage(), e.getCause());
        }
        return draftItemInfo;
    }

    private void doDraftItemDesc(Hashtable hsData, Context ctx, DraftItemInfo draftItemInfo) throws TaskExternalException {
        String description = this.getCellStr(hsData, "FDescription_l2");
        if (!"".equals(description)) {
            if (description.trim().length() > 255) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Desc_TooLong", ctx.getLocale()));
            }
            draftItemInfo.setDescription(description);
        }
    }

    private void doDraftItemCU(Hashtable hsData, Context ctx, DraftItemInfo draftItemInfo) throws BOSException, TaskExternalException {
        String cuNum = this.getCellStr(hsData, "FCU_number");
        if (!"".equals(cuNum)) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("number", (Object)cuNum, CompareType.EQUALS));
            view.setFilter(filter);
            CtrlUnitCollection cuCol = CtrlUnitFactory.getLocalInstance((Context)ctx).getCtrlUnitCollection(view);
            if (cuCol == null || cuCol.size() == 0) {
                throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "CU_NotExist", ctx.getLocale()));
            }
            CtrlUnitInfo info = cuCol.get(0);
            draftItemInfo.setCU(info);
        }
    }

    private void doDraftItemIsAwaken(Hashtable hsData, Context ctx, DraftItemInfo draftItemInfo) throws TaskExternalException {
        String str = this.getCellStr(hsData, "FIsAwaken");
        DraftItemStatus isAwaken = DraftItemStatus.getEnum(str.toString().trim());
        if (isAwaken == null) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Status_Invalid", ctx.getLocale()));
        }
        if (str != null && !"".equals(str)) {
            draftItemInfo.setIsAwaken(isAwaken);
        }
    }

    private void doDraftItemName(Hashtable hsData, Context ctx, DraftItemInfo draftItemInfo) throws TaskExternalException {
        Object o = ((DataToken)hsData.get((Object)"FName_l2")).data;
        String name = "";
        if (o == null || o.toString().trim().length() == 0) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Name_NotNull", ctx.getLocale()));
        }
        name = o.toString().trim();
        if (name.length() > 255) {
            throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Name_TooLong", ctx.getLocale()));
        }
        draftItemInfo.setName(name);
    }

    private DraftItemInfo doNumber(Hashtable hsData, Context ctx, DraftItemInfo draftItemInfo) throws TaskExternalException, EASBizException, BOSException {
        Object number = ((DataToken)hsData.get((Object)"FNumber")).data;
        if (number != null && number.toString().trim().length() > 0) {
            draftItemInfo.setNumber(number.toString().trim());
            DraftItemCollection draftItemCol = this.getDraftItemCollection(ctx, number.toString().trim());
            if (!this.isSltImportUpdate()) {
                if (draftItemCol.size() > 0) {
                    String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Number_HasExist", ctx.getLocale());
                    throw new TaskExternalException(number.toString().trim() + "  " + str);
                }
            } else {
                block10: {
                    if (draftItemCol.size() == 0) {
                        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Bill_NotExist", ctx.getLocale()));
                    }
                    DraftItemInfo info = draftItemCol.get(0);
                    StringBuffer sql = new StringBuffer();
                    sql.append(" SELECT relation.fid as fid, relation.fstate as state FROM t_tm_draftitem draft ");
                    sql.append(" left join t_tm_orgtodraftitem relation on draft.fid = relation.FDRAFTITEMID ");
                    sql.append(" where draft.fid = '").append(info.getId().toString()).append("' ");
                    sql.append(" and relation.FTAXTYPEITEMID = '").append(((TaxItemTypeInfo)this.getContextParameter().get("taxItemTypeInfo")).getId().toString()).append("' ");
                    IRowSet result = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
                    try {
                        if (result.next()) {
                            this.relationFid = result.getString("fid");
                            if (!"0".equals(result.getString("state"))) {
                                String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "OnlySaveCanImport", ctx.getLocale());
                                throw new TaskExternalException(number.toString().trim() + "  " + str);
                            }
                            break block10;
                        }
                        throw new TaskExternalException(TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Bill_NotExist", ctx.getLocale()));
                    }
                    catch (SQLException e) {
                        throw new TaskExternalException(number.toString().trim() + TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "OnlySaveCanImport", ctx.getLocale()));
                    }
                }
                draftItemInfo = draftItemCol.get(0);
            }
        } else {
            String str = TDUtils.getString("com.kingdee.eas.tm.td.basedata.DraftItemImportResource", "Number_NotNull", ctx.getLocale());
            throw new TaskExternalException(str);
        }
        return draftItemInfo;
    }

    private DraftItemCollection getDraftItemCollection(Context ctx, String number) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        view.setFilter(filter);
        DraftItemCollection coll = DraftItemFactory.getLocalInstance(ctx).getDraftItemCollection(view);
        return coll;
    }

    public Map exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable<String, String> result = new Hashtable<String, String>();
        try {
            result.put("FNumber", this.transformValue(rs.getString("number")));
            result.put("FName_l2", this.transformValue(rs.getString("name")));
            if (!StringUtils.isEmpty((String)this.transformValue(rs.getString("relation.state")))) {
                String statusValue = this.transformValue(rs.getString("relation.state"));
                DraftItemStatus status = DraftItemStatus.getEnum(statusValue);
                if (status != null) {
                    result.put("FIsAwaken", status.getAlias());
                }
            } else {
                result.put("FIsAwaken", "");
            }
            result.put("FTaxItemType_number", this.transformValue(rs.getString("taxItemType.number")));
            result.put("FTaxItemType_name_l2", this.transformValue(rs.getString("taxItemType.name")));
            result.put("FCU_number", this.transformValue(rs.getString("unit.number")));
            result.put("FCU_name_l2", this.transformValue(rs.getString("unit.name")));
            result.put("FDescription_l2", this.transformValue(rs.getString("description")));
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private String getCellStr(Hashtable hsData, String cellName) {
        String retval = "";
        Object o = ((DataToken)hsData.get((Object)cellName)).data;
        if (o != null && !"".equals(o.toString())) {
            retval = o.toString();
        }
        return retval;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.tm.td.basedata.app.DraftItemCuQuery";
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filter = new FilterInfo();
        if (this.getContextMap().get("filter") != null) {
            String filterStr = this.getContextMap().get("filter").toString();
            filterStr = filterStr.replace("$", "'");
            try {
                filter = new FilterInfo(filterStr);
            }
            catch (ParserException e) {
                Logger.error((Throwable)e);
            }
            return filter;
        }
        return super.getExportFilterForQuery(ctx);
    }

    public String transformValue(Object value) {
        if (value == null) {
            return "";
        }
        return value.toString();
    }
}

