/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.tm.td.ProcessStatusEnum;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TaxAlertItemFactory;
import com.kingdee.eas.tm.td.TaxAlertItemInfo;
import com.kingdee.eas.tm.td.app.AbstractTaxAlertItemControllerBean;
import com.kingdee.eas.tm.td.cloud.TDCloudException;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaxAlertItemControllerBean
extends AbstractTaxAlertItemControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.TaxAlertItemControllerBean");

    public Result save(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        if (colls == null || colls.size() == 0) {
            return null;
        }
        TaxAlertItemInfo tempValue = (TaxAlertItemInfo)colls.getObject(0);
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("rptId", (Object)tempValue.getRptId());
        this._delete(ctx, filter);
        int size = colls.size();
        Date now = new Date();
        CompanyOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < size; ++i) {
            TaxAlertItemInfo info = (TaxAlertItemInfo)colls.getObject(i);
            String companyNumber = info.getDescription();
            orgUnitInfo = this.getCompanyUnitByNumber(ctx, companyNumber);
            if (orgUnitInfo == null) continue;
            info.setCompanyOrgUnit(orgUnitInfo);
            info.setBizDate(now);
            info.setProcessStatus(ProcessStatusEnum.UNDO);
            this.buildBillForDep(ctx, info, "3ED1F354");
            try {
                this._save(ctx, (IObjectValue)info);
                continue;
            }
            catch (Exception e) {
                throw new TDException(TDException.CONFIRM_SAVE_ERROR, new Object[]{i + 1});
            }
        }
        return null;
    }

    protected void _cancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxAlertItemInfo info = TaxAlertItemFactory.getLocalInstance(ctx).getTaxAlertItemInfo(pk);
        this.checkBeforeCancel(ctx, info);
        info.setProcessStatus(ProcessStatusEnum.UNDO);
        super._update(ctx, pk, (IObjectValue)info);
    }

    protected void _cancelCancel(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxAlertItemInfo info = TaxAlertItemFactory.getLocalInstance(ctx).getTaxAlertItemInfo(pk);
        this.checkBeforeCancelCancel(ctx, info);
        info.setProcessStatus(ProcessStatusEnum.DONE);
        super._update(ctx, pk, (IObjectValue)info);
    }

    private void checkBeforeCancel(Context ctx, TaxAlertItemInfo info) throws BOSException, EASBizException {
        if (!ProcessStatusEnum.DONE.equals((Object)info.getProcessStatus())) {
            throw new TDCloudException(TDCloudException.ALARM_UNDO);
        }
    }

    private void checkBeforeCancelCancel(Context ctx, TaxAlertItemInfo info) throws BOSException, EASBizException {
        if (ProcessStatusEnum.DONE.equals((Object)info.getProcessStatus())) {
            throw new TDCloudException(TDCloudException.ALARM_DO);
        }
    }
}

