/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.metadata.bot.BOTRelationCollection;
import com.kingdee.bos.metadata.bot.BOTRelationInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.botp.BOTBillOperStateEnum;
import com.kingdee.eas.base.dap.DAPTransformerFactory;
import com.kingdee.eas.base.dap.IDAPTransformer;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.fi.gl.BaseVoucherInfo;
import com.kingdee.eas.fi.gl.IVoucher;
import com.kingdee.eas.fi.gl.VoucherFactory;
import com.kingdee.eas.fi.gl.VoucherInfo;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TaxDraftConfirmBillInfo;
import com.kingdee.eas.tm.td.account.engine.util.KsqlUtil;
import com.kingdee.eas.tm.td.app.AbstractTaxDraftConfirmBillControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class TaxDraftConfirmBillControllerBean
extends AbstractTaxDraftConfirmBillControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.TaxDraftConfirmBillControllerBean");

    public Result save(Context ctx, CoreBaseCollection colls) throws BOSException, EASBizException {
        if (colls == null || colls.size() == 0) {
            return null;
        }
        TaxDraftConfirmBillInfo tempValue = (TaxDraftConfirmBillInfo)colls.getObject(0);
        String draftRecordID = tempValue.getRptId();
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("rptId", (Object)draftRecordID);
        this._delete(ctx, filter);
        int size = colls.size();
        Date now = new Date();
        CompanyOrgUnitInfo orgUnitInfo = null;
        for (int i = 0; i < size; ++i) {
            TaxDraftConfirmBillInfo info = (TaxDraftConfirmBillInfo)colls.getObject(i);
            String companyNumber = info.getDescription();
            orgUnitInfo = this.getCompanyUnitByNumber(ctx, companyNumber);
            if (orgUnitInfo == null) {
                throw new TDException(TDException.NULLORG_SAVE_ERROR, new Object[]{i + 1});
            }
            info.setCompanyOrgUnit(orgUnitInfo);
            info.setBizDate(now);
            this.buildBillForDep(ctx, info, "D7EA12D6");
            try {
                this._save(ctx, (IObjectValue)info);
                continue;
            }
            catch (Exception e) {
                throw new TDException(TDException.CONFIRM_SAVE_ERROR, new Object[]{i + 1});
            }
        }
        return null;
    }

    protected boolean _deleteVoucher(Context ctx, IObjectPK sourceBillPk) throws BOSException, EASBizException {
        String billID = sourceBillPk.toString();
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT FRptID FROM T_TD_TaxDraftConfirmBill WHERE fid = ?");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billID});
        String rptID = null;
        try {
            if (rs.next()) {
                rptID = rs.getString("FRptID");
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        String bosType = BOSUuid.read(rptID).getType().toString();
        String reportTblName = null;
        if ("2A607F02".equals(bosType)) {
            reportTblName = "T_TD_TaxDraftRecord";
        } else if ("B4FE5E14".equals(bosType)) {
            reportTblName = "T_TD_TaxOtherReport";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(" SELECT t2.fvoucherid as voucherID FROM T_TD_TaxDraftConfirmBill t1 inner join " + reportTblName + " t2 on t1.frptid =  t2.fid ");
        sb.append(" where t1.fid = '").append(billID).append("'");
        rs = DBUtil.executeQuery((Context)ctx, (String)sb.toString(), null);
        String voucherID = null;
        try {
            if (rs.next()) {
                voucherID = rs.getString("voucherID");
            }
        }
        catch (SQLException e) {
            new BOSException((Throwable)e);
        }
        if (voucherID == null) {
            return false;
        }
        ObjectStringPK vpk = new ObjectStringPK(voucherID);
        IVoucher iVoucher = VoucherFactory.getLocalInstance((Context)ctx);
        VoucherInfo voucher = (VoucherInfo)iVoucher.getBillBaseInfo((IObjectPK)vpk);
        iVoucher.delete((IObjectPK)vpk);
        IDAPTransformer dapTransformer = DAPTransformerFactory.getLocalInstance((Context)ctx);
        dapTransformer.undoTransformFromVoucher((BaseVoucherInfo)voucher);
        return true;
    }

    protected void _reverseSave(Context ctx, IObjectPK srcBillPK, IObjectValue srcBillVO, BOTBillOperStateEnum bOTBillOperStateEnum, IObjectValue bOTRelationInfo) throws BOSException, EASBizException {
        BOTRelationInfo botRelation = (BOTRelationInfo)bOTRelationInfo;
        if (new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            CoreBillBaseCollection srcBillVOs = new CoreBillBaseCollection();
            srcBillVOs.addObject(srcBillVO);
            BOTRelationCollection botRelationInfos = new BOTRelationCollection();
            botRelationInfos.add(botRelation);
            this._batchReverseSave(ctx, new IObjectPK[]{srcBillPK}, srcBillVOs, bOTBillOperStateEnum, botRelationInfos);
        }
    }

    protected void _batchReverseSave(Context ctx, IObjectPK[] srcBillPKs, CoreBillBaseCollection srcBillVOs, BOTBillOperStateEnum bOTBillOperStateEnum, BOTRelationCollection bOTRelationInfos) throws BOSException, EASBizException {
        long t1 = System.currentTimeMillis();
        logger.debug((Object)("bOTRelationInfos.length:" + bOTRelationInfos.size()));
        if (bOTRelationInfos.size() < 1) {
            return;
        }
        BOTRelationInfo botRelation = bOTRelationInfos.get(0);
        logger.debug((Object)("botRelation.destEntityId:" + botRelation.getDestEntityID()));
        logger.debug((Object)("botRelation.srcEntityId:" + botRelation.getSrcEntityID()));
        if (!new VoucherInfo().getBOSType().toString().equals(botRelation.getDestEntityID())) {
            return;
        }
        try {
            String reportTblName = null;
            StringBuffer sql = new StringBuffer();
            if (bOTRelationInfos.size() > 0) {
                String bosType;
                String billID = bOTRelationInfos.get(0).getSrcObjectID();
                sql.append(" SELECT FRptID FROM T_TD_TaxDraftConfirmBill WHERE fid = ?");
                IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])new Object[]{billID});
                String rptID = null;
                if (rs.next()) {
                    rptID = rs.getString("FRptID");
                }
                if ("2A607F02".equals(bosType = BOSUuid.read(rptID).getType().toString())) {
                    reportTblName = "T_TD_TaxDraftRecord";
                } else if ("B4FE5E14".equals(bosType)) {
                    reportTblName = "T_TD_TaxOtherReport";
                }
            }
            if (BOTBillOperStateEnum.DELETE.equals((Object)bOTBillOperStateEnum)) {
                StringBuffer sqlin = new StringBuffer();
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    if (i != 0) {
                        sqlin.append(",");
                    }
                    sqlin.append("'").append(bOTRelationInfos.get(i).getSrcObjectID()).append("'");
                }
                sql.setLength(0);
                sql.append(" update  " + reportTblName + " myRecord set FIsVoucher = 0 , FVoucherID = null,FVoucherNumber = null,FVoucherType = null");
                sql.append(" where exists ( ");
                sql.append(" select 1 from " + reportTblName + " record ");
                sql.append(" inner join T_TD_TaxDraftConfirmBill confirm on record.fid = confirm.FRptID");
                sql.append(" where record.fid = myRecord.fid and confirm.fid in (").append(sqlin).append("))");
                String sqlStr = sql.toString();
                DbUtil.execute((Context)ctx, (String)sqlStr);
            } else {
                StringBuffer createSql = new StringBuffer();
                String tempTableName = null;
                createSql.append("create table temptable ( FDestBillID varchar(44),FSrcBillID varchar(44),FVoucherNumber varchar(88),FVoucherType nvarchar(255) ); ");
                tempTableName = KsqlUtil.createTempTableWithNewTx(ctx, createSql.toString());
                String[] insertSqls = new String[bOTRelationInfos.size()];
                StringBuffer insertSql = new StringBuffer();
                int size = bOTRelationInfos.size();
                for (int i = 0; i < size; ++i) {
                    String destBillId = bOTRelationInfos.get(i).getDestObjectID();
                    String srcBillId = bOTRelationInfos.get(i).getSrcObjectID();
                    insertSql.append(" insert into ").append(tempTableName).append("(FDestBillID,FSrcBillID) values ('").append(destBillId).append("','").append(srcBillId).append("');");
                    insertSqls[i] = insertSql.toString();
                    insertSql.setLength(0);
                }
                DBUtil.executeBatch((Context)ctx, (String[])insertSqls);
                StringBuffer updateSql = new StringBuffer();
                updateSql.append(" update " + reportTblName + " as taxrecord set (FIsVoucher,FVoucherID,FVoucherNumber,FVoucherType) = (");
                updateSql.append(" select 1,t1.fid,t1.fnumber,t2.FNAME_l2 as voucherType from T_GL_Voucher t1 ");
                updateSql.append(" inner join T_BD_VoucherTypes t2 on t1.fvouchertypeid = t2.fid ");
                updateSql.append(" inner join ").append(tempTableName).append(" temp on t1.fid = temp.FDestBillID");
                updateSql.append(" inner join T_TD_TaxDraftConfirmBill bill on bill.fid = temp.FSrcBillID ");
                updateSql.append(" inner join " + reportTblName + "  record on record.fid = bill.FRptID where taxrecord.fid = record.fid)");
                DBUtil.executeUpdate((Context)ctx, (String)updateSql.toString(), null);
                KsqlUtil.releaseTempTable(ctx, tempTableName);
            }
        }
        catch (BOSException sqle) {
            throw new BOSException((Throwable)sqle);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        logger.debug((Object)("batchReverseSave spent:" + (System.currentTimeMillis() - t1) + "ms"));
    }
}

