/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.core.util.DateUtil;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.tm.td.TDException;
import com.kingdee.eas.tm.td.TDFacadeFactory;
import com.kingdee.eas.tm.td.TDUtils;
import com.kingdee.eas.tm.td.TaxDraftConfirmBillFactory;
import com.kingdee.eas.tm.td.TaxDraftConfirmBillInfo;
import com.kingdee.eas.tm.td.TaxOtherReportCollection;
import com.kingdee.eas.tm.td.TaxOtherReportFactory;
import com.kingdee.eas.tm.td.TaxOtherReportInfo;
import com.kingdee.eas.tm.td.TaxReportStatusEnum;
import com.kingdee.eas.tm.td.app.AbstractTaxOtherReportControllerBean;
import com.kingdee.eas.tm.td.app.util.TDServerUtils;
import com.kingdee.eas.tm.td.utils.LogUtils;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class TaxOtherReportControllerBean
extends AbstractTaxOtherReportControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.app.TaxOtherReportControllerBean");

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkForSave(ctx, model);
        this.checkNumberDup(ctx, model);
        IObjectPK pk = super._save(ctx, model);
        return pk;
    }

    protected void checkNumberDup(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem = new FilterItemInfo("number", (Object)info.getNumber(), CompareType.EQUALS);
        filter.getFilterItems().add(filterItem);
        if (info.getId() != null) {
            filterItem = new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS);
            filter.getFilterItems().add(filterItem);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String number = TDUtils.getString("com.kingdee.eas.tm.td.TDCommonResource", "Number", ctx.getLocale()) + " : " + info.getNumber();
            throw new EASBizException(EASBizException.CHECKDUPLICATED, new Object[]{number});
        }
    }

    protected void checkForSave(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        if (!TaxReportStatusEnum.SAVE.equals((Object)info.getState())) {
            throw new TDException(TDException.SAVE_ERROR, new Object[]{info.getNumber()});
        }
        this.checkBillUnique(ctx, model);
    }

    protected void _submit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        TaxOtherReportInfo info = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportInfo(pk);
        this.submit(ctx, (CoreBaseInfo)info);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        this.checkForSubmit(ctx, model);
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        info.setState(TaxReportStatusEnum.SUBMIT);
        IObjectPK pk = super._submit(ctx, (IObjectValue)info);
        this.afterSubmit(ctx, pk, model);
        return pk;
    }

    protected void checkForSubmit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        if (TaxReportStatusEnum.AUDIT.equals((Object)info.getState())) {
            throw new TDException(TDException.HASAUDIT);
        }
        this.checkBillUnique(ctx, model);
    }

    protected void checkBillUnique(Context ctx, IObjectValue model) throws EASBizException, BOSException {
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)info.getCompanyOrgUnit().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("rptPeriod.id", (Object)info.getRptPeriod().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("reportType.id", (Object)info.getReportType().getId().toString(), CompareType.EQUALS));
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId(), CompareType.NOTEQUALS));
        }
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(filter);
        SorterItemCollection sorter = new SorterItemCollection();
        sorter.add(new SorterItemInfo("id"));
        if (super._exists(ctx, filter)) {
            String errorMsg = TDUtils.getString("com.kingdee.eas.tm.td.TaxOtherReportResource", "checkBillUnique_Error", ctx.getLocale());
            throw new TDException(TDException.ERROR_MSG, new Object[]{errorMsg});
        }
    }

    private void afterSubmit(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        boolean isSubmit2SaveConfirm;
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        boolean isSubmit2Cacl = TDUtils.getBooleanParam(ctx, info.getCompanyOrgUnit().getId().toString(), "VATD004");
        if (isSubmit2Cacl) {
            try {
                TaxOtherReportInfo reportInfo = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportInfo((IObjectPK)new ObjectStringPK(pk.toString()), TaxOtherReportInfo.getSelectors());
                TDUtils.calculateReport(ctx, reportInfo);
                super._update(ctx, pk, (IObjectValue)reportInfo);
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        if (isSubmit2SaveConfirm = TDUtils.getBooleanParam(ctx, info.getCompanyOrgUnit().getId().toString(), "VATD001")) {
            TaxOtherReportInfo reportInfo = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportInfo((IObjectPK)new ObjectStringPK(pk.toString()), TaxOtherReportInfo.getSelectors());
            TDServerUtils.doSaveTaxDraftConfirmBill(ctx, reportInfo);
        }
    }

    protected void _audit(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id.toString());
        TaxOtherReportInfo info = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportInfo((IObjectPK)pk);
        this.checkForAudit(ctx, (IObjectValue)info);
        info.setState(TaxReportStatusEnum.AUDIT);
        info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        info.setAuditTime(DateUtil.getTime());
        this._update(ctx, (IObjectPK)pk, (IObjectValue)info);
    }

    protected void checkForAudit(Context ctx, IObjectValue model) throws TDException {
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        if (TaxReportStatusEnum.AUDIT.equals((Object)info.getState())) {
            throw new TDException(TDException.HASAUDIT);
        }
        if (!TaxReportStatusEnum.SUBMIT.equals((Object)info.getState())) {
            throw new TDException(TDException.NOT_SUBMIT_STATUS);
        }
    }

    protected void _unAudit(Context ctx, IObjectPK id) throws BOSException, EASBizException {
        ObjectUuidPK pk = new ObjectUuidPK(id.toString());
        TaxOtherReportInfo info = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportInfo((IObjectPK)pk);
        this.checkForUnAudit(ctx, (IObjectValue)info);
        info.setAuditor(null);
        info.setAuditTime(null);
        info.setState(TaxReportStatusEnum.SAVE);
        this._update(ctx, id, (IObjectValue)info);
    }

    protected void checkForUnAudit(Context ctx, IObjectValue model) throws TDException {
        TaxOtherReportInfo info = (TaxOtherReportInfo)model;
        if (!TaxReportStatusEnum.AUDIT.equals((Object)info.getState())) {
            throw new TDException(TDException.NOT_AUDIT_STATUS);
        }
        if (info.isIsVoucher()) {
            throw new TDException(TDException.HAS_VOUCHER);
        }
    }

    @Override
    public void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.checkForDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    protected void checkForDelete(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (!this._exists(ctx, pk)) {
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
        TaxOtherReportInfo info = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportInfo(pk);
        if (TaxReportStatusEnum.AUDIT.equals((Object)info.getState())) {
            throw new TDException(TDException.AUDIT_STATUS);
        }
    }

    @Override
    protected void _autoAudit(Context ctx, IObjectPK id, IObjectPK auditorID) throws BOSException, EASBizException {
        TaxOtherReportInfo info = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportInfo(id);
        if (TaxReportStatusEnum.AUDIT.equals((Object)info.getState())) {
            throw new TDException(TDException.HASAUDIT);
        }
        if (!TaxReportStatusEnum.SUBMIT.equals((Object)info.getState())) {
            throw new TDException(TDException.NOT_SUBMIT_STATUS);
        }
        info.setState(TaxReportStatusEnum.AUDIT);
        if (auditorID != null) {
            UserInfo auditor = new UserInfo();
            auditor.setId(BOSUuid.read((String)auditorID.toString()));
            info.setAuditor(auditor);
        } else {
            info.setAuditor(ContextUtil.getCurrentUserInfo((Context)ctx));
        }
        info.setAuditTime(DateUtil.getTime());
        StringBuffer sql = new StringBuffer();
        sql.append("update  T_TD_TaxOtherReport set FState =? ,FAuditorID = ?,FAuditedTime = ?");
        sql.append(" where FID = '").append(info.getId().toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString(), (Object[])new Object[]{info.getState().getValue(), info.getAuditor().getId().toString(), info.getAuditTime()});
    }

    @Override
    protected Map _checkBeforeVoucher(Context ctx, Set idSet) throws BOSException, EASBizException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxOtherReportCollection coll = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportCollection(view);
        HashMap<String, TaxOtherReportInfo> reportMap = new HashMap<String, TaxOtherReportInfo>();
        TaxOtherReportInfo reportInfo = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            reportInfo = coll.get(i);
            reportMap.put(reportInfo.getId().toString(), reportInfo);
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rptId", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("companyOrgUnit.*"));
        view.setSelector(sic);
        CoreBillBaseCollection billColl = TaxDraftConfirmBillFactory.getLocalInstance(ctx).getCoreBillBaseCollection(view);
        TaxDraftConfirmBillInfo billInfo = null;
        HashMap billMap = new HashMap();
        int size2 = billColl.size();
        for (int i = 0; i < size2; ++i) {
            billInfo = (TaxDraftConfirmBillInfo)billColl.get(i);
            if (!billMap.containsKey(billInfo.getRptId())) {
                billMap.put(billInfo.getRptId(), new ArrayList());
            }
            ((List)billMap.get(billInfo.getRptId())).add(billInfo);
        }
        ArrayList<String> billIds = new ArrayList<String>();
        StringBuffer errorDetailMSG = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            reportInfo = coll.get(i);
            try {
                String orgId = reportInfo.getCompanyOrgUnit().getId().toString();
                TDFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(orgId, "td_taxotherreport_comfire_certificate");
            }
            catch (Exception ex) {
                errorDetailMSG.append(ex.getMessage()).append("\n");
                billMap.remove(reportInfo.getId().toString());
                continue;
            }
            if (!TaxReportStatusEnum.AUDIT.equals((Object)reportInfo.getState())) {
                errorDetailMSG.append(new TDException(TDException.NOT_AUDIT_1, new Object[]{reportInfo.getNumber()}).getMessage()).append("\n");
                billMap.remove(reportInfo.getId().toString());
                continue;
            }
            if (reportInfo.isIsVoucher()) {
                errorDetailMSG.append(new TDException(TDException.HAS_VOUCHER_1, new Object[]{reportInfo.getNumber()}).getMessage()).append("\n");
                billMap.remove(reportInfo.getId().toString());
                continue;
            }
            if (billMap.get(reportInfo.getId().toString()) == null || ((List)billMap.get(reportInfo.getId().toString())).size() == 0) {
                errorDetailMSG.append(new TDException(TDException.NO_DRAFTBILL_1, new Object[]{reportInfo.getNumber()}).getMessage()).append("\n");
                billMap.remove(reportInfo.getId().toString());
                continue;
            }
            billIds.add(reportInfo.getId().toString());
        }
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        retMap.put("billIds", billIds);
        retMap.put("errorMsg", errorDetailMSG);
        retMap.put("reportMap", reportMap);
        retMap.put("confirmbillMap", billMap);
        return retMap;
    }

    @Override
    protected Map _delVoucher(Context ctx, Set idSet) throws BOSException, EASBizException {
        ArrayList<String> billIds = new ArrayList<String>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", new HashSet(idSet), CompareType.INCLUDE));
        view.setFilter(filter);
        TaxOtherReportCollection coll = TaxOtherReportFactory.getLocalInstance(ctx).getTaxOtherReportCollection(view);
        TaxOtherReportInfo reportInfo = null;
        StringBuffer errorDetailMSG = new StringBuffer();
        for (int i = 0; i < coll.size(); ++i) {
            reportInfo = coll.get(i);
            String logDetailStr = reportInfo.getNumber();
            IObjectPK logPk = LogUtils.beginLog(null, "saveConfirmBill", BOSObjectType.create((String)"2A607F02"), (IObjectPK)new ObjectUuidPK(reportInfo.getId().toString()), logDetailStr, "taxotherreport_comfire_delcertificate", "");
            try {
                String orgId = reportInfo.getCompanyOrgUnit().getId().toString();
                TDFacadeFactory.getLocalInstance(ctx).checkFunctionPermission(orgId, "td_taxotherreport_comfire_delcertificate");
            }
            catch (Exception ex) {
                errorDetailMSG.append(ex.getMessage()).append("\n");
                continue;
            }
            if (!reportInfo.isIsVoucher()) {
                errorDetailMSG.append(new TDException(TDException.NO_VOUCHER_1, new Object[]{reportInfo.getNumber()}).getMessage()).append("\n");
                continue;
            }
            try {
                ObjectUuidPK pk = new ObjectUuidPK(reportInfo.getId().toString());
                TaxDraftConfirmBillFactory.getLocalInstance(ctx).deleteVoucher((IObjectPK)pk);
            }
            catch (Exception ex) {
                errorDetailMSG.append(ex.getMessage()).append("\n");
                continue;
            }
            billIds.add(reportInfo.getId().toString());
            LogUtils.afterLog(null, logPk);
        }
        HashMap<String, Serializable> retMap = new HashMap<String, Serializable>();
        retMap.put("billIds", billIds);
        retMap.put("errorMsg", errorDetailMSG);
        return retMap;
    }
}

