/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.app.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ReflectException;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteException;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.MDHostType;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.bo.BusinessObjectInfo;
import com.kingdee.bos.metadata.bo.MethodCollection;
import com.kingdee.bos.metadata.bo.MethodInfo;
import com.kingdee.bos.metadata.bo.ParameterCollection;
import com.kingdee.bos.metadata.bo.TypeReference;
import com.kingdee.bos.metadata.bo.TypeReferenceFactory;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.service.ServiceStateManager;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.app.adapter.LogControllManager;
import com.kingdee.util.BaseException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class TDBatchService {
    private BOSObjectType type;
    private IBizCtrl bizCtrl;

    public TDBatchService(BOSObjectType type, IBizCtrl bizCtrl) {
        this.type = type;
        this.bizCtrl = bizCtrl;
    }

    public BatchExecuteResult batchExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BaseException {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("methodName cannot be null.");
        }
        if (paramTypes == null) {
            throw new IllegalArgumentException("method parameter cannot be null.");
        }
        if (paramEntries == null || paramEntries.length == 0) {
            throw new IllegalArgumentException("method arguments cannot be null.");
        }
        if (paramTypes.length == 0) {
            throw new BatchExecuteException("method parameter cannot be empty.");
        }
        MetaDataPK methodPK = this.getMethodPK(ctx, name, paramTypes);
        if (methodPK == null) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
            throw new BatchExecuteException("No Such method: " + name + "(" + this.paramTypesToString(paramTypes) + ") in " + bo);
        }
        Method batchMethod = TDBatchService.getMethod(this, this.getBatchMethodName(ctx, name), new Class[]{Context.class, BatchExecuteParamsEntry[].class});
        if (batchMethod == null) {
            return this.loopingExecute(ctx, name, paramTypes, paramEntries);
        }
        return this.bizCtrl.batchingExecute(methodPK, batchMethod, paramEntries);
    }

    protected BatchExecuteResult loopingExecute(Context ctx, String name, Class[] paramTypes, BatchExecuteParamsEntry[] paramEntries) throws BOSException {
        BatchExecuteResult result = new BatchExecuteResult(paramEntries.length);
        BizController bizCtrl = EJBFactory.getBusinessController((Context)ctx, (BOSObjectType)this.getBOSType());
        Method mth = TDBatchService.getMethod(bizCtrl, name, TDBatchService.getParamTypeArray(paramTypes));
        if (mth == null) {
            BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
            throw new BatchExecuteException("No Such method: " + name + "(" + this.paramTypesToString(paramTypes) + ") in " + bo);
        }
        ServiceStateManager.LoopSnatpot ls = new ServiceStateManager.LoopSnatpot(ServiceStateManager.getInstance());
        for (int i = 0; i < result.size(); ++i) {
            try {
                ServiceStateManager.getInstance().reSetServiceState(ls);
                LogControllManager.getInstance().enableLog();
                Object rtv = TDBatchService.invoke(bizCtrl, mth, TDBatchService.getParamValueArray(ctx, paramEntries[i]));
                result.setReturnValue(i, rtv);
                continue;
            }
            catch (Throwable th) {
                result.setException(i, th);
            }
        }
        ServiceStateManager.getInstance().reSetStateSnatpot(ls);
        return result;
    }

    private String paramTypesToString(Class[] paramTypes) {
        assert (paramTypes != null);
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < paramTypes.length; ++i) {
            sbuf.append(paramTypes[i].getName());
            if (i >= paramTypes.length - 1) continue;
            sbuf.append(", ");
        }
        return sbuf.toString();
    }

    private static Method getMethod(Object obj, String methodName, Class[] parameterTypes) {
        Method[] methods = obj.getClass().getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(methodName) || m.getParameterTypes().length != parameterTypes.length) continue;
            Class<?>[] params = m.getParameterTypes();
            boolean flag = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j].isAssignableFrom(parameterTypes[j])) continue;
                flag = false;
                break;
            }
            if (!flag) continue;
            return m;
        }
        return null;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    private static Class[] getParamTypeArray(Class[] parameterTypes) {
        Class[] types = new Class[parameterTypes.length + 1];
        types[0] = Context.class;
        System.arraycopy(parameterTypes, 0, types, 1, parameterTypes.length);
        return types;
    }

    private static Object[] getParamValueArray(Context ctx, BatchExecuteParamsEntry entry) {
        Object[] params = new Object[entry.getParamTypes().length + 1];
        params[0] = ctx;
        Object[] entryItems = entry.toArray();
        System.arraycopy(entryItems, 0, params, 1, entryItems.length);
        return params;
    }

    private MetaDataPK getMethodPK(Context ctx, String name, Class[] parameterTypes) {
        BusinessObjectInfo bo = MetaDataLoaderFactory.getMetaDataLoader((Context)ctx).getBusinessObject(this.getBOSType());
        MethodCollection mthdCol = bo.getAllMethodsRuntime();
        for (int i = 0; i < mthdCol.size(); ++i) {
            ParameterCollection paramCol;
            boolean nameMatch;
            MethodInfo mthd = mthdCol.get(i);
            String pimMthdName = mthd.getName();
            boolean bl = nameMatch = pimMthdName.equals(name) || "getValue".equals(pimMthdName) && name.equals(this.get_GETVALUE_MethodName(bo)) || "getCollection".equals(pimMthdName) && name.equals(this.get_GETCOLLECTION_MethodName(bo));
            if (!nameMatch || (paramCol = mthd.getParameters()).size() != parameterTypes.length) continue;
            boolean paramTypeMatch = true;
            TypeReferenceFactory trf = TypeReferenceFactory.getInstance((MDHostType)MDHostType.RUNTIME);
            int n = paramCol.size();
            for (int j = 0; j < n; ++j) {
                TypeReference pimType = trf.getParameterType(bo, paramCol.get(j));
                TypeReference psmType = trf.createTypeReference(parameterTypes[j]);
                if (psmType.equals((Object)pimType)) continue;
                paramTypeMatch = false;
                break;
            }
            if (!paramTypeMatch) continue;
            return MetaDataPK.create((String)mthd.getInnerID());
        }
        return null;
    }

    private String get_GETVALUE_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectValueClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private String get_GETCOLLECTION_MethodName(BusinessObjectInfo bo) {
        if (bo instanceof EntityObjectInfo) {
            EntityObjectInfo entity = (EntityObjectInfo)bo;
            String className = entity.getObjectCollectionClassRuntime();
            int pos = className.lastIndexOf(46);
            return "get" + className.substring(pos + 1);
        }
        return null;
    }

    private static Object invoke(Object obj, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(obj, args);
        }
        catch (IllegalAccessException iae) {
            throw new ReflectException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw ite.getTargetException();
        }
    }

    protected BOSObjectType getBOSType() {
        return this.type;
    }
}

