/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.tm.td.basedata.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.tm.td.basedata.app.AbstractDataImportFacadeControllerBean;
import com.kingdee.eas.tm.td.basedata.dataImport.DataImportFactory;
import com.kingdee.eas.tm.td.basedata.dataImport.impl.IDataImport;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportParams;
import com.kingdee.eas.tm.td.basedata.dataImport.model.DataImportResult;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.log4j.Logger;

public class DataImportFacadeControllerBean
extends AbstractDataImportFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.tm.td.basedata.app.DataImportFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map _dataImport(Context ctx, Map params) throws BOSException, EASBizException {
        List importParams = (List)params.get("importParams");
        ExecutorService service = null;
        CountDownLatch latch = null;
        DataImportParams importParam22 = null;
        ImportTask importTask = null;
        List<DataImportResult> result = Collections.synchronizedList(new ArrayList());
        try {
            service = Executors.newFixedThreadPool(16);
            latch = new CountDownLatch(importParams.size());
            for (DataImportParams importParam22 : importParams) {
                IDataImport dataImport = DataImportFactory.getInstance().getDataImport(ctx, importParam22);
                importTask = new ImportTask(dataImport, result, latch);
                service.execute(importTask);
            }
            latch.await();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        finally {
            if (service != null) {
                service.shutdown();
            }
        }
        DataImportResult importResult22 = null;
        int successsCount = 0;
        int failCount = 0;
        ArrayList<String> detailList = new ArrayList<String>();
        for (DataImportResult importResult22 : result) {
            successsCount += importResult22.getSuccessCount();
            failCount += importResult22.getFailCount();
            if (importResult22.getDetailMsg() == null) continue;
            detailList.add(importResult22.getDetailMsg());
        }
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        ret.put("successCount", Integer.valueOf(successsCount));
        ret.put("failCount", Integer.valueOf(failCount));
        ret.put("detailList", detailList);
        return ret;
    }

    class ImportTask
    implements Runnable {
        private IDataImport dataImport = null;
        private List result = null;
        private CountDownLatch latch = null;

        public ImportTask(IDataImport dataImport, List result, CountDownLatch latch) {
            this.dataImport = dataImport;
            this.result = result;
            this.latch = latch;
        }

        @Override
        public void run() {
            try {
                DataImportResult importResult = this.dataImport.dataImport();
                this.result.add(importResult);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                this.latch.countDown();
            }
        }
    }
}

